// Copyright 2025 The OPA Authors.  All rights reserved.
// Use of this source code is governed by an Apache2
// license that can be found in the LICENSE file.

package cmd

import (
	"fmt"
)

type ExitError struct {
	Exit    int
	wrapped error
}

func newExitError(exit int) error {
	return &ExitError{Exit: exit}
}

func newExitErrorWrap(exit int, err error) error {
	return &ExitError{Exit: exit, wrapped: err}
}

func (c *ExitError) Error() string {
	return fmt.Sprintf("exit %d", c.Exit)
}

func (c *ExitError) Unwrap() error {
	return c.wrapped
}
