/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.syntax;

import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalSorter;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.sql.semantics.completion.SQLQueryCompletionProposal;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorBase;
import org.jkiss.dbeaver.ui.editors.sql.semantics.SQLEditorQueryCompletionProposal;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLCompletionProposal;

public class SQLCompletionSorter
implements ICompletionProposalSorter {
    private final SQLEditorBase editor;
    private boolean sortAlphabetically;
    private boolean isSearchInsideNames;

    public SQLCompletionSorter(SQLEditorBase editor) {
        this.editor = editor;
    }

    public int compare(ICompletionProposal p1, ICompletionProposal p2) {
        if (this.isSearchInsideNames) {
            return this.compareWhenFuzzySearch(p1, p2);
        }
        return this.compareWhenPrefixSearch(p1, p2);
    }

    private int compareWhenFuzzySearch(ICompletionProposal p1, ICompletionProposal p2) {
        int rc;
        int score1 = SQLCompletionSorter.getScore(p1);
        int score2 = SQLCompletionSorter.getScore(p2);
        if (score1 == Integer.MAX_VALUE && score2 == Integer.MAX_VALUE) {
            return this.compareWhenPrefixSearch(p1, p2);
        }
        if ((score1 > 0 || score2 > 0) && (rc = -Integer.compare(score1, score2)) != 0) {
            return rc;
        }
        if (this.sortAlphabetically) {
            rc = p1.getDisplayString().compareToIgnoreCase(p2.getDisplayString());
            if (rc != 0) {
                return rc;
            }
        } else {
            return 0;
        }
        return SQLCompletionSorter.compareProposalKind(p1, p2);
    }

    private int compareWhenPrefixSearch(ICompletionProposal p1, ICompletionProposal p2) {
        int rc;
        int krc = SQLCompletionSorter.compareProposalKind(p1, p2);
        if (krc != 0) {
            return krc;
        }
        if (this.sortAlphabetically && (rc = p1.getDisplayString().compareToIgnoreCase(p2.getDisplayString())) != 0) {
            return rc;
        }
        return 0;
    }

    private static int compareProposalKind(ICompletionProposal a, ICompletionProposal b) {
        int n;
        int aOrd;
        if (a instanceof SQLQueryCompletionProposal) {
            SQLQueryCompletionProposal x = (SQLQueryCompletionProposal)a;
            v0 = x.getItemKind().sortOrder;
        } else if (a instanceof SQLCompletionProposal) {
            SQLCompletionProposal x = (SQLCompletionProposal)a;
            v0 = x.getProposalType().sortOrder;
        } else {
            v0 = aOrd = Integer.MAX_VALUE;
        }
        if (b instanceof SQLQueryCompletionProposal) {
            SQLQueryCompletionProposal y = (SQLQueryCompletionProposal)b;
            n = y.getItemKind().sortOrder;
        } else if (b instanceof SQLCompletionProposal) {
            SQLCompletionProposal y = (SQLCompletionProposal)b;
            n = y.getProposalType().sortOrder;
        } else {
            n = Integer.MAX_VALUE;
        }
        int bOrd = n;
        return Integer.compare(aOrd, bOrd);
    }

    private static int getScore(ICompletionProposal p) {
        if (p instanceof SQLCompletionProposal) {
            SQLCompletionProposal cp = (SQLCompletionProposal)p;
            return cp.getProposalScore();
        }
        if (p instanceof SQLEditorQueryCompletionProposal) {
            SQLEditorQueryCompletionProposal qcp = (SQLEditorQueryCompletionProposal)p;
            return qcp.getProposalScore();
        }
        return 0;
    }

    public void refreshSettings() {
        DBPPreferenceStore prefStore = this.editor.getActivePreferenceStore();
        this.sortAlphabetically = prefStore.getBoolean("SQLEditor.ContentAssistant.proposals.sort.alphabetically");
        this.isSearchInsideNames = prefStore.getBoolean("SQLEditor.ContentAssistant.matching.fuzzy");
    }
}

