/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.folders;

import java.util.EventListener;
import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ui.BaseThemeSettings;
import org.jkiss.dbeaver.ui.ConComposite;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.SharedTextColors;
import org.jkiss.dbeaver.ui.UIStyles;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.folders.TabbedFolderInfo;
import org.jkiss.dbeaver.ui.css.CSSUtils;

public class TabbedFolderList
extends ConComposite {
    private static final ListElement[] ELEMENTS_EMPTY = new ListElement[0];
    protected static final int NONE = -1;
    protected static final int INDENT_LEFT = 7;
    protected static final int INDENT_RIGHT = 10;
    public static final String LABEL_NA = "N/A";
    public static final int SECTION_DIV_HEIGHT = 7;
    private final boolean section;
    private boolean focus = false;
    private ListElement[] elements;
    private int selectedElementIndex = -1;
    private int topVisibleIndex = -1;
    private int bottomVisibleIndex = -1;
    private final TopNavigationElement topNavigationElement;
    private final BottomNavigationElement bottomNavigationElement;
    private int widestLabelIndex = -1;
    private int tabsThatFitInComposite = -1;
    Color widgetForeground;
    Color widgetNormalShadow;
    Color widgetDarkShadow;
    private Color listBackground;
    private Color hoverGradientStart;
    private Color hoverGradientEnd;
    private Color elementBackground;
    private Color indentedDefaultBackground;
    private Color indentedHoverBackground;
    private Color navigationElementShadowStroke;
    private Color bottomNavigationElementShadowStroke1;
    private Color bottomNavigationElementShadowStroke2;
    private final Map<Image, Image> grayedImages = new IdentityHashMap<Image, Image>();
    private RGB white;
    private RGB black;

    private Image getGrayedImage(Image image) {
        Image disabledImage = this.grayedImages.get(image);
        if (disabledImage == null) {
            disabledImage = new Image(image.getDevice(), image, 2);
            this.grayedImages.put(image, disabledImage);
        }
        return disabledImage;
    }

    private Color getWidgetBackgrund(boolean adapt) {
        Color connectionColor = CSSUtils.getCurrentEditorConnectionColor((Widget)this);
        if (connectionColor != null) {
            if (adapt) {
                SharedTextColors sharedColors = UIUtils.getSharedTextColors();
                connectionColor = this.listBackground.hashCode() < connectionColor.hashCode() ? sharedColors.getColor(UIUtils.blend(this.black, connectionColor.getRGB(), 15)) : sharedColors.getColor(UIUtils.blend(this.white, connectionColor.getRGB(), 15));
            }
            return connectionColor;
        }
        return this.listBackground;
    }

    public TabbedFolderList(Composite parent, boolean section) {
        super(parent, 524288);
        this.section = section;
        this.removeAll();
        this.setLayout((Layout)new FormLayout());
        this.topNavigationElement = new TopNavigationElement(this);
        this.bottomNavigationElement = new BottomNavigationElement(this);
        this.initColours();
        this.initAccessible();
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                TabbedFolderList.this.focus = true;
                int i = TabbedFolderList.this.getSelectionIndex();
                if (i >= 0) {
                    TabbedFolderList.this.elements[i].redraw();
                }
            }

            public void focusLost(FocusEvent e) {
                TabbedFolderList.this.focus = false;
                int i = TabbedFolderList.this.getSelectionIndex();
                if (i >= 0) {
                    TabbedFolderList.this.elements[i].redraw();
                }
            }
        });
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                TabbedFolderList.this.computeTopAndBottomTab();
                UIUtils.asyncExec(() -> TabbedFolderList.this.redraw());
            }
        });
        this.addTraverseListener(this::handleTraverse);
        this.addDisposeListener(e -> {
            for (Image di : this.grayedImages.values()) {
                UIUtils.dispose((Resource)di);
            }
            this.grayedImages.clear();
        });
        UIUtils.installAndUpdateMainFont((Control)this);
    }

    protected void computeTabsThatFitInComposite() {
        this.tabsThatFitInComposite = Math.round((this.getSize().y - 22) / this.getTabHeight());
        if (this.tabsThatFitInComposite <= 0) {
            this.tabsThatFitInComposite = 1;
        }
    }

    public int getNumberOfElements() {
        return this.elements.length;
    }

    public ListElement getElementAt(int index) {
        if (index >= 0 && index < this.elements.length) {
            return this.elements[index];
        }
        return null;
    }

    public TabbedFolderInfo[] getElements() {
        TabbedFolderInfo[] tabs = new TabbedFolderInfo[this.elements.length];
        int i = 0;
        while (i < this.elements.length) {
            tabs[i] = this.elements[i].getInfo();
            ++i;
        }
        return tabs;
    }

    public int getSelectionIndex() {
        return this.selectedElementIndex;
    }

    public void removeAll() {
        if (this.elements != null) {
            ListElement[] listElementArray = this.elements;
            int n = this.elements.length;
            int n2 = 0;
            while (n2 < n) {
                ListElement element = listElementArray[n2];
                element.dispose();
                ++n2;
            }
        }
        this.elements = ELEMENTS_EMPTY;
        this.selectedElementIndex = -1;
        this.widestLabelIndex = -1;
        this.topVisibleIndex = -1;
        this.bottomVisibleIndex = -1;
    }

    public void setFolders(TabbedFolderInfo[] children) {
        if (this.elements != ELEMENTS_EMPTY) {
            this.removeAll();
        }
        this.elements = new ListElement[children.length];
        int i = 0;
        while (i < children.length) {
            this.elements[i] = new ListElement(this, children[i], i);
            this.elements[i].setVisible(false);
            this.elements[i].setLayoutData(null);
            ++i;
        }
        this.computeTabsWidth();
    }

    private void computeTabsWidth() {
        if (this.elements.length == 0) {
            this.widestLabelIndex = -1;
        } else {
            this.widestLabelIndex = 0;
            int i = 0;
            while (i < this.elements.length) {
                int width;
                if (i != this.widestLabelIndex && (width = this.getTabWidth(this.elements[i].tab)) > this.getTabWidth(this.elements[this.widestLabelIndex].tab)) {
                    this.widestLabelIndex = i;
                }
                ++i;
            }
        }
        if (this.widestLabelIndex != -1) {
            int maxTabWidth = this.getTabWidth(this.elements[this.widestLabelIndex].tab);
            Object layoutData = this.getLayoutData();
            if (layoutData instanceof GridData) {
                ((GridData)layoutData).widthHint = maxTabWidth + 7 + 10;
            }
        }
        this.computeTopAndBottomTab();
    }

    private int getTabWidth(TabbedFolderInfo folderInfo) {
        int width = this.getTextDimension((String)folderInfo.getText()).x;
        if (folderInfo.getImage() != null) {
            Image image = DBeaverIcons.getImage(folderInfo.getImage());
            width = width + image.getBounds().width + 4;
        }
        if (folderInfo.isIndented()) {
            width += 7;
        }
        return width;
    }

    public void select(int index) {
        this.select(index, true);
    }

    public void select(int index, boolean setFocus) {
        if (index >= 0 && index < this.elements.length) {
            int lastSelected = this.getSelectionIndex();
            if (index == lastSelected) {
                return;
            }
            this.elements[index].setSelected(true);
            this.selectedElementIndex = index;
            if (lastSelected != -1) {
                this.elements[lastSelected].setSelected(false);
                if (this.getSelectionIndex() != this.elements.length - 1) {
                    this.elements[this.getSelectionIndex() + 1].setSelected(false);
                }
            }
            this.topNavigationElement.redraw();
            this.bottomNavigationElement.redraw();
            if (this.selectedElementIndex < this.topVisibleIndex || this.selectedElementIndex > this.bottomVisibleIndex) {
                this.computeTopAndBottomTab();
            }
        }
        this.notifyListeners(13, new Event());
        if (setFocus) {
            this.elements[index].getInfo().getContents().setFocus();
        }
    }

    public void deselectAll() {
        if (this.getSelectionIndex() != -1) {
            this.elements[this.getSelectionIndex()].setSelected(false);
            this.selectedElementIndex = -1;
        }
    }

    private int getIndex(ListElement element) {
        return element.index;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point result = super.computeSize(wHint, hHint, changed);
        Object layoutData = this.getLayoutData();
        if (layoutData instanceof GridData && ((GridData)layoutData).widthHint != -1) {
            result.x = ((GridData)layoutData).widthHint;
        } else if (this.widestLabelIndex == -1) {
            result.x = this.getTextDimension((String)LABEL_NA).x + 7;
        } else {
            int width = this.getTabWidth(this.elements[this.widestLabelIndex].getInfo()) + 7;
            result.x = width + 10;
        }
        return result;
    }

    private Point getTextDimension(String text) {
        GC gc = new GC((Drawable)this);
        gc.setFont(BaseThemeSettings.instance.partTitleBoldFont);
        Point point = gc.textExtent(text);
        ++point.x;
        gc.dispose();
        return point;
    }

    private void initColours() {
        Color widgetBackground;
        Display display = this.getDisplay();
        SharedTextColors sharedColors = UIUtils.getSharedTextColors();
        this.listBackground = UIStyles.getDefaultTextBackground();
        if (UIStyles.isDarkTheme()) {
            widgetBackground = UIStyles.getDefaultWidgetBackground();
            super.setBackground(widgetBackground);
            this.topNavigationElement.setBackground(widgetBackground);
            this.bottomNavigationElement.setBackground(widgetBackground);
        } else {
            widgetBackground = this.getBackground();
        }
        this.widgetForeground = UIStyles.isDarkHighContrastTheme() ? UIStyles.COLOR_WHITE : UIStyles.getDefaultTextForeground();
        this.widgetDarkShadow = display.getSystemColor(17);
        this.widgetNormalShadow = display.getSystemColor(18);
        this.white = display.getSystemColor(1).getRGB();
        this.black = display.getSystemColor(2).getRGB();
        this.elementBackground = this.widgetNormalShadow.hashCode() < widgetBackground.hashCode() ? sharedColors.getColor(UIUtils.blend(this.black, widgetBackground.getRGB(), 15)) : sharedColors.getColor(UIUtils.blend(this.white, widgetBackground.getRGB(), 15));
        this.navigationElementShadowStroke = sharedColors.getColor(UIUtils.blend(this.white, this.widgetNormalShadow.getRGB(), 55));
        this.bottomNavigationElementShadowStroke1 = sharedColors.getColor(UIUtils.blend(this.black, widgetBackground.getRGB(), 10));
        this.bottomNavigationElementShadowStroke2 = sharedColors.getColor(UIUtils.blend(this.black, widgetBackground.getRGB(), 5));
        this.hoverGradientStart = sharedColors.getColor(UIUtils.blend(this.white, widgetBackground.getRGB(), 20));
        this.hoverGradientEnd = sharedColors.getColor(UIUtils.blend(this.widgetNormalShadow.getRGB(), widgetBackground.getRGB(), 10));
        this.indentedDefaultBackground = sharedColors.getColor(UIUtils.blend(this.white, widgetBackground.getRGB(), 10));
        this.indentedHoverBackground = sharedColors.getColor(UIUtils.blend(this.white, widgetBackground.getRGB(), 75));
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.computeTabsWidth();
    }

    int getTabHeight() {
        int tabHeight = this.getTextDimension((String)"").y + 7;
        if (this.tabsThatFitInComposite == 1) {
            int ret = this.getBounds().height - 20;
            return ret > tabHeight ? tabHeight : Math.max(ret, 5);
        }
        return tabHeight;
    }

    private boolean isDownScrollRequired() {
        return this.elements.length > this.tabsThatFitInComposite && this.bottomVisibleIndex != this.elements.length - 1;
    }

    private boolean isUpScrollRequired() {
        return this.elements.length > this.tabsThatFitInComposite && this.topVisibleIndex != 0;
    }

    private void computeTopAndBottomTab() {
        this.computeTabsThatFitInComposite();
        if (this.elements.length == 0) {
            this.topVisibleIndex = 0;
            this.bottomVisibleIndex = 0;
        } else if (this.tabsThatFitInComposite >= this.elements.length) {
            this.topVisibleIndex = 0;
            this.bottomVisibleIndex = this.elements.length - 1;
        } else if (this.getSelectionIndex() == -1) {
            this.topVisibleIndex = 0;
            this.bottomVisibleIndex = this.tabsThatFitInComposite - 1;
        } else if (this.getSelectionIndex() + this.tabsThatFitInComposite > this.elements.length) {
            this.bottomVisibleIndex = this.elements.length - 1;
            this.topVisibleIndex = this.bottomVisibleIndex - this.tabsThatFitInComposite + 1;
        } else {
            this.topVisibleIndex = this.selectedElementIndex;
            this.bottomVisibleIndex = this.selectedElementIndex + this.tabsThatFitInComposite - 1;
        }
        this.layoutTabs();
    }

    private void layoutTabs() {
        if (this.tabsThatFitInComposite == -1 || this.elements.length == 0) {
            formData = new FormData();
            formData.left = new FormAttachment(0, 0);
            formData.right = new FormAttachment(100, 0);
            formData.top = new FormAttachment(0, 0);
            formData.height = this.getTabHeight();
            this.topNavigationElement.setLayoutData(formData);
            formData = new FormData();
            formData.left = new FormAttachment(0, 0);
            formData.right = new FormAttachment(100, 0);
            formData.top = new FormAttachment((Control)this.topNavigationElement, 0);
            formData.bottom = new FormAttachment(100, 0);
            this.bottomNavigationElement.setLayoutData(formData);
        } else {
            formData = new FormData();
            formData.left = new FormAttachment(0, 0);
            formData.right = new FormAttachment(100, 0);
            formData.top = new FormAttachment(0, 0);
            formData.height = 10;
            this.topNavigationElement.setLayoutData(formData);
            Canvas nextElement = this.topNavigationElement;
            int i = 0;
            while (i < this.elements.length) {
                if (i < this.topVisibleIndex || i > this.bottomVisibleIndex) {
                    this.elements[i].setLayoutData(null);
                    this.elements[i].setVisible(false);
                } else {
                    formData = new FormData();
                    formData.height = this.getTabHeight();
                    formData.left = new FormAttachment(0, 0);
                    formData.right = new FormAttachment(100, 0);
                    formData.top = new FormAttachment((Control)nextElement, 0);
                    nextElement = this.elements[i];
                    this.elements[i].setLayoutData(formData);
                    this.elements[i].setVisible(true);
                }
                ++i;
            }
            formData = new FormData();
            formData.left = new FormAttachment(0, 0);
            formData.right = new FormAttachment(100, 0);
            formData.top = new FormAttachment((Control)nextElement, 0);
            formData.bottom = new FormAttachment(100, 0);
            formData.height = 10;
            this.bottomNavigationElement.setLayoutData(formData);
        }
        Composite grandparent = this.getParent().getParent();
        grandparent.layout(true);
        this.layout(true);
    }

    private void initAccessible() {
        Accessible accessible = this.getAccessible();
        accessible.addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (TabbedFolderList.this.getSelectionIndex() != -1) {
                    e.result = TabbedFolderList.this.elements[TabbedFolderList.this.getSelectionIndex()].getInfo().getText();
                }
            }

            public void getHelp(AccessibleEvent e) {
                if (TabbedFolderList.this.getSelectionIndex() != -1) {
                    e.result = TabbedFolderList.this.elements[TabbedFolderList.this.getSelectionIndex()].getInfo().getText();
                }
            }
        });
        accessible.addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent e) {
                Point pt = TabbedFolderList.this.toControl(new Point(e.x, e.y));
                e.childID = TabbedFolderList.this.getBounds().contains(pt) ? -1 : -2;
            }

            public void getLocation(AccessibleControlEvent e) {
                if (TabbedFolderList.this.getSelectionIndex() != -1) {
                    Rectangle location = TabbedFolderList.this.elements[TabbedFolderList.this.getSelectionIndex()].getBounds();
                    Point pt = TabbedFolderList.this.toDisplay(new Point(location.x, location.y));
                    e.x = pt.x;
                    e.y = pt.y;
                    e.width = location.width;
                    e.height = location.height;
                }
            }

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 37;
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = 0x300006;
            }
        });
        this.addListener(13, event -> {
            if (this.isFocusControl()) {
                accessible.setFocus(-1);
            }
        });
        this.addListener(15, event -> accessible.setFocus(-1));
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        TypedListener typedListener = new TypedListener((EventListener)listener);
        this.addListener(13, (Listener)typedListener);
        this.addListener(14, (Listener)typedListener);
    }

    public void handleTraverse(TraverseEvent e) {
        if (e.detail == 256 || e.detail == 512) {
            if ((e.stateMask & 0x40000) != 262144 && (e.stateMask & 0x10000) != 65536) {
                return;
            }
            e.doit = false;
            int nMax = this.elements.length - 1;
            int nCurrent = this.getSelectionIndex();
            if (e.detail == 256 ? --nCurrent < 0 : ++nCurrent > nMax) {
                return;
            }
            this.select(nCurrent);
            this.redraw();
        } else {
            e.doit = true;
        }
    }

    public class BottomNavigationElement
    extends Canvas {
        public BottomNavigationElement(Composite parent) {
            super(parent, 524288);
            this.addPaintListener(this::paint);
            this.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    if (TabbedFolderList.this.isDownScrollRequired()) {
                        ++((BottomNavigationElement)BottomNavigationElement.this).TabbedFolderList.this.topVisibleIndex;
                        if (((BottomNavigationElement)BottomNavigationElement.this).TabbedFolderList.this.bottomVisibleIndex != ((BottomNavigationElement)BottomNavigationElement.this).TabbedFolderList.this.elements.length - 1) {
                            ++((BottomNavigationElement)BottomNavigationElement.this).TabbedFolderList.this.bottomVisibleIndex;
                        }
                        TabbedFolderList.this.layoutTabs();
                        ((BottomNavigationElement)BottomNavigationElement.this).TabbedFolderList.this.topNavigationElement.redraw();
                        ((BottomNavigationElement)BottomNavigationElement.this).TabbedFolderList.this.bottomNavigationElement.redraw();
                    }
                }
            });
            this.setFont(TabbedFolderList.this.getFont());
        }

        private void paint(PaintEvent e) {
            Color bgColor = TabbedFolderList.this.getWidgetBackgrund(true);
            e.gc.setForeground(TabbedFolderList.this.widgetForeground);
            Rectangle bounds = this.getBounds();
            if (TabbedFolderList.this.elements.length != 0) {
                e.gc.setBackground(bgColor);
                e.gc.fillRectangle(0, 0, bounds.width, bounds.height);
                e.gc.setForeground(TabbedFolderList.this.widgetNormalShadow);
                if (!TabbedFolderList.this.section || TabbedFolderList.this.isDownScrollRequired()) {
                    e.gc.drawLine(bounds.width - 1, 0, bounds.width - 1, bounds.height - 1);
                } else {
                    e.gc.drawLine(bounds.width - 1, 0, bounds.width - 1, bounds.height - 7);
                    e.gc.drawPoint(bounds.width - 1, bounds.height - 1);
                }
                e.gc.drawLine(0, 0, bounds.width - 1, 0);
                e.gc.setForeground(TabbedFolderList.this.bottomNavigationElementShadowStroke1);
                e.gc.drawLine(0, 1, bounds.width - 2, 1);
                e.gc.setForeground(TabbedFolderList.this.bottomNavigationElementShadowStroke2);
                e.gc.drawLine(0, 2, bounds.width - 2, 2);
            } else {
                e.gc.setBackground(bgColor);
                e.gc.fillRectangle(0, 0, bounds.width, bounds.height);
            }
            if (TabbedFolderList.this.isDownScrollRequired()) {
                e.gc.setForeground(TabbedFolderList.this.widgetDarkShadow);
                int middle = bounds.width / 2;
                int bottom = bounds.height - 3;
                e.gc.drawLine(middle + 1, bottom, middle + 5, bottom - 4);
                e.gc.drawLine(middle, bottom, middle - 4, bottom - 4);
                e.gc.drawLine(middle - 3, bottom - 4, middle + 4, bottom - 4);
                e.gc.setForeground(TabbedFolderList.this.listBackground);
                e.gc.drawLine(middle, bottom - 1, middle + 1, bottom - 1);
                e.gc.drawLine(middle - 1, bottom - 2, middle + 2, bottom - 2);
                e.gc.drawLine(middle - 2, bottom - 3, middle + 3, bottom - 3);
                e.gc.setForeground(TabbedFolderList.this.widgetNormalShadow);
                e.gc.drawLine(0, bottom - 7, bounds.width - 2, bottom - 7);
                e.gc.setForeground(TabbedFolderList.this.navigationElementShadowStroke);
                e.gc.drawLine(0, bottom + 2, bounds.width - 2, bottom + 2);
                e.gc.drawLine(0, bottom - 6, bounds.width - 2, bottom - 6);
            }
        }
    }

    public class ListElement
    extends Canvas {
        private final TabbedFolderInfo tab;
        private final int index;
        private boolean selected;
        private boolean hover;

        public ListElement(@NotNull Composite parent, TabbedFolderInfo tab, int index) {
            super(parent, 524288);
            this.tab = tab;
            this.hover = false;
            this.selected = false;
            this.index = index;
            this.addPaintListener(this::paint);
            this.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    if (!ListElement.this.selected) {
                        TabbedFolderList.this.select(TabbedFolderList.this.getIndex(ListElement.this));
                        Composite tabbedPropertyComposite = ListElement.this.getParent();
                        tabbedPropertyComposite.setFocus();
                    }
                }
            });
            this.addMouseMoveListener(e -> {
                String tooltip = tab.getTooltip();
                if (tooltip != null) {
                    this.setToolTipText(tooltip);
                }
                if (!this.hover) {
                    this.hover = true;
                    this.redraw();
                }
            });
            this.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

                public void mouseExit(MouseEvent e) {
                    ListElement.this.hover = false;
                    ListElement.this.redraw();
                }
            });
            this.setFont(TabbedFolderList.this.getFont());
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
            this.redraw();
        }

        private void paint(PaintEvent e) {
            Color bgColor = TabbedFolderList.this.listBackground;
            Rectangle bounds = this.getBounds();
            e.gc.setForeground(TabbedFolderList.this.widgetNormalShadow);
            e.gc.drawLine(0, 0, bounds.width - 1, 0);
            e.gc.setForeground(bgColor);
            e.gc.drawLine(0, 1, bounds.width - 1, 1);
            if (this.selected) {
                e.gc.setBackground(bgColor);
                e.gc.fillRectangle(0, 2, bounds.width, bounds.height - 1);
            } else if (this.hover && this.tab.isIndented()) {
                e.gc.setBackground(TabbedFolderList.this.indentedHoverBackground);
                e.gc.fillRectangle(0, 2, bounds.width - 1, bounds.height - 1);
            } else if (this.hover) {
                e.gc.setForeground(TabbedFolderList.this.hoverGradientStart);
                e.gc.setBackground(TabbedFolderList.this.hoverGradientEnd);
                e.gc.fillGradientRectangle(0, 2, bounds.width - 1, bounds.height - 1, true);
            } else if (this.tab.isIndented()) {
                e.gc.setBackground(TabbedFolderList.this.indentedDefaultBackground);
                e.gc.fillRectangle(0, 2, bounds.width - 1, bounds.height - 1);
            } else {
                e.gc.setBackground(TabbedFolderList.this.elementBackground);
                e.gc.fillRectangle(0, 2, bounds.width - 1, bounds.height - 1);
            }
            if (!this.selected) {
                e.gc.setForeground(TabbedFolderList.this.widgetNormalShadow);
                e.gc.drawLine(bounds.width - 1, 1, bounds.width - 1, bounds.height + 1);
            }
            int textIndent = 7;
            FontMetrics fm = e.gc.getFontMetrics();
            int height = fm.getHeight();
            int textMiddle = (bounds.height - height) / 2;
            if (this.tab.getImage() != null) {
                textIndent = this.tab.isIndented() ? (textIndent += 7) : (textIndent -= 3);
                Image image = DBeaverIcons.getImage(this.tab.getImage());
                Rectangle imageBounds = image.getBounds();
                int imageMiddle = (bounds.height - imageBounds.height) / 2;
                if (this.selected || this.hover) {
                    e.gc.drawImage(image, textIndent, imageMiddle - 1);
                } else {
                    e.gc.drawImage(TabbedFolderList.this.getGrayedImage(image), textIndent, imageMiddle - 1);
                }
                textIndent = textIndent + imageBounds.width + 4;
            } else if (this.tab.isIndented()) {
                textIndent += 7;
            }
            e.gc.setForeground(TabbedFolderList.this.widgetForeground);
            if (this.selected) {
                e.gc.setFont(BaseThemeSettings.instance.partTitleBoldFont);
            } else {
                e.gc.setFont(BaseThemeSettings.instance.partTitleFont);
            }
            e.gc.drawText(this.tab.getText(), textIndent, textMiddle, true);
            if (((TabbedFolderList)this.getParent()).focus && this.selected) {
                Point point = e.gc.textExtent(this.tab.getText());
                e.gc.drawLine(textIndent, bounds.height - 4, textIndent + point.x, bounds.height - 4);
            }
            if (!this.hover) {
                e.gc.setForeground(bgColor);
                e.gc.drawLine(0, bounds.height - 1, bounds.width - 2, bounds.height - 1);
            }
        }

        public TabbedFolderInfo getInfo() {
            return this.tab;
        }

        public String toString() {
            return this.tab.getText();
        }
    }

    public class TopNavigationElement
    extends Canvas {
        public TopNavigationElement(Composite parent) {
            super(parent, 524288);
            this.addPaintListener(this::paint);
            this.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    if (TabbedFolderList.this.isUpScrollRequired()) {
                        --((TopNavigationElement)TopNavigationElement.this).TabbedFolderList.this.bottomVisibleIndex;
                        if (((TopNavigationElement)TopNavigationElement.this).TabbedFolderList.this.topVisibleIndex != 0) {
                            --((TopNavigationElement)TopNavigationElement.this).TabbedFolderList.this.topVisibleIndex;
                        }
                        TabbedFolderList.this.layoutTabs();
                        ((TopNavigationElement)TopNavigationElement.this).TabbedFolderList.this.topNavigationElement.redraw();
                        ((TopNavigationElement)TopNavigationElement.this).TabbedFolderList.this.bottomNavigationElement.redraw();
                    }
                }
            });
            this.setFont(TabbedFolderList.this.getFont());
        }

        private void paint(PaintEvent e) {
            Color bgColor = TabbedFolderList.this.getWidgetBackgrund(false);
            e.gc.setForeground(TabbedFolderList.this.widgetForeground);
            Rectangle bounds = this.getBounds();
            if (TabbedFolderList.this.elements.length != 0) {
                e.gc.setBackground(bgColor);
                e.gc.fillRectangle(0, 0, bounds.width, bounds.height);
                e.gc.setForeground(TabbedFolderList.this.widgetNormalShadow);
                e.gc.drawLine(bounds.width - 1, 0, bounds.width - 1, bounds.height - 1);
            } else {
                e.gc.setBackground(bgColor);
                e.gc.fillRectangle(0, 0, bounds.width, bounds.height);
                int textIndent = 7;
                FontMetrics fm = e.gc.getFontMetrics();
                int height = fm.getHeight();
                int textMiddle = (bounds.height - height) / 2;
                e.gc.setForeground(TabbedFolderList.this.widgetForeground);
                e.gc.drawText(TabbedFolderList.LABEL_NA, textIndent, textMiddle);
            }
            if (TabbedFolderList.this.isUpScrollRequired()) {
                e.gc.setForeground(TabbedFolderList.this.widgetDarkShadow);
                int middle = bounds.width / 2;
                e.gc.drawLine(middle + 1, 3, middle + 5, 7);
                e.gc.drawLine(middle, 3, middle - 4, 7);
                e.gc.drawLine(middle - 3, 7, middle + 4, 7);
                e.gc.setForeground(TabbedFolderList.this.listBackground);
                e.gc.drawLine(middle, 4, middle + 1, 4);
                e.gc.drawLine(middle - 1, 5, middle + 2, 5);
                e.gc.drawLine(middle - 2, 6, middle + 3, 6);
                e.gc.setForeground(TabbedFolderList.this.widgetNormalShadow);
                e.gc.drawLine(0, 0, bounds.width - 2, 0);
                e.gc.setForeground(TabbedFolderList.this.navigationElementShadowStroke);
                e.gc.drawLine(0, 1, bounds.width - 2, 1);
                e.gc.drawLine(0, bounds.height - 1, bounds.width - 2, bounds.height - 1);
            }
        }
    }
}

