/* show progress
   Copyright (C) 1998, 1999, 2000, 2001, 2002, 2003
   Wouter van Ooijen

This file is part of jal.

jal is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

jal is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with jal; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include "stdhdr.h"
#include "global.h"
#include "target.h"
#include "errorlh.h"
#include "showprog.h"
#include "cstringf.h"

int progress_counter = 0;
char *progress_string = "";
int progress_interval = 10;
string progress_print_string;
void progress(char *name, int n)
{
    if (!verbose_progress)
        return;
    if (n < 0) {
        sprintf(progress_print_string, "%s", name);
    } else {
        if (!string_equal(progress_string, name)) {
            progress_counter = 0;
        }
        progress_string = name;
        if (n == 0) {
            n = ++progress_counter;
        }
        if ((n % progress_interval) == 0) {
            sprintf(progress_print_string, "%s %d", name, n);
        }
    }
    printf(pad(progress_print_string, 78, ' '));
    printf("\r");
    fflush(stdout);
}
