/* squasher
   Copyright (C) 1998, 1999, 2000, 2001, 2002, 2003
   Wouter van Ooijen

This file is part of jal.

jal is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

jal is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with jal; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include "stdhdr.h"
#include "global.h"
#include "target.h"
#include "errorlh.h"
#include "treerep.h"
#include "assemble.h"
#include "stacksg.h"
#include "scanner.h"
#include "codegen.h"
#include "regalloc.h"
#include "reswords.h"
#include "compdriver.h"
#include "parser.h"
#include "treetools.h"
#include "squasher.h"

tree squash_outer_scope;

/* forward for general squash */
tree squash_node(tree p, tree scope);

/* must this operator be squashed? */
boolean is_simple_op(tree p, tree t)
{
    stack_guard;
    assert_pointer(NULL, p);
    assert_pointer(NULL, t);

    /* a known implementation must exist */
    if (p->impl == NULL)
        return false;

    /* first arg must be compatible with t */
    assert_kind(p->loc, p->impl, node_procedure);
    if (!is_type_compatible(arg(p->impl, 1, true)->type, t))
        return false;

    /* for a monop this is sufficient */
    if (is_monop(p->op))
        return true;

    /* for a diop the second argument must also be compatible with t */
    if (!is_type_compatible(arg(p->impl, 2, true)->type, t))
        return false;

    /* OK, it is a simple_op */
    return true;

}

/* squash a (right-hand) reference */
tree squash_ref(tree p, tree scope)
{
    stack_guard;

    assert_kind(p->loc, p, node_ref);
    assert_pointer(p->loc, p->first);

    p->first = squash_node(p->first, scope);

    if (p->ref == ref_own) {

        /* keep as is! */
        return p;
    }

    if (p->first->get != NULL) {

        /* virtual variable : insert call to get function */
        assert_kind(p->loc, p->first->get->result, node_decl);
        assert_kind(p->loc, p->first->get->result->first, node_var);
        return new_chain3(new_precall(p->loc, p->first->get), new_call(p->loc, p->first->get),
                          new_ref(p->loc, ref_var, (p->first->get->has_transfer ?
                                          transfer_variable(p->first->type) : 
                                          p->first->get->result->first), NULL)
            );
    }

    if ((p->first->mode != mode_none)
        && (p->first->is_volatile)
        ) {

        /* volatile parameter : insert indirect call */
        return new_chain2(new_icall(p->loc, p->first, 0),
                          new_ref(p->loc, ref_var, transfer_variable(p->first->type), NULL)
            );
    }

    return p;
}

tree squash_assign(tree p, tree scope)
{
    tree source = follow(p->next);
    tree dest = follow(p->first);
    stack_guard;

#ifdef __DEBUG__
    trace_subtree(p);
#endif

    assert_kind(p->loc, p, node_assign);
    assert_kind(p->loc, dest, node_ref);
#ifdef __DEBUG__
    assert_kind(p->loc, dest->first, node_var); /* can be node_w! */
#endif

    if ((dest->ref == ref_actual)
        && (dest->first->is_volatile)
        && (source->kind == node_ref)
        && (source->ref == ref_formal)
        && (source->first->is_volatile)
        ) {

        /* A very special situation: pass one of our virtual
            parameters along to a subsequent call.
            This can be handled as a normal assignment!
            it is the indirection address which is copied, but that is
            of no concern to the code generation lateron...
         */

        /* 0.4-28 : make sure the right hand side is not handled as indirect! */
        source->indirect = false;

        return p;
    }
#ifdef __DEBUG__
    trace
        log((m, "%d %d %d %d", (int) (dest->ref == ref_actual),
             (int) ((dest->is_volatile) ||
                    (dest->first->is_volatile)), (int) (source->kind == node_ref),
             (int) (source->indirect)));
#endif
    if ((dest->ref == ref_actual)
        && ((dest->is_volatile) || (dest->first->is_volatile))
        && (source->kind == node_ref)
        && ((source->first->indirect) || (source->indirect))
        ) {
#ifdef __DEBUG__
        trace
#endif
            /* we are supplying an actual for a volatile parameter,
             * source is indirect:
             * pass indirect address;  do not squash the source */
            /* create put if needed */
            if ((source->first->put == NULL)
                && (mode_has(dest->first->mode, mode_in))
            ) {
            tree proc;
#ifdef __DEBUG__
            trace
#endif
                /* construct the procedure */
                proc = new_proc("generated", NULL, NULL);
            proc->address = new_label(NULL, "p_%d_%s_aput", proc->nr, "generated");
            proc->label = proc->address->name;
            proc->tlabel = new_label(NULL, "p_%d_%s_tput", proc->nr, "generated");
            proc->transfer1 = new_chain2(proc->address, /* this is a dirty hack */
                               new_assign(source->loc,
                               new_ref(NULL, ref_var, source->first, NULL),
                               new_ref(NULL, ref_var, transfer_variable(source->first->type), NULL))
                );
            proc->first = NULL;
            proc->next = proc->address;
            proc->is_virtual = true;
            proc->generated = true;
            /* note it as 'put procedure */
            source->first->put = proc;

            /* add the declartion at the outermost scope */
            squash_outer_scope->next = new_chain2(new_decl(p->loc, proc), squash_outer_scope->next);
#ifdef __DEBUG__
            trace_subtree(squash_outer_scope);
#endif
        }
#ifdef __DEBUG__
        trace
#endif
            /* note that this routine is used indirect */
            if (source->first->put != NULL) {
#ifdef __DEBUG__
            trace
#endif
                source->first->put->has_transfer = true;
        }
        /* create get if needed */
        if ((source->first->get == NULL)
            && (mode_has(dest->first->mode, mode_out))
            ) {
            tree proc;
#ifdef __DEBUG__
            trace
#endif
                proc = new_proc("generated", NULL, NULL);
            proc->address = new_label(NULL, "p_%d_%s_aget", proc->nr, "generated");
            proc->label = proc->address->name;
            proc->tlabel = new_label(proc->loc, "p_%d_%s_tget", proc->nr, "generated");
            proc->transfer2 = new_chain2(proc->address, /* this is a dirty hack */
                              new_assign(NULL, new_ref(NULL, ref_var,
                                      transfer_variable(source->first->type), NULL), 
                                      new_ref(NULL, ref_var, source->first, NULL))
                );
            proc->first = NULL;
            proc->next = proc->address;
            proc->is_virtual = true;
            source->first->get = proc;

            squash_outer_scope->next = new_chain2(new_decl(p->loc, proc), squash_outer_scope->next);
        }
#ifdef __DEBUG__
        trace_subtree(squash_outer_scope);
#endif
        if (source->first->get != NULL) {
#ifdef __DEBUG__
            trace
#endif
                source->first->get->has_transfer = true;
        }
        return p;
    }
#ifdef __DEBUG__
    trace
#endif
        if ((dest->ref == ref_var)
            && (dest->first->put != NULL)
            && (!dest->first->put->generated)
        ) {
        tree q, par, result;

        /* target is a (global or local) indirect variable */
        p->next = squash_node(p->next, scope);

/* wovo */
#ifdef __DEBUG__
        trace show_subtree(p);
        log((m, "htv=%d", (int) dest->first->get->has_transfer));
#endif

        q = arg(dest->first->put, 1, true);
        if (q->pass_in_w) {
            par = new_ref(p->loc, ref_var, new_w(NULL, mode_out), NULL);
        } else {
            par = new_ref(p->loc, ref_var, q, NULL);
        }

        /* insert put call */
        assert_kind(p->loc, dest->first->put, node_procedure);
#ifdef __DEBUG__
        trace
#endif
            result =
            new_chain3(new_precall(p->loc, dest->first->put), new_assign(p->loc, par, p->next),
                       new_call(p->loc, dest->first->put)
            );
#ifdef __DEBUG__
        trace
#endif
            return result;
    }
#ifdef __DEBUG__
    trace
#endif
        if ((dest->ref == ref_formal)
            && (dest->first->is_volatile)
        ) {

        /* target is a volatile parameter */
        p->next = squash_node(p->next, scope);

        /* insert indirect put call */
        return
            new_chain2(
                   new_assign (p->first->loc,
                        new_ref(p->first->loc, ref_var, transfer_variable(p->first->first->type),
                                NULL), p->next), new_icall(p->loc, dest->first, 1)
            );
    }
#ifdef __DEBUG__
    trace
#endif
        /* don't squash p->first, do squash p->next */
        p->next = squash_node(p->next, scope);

#ifdef __DEBUG__
    trace
#endif
        /* no further squashing needed... */
        return p;
}

tree squash_for(tree p, tree scope)
{
    tree decl = NULL;
    stack_guard;

    assert_kind(p->loc, p, node_for);
#ifdef __DEBUG__
    log((m, "for loca=%s", location_string(p->loc)));
#endif
    p->first = squash_node(p->first, scope);
    p->var = squash_node(p->var, scope);
    p->start = squash_node(p->start, scope);
    p->step = squash_node(p->step, scope);
    p->end = squash_node(p->end, scope);

    /* create start one ? */
    if (p->start == NULL) {
        p->start = new_ref(p->loc, ref_const, const_zero, NULL);
    }

    /* create step one ? */
    if (p->step == NULL) {
        p->step = new_ref(p->loc, ref_const, const_one, NULL);
    }

    /* create temporary for control var? */
    if (p->var == NULL) {
        string s;
        sprintf(s, "_loop_temp_%d", p->nr);
        assert_pointer(p->loc, p->end);
        assert_kind(p->loc, p->end->type, node_type);
        p->var = new_var(p->loc, s, p->end->type);
        decl = new_decl(p->loc, p->var);
    }

    /* no control var specified by the user? */
    if (decl != NULL) {
        tree again_label = new_label(p->loc, "f_%d_again", p->nr, "");
        tree beyond_label = new_label(p->loc, "f_%d_beyond", p->nr, "");

#ifdef __DEBUG__
        trace_subtree(again_label);
        log((m, "loca=%s", location_string(again_label->loc)));
#endif

        /* for 5 loop */
        if (node_is_some_constant(p->end)
            && (!node_is_constant(p->end, 0))
            ) {
            return new_chain6(decl,
                              new_assign(p->loc, new_ref(p->loc, ref_var, p->var, NULL), p->end),
                              again_label, p->first, code_code_page(again_label,
                                 code_register_bank(p->var,
                                new_asm (nowhere, opcode_decfsz, p->var, dest_f))),
                              new_asm(nowhere, opcode_goto, again_label, 0)
                );

            /* for x loop */
        } else if (false        /* node_is_plain_variable( p->end ) */
            ) {
            return new_chain7(decl, new_chain2( /* should be done with a plain assignment! */
                                code_register_bank(p->end,
                                 new_asm(nowhere, opcode_incf, p->end, dest_w)),
                                new_assign(p->loc, p->var, 
                                        new_ref(p->loc, ref_var, new_w(NULL, mode_out), NULL))
                              ), again_label,
                              new_chain2(code_code_page (beyond_label,
                                code_register_bank(p->var, 
                                new_asm(nowhere, opcode_decfsz, p->var, dest_f))), 
                                      new_asm(nowhere, opcode_goto, beyond_label, 0)), p->first, 
                              code_code_page(beyond_label, code_register_bank(p->var,
                              new_asm(nowhere, opcode_decfsz, p->var, dest_f))), beyond_label);

        } else {
            /* less eficient, but better than the general while case */
            return new_chain3(decl,
                              new_assign(p->loc, new_ref(p->loc, ref_var, p->var, NULL), p->end),
                              create_while(p->loc, new_op(p->loc, type_bit, op_not_equal,
                                          new_ref(p->loc, ref_var, p->var, NULL), p->start),
                                           new_chain2(p->first, code_register_bank(p->var,
                                           new_asm(nowhere, opcode_decf, p->var, dest_f)))));

        }
    }

    /* general case: build the assign, while and step */
    if ((target_cpu == pic_14) || (target_cpu == pic_16)) {

        return new_chain3(decl,
                          new_assign(p->loc, new_ref(p->loc, ref_var, p->var, NULL), p->start),
                          create_while(p->loc,
                                       new_op(p->loc, type_bit, op_not_equal,
                                              new_ref(p->loc, ref_var, p->var, NULL), p->end),
                                       new_chain2(p->first, new_assign(p->loc,
                                            new_ref(p->loc, ref_var, p->var, NULL),
                                            new_op(p->loc, p->var->type, op_plus,
                                            new_ref(p->loc, ref_var, p->var, NULL), p->step)))));

    } else {

        string s;
        tree decl_step, decl_end;
        sprintf(s, "_loop_step_temp_%d", p->nr);
        decl_step = new_var(p->loc, s, p->end->type);
        sprintf(s, "_loop_end_temp_%d", p->nr);
        decl_end = new_var(p->loc, s, p->end->type);

        return new_chain5(decl, new_decl(p->loc, decl_step), new_decl(p->loc, decl_end),
                          new_chain3(new_assign
                                     (p->loc, new_ref(p->loc, ref_var, decl_step, NULL), p->step),
                                     new_assign(p->loc, new_ref(p->loc, ref_var, decl_end, NULL),
                                                p->end), new_assign(p->loc, 
                                                new_ref(p->loc, ref_var, p->var, NULL), p->start)), 
                          create_while(p->loc, new_op(p->loc, type_bit, op_not_equal,
                          new_ref(p->loc, ref_var, p->var, NULL),
                          new_ref(p->loc, ref_var, decl_end, NULL)), 
                          new_chain2(p->first, new_assign(p->loc, new_ref(p->loc, ref_var, p->var, NULL), 
                        new_op(p->loc, p->var-> type, op_plus, new_ref(p-> loc, ref_var, p-> var, NULL),
                        new_ref(p-> loc, ref_var, decl_step, NULL))))));

    }
}

/* remove the implementation pointer for primitive operations */
void squash_buildins(tree p)
{

    /* don't call the rtl for these bit-operations */
    if (is_simple_op(p, type_bit)) {
        switch (p->op) {
        case op_and:
        case op_or:
        case op_xor:
        case op_equal:
        case op_not_equal:
        case op_mnot:{
                p->impl = NULL;
                break;
            }
        default:{
                break;
            }
        }
    }

    if (is_simple_op(p, type_byte)) {

        switch (p->op) {

        case op_and:
        case op_or:
        case op_xor:
        case op_equal:
        case op_not_equal:
        case op_smaller_or_equal:
        case op_larger:
        case op_minus:
        case op_plus:
        case op_mnot:
        case op_mminus:
        case op_mplus:{
                p->impl = NULL;
                break;
            }

        case op_shift_left:
        case op_shift_right:{
                /* shift by one or four does not need a call */
                if (((node_is_constant(p->next, 1))
                     || ((node_is_constant(p->next, 4))
                         && ((target_cpu == pic_14)
                             || (target_cpu == pic_16))
                     )
                    ) && ((p->first->kind == node_ref)
                    )) {
                    p->impl = NULL;
                }
                break;
            }

        case op_smaller:{
                swapp(p->first, p->next);
                p->op = op_larger;
                p->impl = NULL;
                break;
            }

        case op_larger_or_equal:{
                swapp(p->first, p->next);
                p->op = op_smaller_or_equal;
                p->impl = NULL;
                break;
            }

        case op_times:
        case op_divide:
        case op_modulo:
        case op_check:{
                break;
            }

        default:{
                /* there are no other operations */
                snark_node(p->loc, p);
                break;
            }
        }
    }
}

tree squash_op(tree p, tree scope)
{
    stack_guard;

    /* first squash lower nodes */
    p->first = squash_node(p->first, scope);
    p->next = squash_node(p->next, scope);
    squash_buildins(p);

    if (verbose_squasher)
        log((m, "squash nr=%04d sqf=%d", p->nr, p->impl));

    /* handle operators which are implemented by small procedures */
    if (p->impl != NULL) {
        string s;
        tree x;

        if (verbose_squasher)
            log((m, "squash nr=%04d call rtl", p->nr));
        assert_pointer(p->loc, p->impl->result);
        assert_pointer(p->loc, p->impl->result->first);

        /* create temporary, append it to the scope node */
        sprintf(s, "sq_temp_%d", p->nr);
        x = new_var(NULL, s, p->type);
        scope->next = new_chain2(new_decl(p->loc, x), scope->next);

        return new_chain2(new_chain5(
                                        /* precall */
                                        new_precall(p->loc, p->impl),
                                        /* pass the in parameters */
                                        new_assign(p->loc, new_ref(p->loc, ref_actual,
                                                           arg(p->impl, 1, true), NULL), p->first),
                                        new_assign(p->loc, new_ref(p->loc, ref_actual,
                                                           arg(p->impl, 2, true), NULL), p->next),
                                        /* call */
                                        new_call(p->loc, p->impl),
                                        /* get the result */
                                        new_assign(p->loc, new_ref(p->loc, ref_var, x, NULL),
                                                   new_ref(p->loc, ref_actual,
                                                           p->impl->result->first, NULL)
                                        )
                          ),
                          /* 'return' the temporary */
                          new_ref(p->loc, ref_var, x, NULL)
            );
    }

    if (p->first->kind == node_chain) {
#ifdef __DEBUG__
        trace_subtree(p);
#endif
        if (false) {
            tree q = new_chain2(p->first,
                                p);
            p->first = follow(p->first);
            p = q;
#ifdef __DEBUG__
            trace_subtree(p);
#endif
        }
    }

    /* for PIC build-in operators extract the second argument */
    if ((p->next != NULL)
        && ((p->next->type != type_bit)
            || (p->op == op_xor)
        )
        && ((p->next->kind != node_ref)
            || (((target_cpu == sx_12) || (target_cpu == pic_12))
                && node_is_some_constant(p->next)
/*            && ( ! node_is_constant( p->next, 0 ) ) */
                && (!node_is_constant(p->next, 1))
                && (opcode_from_const[p->op] == opcode_undefined)
                && (p->impl == NULL)
            )
            || (((target_cpu == sx_12) || (target_cpu == pic_12))
                && node_is_some_constant(p->next)
                && ((((p->op == op_minus) || (p->op == op_plus))
                     && (!node_is_constant(p->next, 1))
                     && (!node_is_constant(p->next, -1))
                    )
                    || ((p->op == op_minus) || (p->op == op_plus))      /* because of (a&5)+1 */
                    ||(p->op == op_equal)
                    || (p->op == op_larger)
                    || (p->op == op_smaller)
                    || (p->op == op_larger_or_equal)
                    || (p->op == op_smaller_or_equal)
                )
            )
        )
        ) {
        tree x, t;
        string s;
        tree old_next = p->next;
#ifdef __DEBUG__
        trace_subtree(p);
#endif
        /* create temporary, append it to the scope node */
        sprintf(s, "sqx_temp_%d", p->nr);
        t = follow(p->next)->type;
        if (t == type_universal)
            t = type_byte;
        x = new_var(NULL, s, t);
#ifdef __DEBUG__
        x = new_var(NULL, s, follow(p->first)->type);
#endif
        scope->next = new_chain2(new_decl(p->loc, x), scope->next);

#ifdef __DEBUG__
        trace_subtree(scope);
        trace_subtree(x);
#endif


        /* replace the squashed expression */
        p->next = new_ref(p->loc, ref_var, x, NULL);

        /* put the calculation before p */
        {
            tree q;

            q = new_chain2(new_assign(p->loc, new_ref(p->loc, ref_var, x, NULL), old_next), p);

            return q;
        }
    }

    /* was not here in 0.03-02 ?? */
 
  return p;
}

tree squash_chain(tree p, tree scope)
{
    tree q = p;
    stack_guard;
    assert_kind(p->loc, p, node_chain);

    /* walk the chain, don't use recursion */
    for (;;) {
        p->next = squash_node(p->next, scope);
        p = p->next;
        if (p == NULL)
            return q;
        if (p->kind != node_chain) {
            p = squash_node(p, scope);
            return q;
        }
    }
}

tree squash_node(tree p, tree scope)
{
    stack_guard;

    if (p == NULL)
        return NULL;

    if (verbose_squasher)
        log((m, "squash node nr=%04d kind=%d %s", p->nr, p->kind, node_name[p->kind]));

    switch (p->kind) {

    case node_asm:
    case node_label:
    case node_precall:
    case node_call:
    case node_type:
    case node_return:
    case node_var:
    case node_error:
    case node_w:
    case node_org:
    case node_test:{
            break;
        }

    case node_ref:{
            p = squash_ref(p, scope);
            break;
        }

    case node_assign:{
            p = squash_assign(p, scope);
            break;
        }

    case node_const:
    case node_decl:
    case node_chain:
    case node_procedure:
    case node_if:
    case node_while:{
            p->first = squash_node(p->first, scope);
            p->condition = squash_node(p->condition, scope);

            {                   /* temporaries can be instered behind p */
                tree q, z;
                z = p->next;
                p->next = NULL;
                q = squash_node(z, p);
                for (z = p; z->next != NULL; z = z->next);
                z->next = q;
            }

            break;
        }

    case node_for:{
            p = squash_for(p, scope);
            break;
        }

    case node_op:{
            p = squash_op(p, scope);
            break;
        }

    default:{
            snark_node(p->loc, p);
            break;
        }
    }

    return p;
}

void squash(tree * p)
{
    /* why???? */
    tree q = new_chain2(NULL, *p);
    tree r = new_chain2(NULL, q);
    stack_guard;
    squash_outer_scope = r;
    q->next = squash_node(q->next, r);
    *p = r;
}
