/* stack size guarding
   Copyright (C) 1998, 1999, 2000, 2001, 2002, 2003
   Wouter van Ooijen

This file is part of jal.

jal is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

jal is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with jal; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#ifndef __STACKSG_H__
#define __STACKSG_H__

/********** compiler and platform specifics **********/

#define Kb 1024
#define Mb ( 1024 * 1024 )
#define stack_size   5000 * Kb
#define stack_margin   50 * Kb
#define stack_use_depth 65535

void stack_guard_init(void);
void stack_guard_f(int line);
void stack_dump(void);

extern int max_stack_size;
extern boolean check_stack;


#define stack_guard { if( check_stack ) stack_guard_f( __LINE__ ); }

#endif
