/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import org.apache.log4j.Layout;
import org.apache.log4j.helpers.DateLayout;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.spi.LoggingEvent;

public class TTCCLayout
extends DateLayout {
    public static final String THREAD_PRINTING_OPTION = "ThreadPrinting";
    public static final String CATEGORY_PREFIXING_OPTION = "CategoryPrefixing";
    public static final String CONTEXT_PRINTING_OPTION = "ContextPrinting";
    private boolean threadPrinting = true;
    private boolean categoryPrefixing = true;
    private boolean contextPrinting = true;
    protected final StringBuffer buf = new StringBuffer(256);

    public String format(LoggingEvent loggingEvent) {
        this.buf.setLength(0);
        this.dateFormat(this.buf, loggingEvent);
        if (this.threadPrinting) {
            this.buf.append('[');
            this.buf.append(loggingEvent.getThreadName());
            this.buf.append("] ");
        }
        this.buf.append(loggingEvent.priority.toString());
        this.buf.append(' ');
        if (this.categoryPrefixing) {
            this.buf.append(loggingEvent.categoryName);
            this.buf.append(' ');
        }
        if (this.contextPrinting) {
            loggingEvent.getNDC();
            if (loggingEvent.ndc != null) {
                this.buf.append(loggingEvent.ndc);
                this.buf.append(' ');
            }
        }
        this.buf.append("- ");
        this.buf.append(loggingEvent.message);
        this.buf.append(Layout.LINE_SEP);
        return this.buf.toString();
    }

    public String[] getOptionStrings() {
        return OptionConverter.concatanateArrays(super.getOptionStrings(), new String[]{THREAD_PRINTING_OPTION, CATEGORY_PREFIXING_OPTION, CONTEXT_PRINTING_OPTION});
    }

    public boolean ignoresThrowable() {
        return true;
    }

    public void setOption(String string, String string2) {
        super.setOption(string, string2);
        if (string.equalsIgnoreCase(THREAD_PRINTING_OPTION)) {
            this.threadPrinting = OptionConverter.toBoolean(string2, this.threadPrinting);
        } else if (string.equalsIgnoreCase(CATEGORY_PREFIXING_OPTION)) {
            this.categoryPrefixing = OptionConverter.toBoolean(string2, this.categoryPrefixing);
        } else if (string.equalsIgnoreCase(CONTEXT_PRINTING_OPTION)) {
            this.contextPrinting = OptionConverter.toBoolean(string2, this.contextPrinting);
        }
    }

    public void setCategoryPrefixing(boolean bl) {
        this.categoryPrefixing = bl;
    }

    public void setThreadPrinting(boolean bl) {
        this.threadPrinting = bl;
    }

    public TTCCLayout() {
        this.setDateFormat("RELATIVE", null);
    }

    public TTCCLayout(String string) {
        this.setDateFormat(string);
    }
}

