/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.net;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.spi.LoggingEvent;

public class SocketAppender
extends AppenderSkeleton {
    private static final int RESET_FREQUENCY = 1;
    public static final String REMOTE_HOST_OPTION = "RemoteHost";
    public static final String PORT_OPTION = "Port";
    public static final String LOCATION_INFO_OPTION = "LocationInfo";
    public static final String RECONNECTION_DELAY_OPTION = "ReconnectionDelay";
    InetAddress address;
    int port = 4560;
    String hostName;
    ObjectOutputStream oos;
    int reconnectionDelay = 30000;
    boolean locationInfo = false;
    private Connector connector;
    int counter = 0;

    public void activateOptions() {
        this.connect(this.address, this.port);
    }

    public void close() {
        this.closed = true;
        this.cleanUp();
    }

    public void cleanUp() {
        if (this.oos != null) {
            try {
                this.oos.close();
            }
            catch (IOException iOException) {
                LogLog.error("Could not close oos.", iOException);
            }
            this.oos = null;
        }
        if (this.connector != null) {
            this.connector.interrupt();
            this.connector = null;
        }
    }

    void connect(InetAddress inetAddress, int n) {
        if (this.address == null) {
            return;
        }
        try {
            this.cleanUp();
            this.oos = new ObjectOutputStream(new Socket(inetAddress, n).getOutputStream());
        }
        catch (IOException iOException) {
            LogLog.error("Could not connect to remote log4j server at [" + inetAddress.getHostName() + "]. We will try again later.", iOException);
            this.fireConnector();
        }
    }

    public void append(LoggingEvent loggingEvent) {
        if (this.address == null) {
            this.errorHandler.error("No remote host is set for SocketAppedender named \"" + this.name + "\".");
            return;
        }
        if (this.oos != null) {
            try {
                if (this.locationInfo) {
                    loggingEvent.setLocationInformation();
                }
                this.oos.writeObject(loggingEvent);
                this.oos.flush();
                if (++this.counter >= 1) {
                    this.counter = 0;
                    this.oos.reset();
                }
            }
            catch (IOException iOException) {
                this.oos = null;
                LogLog.debug("Detected problem with connection: " + iOException);
                this.fireConnector();
            }
        }
    }

    void fireConnector() {
        if (this.connector == null) {
            LogLog.debug("Starting a new connector thread.");
            SocketAppender socketAppender = this;
            if (socketAppender == null) {
                throw null;
            }
            this.connector = socketAppender.new Connector();
            this.connector.setDaemon(true);
            this.connector.setPriority(1);
            this.connector.start();
        }
    }

    InetAddress getAddressByName(String string) {
        try {
            return InetAddress.getByName(string);
        }
        catch (Exception exception) {
            LogLog.error("Could not find address of [" + string + "].", exception);
            return null;
        }
    }

    public String[] getOptionStrings() {
        return OptionConverter.concatanateArrays(super.getOptionStrings(), new String[]{REMOTE_HOST_OPTION, PORT_OPTION, LOCATION_INFO_OPTION, RECONNECTION_DELAY_OPTION});
    }

    public boolean requiresLayout() {
        return false;
    }

    public void setOption(String string, String string2) {
        if (string2 == null) {
            return;
        }
        super.setOption(string, string2);
        if (string.equals(REMOTE_HOST_OPTION)) {
            this.address = this.getAddressByName(string2);
        } else if (string.equals(PORT_OPTION)) {
            this.port = OptionConverter.toInt(string2, this.port);
        } else if (string.equals(LOCATION_INFO_OPTION)) {
            this.locationInfo = OptionConverter.toBoolean(string2, this.locationInfo);
        } else if (string.equals(RECONNECTION_DELAY_OPTION)) {
            this.reconnectionDelay = OptionConverter.toInt(string2, this.reconnectionDelay);
        }
    }

    static /* synthetic */ boolean access$0(SocketAppender socketAppender) {
        return socketAppender.closed;
    }

    static /* synthetic */ Connector access$3(SocketAppender socketAppender) {
        return socketAppender.connector;
    }

    public SocketAppender() {
    }

    public SocketAppender(InetAddress inetAddress, int n) {
        this.address = inetAddress;
        this.port = n;
        this.hostName = inetAddress.getHostName();
        this.connect(inetAddress, n);
    }

    public SocketAppender(String string, int n) {
        this.port = n;
        this.hostName = string;
        this.address = this.getAddressByName(string);
        this.connect(this.address, n);
    }

    class Connector
    extends Thread {
        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            while (!this.isInterrupted()) {
                try {
                    Thread.sleep(SocketAppender.this.reconnectionDelay);
                    LogLog.debug("Attempting connection to " + SocketAppender.this.address.getHostName());
                    Socket socket = new Socket(SocketAppender.this.address, SocketAppender.this.port);
                    Connector connector = this;
                    synchronized (connector) {
                        SocketAppender.this.oos = new ObjectOutputStream(socket.getOutputStream());
                        SocketAppender.this.connector = null;
                        return;
                    }
                }
                catch (InterruptedException interruptedException) {
                    LogLog.debug("Connector interrupted. Leaving loop.");
                    return;
                }
                catch (ConnectException connectException) {
                    LogLog.debug("Remote host " + SocketAppender.this.address.getHostName() + " refused connection.");
                }
                catch (IOException iOException) {
                    LogLog.debug("Could not connect to " + SocketAppender.this.address.getHostName() + ". Exception is " + iOException);
                }
            }
        }

        Connector() {
        }
    }
}

