/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.xml;

import org.apache.log4j.Layout;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.spi.LoggingEvent;

public class XMLLayout
extends Layout {
    public static final String LOCATION_INFO_OPTION = "LocationInfo";
    private final int DEFAULT_SIZE;
    private final int UPPER_LIMIT;
    private StringBuffer buf = new StringBuffer(256);
    private boolean locationInfo = false;

    public void activateOptions() {
    }

    public String format(LoggingEvent loggingEvent) {
        String string;
        if (this.buf.capacity() > 2048) {
            this.buf = new StringBuffer(256);
        } else {
            this.buf.setLength(0);
        }
        this.buf.append("<log4j:event category=\"");
        this.buf.append(loggingEvent.categoryName);
        this.buf.append("\" timestamp=\"");
        this.buf.append(loggingEvent.timeStamp);
        this.buf.append("\" priority=\"");
        this.buf.append(loggingEvent.priority);
        this.buf.append("\" thread=\"");
        this.buf.append(loggingEvent.getThreadName());
        this.buf.append("\">\r\n");
        this.buf.append("<log4j:message>");
        this.buf.append(loggingEvent.message);
        this.buf.append("</log4j:message>\r\n");
        String string2 = loggingEvent.getNDC();
        if (string2 != null) {
            this.buf.append("<log4j:NDC>");
            this.buf.append(string2);
            this.buf.append("</log4j:NDC>\r\n");
        }
        if ((string = loggingEvent.getThrowableInformation()) != null) {
            this.buf.append("<log4j:throwable>");
            this.buf.append(string);
            this.buf.append("</log4j:throwable>\r\n");
        }
        if (this.locationInfo) {
            loggingEvent.setLocationInformation();
            this.buf.append("<log4j:locationInfo class=\"");
            this.buf.append(loggingEvent.locationInfo.getClassName());
            this.buf.append("\" method=\"");
            this.buf.append(loggingEvent.locationInfo.getMethodName());
            this.buf.append("\" file=\"");
            this.buf.append(loggingEvent.locationInfo.getFileName());
            this.buf.append("\" line=\"");
            this.buf.append(loggingEvent.locationInfo.getLineNumber());
            this.buf.append("\"/>\r\n");
        }
        this.buf.append("</log4j:event>\r\n\r\n");
        return this.buf.toString();
    }

    public String[] getOptionStrings() {
        return new String[]{LOCATION_INFO_OPTION};
    }

    public boolean ignoresThrowable() {
        return false;
    }

    public void setOption(String string, String string2) {
        if (string2 == null) {
            return;
        }
        if (string.equals(LOCATION_INFO_OPTION)) {
            this.locationInfo = OptionConverter.toBoolean(string2, this.locationInfo);
        }
    }

    public XMLLayout() {
        this.DEFAULT_SIZE = 256;
        this.UPPER_LIMIT = 2048;
    }
}

