/**
 *    Copyright (C) 2021-present MongoDB, Inc.
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the Server Side Public License, version 1,
 *    as published by MongoDB, Inc.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    Server Side Public License for more details.
 *
 *    You should have received a copy of the Server Side Public License
 *    along with this program. If not, see
 *    <http://www.mongodb.com/licensing/server-side-public-license>.
 *
 *    As a special exception, the copyright holders give permission to link the
 *    code of portions of this program with the OpenSSL library under certain
 *    conditions as described in each individual source file and distribute
 *    linked combinations including the program with the OpenSSL library. You
 *    must comply with the Server Side Public License in all respects for
 *    all of the code used other than as permitted herein. If you modify file(s)
 *    with this exception, you may extend this exception to your version of the
 *    file(s), but you are not obligated to do so. If you do not wish to do so,
 *    delete this exception statement from your version. If you delete this
 *    exception statement from all source files in the program, then also delete
 *    it in the license file.
 */

#include <cstdint>

#include "mongo/platform/atomic_word.h"
#include "mongo/util/processinfo.h"

namespace mongo {

AtomicWord<long long> gTimeseriesIdleBucketExpiryMemoryUsageThresholdBytes{-1};
AtomicWord<long long> gTimeseriesSideBucketCatalogMemoryUsageThresholdBytes{104857600};  // 100MB

uint64_t getTimeseriesIdleBucketExpiryMemoryUsageThresholdBytes() {
    long long userValue = gTimeseriesIdleBucketExpiryMemoryUsageThresholdBytes.load();
    if (userValue <= 0) {
        userValue = 5;  // Negative values are interpreted as 5% of system memory
    }

    if (userValue <= 100) {
        const uint64_t systemBasedValue{ProcessInfo::getSystemMemSizeMB() * userValue *
                                        10485};  // ~% of system memory. 10485 ~= 1024*1024/100.
        return systemBasedValue;
    }

    return userValue;
}

uint64_t getTimeseriesSideBucketCatalogMemoryUsageThresholdBytes() {
    return static_cast<uint64_t>(gTimeseriesSideBucketCatalogMemoryUsageThresholdBytes.load());
}

}  // namespace mongo
