#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <ctype.h>
#include <pwd.h>
#include <signal.h>
#include <errno.h>

/* configure #defines the types we need that we don't have.
   unfortunately, this screws up cproto.   so work around
   my broken header files...
*/

#ifdef size_t
typedef size_t
#undef size_t
      size_t;
#endif

#ifdef mode_t
typedef mode_t
#undef mode_t
      mode_t;
#endif

#ifdef pid_t
typedef pid_t
#undef pid_t
      pid_t;
#endif

#ifdef FILE
typedef FILE
#undef FILE
      FILE;
#endif

typedef RETSIGTYPE retsigtype;

#include "fgetl.h"
#include "getopt.h"

#ifdef __STDC__
	typedef void *voidptr;
#else
	typedef char *voidptr;
#endif

#ifdef HAVE_STRING_H
#	include <string.h>
#endif

#ifdef HAVE_STRINGS_H
#	include <strings.h>
#endif

#ifdef HAVE_SGTTY_H
#	include <sgtty.h>
#endif

#ifdef HAVE_SYS_IOCTL_H
#	include <sys/ioctl.h>
#endif

#ifdef HAVE_UNISTD_H
#	include <unistd.h>
#endif

#ifdef HAVE_LIBC_H
#	include <libc.h>
#endif

#ifdef HAVE_TERMCAP_H

/* does this actually exist anywhere?
   Yes, under Linux, it looks like.
*/

#	include <termcap.h>
#else
	int tgetent();
	void tputs();
	char *tgetstr();
	char *tgoto();
	int tgetnum();
#endif

/* list all our processes, PID first.
   Silliness to make it work on both sysv and bsd, and even aix,
   and brand-new silliness to make it work with 4.4BSD
*/

#define PSCMD "(ps -opid,ucomm || ps xc || ps -a) 2>/dev/null | sed 's/ *$//'"

#define same(a,b) (strcmp ((a), (b)) == 0)
#define THISBUFFERSIZE 8000   /* stdout buffer size */

struct flist {
	char *name;
	struct flist *next;
};
typedef struct flist flist;

struct mailbox {
	char *name;
	long size;
	flist *isdir;	/* 0 if not a dir; string list ptr if so */
	time_t mtime;

	struct mailbox *next;
};
typedef struct mailbox mailbox;

struct hlist {
	char *from;
	char *to;
	char *subject;
	long startpoint;
	long endpoint;
	int msgnumint;
	char *msgnumstr;
	char *postmark;
};
typedef struct hlist hlist;

extern int errno;

#include "proto.h"

#ifndef HAVE_STRERROR
#   ifdef __STDC__
	char *strerror (int);
#   else
	char *strerror();
#   endif
#endif

extern char *program;      /* program name */
extern int biff;           /* --biff option enabled */
extern int wantquote;      /* --quote or --verbose enabled */
extern char thisbuffer[];  /* for stdout buffering */
extern pid_t shell;        /* process ID of our parent shell */
extern char *lastadd;      /* name of last file notified from */
extern int likeinverse;    /* funky inverse video notifications */
extern int fileannounce;   /* tell what file new mail is in */
extern int debug;
extern int terse;          /* be terse about our messages (--terse) */
extern int preferaddr;     /* addresses instead of names (--address) */

#define JUSTNAME 0
#define JUSTADDR 1
#define CANONICAL 2
