/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.generic.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Locale;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericTableConstraintColumn;
import org.jkiss.dbeaver.ext.generic.model.GenericUniqueKey;
import org.jkiss.dbeaver.ext.generic.model.GenericUtils;
import org.jkiss.dbeaver.ext.generic.model.TableCache;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaObject;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCCompositeCache;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCStructCache;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class ConstraintKeysCache
extends JDBCCompositeCache<GenericStructContainer, GenericTableBase, GenericUniqueKey, GenericTableConstraintColumn> {
    private final GenericMetaObject pkObject;

    ConstraintKeysCache(TableCache tableCache) {
        super((JDBCStructCache)tableCache, GenericTableBase.class, GenericUtils.getColumn(tableCache.getDataSource(), "primary-key", "TABLE_NAME"), GenericUtils.getColumn(tableCache.getDataSource(), "primary-key", "PK_NAME"));
        this.pkObject = tableCache.getDataSource().getMetaObject("primary-key");
    }

    @NotNull
    protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer owner, @Nullable GenericTableBase forParent) throws SQLException {
        try {
            return owner.getDataSource().getMetaModel().prepareUniqueConstraintsLoadStatement(session, owner, forParent);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            if (forParent == null) {
                throw new SQLException("Global primary keys read not supported", e);
            }
            throw new SQLException(e);
        }
    }

    protected String getDefaultObjectName(JDBCResultSet dbResult, String parentName) {
        GenericUtils.safeGetInt(this.pkObject, (ResultSet)dbResult, "KEY_SEQ");
        return parentName.toUpperCase(Locale.ENGLISH) + "_PK";
    }

    @Nullable
    protected GenericUniqueKey fetchObject(@NotNull JDBCSession session, @NotNull GenericStructContainer owner, @NotNull GenericTableBase parent, @NotNull String pkName, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
        return owner.getDataSource().getMetaModel().createConstraintImpl(parent, pkName, owner.getDataSource().getMetaModel().getUniqueConstraintType(dbResult), dbResult, true);
    }

    @Nullable
    protected GenericTableConstraintColumn[] fetchObjectRow(@NotNull JDBCSession session, @NotNull GenericTableBase parent, @NotNull GenericUniqueKey object, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
        return ((GenericDataSource)parent.getDataSource()).getMetaModel().createConstraintColumnsImpl(session, parent, object, this.pkObject, dbResult);
    }

    protected void cacheChildren(@NotNull DBRProgressMonitor monitor, @NotNull GenericUniqueKey primaryKey, @NotNull List<GenericTableConstraintColumn> rows) {
        primaryKey.setAttributeReferences(rows);
    }
}

