.\" $NCDId: @(#)AuOpSer.man,v 1.1 1994/09/27 00:33:32 greg Exp $
.\" copyright 1994 Steven King
.\"
.\" portions are
.\" * Copyright 1993 Network Computing Devices, Inc.
.\" *
.\" * Permission to use, copy, modify, distribute, and sell this software and its
.\" * documentation for any purpose is hereby granted without fee, provided that
.\" * the above copyright notice appear in all copies and that both that
.\" * copyright notice and this permission notice appear in supporting
.\" * documentation, and that the name Network Computing Devices, Inc. not be
.\" * used in advertising or publicity pertaining to distribution of this
.\" * software without specific, written prior permission.
.\" * 
.\" * THIS SOFTWARE IS PROVIDED 'AS-IS'.  NETWORK COMPUTING DEVICES, INC.,
.\" * DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING WITHOUT
.\" * LIMITATION ALL IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
.\" * PARTICULAR PURPOSE, OR NONINFRINGEMENT.  IN NO EVENT SHALL NETWORK
.\" * COMPUTING DEVICES, INC., BE LIABLE FOR ANY DAMAGES WHATSOEVER, INCLUDING
.\" * SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES, INCLUDING LOSS OF USE, DATA,
.\" * OR PROFITS, EVEN IF ADVISED OF THE POSSIBILITY THEREOF, AND REGARDLESS OF
.\" * WHETHER IN AN ACTION IN CONTRACT, TORT OR NEGLIGENCE, ARISING OUT OF OR IN
.\" * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\"
.\" $Id$
.TH AuOpenServer 3 "1.2" "audiolib - housekeeping"
.SH \fBName\fP
\fBAuOpenServer\fP \- connect to audio server
.SH \fBSynopsis\fP
#include <audio/audiolib.h>
.sp 1
AuServer *\fBAuOpenServer\fP(\fIservername\fP, \fInum_authproto\fP, \fIauthproto\fP, \fInum_authdata\fP, \fIauthdata\fP, \fIret_status\fP)
.br
    char *\fIservername\fP;
.br
    int \fInum_authproto\fP;
.br
    char *\fIauthproto\fP;
.br
    int \fInum_authdata\fP;
.br
    char *\fIauthdata\fP;
.br
    char **\fIreturn_status\fP; /* \fBRETURN\fP */
.SH \fBArguments\fP
.IP \fIservername\fP 1i
Specifies the audio server name.
This determines the server and communications domain to be used.
.IP \fInum_authproto\fP 1i
Specifies the length of the connection authorization protocol name.
.IP \fIauthproto\fP 1i
Specifies the name of the connection authorization protocol.
.IP \fInum_authdata\fP 1i
Specifies the length of the connection authorization data.
.IP \fIauthdata\fP 1i
Specifies the connection authorization data.
.IP \fIreturn_status\fP 1i
If non-NULL, and the connection is refused, returns an error message.
.SH \fBDescription\fP
\fBAuOpenServer\fP creates a connection to the specified audio server and returns a pointer to an \fBAuServer\fP structure or NULL, with \fIreturn_status\fP (if non-NULL) pointing to an error message describing the reason, if it was unsuccessfull.
.LP
If \fIservername\fP is NULL or a pointer to NUL, \fBAuOpenServer\fP get the value from the enviroment.
\fIservername\fP has the format \fIhostname\fP:\fIport\fP or \fIhostname\fP::\fIport\fP.
If a double colon (::) separates the hostname and port number, \fBAuOpenServer\fP connects using DECnet streams.
If a single colon (:) separates the hostname and port number, and the hostname is a host machine name, \fBAuOpenServer\fP connects using TCP streams.
If a single colon (:) separates the hostname and port number, and the hostname is "unix", \fBAuOpenServer\fP connects using UNIX domain sockets (or Streams).
If the hostname is not specified, \fBAuOpenServer\fP uses whatever it believes is the fastest transport.
.SH \fBSee Also\fP
\fBAuCloseServer\fP,
\fBAuServerName\fP.
.sp 1
audiolib \- \fBNetwork Audio System\fP C Language Interface
