/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_tt extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ja = "япон";
        final String metaValue_ko = "корея";
        final String metaValue_la = "латин";
        final Object[][] data = new Object[][] {
            { "001", "дөнья" },
            { "002", "Африка" },
            { "003", "Төньяк Америка" },
            { "005", "Көньяк Америка" },
            { "009", "Океания" },
            { "011", "Көнбатыш Африка" },
            { "013", "Үзәк Америка" },
            { "014", "Көнчыгыш Африка" },
            { "015", "Төньяк Африка" },
            { "017", "Урта Африка" },
            { "018", "Көньяктагы Африка" },
            { "019", "Америка" },
            { "021", "Төньяктагы Америка" },
            { "029", "Кариб бассейны" },
            { "030", "Көнчыгыш Азия" },
            { "034", "Көньяк Азия" },
            { "035", "Көньяк-Көнчыгыш Азия" },
            { "039", "Көньяк Европа" },
            { "053", "Австралазия" },
            { "054", "Меланезия" },
            { "057", "Микронезия төбәге" },
            { "061", "Полинезия" },
            { "142", "Азия" },
            { "143", "Үзәк Азия" },
            { "145", "Көнбатыш Азия" },
            { "150", "Европа" },
            { "151", "Көнчыгыш Европа" },
            { "154", "Төньяк Европа" },
            { "155", "Көнбатыш Европа" },
            { "202", "Сахарадан көньякта Африка" },
            { "419", "Латин Америка" },
            { "AC", "Вознесение утравы" },
            { "AD", "Андорра" },
            { "AE", "Берләшкән Гарәп Әмирлекләре" },
            { "AF", "Әфганстан" },
            { "AG", "Антигуа һәм Барбуда" },
            { "AI", "Ангилья" },
            { "AL", "Албания" },
            { "AM", "Әрмәнстан" },
            { "AO", "Ангола" },
            { "AQ", "Антарктика" },
            { "AR", "Аргентина" },
            { "AS", "Америка Самоасы" },
            { "AT", "Австрия" },
            { "AU", "Австралия" },
            { "AW", "Аруба" },
            { "AX", "Аланд утраулары" },
            { "AZ", "Әзәрбайҗан" },
            { "BA", "Босния һәм Герцеговина" },
            { "BB", "Барбадос" },
            { "BD", "Бангладеш" },
            { "BE", "Бельгия" },
            { "BF", "Буркина-Фасо" },
            { "BG", "Болгария" },
            { "BH", "Бәхрәйн" },
            { "BI", "Бурунди" },
            { "BJ", "Бенин" },
            { "BL", "Сен-Бартельми" },
            { "BM", "Бермуд утраулары" },
            { "BN", "Бруней" },
            { "BO", "Боливия" },
            { "BQ", "Кариб Нидерландлары" },
            { "BR", "Бразилия" },
            { "BS", "Багам утраулары" },
            { "BT", "Бутан" },
            { "BV", "Буве утравы" },
            { "BW", "Ботсвана" },
            { "BY", "Беларусь" },
            { "BZ", "Белиз" },
            { "CA", "Канада" },
            { "CC", "Кокос (Килинг) утраулары" },
            { "CD", "Конго (КДР)" },
            { "CF", "Үзәк Африка Республикасы" },
            { "CG", "Конго - Браззавиль" },
            { "CH", "Швейцария" },
            { "CI", "Кот-д’Ивуар" },
            { "CK", "Кук утраулары" },
            { "CL", "Чили" },
            { "CM", "Камерун" },
            { "CN", "Кытай" },
            { "CO", "Колумбия" },
            { "CP", "Клиппертон утравы" },
            { "CQ", "Сарк" },
            { "CR", "Коста-Рика" },
            { "CU", "Куба" },
            { "CV", "Кабо-Верде" },
            { "CW", "Кюрасао" },
            { "CX", "Раштуа утравы" },
            { "CY", "Кипр" },
            { "CZ", "Чехия Республикасы" },
            { "DE", "Германия" },
            { "DG", "Диего Гарсия" },
            { "DJ", "Җибүти" },
            { "DK", "Дания" },
            { "DM", "Доминика" },
            { "DO", "Доминикана Республикасы" },
            { "DZ", "Алжир" },
            { "EA", "Сеута һәм Мелилья" },
            { "EC", "Эквадор" },
            { "EE", "Эстония" },
            { "EG", "Мисыр" },
            { "EH", "Көнбатыш Сахара" },
            { "ER", "Эритрея" },
            { "ES", "Испания" },
            { "ET", "Эфиопия" },
            { "EU", "Европа Берлеге" },
            { "EZ", "Еврозона" },
            { "FI", "Финляндия" },
            { "FJ", "Фиджи" },
            { "FK", "Фолкленд утраулары" },
            { "FM", "Микронезия" },
            { "FO", "Фарер утраулары" },
            { "FR", "Франция" },
            { "GA", "Габон" },
            { "GB", "Берләшкән Корольлек" },
            { "GD", "Гренада" },
            { "GE", "Грузия" },
            { "GF", "Француз Гвианасы" },
            { "GG", "Гернси" },
            { "GH", "Гана" },
            { "GI", "Гибралтар" },
            { "GL", "Гренландия" },
            { "GM", "Гамбия" },
            { "GN", "Гвинея" },
            { "GP", "Гваделупа" },
            { "GQ", "Экваториаль Гвинея" },
            { "GR", "Греция" },
            { "GS", "Көньяк Георгия һәм Көньяк Сандвич утраулары" },
            { "GT", "Гватемала" },
            { "GU", "Гуам" },
            { "GW", "Гвинея-Бисау" },
            { "GY", "Гайана" },
            { "HK", "Гонконг Махсус Идарәле Төбәге" },
            { "HM", "Херд утравы һәм Макдональд утраулары" },
            { "HN", "Гондурас" },
            { "HR", "Хорватия" },
            { "HT", "Гаити" },
            { "HU", "Венгрия" },
            { "IC", "Канар утраулары" },
            { "ID", "Индонезия" },
            { "IE", "Ирландия" },
            { "IL", "Израиль" },
            { "IM", "Мэн утравы" },
            { "IN", "Индия" },
            { "IO", "Британиянең Һинд Океанындагы Территориясе" },
            { "IQ", "Гыйрак" },
            { "IR", "Иран" },
            { "IS", "Исландия" },
            { "IT", "Италия" },
            { "JE", "Джерси" },
            { "JM", "Ямайка" },
            { "JO", "Иордания" },
            { "JP", "Япония" },
            { "KE", "Кения" },
            { "KG", "Кыргызстан" },
            { "KH", "Камбоджа" },
            { "KI", "Кирибати" },
            { "KM", "Комор утраулары" },
            { "KN", "Сент-Китс һәм Невис" },
            { "KP", "Төньяк Корея" },
            { "KR", "Көньяк Корея" },
            { "KW", "Күвәйт" },
            { "KY", "Кайман утраулары" },
            { "KZ", "Казахстан" },
            { "LA", "Лаос" },
            { "LB", "Ливан" },
            { "LC", "Сент-Люсия" },
            { "LI", "Лихтенштейн" },
            { "LK", "Шри-Ланка" },
            { "LR", "Либерия" },
            { "LS", "Лесото" },
            { "LT", "Литва" },
            { "LU", "Люксембург" },
            { "LV", "Латвия" },
            { "LY", "Ливия" },
            { "MA", "Марокко" },
            { "MC", "Монако" },
            { "MD", "Молдова" },
            { "ME", "Черногория" },
            { "MF", "Сент-Мартин" },
            { "MG", "Мадагаскар" },
            { "MH", "Маршалл утраулары" },
            { "MK", "Төньяк Македония" },
            { "ML", "Мали" },
            { "MM", "Мьянма (Бирма)" },
            { "MN", "Монголия" },
            { "MO", "Макао Махсус Идарәле Төбәге" },
            { "MP", "Төньяк Мариана утраулары" },
            { "MQ", "Мартиника" },
            { "MR", "Мавритания" },
            { "MS", "Монтсеррат" },
            { "MT", "Мальта" },
            { "MU", "Маврикий" },
            { "MV", "Мальдив утраулары" },
            { "MW", "Малави" },
            { "MX", "Мексика" },
            { "MY", "Малайзия" },
            { "MZ", "Мозамбик" },
            { "NA", "Намибия" },
            { "NC", "Яңа Каледония" },
            { "NE", "Нигер" },
            { "NF", "Норфолк утравы" },
            { "NG", "Нигерия" },
            { "NI", "Никарагуа" },
            { "NL", "Нидерланд" },
            { "NO", "Норвегия" },
            { "NP", "Непал" },
            { "NR", "Науру" },
            { "NU", "Ниуэ" },
            { "NZ", "Яңа Зеландия" },
            { "OM", "Оман" },
            { "PA", "Панама" },
            { "PE", "Перу" },
            { "PF", "Француз Полинезиясе" },
            { "PG", "Папуа - Яңа Гвинея" },
            { "PH", "Филиппин" },
            { "PK", "Пакистан" },
            { "PL", "Польша" },
            { "PM", "Сен-Пьер һәм Микелон" },
            { "PN", "Питкэрн утраулары" },
            { "PR", "Пуэрто-Рико" },
            { "PS", "Фәләстин территорияләре" },
            { "PT", "Португалия" },
            { "PW", "Палау" },
            { "PY", "Парагвай" },
            { "QA", "Катар" },
            { "QO", "Ерак Океания" },
            { "RE", "Реюньон" },
            { "RO", "Румыния" },
            { "RS", "Сербия" },
            { "RU", "Россия" },
            { "RW", "Руанда" },
            { "SA", "Согуд Гарәбстаны" },
            { "SB", "Сөләйман утраулары" },
            { "SC", "Сейшел утраулары" },
            { "SD", "Судан" },
            { "SE", "Швеция" },
            { "SG", "Сингапур" },
            { "SH", "Изге Елена утравы" },
            { "SI", "Словения" },
            { "SJ", "Шпицберген һәм Ян-Майен" },
            { "SK", "Словакия" },
            { "SL", "Сьерра-Леоне" },
            { "SM", "Сан-Марино" },
            { "SN", "Сенегал" },
            { "SO", "Сомали" },
            { "SR", "Суринам" },
            { "SS", "Көньяк Судан" },
            { "ST", "Сан-Томе һәм Принсипи" },
            { "SV", "Сальвадор" },
            { "SX", "Синт-Мартен" },
            { "SY", "Сүрия" },
            { "SZ", "Свазиленд" },
            { "TA", "Тристан-да-Кунья" },
            { "TC", "Теркс һәм Кайкос утраулары" },
            { "TD", "Чад" },
            { "TF", "Франциянең Көньяк Территорияләре" },
            { "TG", "Того" },
            { "TH", "Тайланд" },
            { "TJ", "Таҗикстан" },
            { "TK", "Токелау" },
            { "TL", "Тимор-Лесте" },
            { "TM", "Төркмәнстан" },
            { "TN", "Тунис" },
            { "TO", "Тонга" },
            { "TR", "Төркия" },
            { "TT", "Тринидад һәм Тобаго" },
            { "TV", "Тувалу" },
            { "TW", "Тайвань" },
            { "TZ", "Танзания" },
            { "UA", "Украина" },
            { "UG", "Уганда" },
            { "UM", "АКШ Кече Читтәге утраулары" },
            { "UN", "Берләшкән Милләтләр" },
            { "US", "АКШ" },
            { "UY", "Уругвай" },
            { "UZ", "Үзбәкстан" },
            { "VA", "Ватикан" },
            { "VC", "Сент-Винсент һәм Гренадин" },
            { "VE", "Венесуэла" },
            { "VG", "Британия Виргин утраулары" },
            { "VI", "АКШ Виргин утраулары" },
            { "VN", "Вьетнам" },
            { "VU", "Вануату" },
            { "WF", "Уоллис һәм Футуна" },
            { "WS", "Самоа" },
            { "XA", "Псевдоакцентлар" },
            { "XB", "Псевдо-Биди" },
            { "XK", "Косово" },
            { "YE", "Йәмән" },
            { "YT", "Майотта" },
            { "ZA", "Көньяк Африка" },
            { "ZM", "Замбия" },
            { "ZW", "Зимбабве" },
            { "ZZ", "билгесез төбәк" },
            { "af", "африкаанс" },
            { "am", "амхар" },
            { "ar", "гарәпчә" },
            { "as", "ассам" },
            { "az", "әзәрбайҗан" },
            { "ba", "башкорт" },
            { "be", "белорус" },
            { "bg", "болгар" },
            { "bn", "бенгалча" },
            { "bo", "тибет" },
            { "br", "бретон" },
            { "bs", "босния" },
            { "ca", "каталан" },
            { "co", "корсика" },
            { "cs", "чех" },
            { "cy", "уэльс" },
            { "da", "дания" },
            { "de", "алман" },
            { "dv", "мальдив" },
            { "dz", "дзонг-кха" },
            { "el", "грек" },
            { "en", "инглиз" },
            { "eo", "эсперанто" },
            { "es", "испан" },
            { "et", "эстон" },
            { "eu", "баск" },
            { "fa", "фарсы" },
            { "ff", "фула" },
            { "fi", "фин" },
            { "fo", "фарер" },
            { "fr", "француз" },
            { "ga", "ирланд" },
            { "gd", "шотланд гэль" },
            { "gl", "галисия" },
            { "gn", "гуарани" },
            { "gu", "гуҗарати" },
            { "ha", "хауса" },
            { "he", "яһүд" },
            { "hi", "һинд" },
            { "hr", "хорват" },
            { "ht", "гаити креол" },
            { "hu", "венгр" },
            { "hy", "әрмән" },
            { "hz", "гереро" },
            { "id", "индонезия" },
            { "ig", "игбо" },
            { "is", "исланд" },
            { "it", "итальян" },
            { "iu", "инуктикут" },
            { "ja", metaValue_ja },
            { "ka", "грузин" },
            { "kk", "казакъ" },
            { "km", "кхмер" },
            { "kn", "каннада" },
            { "ko", metaValue_ko },
            { "kr", "канури" },
            { "ks", "кашмири" },
            { "ku", "көрд" },
            { "ky", "кыргыз" },
            { "la", metaValue_la },
            { "lb", "люксембург" },
            { "lo", "лаос" },
            { "lt", "литва" },
            { "lv", "латыш" },
            { "mg", "малагаси" },
            { "mi", "маори" },
            { "mk", "македон" },
            { "ml", "малаялам" },
            { "mn", "монгол" },
            { "mr", "маратхи" },
            { "ms", "малай" },
            { "mt", "мальта" },
            { "my", "бирма" },
            { "ne", "непали" },
            { "nl", "голланд" },
            { "ny", "ньянҗа" },
            { "oc", "окситан" },
            { "om", "оромо" },
            { "or", "ория" },
            { "pa", "пәнҗаби" },
            { "pl", "поляк" },
            { "ps", "пушту" },
            { "pt", "португал" },
            { "qu", "кечуа" },
            { "rm", "ретороман" },
            { "ro", "румын" },
            { "ru", "рус" },
            { "rw", "руанда" },
            { "sa", "санскрит" },
            { "sd", "синдһи" },
            { "se", "төньяк саам" },
            { "si", "сингал" },
            { "sk", "словак" },
            { "sl", "словен" },
            { "so", "сомали" },
            { "sq", "албан" },
            { "sr", "серб" },
            { "sv", "швед" },
            { "ta", "тамил" },
            { "te", "телугу" },
            { "tg", "таҗик" },
            { "th", "тай" },
            { "ti", "тигринья" },
            { "tk", "төрекмән" },
            { "to", "тонга" },
            { "tr", "төрек" },
            { "tt", "татар" },
            { "ug", "уйгыр" },
            { "uk", "украин" },
            { "ur", "урду" },
            { "uz", "үзбәк" },
            { "ve", "венда" },
            { "vi", "вьетнам" },
            { "wo", "волоф" },
            { "yi", "идиш" },
            { "yo", "йоруба" },
            { "zh", "кытайча" },
            { "arn", "мапуче" },
            { "ban", "бали" },
            { "bem", "бемба" },
            { "ceb", "себуано" },
            { "chm", "мари" },
            { "chr", "чероки" },
            { "ckb", "үзәк көрд" },
            { "dsb", "түбән сорб" },
            { "fil", "филиппин" },
            { "haw", "гавайи" },
            { "hil", "хилигайнон" },
            { "hsb", "югары сорб" },
            { "ibb", "ибибио" },
            { "kok", "конкани" },
            { "kru", "курух" },
            { "men", "менде" },
            { "mni", "манипури" },
            { "moh", "могаук" },
            { "niu", "ниуэ" },
            { "pap", "папьяменто" },
            { "quc", "киче" },
            { "sah", "саха" },
            { "sat", "сантали" },
            { "sma", "көньяк саам" },
            { "smj", "луле-саам" },
            { "smn", "инари-саам" },
            { "sms", "колтта-саам" },
            { "syr", "сүрия" },
            { "tzm", "үзәк атлас тамазигт" },
            { "und", "билгесез тел" },
            { "Arab", "гарәп" },
            { "Cyrl", "кирилл" },
            { "Hans", "гадиләштерелгән" },
            { "Hant", "традицион" },
            { "Jpan", metaValue_ja },
            { "Kore", metaValue_ko },
            { "Latn", metaValue_la },
            { "Zxxx", "язусыз" },
            { "Zzzz", "билгесез язу" },
            { "de_CH", "югары алман (Швейцария)" },
            { "en_GB", "Британия инглизчәсе" },
            { "en_US", "Америка инглизчәсе" },
            { "es_ES", "испан (Европа)" },
            { "nl_BE", "фламандча" },
            { "pt_PT", "португал (Европа)" },
            { "ar_001", "заманча стандарт гарәпчә" },
            { "es_419", "испан (Латин Америкасы)" },
            { "zh_Hans", "гадиләштерелгән кытай" },
            { "zh_Hant", "традицион кытай" },
            { "type.nu.latn", "көнбатыш цифрлары" },
            { "type.ca.iso8601", "ISO-8601 календаре" },
            { "type.co.standard", "гадәти тәртипләү ысулы" },
            { "type.ca.gregorian", "григориан ел исәбе" },
        };
        return data;
    }
}
