// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/bigtable/admin/v2/bigtable_instance_admin.proto

#include "google/cloud/bigtable/admin/bigtable_instance_admin_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace bigtable_admin {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

BigtableInstanceAdminConnectionIdempotencyPolicy::
    ~BigtableInstanceAdminConnectionIdempotencyPolicy() = default;

std::unique_ptr<BigtableInstanceAdminConnectionIdempotencyPolicy>
BigtableInstanceAdminConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<BigtableInstanceAdminConnectionIdempotencyPolicy>(
      *this);
}

Idempotency BigtableInstanceAdminConnectionIdempotencyPolicy::CreateInstance(
    google::bigtable::admin::v2::CreateInstanceRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency BigtableInstanceAdminConnectionIdempotencyPolicy::GetInstance(
    google::bigtable::admin::v2::GetInstanceRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency BigtableInstanceAdminConnectionIdempotencyPolicy::ListInstances(
    google::bigtable::admin::v2::ListInstancesRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency BigtableInstanceAdminConnectionIdempotencyPolicy::UpdateInstance(
    google::bigtable::admin::v2::Instance const&) {
  return Idempotency::kIdempotent;
}

Idempotency
BigtableInstanceAdminConnectionIdempotencyPolicy::PartialUpdateInstance(
    google::bigtable::admin::v2::PartialUpdateInstanceRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency BigtableInstanceAdminConnectionIdempotencyPolicy::DeleteInstance(
    google::bigtable::admin::v2::DeleteInstanceRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency BigtableInstanceAdminConnectionIdempotencyPolicy::CreateCluster(
    google::bigtable::admin::v2::CreateClusterRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency BigtableInstanceAdminConnectionIdempotencyPolicy::GetCluster(
    google::bigtable::admin::v2::GetClusterRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency BigtableInstanceAdminConnectionIdempotencyPolicy::ListClusters(
    google::bigtable::admin::v2::ListClustersRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency BigtableInstanceAdminConnectionIdempotencyPolicy::UpdateCluster(
    google::bigtable::admin::v2::Cluster const&) {
  return Idempotency::kIdempotent;
}

Idempotency
BigtableInstanceAdminConnectionIdempotencyPolicy::PartialUpdateCluster(
    google::bigtable::admin::v2::PartialUpdateClusterRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency BigtableInstanceAdminConnectionIdempotencyPolicy::DeleteCluster(
    google::bigtable::admin::v2::DeleteClusterRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency BigtableInstanceAdminConnectionIdempotencyPolicy::CreateAppProfile(
    google::bigtable::admin::v2::CreateAppProfileRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency BigtableInstanceAdminConnectionIdempotencyPolicy::GetAppProfile(
    google::bigtable::admin::v2::GetAppProfileRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency BigtableInstanceAdminConnectionIdempotencyPolicy::ListAppProfiles(
    google::bigtable::admin::v2::ListAppProfilesRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency BigtableInstanceAdminConnectionIdempotencyPolicy::UpdateAppProfile(
    google::bigtable::admin::v2::UpdateAppProfileRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency BigtableInstanceAdminConnectionIdempotencyPolicy::DeleteAppProfile(
    google::bigtable::admin::v2::DeleteAppProfileRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency BigtableInstanceAdminConnectionIdempotencyPolicy::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency BigtableInstanceAdminConnectionIdempotencyPolicy::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request) {
  return request.policy().etag().empty() ? Idempotency::kNonIdempotent
                                         : Idempotency::kIdempotent;
}

Idempotency
BigtableInstanceAdminConnectionIdempotencyPolicy::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency BigtableInstanceAdminConnectionIdempotencyPolicy::ListHotTablets(
    google::bigtable::admin::v2::ListHotTabletsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

std::unique_ptr<BigtableInstanceAdminConnectionIdempotencyPolicy>
MakeDefaultBigtableInstanceAdminConnectionIdempotencyPolicy() {
  return std::make_unique<BigtableInstanceAdminConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigtable_admin
}  // namespace cloud
}  // namespace google
