// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/routes/v1/routes.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_ROUTES_V1_ROUTES_CONNECTION_IDEMPOTENCY_POLICY_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_ROUTES_V1_ROUTES_CONNECTION_IDEMPOTENCY_POLICY_H

#include "google/cloud/idempotency.h"
#include "google/cloud/version.h"
#include <google/cloud/compute/routes/v1/routes.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace compute_routes_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class RoutesConnectionIdempotencyPolicy {
 public:
  virtual ~RoutesConnectionIdempotencyPolicy();

  /// Create a new copy of this object.
  virtual std::unique_ptr<RoutesConnectionIdempotencyPolicy> clone() const;

  virtual google::cloud::Idempotency DeleteRoute(
      google::cloud::cpp::compute::routes::v1::DeleteRouteRequest const&
          request);

  virtual google::cloud::Idempotency GetRoute(
      google::cloud::cpp::compute::routes::v1::GetRouteRequest const& request);

  virtual google::cloud::Idempotency InsertRoute(
      google::cloud::cpp::compute::routes::v1::InsertRouteRequest const&
          request);

  virtual google::cloud::Idempotency ListRoutes(
      google::cloud::cpp::compute::routes::v1::ListRoutesRequest request);
};

std::unique_ptr<RoutesConnectionIdempotencyPolicy>
MakeDefaultRoutesConnectionIdempotencyPolicy();

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_routes_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_ROUTES_V1_ROUTES_CONNECTION_IDEMPOTENCY_POLICY_H
