// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/contentwarehouse/v1/synonymset_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_CONTENTWAREHOUSE_V1_SYNONYM_SET_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_CONTENTWAREHOUSE_V1_SYNONYM_SET_CLIENT_H

#include "google/cloud/contentwarehouse/v1/synonym_set_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace contentwarehouse_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// A Service that manage/custom customer specified SynonymSets.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class SynonymSetServiceClient {
 public:
  explicit SynonymSetServiceClient(
      std::shared_ptr<SynonymSetServiceConnection> connection,
      Options opts = {});
  ~SynonymSetServiceClient();

  ///@{
  /// @name Copy and move support
  SynonymSetServiceClient(SynonymSetServiceClient const&) = default;
  SynonymSetServiceClient& operator=(SynonymSetServiceClient const&) = default;
  SynonymSetServiceClient(SynonymSetServiceClient&&) = default;
  SynonymSetServiceClient& operator=(SynonymSetServiceClient&&) = default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(SynonymSetServiceClient const& a,
                         SynonymSetServiceClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(SynonymSetServiceClient const& a,
                         SynonymSetServiceClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Creates a SynonymSet for a single context.
  /// Throws an ALREADY_EXISTS exception if a synonymset already exists
  /// for the context.
  ///
  /// @param parent  Required. The parent name.
  ///  Format: projects/{project_number}/locations/{location}.
  /// @param synonym_set  Required. The synonymSet to be created for a context
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.contentwarehouse.v1.SynonymSet])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.contentwarehouse.v1.CreateSynonymSetRequest]: @googleapis_reference_link{google/cloud/contentwarehouse/v1/synonymset_service_request.proto#L32}
  /// [google.cloud.contentwarehouse.v1.SynonymSet]: @googleapis_reference_link{google/cloud/contentwarehouse/v1/synonymset.proto#L35}
  ///
  // clang-format on
  StatusOr<google::cloud::contentwarehouse::v1::SynonymSet> CreateSynonymSet(
      std::string const& parent,
      google::cloud::contentwarehouse::v1::SynonymSet const& synonym_set,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a SynonymSet for a single context.
  /// Throws an ALREADY_EXISTS exception if a synonymset already exists
  /// for the context.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.contentwarehouse.v1.CreateSynonymSetRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.contentwarehouse.v1.SynonymSet])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.contentwarehouse.v1.CreateSynonymSetRequest]: @googleapis_reference_link{google/cloud/contentwarehouse/v1/synonymset_service_request.proto#L32}
  /// [google.cloud.contentwarehouse.v1.SynonymSet]: @googleapis_reference_link{google/cloud/contentwarehouse/v1/synonymset.proto#L35}
  ///
  // clang-format on
  StatusOr<google::cloud::contentwarehouse::v1::SynonymSet> CreateSynonymSet(
      google::cloud::contentwarehouse::v1::CreateSynonymSetRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets a SynonymSet for a particular context.
  /// Throws a NOT_FOUND exception if the Synonymset
  /// does not exist
  ///
  /// @param name  Required. The name of the synonymSet to retrieve
  ///  Format:
  ///  projects/{project_number}/locations/{location}/synonymSets/{context}.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.contentwarehouse.v1.SynonymSet])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.contentwarehouse.v1.GetSynonymSetRequest]: @googleapis_reference_link{google/cloud/contentwarehouse/v1/synonymset_service_request.proto#L48}
  /// [google.cloud.contentwarehouse.v1.SynonymSet]: @googleapis_reference_link{google/cloud/contentwarehouse/v1/synonymset.proto#L35}
  ///
  // clang-format on
  StatusOr<google::cloud::contentwarehouse::v1::SynonymSet> GetSynonymSet(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets a SynonymSet for a particular context.
  /// Throws a NOT_FOUND exception if the Synonymset
  /// does not exist
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.contentwarehouse.v1.GetSynonymSetRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.contentwarehouse.v1.SynonymSet])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.contentwarehouse.v1.GetSynonymSetRequest]: @googleapis_reference_link{google/cloud/contentwarehouse/v1/synonymset_service_request.proto#L48}
  /// [google.cloud.contentwarehouse.v1.SynonymSet]: @googleapis_reference_link{google/cloud/contentwarehouse/v1/synonymset.proto#L35}
  ///
  // clang-format on
  StatusOr<google::cloud::contentwarehouse::v1::SynonymSet> GetSynonymSet(
      google::cloud::contentwarehouse::v1::GetSynonymSetRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Remove the existing SynonymSet for the context and replaces it
  /// with a new one.
  /// Throws a NOT_FOUND exception if the SynonymSet is not found.
  ///
  /// @param name  Required. The name of the synonymSet to update
  ///  Format:
  ///  projects/{project_number}/locations/{location}/synonymSets/{context}.
  /// @param synonym_set  Required. The synonymSet to be updated for the customer
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.contentwarehouse.v1.SynonymSet])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.contentwarehouse.v1.SynonymSet]: @googleapis_reference_link{google/cloud/contentwarehouse/v1/synonymset.proto#L35}
  /// [google.cloud.contentwarehouse.v1.UpdateSynonymSetRequest]: @googleapis_reference_link{google/cloud/contentwarehouse/v1/synonymset_service_request.proto#L99}
  ///
  // clang-format on
  StatusOr<google::cloud::contentwarehouse::v1::SynonymSet> UpdateSynonymSet(
      std::string const& name,
      google::cloud::contentwarehouse::v1::SynonymSet const& synonym_set,
      Options opts = {});

  // clang-format off
  ///
  /// Remove the existing SynonymSet for the context and replaces it
  /// with a new one.
  /// Throws a NOT_FOUND exception if the SynonymSet is not found.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.contentwarehouse.v1.UpdateSynonymSetRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.contentwarehouse.v1.SynonymSet])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.contentwarehouse.v1.SynonymSet]: @googleapis_reference_link{google/cloud/contentwarehouse/v1/synonymset.proto#L35}
  /// [google.cloud.contentwarehouse.v1.UpdateSynonymSetRequest]: @googleapis_reference_link{google/cloud/contentwarehouse/v1/synonymset_service_request.proto#L99}
  ///
  // clang-format on
  StatusOr<google::cloud::contentwarehouse::v1::SynonymSet> UpdateSynonymSet(
      google::cloud::contentwarehouse::v1::UpdateSynonymSetRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes a SynonymSet for a given context.
  /// Throws a NOT_FOUND exception if the SynonymSet is not found.
  ///
  /// @param name  Required. The name of the synonymSet to delete
  ///  Format:
  ///  projects/{project_number}/locations/{location}/synonymSets/{context}.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.contentwarehouse.v1.DeleteSynonymSetRequest]: @googleapis_reference_link{google/cloud/contentwarehouse/v1/synonymset_service_request.proto#L115}
  ///
  // clang-format on
  Status DeleteSynonymSet(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a SynonymSet for a given context.
  /// Throws a NOT_FOUND exception if the SynonymSet is not found.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.contentwarehouse.v1.DeleteSynonymSetRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.contentwarehouse.v1.DeleteSynonymSetRequest]: @googleapis_reference_link{google/cloud/contentwarehouse/v1/synonymset_service_request.proto#L115}
  ///
  // clang-format on
  Status DeleteSynonymSet(
      google::cloud::contentwarehouse::v1::DeleteSynonymSetRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Returns all SynonymSets (for all contexts) for the specified location.
  ///
  /// @param parent  Required. The parent name.
  ///  Format: projects/{project_number}/locations/{location}.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.contentwarehouse.v1.SynonymSet], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.contentwarehouse.v1.ListSynonymSetsRequest]: @googleapis_reference_link{google/cloud/contentwarehouse/v1/synonymset_service_request.proto#L62}
  /// [google.cloud.contentwarehouse.v1.SynonymSet]: @googleapis_reference_link{google/cloud/contentwarehouse/v1/synonymset.proto#L35}
  ///
  // clang-format on
  StreamRange<google::cloud::contentwarehouse::v1::SynonymSet> ListSynonymSets(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Returns all SynonymSets (for all contexts) for the specified location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.contentwarehouse.v1.ListSynonymSetsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.contentwarehouse.v1.SynonymSet], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.contentwarehouse.v1.ListSynonymSetsRequest]: @googleapis_reference_link{google/cloud/contentwarehouse/v1/synonymset_service_request.proto#L62}
  /// [google.cloud.contentwarehouse.v1.SynonymSet]: @googleapis_reference_link{google/cloud/contentwarehouse/v1/synonymset.proto#L35}
  ///
  // clang-format on
  StreamRange<google::cloud::contentwarehouse::v1::SynonymSet> ListSynonymSets(
      google::cloud::contentwarehouse::v1::ListSynonymSetsRequest request,
      Options opts = {});

 private:
  std::shared_ptr<SynonymSetServiceConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace contentwarehouse_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_CONTENTWAREHOUSE_V1_SYNONYM_SET_CLIENT_H
