// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/clouddms/v1/clouddms.proto

#include "google/cloud/datamigration/v1/internal/data_migration_metadata_decorator.h"
#include "google/cloud/common_options.h"
#include "google/cloud/internal/absl_str_cat_quiet.h"
#include "google/cloud/internal/api_client_header.h"
#include "google/cloud/internal/url_encode.h"
#include "google/cloud/status_or.h"
#include <google/cloud/clouddms/v1/clouddms.grpc.pb.h>
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace datamigration_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

DataMigrationServiceMetadata::DataMigrationServiceMetadata(
    std::shared_ptr<DataMigrationServiceStub> child,
    std::multimap<std::string, std::string> fixed_metadata,
    std::string api_client_header)
    : child_(std::move(child)),
      fixed_metadata_(std::move(fixed_metadata)),
      api_client_header_(
          api_client_header.empty()
              ? google::cloud::internal::GeneratedLibClientHeader()
              : std::move(api_client_header)) {}

StatusOr<google::cloud::clouddms::v1::ListMigrationJobsResponse>
DataMigrationServiceMetadata::ListMigrationJobs(
    grpc::ClientContext& context,
    google::cloud::clouddms::v1::ListMigrationJobsRequest const& request) {
  SetMetadata(context, internal::CurrentOptions(),
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListMigrationJobs(context, request);
}

StatusOr<google::cloud::clouddms::v1::MigrationJob>
DataMigrationServiceMetadata::GetMigrationJob(
    grpc::ClientContext& context,
    google::cloud::clouddms::v1::GetMigrationJobRequest const& request) {
  SetMetadata(context, internal::CurrentOptions(),
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetMigrationJob(context, request);
}

future<StatusOr<google::longrunning::Operation>>
DataMigrationServiceMetadata::AsyncCreateMigrationJob(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::clouddms::v1::CreateMigrationJobRequest const& request) {
  SetMetadata(*context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->AsyncCreateMigrationJob(cq, std::move(context), options,
                                         request);
}

future<StatusOr<google::longrunning::Operation>>
DataMigrationServiceMetadata::AsyncUpdateMigrationJob(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::clouddms::v1::UpdateMigrationJobRequest const& request) {
  SetMetadata(
      *context, options,
      absl::StrCat("migration_job.name=",
                   internal::UrlEncode(request.migration_job().name())));
  return child_->AsyncUpdateMigrationJob(cq, std::move(context), options,
                                         request);
}

future<StatusOr<google::longrunning::Operation>>
DataMigrationServiceMetadata::AsyncDeleteMigrationJob(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::clouddms::v1::DeleteMigrationJobRequest const& request) {
  SetMetadata(*context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncDeleteMigrationJob(cq, std::move(context), options,
                                         request);
}

future<StatusOr<google::longrunning::Operation>>
DataMigrationServiceMetadata::AsyncStartMigrationJob(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::clouddms::v1::StartMigrationJobRequest const& request) {
  SetMetadata(*context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncStartMigrationJob(cq, std::move(context), options,
                                        request);
}

future<StatusOr<google::longrunning::Operation>>
DataMigrationServiceMetadata::AsyncStopMigrationJob(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::clouddms::v1::StopMigrationJobRequest const& request) {
  SetMetadata(*context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncStopMigrationJob(cq, std::move(context), options,
                                       request);
}

future<StatusOr<google::longrunning::Operation>>
DataMigrationServiceMetadata::AsyncResumeMigrationJob(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::clouddms::v1::ResumeMigrationJobRequest const& request) {
  SetMetadata(*context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncResumeMigrationJob(cq, std::move(context), options,
                                         request);
}

future<StatusOr<google::longrunning::Operation>>
DataMigrationServiceMetadata::AsyncPromoteMigrationJob(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::clouddms::v1::PromoteMigrationJobRequest const& request) {
  SetMetadata(*context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncPromoteMigrationJob(cq, std::move(context), options,
                                          request);
}

future<StatusOr<google::longrunning::Operation>>
DataMigrationServiceMetadata::AsyncVerifyMigrationJob(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::clouddms::v1::VerifyMigrationJobRequest const& request) {
  SetMetadata(*context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncVerifyMigrationJob(cq, std::move(context), options,
                                         request);
}

future<StatusOr<google::longrunning::Operation>>
DataMigrationServiceMetadata::AsyncRestartMigrationJob(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::clouddms::v1::RestartMigrationJobRequest const& request) {
  SetMetadata(*context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncRestartMigrationJob(cq, std::move(context), options,
                                          request);
}

StatusOr<google::cloud::clouddms::v1::SshScript>
DataMigrationServiceMetadata::GenerateSshScript(
    grpc::ClientContext& context,
    google::cloud::clouddms::v1::GenerateSshScriptRequest const& request) {
  SetMetadata(context, internal::CurrentOptions(),
              absl::StrCat("migration_job=",
                           internal::UrlEncode(request.migration_job())));
  return child_->GenerateSshScript(context, request);
}

StatusOr<google::cloud::clouddms::v1::TcpProxyScript>
DataMigrationServiceMetadata::GenerateTcpProxyScript(
    grpc::ClientContext& context,
    google::cloud::clouddms::v1::GenerateTcpProxyScriptRequest const& request) {
  SetMetadata(context, internal::CurrentOptions(),
              absl::StrCat("migration_job=",
                           internal::UrlEncode(request.migration_job())));
  return child_->GenerateTcpProxyScript(context, request);
}

StatusOr<google::cloud::clouddms::v1::ListConnectionProfilesResponse>
DataMigrationServiceMetadata::ListConnectionProfiles(
    grpc::ClientContext& context,
    google::cloud::clouddms::v1::ListConnectionProfilesRequest const& request) {
  SetMetadata(context, internal::CurrentOptions(),
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListConnectionProfiles(context, request);
}

StatusOr<google::cloud::clouddms::v1::ConnectionProfile>
DataMigrationServiceMetadata::GetConnectionProfile(
    grpc::ClientContext& context,
    google::cloud::clouddms::v1::GetConnectionProfileRequest const& request) {
  SetMetadata(context, internal::CurrentOptions(),
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetConnectionProfile(context, request);
}

future<StatusOr<google::longrunning::Operation>>
DataMigrationServiceMetadata::AsyncCreateConnectionProfile(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::clouddms::v1::CreateConnectionProfileRequest const&
        request) {
  SetMetadata(*context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->AsyncCreateConnectionProfile(cq, std::move(context), options,
                                              request);
}

future<StatusOr<google::longrunning::Operation>>
DataMigrationServiceMetadata::AsyncUpdateConnectionProfile(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::clouddms::v1::UpdateConnectionProfileRequest const&
        request) {
  SetMetadata(
      *context, options,
      absl::StrCat("connection_profile.name=",
                   internal::UrlEncode(request.connection_profile().name())));
  return child_->AsyncUpdateConnectionProfile(cq, std::move(context), options,
                                              request);
}

future<StatusOr<google::longrunning::Operation>>
DataMigrationServiceMetadata::AsyncDeleteConnectionProfile(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::clouddms::v1::DeleteConnectionProfileRequest const&
        request) {
  SetMetadata(*context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncDeleteConnectionProfile(cq, std::move(context), options,
                                              request);
}

future<StatusOr<google::longrunning::Operation>>
DataMigrationServiceMetadata::AsyncCreatePrivateConnection(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::clouddms::v1::CreatePrivateConnectionRequest const&
        request) {
  SetMetadata(*context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->AsyncCreatePrivateConnection(cq, std::move(context), options,
                                              request);
}

StatusOr<google::cloud::clouddms::v1::PrivateConnection>
DataMigrationServiceMetadata::GetPrivateConnection(
    grpc::ClientContext& context,
    google::cloud::clouddms::v1::GetPrivateConnectionRequest const& request) {
  SetMetadata(context, internal::CurrentOptions(),
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetPrivateConnection(context, request);
}

StatusOr<google::cloud::clouddms::v1::ListPrivateConnectionsResponse>
DataMigrationServiceMetadata::ListPrivateConnections(
    grpc::ClientContext& context,
    google::cloud::clouddms::v1::ListPrivateConnectionsRequest const& request) {
  SetMetadata(context, internal::CurrentOptions(),
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListPrivateConnections(context, request);
}

future<StatusOr<google::longrunning::Operation>>
DataMigrationServiceMetadata::AsyncDeletePrivateConnection(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::clouddms::v1::DeletePrivateConnectionRequest const&
        request) {
  SetMetadata(*context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncDeletePrivateConnection(cq, std::move(context), options,
                                              request);
}

StatusOr<google::cloud::clouddms::v1::ConversionWorkspace>
DataMigrationServiceMetadata::GetConversionWorkspace(
    grpc::ClientContext& context,
    google::cloud::clouddms::v1::GetConversionWorkspaceRequest const& request) {
  SetMetadata(context, internal::CurrentOptions(),
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetConversionWorkspace(context, request);
}

StatusOr<google::cloud::clouddms::v1::ListConversionWorkspacesResponse>
DataMigrationServiceMetadata::ListConversionWorkspaces(
    grpc::ClientContext& context,
    google::cloud::clouddms::v1::ListConversionWorkspacesRequest const&
        request) {
  SetMetadata(context, internal::CurrentOptions(),
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListConversionWorkspaces(context, request);
}

future<StatusOr<google::longrunning::Operation>>
DataMigrationServiceMetadata::AsyncCreateConversionWorkspace(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::clouddms::v1::CreateConversionWorkspaceRequest const&
        request) {
  SetMetadata(*context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->AsyncCreateConversionWorkspace(cq, std::move(context), options,
                                                request);
}

future<StatusOr<google::longrunning::Operation>>
DataMigrationServiceMetadata::AsyncUpdateConversionWorkspace(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::clouddms::v1::UpdateConversionWorkspaceRequest const&
        request) {
  SetMetadata(
      *context, options,
      absl::StrCat("conversion_workspace.name=",
                   internal::UrlEncode(request.conversion_workspace().name())));
  return child_->AsyncUpdateConversionWorkspace(cq, std::move(context), options,
                                                request);
}

future<StatusOr<google::longrunning::Operation>>
DataMigrationServiceMetadata::AsyncDeleteConversionWorkspace(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::clouddms::v1::DeleteConversionWorkspaceRequest const&
        request) {
  SetMetadata(*context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncDeleteConversionWorkspace(cq, std::move(context), options,
                                                request);
}

StatusOr<google::cloud::clouddms::v1::MappingRule>
DataMigrationServiceMetadata::CreateMappingRule(
    grpc::ClientContext& context,
    google::cloud::clouddms::v1::CreateMappingRuleRequest const& request) {
  SetMetadata(context, internal::CurrentOptions(),
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->CreateMappingRule(context, request);
}

Status DataMigrationServiceMetadata::DeleteMappingRule(
    grpc::ClientContext& context,
    google::cloud::clouddms::v1::DeleteMappingRuleRequest const& request) {
  SetMetadata(context, internal::CurrentOptions(),
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DeleteMappingRule(context, request);
}

StatusOr<google::cloud::clouddms::v1::ListMappingRulesResponse>
DataMigrationServiceMetadata::ListMappingRules(
    grpc::ClientContext& context,
    google::cloud::clouddms::v1::ListMappingRulesRequest const& request) {
  SetMetadata(context, internal::CurrentOptions(),
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListMappingRules(context, request);
}

StatusOr<google::cloud::clouddms::v1::MappingRule>
DataMigrationServiceMetadata::GetMappingRule(
    grpc::ClientContext& context,
    google::cloud::clouddms::v1::GetMappingRuleRequest const& request) {
  SetMetadata(context, internal::CurrentOptions(),
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetMappingRule(context, request);
}

future<StatusOr<google::longrunning::Operation>>
DataMigrationServiceMetadata::AsyncSeedConversionWorkspace(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::clouddms::v1::SeedConversionWorkspaceRequest const&
        request) {
  SetMetadata(*context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncSeedConversionWorkspace(cq, std::move(context), options,
                                              request);
}

future<StatusOr<google::longrunning::Operation>>
DataMigrationServiceMetadata::AsyncImportMappingRules(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::clouddms::v1::ImportMappingRulesRequest const& request) {
  SetMetadata(*context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->AsyncImportMappingRules(cq, std::move(context), options,
                                         request);
}

future<StatusOr<google::longrunning::Operation>>
DataMigrationServiceMetadata::AsyncConvertConversionWorkspace(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::clouddms::v1::ConvertConversionWorkspaceRequest const&
        request) {
  SetMetadata(*context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncConvertConversionWorkspace(cq, std::move(context),
                                                 options, request);
}

future<StatusOr<google::longrunning::Operation>>
DataMigrationServiceMetadata::AsyncCommitConversionWorkspace(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::clouddms::v1::CommitConversionWorkspaceRequest const&
        request) {
  SetMetadata(*context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncCommitConversionWorkspace(cq, std::move(context), options,
                                                request);
}

future<StatusOr<google::longrunning::Operation>>
DataMigrationServiceMetadata::AsyncRollbackConversionWorkspace(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::clouddms::v1::RollbackConversionWorkspaceRequest const&
        request) {
  SetMetadata(*context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncRollbackConversionWorkspace(cq, std::move(context),
                                                  options, request);
}

future<StatusOr<google::longrunning::Operation>>
DataMigrationServiceMetadata::AsyncApplyConversionWorkspace(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::clouddms::v1::ApplyConversionWorkspaceRequest const&
        request) {
  SetMetadata(*context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncApplyConversionWorkspace(cq, std::move(context), options,
                                               request);
}

StatusOr<google::cloud::clouddms::v1::DescribeDatabaseEntitiesResponse>
DataMigrationServiceMetadata::DescribeDatabaseEntities(
    grpc::ClientContext& context,
    google::cloud::clouddms::v1::DescribeDatabaseEntitiesRequest const&
        request) {
  SetMetadata(
      context, internal::CurrentOptions(),
      absl::StrCat("conversion_workspace=",
                   internal::UrlEncode(request.conversion_workspace())));
  return child_->DescribeDatabaseEntities(context, request);
}

StatusOr<google::cloud::clouddms::v1::SearchBackgroundJobsResponse>
DataMigrationServiceMetadata::SearchBackgroundJobs(
    grpc::ClientContext& context,
    google::cloud::clouddms::v1::SearchBackgroundJobsRequest const& request) {
  SetMetadata(
      context, internal::CurrentOptions(),
      absl::StrCat("conversion_workspace=",
                   internal::UrlEncode(request.conversion_workspace())));
  return child_->SearchBackgroundJobs(context, request);
}

StatusOr<
    google::cloud::clouddms::v1::DescribeConversionWorkspaceRevisionsResponse>
DataMigrationServiceMetadata::DescribeConversionWorkspaceRevisions(
    grpc::ClientContext& context,
    google::cloud::clouddms::v1::
        DescribeConversionWorkspaceRevisionsRequest const& request) {
  SetMetadata(
      context, internal::CurrentOptions(),
      absl::StrCat("conversion_workspace=",
                   internal::UrlEncode(request.conversion_workspace())));
  return child_->DescribeConversionWorkspaceRevisions(context, request);
}

StatusOr<google::cloud::clouddms::v1::FetchStaticIpsResponse>
DataMigrationServiceMetadata::FetchStaticIps(
    grpc::ClientContext& context,
    google::cloud::clouddms::v1::FetchStaticIpsRequest const& request) {
  SetMetadata(context, internal::CurrentOptions(),
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->FetchStaticIps(context, request);
}

future<StatusOr<google::longrunning::Operation>>
DataMigrationServiceMetadata::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::longrunning::GetOperationRequest const& request) {
  SetMetadata(*context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncGetOperation(cq, std::move(context), options, request);
}

future<Status> DataMigrationServiceMetadata::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::longrunning::CancelOperationRequest const& request) {
  SetMetadata(*context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncCancelOperation(cq, std::move(context), options, request);
}

void DataMigrationServiceMetadata::SetMetadata(
    grpc::ClientContext& context, Options const& options,
    std::string const& request_params) {
  context.AddMetadata("x-goog-request-params", request_params);
  SetMetadata(context, options);
}

void DataMigrationServiceMetadata::SetMetadata(grpc::ClientContext& context,
                                               Options const& options) {
  for (auto const& kv : fixed_metadata_) {
    context.AddMetadata(kv.first, kv.second);
  }
  context.AddMetadata("x-goog-api-client", api_client_header_);
  if (options.has<UserProjectOption>()) {
    context.AddMetadata("x-goog-user-project",
                        options.get<UserProjectOption>());
  }
  auto const& authority = options.get<AuthorityOption>();
  if (!authority.empty()) context.set_authority(authority);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace datamigration_v1_internal
}  // namespace cloud
}  // namespace google
