// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/cx/v3/version.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DIALOGFLOW_CX_MOCKS_MOCK_VERSIONS_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DIALOGFLOW_CX_MOCKS_MOCK_VERSIONS_CONNECTION_H

#include "google/cloud/dialogflow_cx/versions_connection.h"
#include <gmock/gmock.h>

namespace google {
namespace cloud {
namespace dialogflow_cx_mocks {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/**
 * A class to mock `VersionsConnection`.
 *
 * Application developers may want to test their code with simulated responses,
 * including errors, from an object of type `VersionsClient`. To do so,
 * construct an object of type `VersionsClient` with an instance of this
 * class. Then use the Google Test framework functions to program the behavior
 * of this mock.
 *
 * @see [This example][bq-mock] for how to test your application with GoogleTest.
 * While the example showcases types from the BigQuery library, the underlying
 * principles apply for any pair of `*Client` and `*Connection`.
 *
 * [bq-mock]: @cloud_cpp_docs_link{bigquery,bigquery-read-mock}
 */
class MockVersionsConnection : public dialogflow_cx::VersionsConnection {
 public:
  MOCK_METHOD(Options, options, (), (override));

  MOCK_METHOD((StreamRange<google::cloud::dialogflow::cx::v3::Version>),
              ListVersions,
              (google::cloud::dialogflow::cx::v3::ListVersionsRequest request),
              (override));

  MOCK_METHOD(
      StatusOr<google::cloud::dialogflow::cx::v3::Version>, GetVersion,
      (google::cloud::dialogflow::cx::v3::GetVersionRequest const& request),
      (override));

  MOCK_METHOD(
      future<StatusOr<google::cloud::dialogflow::cx::v3::Version>>,
      CreateVersion,
      (google::cloud::dialogflow::cx::v3::CreateVersionRequest const& request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::dialogflow::cx::v3::Version>, UpdateVersion,
      (google::cloud::dialogflow::cx::v3::UpdateVersionRequest const& request),
      (override));

  MOCK_METHOD(
      Status, DeleteVersion,
      (google::cloud::dialogflow::cx::v3::DeleteVersionRequest const& request),
      (override));

  MOCK_METHOD(
      future<StatusOr<google::protobuf::Struct>>, LoadVersion,
      (google::cloud::dialogflow::cx::v3::LoadVersionRequest const& request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::dialogflow::cx::v3::CompareVersionsResponse>,
      CompareVersions,
      (google::cloud::dialogflow::cx::v3::CompareVersionsRequest const&
           request),
      (override));
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_cx_mocks
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DIALOGFLOW_CX_MOCKS_MOCK_VERSIONS_CONNECTION_H
