// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/osconfig/v1/osconfig_service.proto

#include "google/cloud/osconfig/v1/internal/os_config_tracing_stub.h"
#include "google/cloud/internal/grpc_opentelemetry.h"

namespace google {
namespace cloud {
namespace osconfig_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

OsConfigServiceTracingStub::OsConfigServiceTracingStub(
    std::shared_ptr<OsConfigServiceStub> child)
    : child_(std::move(child)), propagator_(internal::MakePropagator()) {}

StatusOr<google::cloud::osconfig::v1::PatchJob>
OsConfigServiceTracingStub::ExecutePatchJob(
    grpc::ClientContext& context,
    google::cloud::osconfig::v1::ExecutePatchJobRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.osconfig.v1.OsConfigService",
                                     "ExecutePatchJob");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ExecutePatchJob(context, request));
}

StatusOr<google::cloud::osconfig::v1::PatchJob>
OsConfigServiceTracingStub::GetPatchJob(
    grpc::ClientContext& context,
    google::cloud::osconfig::v1::GetPatchJobRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.osconfig.v1.OsConfigService",
                                     "GetPatchJob");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetPatchJob(context, request));
}

StatusOr<google::cloud::osconfig::v1::PatchJob>
OsConfigServiceTracingStub::CancelPatchJob(
    grpc::ClientContext& context,
    google::cloud::osconfig::v1::CancelPatchJobRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.osconfig.v1.OsConfigService",
                                     "CancelPatchJob");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CancelPatchJob(context, request));
}

StatusOr<google::cloud::osconfig::v1::ListPatchJobsResponse>
OsConfigServiceTracingStub::ListPatchJobs(
    grpc::ClientContext& context,
    google::cloud::osconfig::v1::ListPatchJobsRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.osconfig.v1.OsConfigService",
                                     "ListPatchJobs");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListPatchJobs(context, request));
}

StatusOr<google::cloud::osconfig::v1::ListPatchJobInstanceDetailsResponse>
OsConfigServiceTracingStub::ListPatchJobInstanceDetails(
    grpc::ClientContext& context,
    google::cloud::osconfig::v1::ListPatchJobInstanceDetailsRequest const&
        request) {
  auto span = internal::MakeSpanGrpc("google.cloud.osconfig.v1.OsConfigService",
                                     "ListPatchJobInstanceDetails");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->ListPatchJobInstanceDetails(context, request));
}

StatusOr<google::cloud::osconfig::v1::PatchDeployment>
OsConfigServiceTracingStub::CreatePatchDeployment(
    grpc::ClientContext& context,
    google::cloud::osconfig::v1::CreatePatchDeploymentRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.osconfig.v1.OsConfigService",
                                     "CreatePatchDeployment");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreatePatchDeployment(context, request));
}

StatusOr<google::cloud::osconfig::v1::PatchDeployment>
OsConfigServiceTracingStub::GetPatchDeployment(
    grpc::ClientContext& context,
    google::cloud::osconfig::v1::GetPatchDeploymentRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.osconfig.v1.OsConfigService",
                                     "GetPatchDeployment");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetPatchDeployment(context, request));
}

StatusOr<google::cloud::osconfig::v1::ListPatchDeploymentsResponse>
OsConfigServiceTracingStub::ListPatchDeployments(
    grpc::ClientContext& context,
    google::cloud::osconfig::v1::ListPatchDeploymentsRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.osconfig.v1.OsConfigService",
                                     "ListPatchDeployments");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListPatchDeployments(context, request));
}

Status OsConfigServiceTracingStub::DeletePatchDeployment(
    grpc::ClientContext& context,
    google::cloud::osconfig::v1::DeletePatchDeploymentRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.osconfig.v1.OsConfigService",
                                     "DeletePatchDeployment");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeletePatchDeployment(context, request));
}

StatusOr<google::cloud::osconfig::v1::PatchDeployment>
OsConfigServiceTracingStub::UpdatePatchDeployment(
    grpc::ClientContext& context,
    google::cloud::osconfig::v1::UpdatePatchDeploymentRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.osconfig.v1.OsConfigService",
                                     "UpdatePatchDeployment");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->UpdatePatchDeployment(context, request));
}

StatusOr<google::cloud::osconfig::v1::PatchDeployment>
OsConfigServiceTracingStub::PausePatchDeployment(
    grpc::ClientContext& context,
    google::cloud::osconfig::v1::PausePatchDeploymentRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.osconfig.v1.OsConfigService",
                                     "PausePatchDeployment");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->PausePatchDeployment(context, request));
}

StatusOr<google::cloud::osconfig::v1::PatchDeployment>
OsConfigServiceTracingStub::ResumePatchDeployment(
    grpc::ClientContext& context,
    google::cloud::osconfig::v1::ResumePatchDeploymentRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.osconfig.v1.OsConfigService",
                                     "ResumePatchDeployment");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ResumePatchDeployment(context, request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<OsConfigServiceStub> MakeOsConfigServiceTracingStub(
    std::shared_ptr<OsConfigServiceStub> stub) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return std::make_shared<OsConfigServiceTracingStub>(std::move(stub));
#else
  return stub;
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace osconfig_v1_internal
}  // namespace cloud
}  // namespace google
