// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/devtools/cloudprofiler/v2/profiler.proto

#include "google/cloud/profiler/v2/profiler_connection.h"
#include "google/cloud/profiler/v2/internal/profiler_connection_impl.h"
#include "google/cloud/profiler/v2/internal/profiler_option_defaults.h"
#include "google/cloud/profiler/v2/internal/profiler_stub_factory.h"
#include "google/cloud/profiler/v2/internal/profiler_tracing_connection.h"
#include "google/cloud/profiler/v2/profiler_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include <memory>

namespace google {
namespace cloud {
namespace profiler_v2 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

ProfilerServiceConnection::~ProfilerServiceConnection() = default;

StatusOr<google::devtools::cloudprofiler::v2::Profile>
ProfilerServiceConnection::CreateProfile(
    google::devtools::cloudprofiler::v2::CreateProfileRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::devtools::cloudprofiler::v2::Profile>
ProfilerServiceConnection::CreateOfflineProfile(
    google::devtools::cloudprofiler::v2::CreateOfflineProfileRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::devtools::cloudprofiler::v2::Profile>
ProfilerServiceConnection::UpdateProfile(
    google::devtools::cloudprofiler::v2::UpdateProfileRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

std::shared_ptr<ProfilerServiceConnection> MakeProfilerServiceConnection(
    Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 ProfilerServicePolicyOptionList>(options,
                                                                  __func__);
  options =
      profiler_v2_internal::ProfilerServiceDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto stub = profiler_v2_internal::CreateDefaultProfilerServiceStub(
      background->cq(), options);
  return profiler_v2_internal::MakeProfilerServiceTracingConnection(
      std::make_shared<profiler_v2_internal::ProfilerServiceConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace profiler_v2
}  // namespace cloud
}  // namespace google
