#ifndef LOAD_SAVE_H
#define LOAD_SAVE_H

#include "util.h"

/*** Defines ***/

#define GLF_VERSION  "1.0"

/* Size limits for the RLE and LIF file formats. RLE_MAX_COLS also applies to the GLF format,
 * but not for the pattern description. */
#define RLE_MAX_COLS         70
#define RLE_DESC_MAX_COLS    (RLE_MAX_COLS-3)
#define LIF_MAX_COLS         80
#define LIF_DESC_MAX_COLS    (LIF_MAX_COLS-3)
#define LIF_DESC_MAX_LINES   22

/*** Enums ***/

/* Possible pattern file formats */
typedef enum {
    FORMAT_GLF,
    FORMAT_RLE,
    FORMAT_LIF_105,
    FORMAT_LIF_106,
    FORMAT_XLIFE,

    NUM_FORMATS
} file_format_type;

/*** Types ***/

/* File format loaders and savers */
typedef void (*loader_function)(FILE* f);
typedef void (*saver_function)(FILE* f);

/* Temporary structure used when saving RLE/GLF files */
typedef struct rle_cage_struct {
    uint16  x, y;
    uint16  nw, ne, sw, se;
} rle_cage;

/*** Public Constants ***/

extern loader_function loaders[NUM_FORMATS];
extern saver_function  savers[NUM_FORMATS];

/*** Public Prototypes ***/

void  load_pattern_glf(FILE* f);
void  load_pattern_rle(FILE* f);
void  load_pattern_lif_105(FILE* f);
void  load_pattern_lif_106(FILE* f);
void  load_pattern_xlife(FILE* f);

void  save_pattern_glf(FILE* f);
void  save_pattern_rle(FILE* f);
void  save_pattern_lif_105(FILE* f);
void  save_pattern_lif_106(FILE* f);
void  save_pattern_xlife(FILE* f);

boolean  process_glf_header(const char* line, int32* startx, int32* starty,
                            int32* width, int32* height);
boolean  process_rle_header(const char* line, int32* startx, int32* starty,
                            int32* width, int32* height);

#endif
