package location

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListEndpointsByIp invokes the location.ListEndpointsByIp API synchronously
// api document: https://help.aliyun.com/api/location/listendpointsbyip.html
func (client *Client) ListEndpointsByIp(request *ListEndpointsByIpRequest) (response *ListEndpointsByIpResponse, err error) {
	response = CreateListEndpointsByIpResponse()
	err = client.DoAction(request, response)
	return
}

// ListEndpointsByIpWithChan invokes the location.ListEndpointsByIp API asynchronously
// api document: https://help.aliyun.com/api/location/listendpointsbyip.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListEndpointsByIpWithChan(request *ListEndpointsByIpRequest) (<-chan *ListEndpointsByIpResponse, <-chan error) {
	responseChan := make(chan *ListEndpointsByIpResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListEndpointsByIp(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListEndpointsByIpWithCallback invokes the location.ListEndpointsByIp API asynchronously
// api document: https://help.aliyun.com/api/location/listendpointsbyip.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListEndpointsByIpWithCallback(request *ListEndpointsByIpRequest, callback func(response *ListEndpointsByIpResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListEndpointsByIpResponse
		var err error
		defer close(result)
		response, err = client.ListEndpointsByIp(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListEndpointsByIpRequest is the request struct for api ListEndpointsByIp
type ListEndpointsByIpRequest struct {
	*requests.RpcRequest
	Ip string `position:"Query" name:"Ip"`
}

// ListEndpointsByIpResponse is the response struct for api ListEndpointsByIp
type ListEndpointsByIpResponse struct {
	*responses.BaseResponse
	RequestId    string                          `json:"RequestId" xml:"RequestId"`
	Success      bool                            `json:"Success" xml:"Success"`
	EndpointList EndpointListInListEndpointsByIp `json:"EndpointList" xml:"EndpointList"`
}

// CreateListEndpointsByIpRequest creates a request to invoke ListEndpointsByIp API
func CreateListEndpointsByIpRequest() (request *ListEndpointsByIpRequest) {
	request = &ListEndpointsByIpRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Location", "2015-06-12", "ListEndpointsByIp", "location", "openAPI")
	return
}

// CreateListEndpointsByIpResponse creates a response to parse from ListEndpointsByIp response
func CreateListEndpointsByIpResponse() (response *ListEndpointsByIpResponse) {
	response = &ListEndpointsByIpResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
