/*
 * Copyright (c) 2025, Mediatek Inc. All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef MT_SPM_VCOREFS_REG_6991_H
#define MT_SPM_VCOREFS_REG_6991_H

#include <platform_def.h>

/*************************************************************************
 * DVFSRC related constants
 *************************************************************************/
#define DVFSRC_BASE			(IO_PHYS + 0x0C013000)
#define EFUSEC_BASE			(IO_PHYS + 0x03260000)
#define EFUSE_SIZE			(0x1000)
#define DVFSRC_REG_SIZE			(0x1000)
#define DVFSRC_BASIC_CONTROL		(DVFSRC_BASE + 0x0)
#define DVFSRC_BASIC_CONTROL_4		(DVFSRC_BASE + 0xC)
#define DVFSRC_SW_REQ1			(DVFSRC_BASE + 0x10)
#define DVFSRC_SW_REQ2			(DVFSRC_BASE + 0x14)
#define DVFSRC_SW_REQ3			(DVFSRC_BASE + 0x18)
#define DVFSRC_SW_REQ4			(DVFSRC_BASE + 0x1C)
#define DVFSRC_SW_REQ5			(DVFSRC_BASE + 0x20)
#define DVFSRC_SW_REQ6			(DVFSRC_BASE + 0x24)
#define DVFSRC_SW_REQ7			(DVFSRC_BASE + 0x28)
#define DVFSRC_SW_REQ8			(DVFSRC_BASE + 0x2C)
#define DVFSRC_EMI_REQUEST		(DVFSRC_BASE + 0x30)
#define DVFSRC_EMI_REQUEST3		(DVFSRC_BASE + 0x38)
#define DVFSRC_EMI_REQUEST5		(DVFSRC_BASE + 0x40)
#define DVFSRC_EMI_QOS0			(DVFSRC_BASE + 0x4C)
#define DVFSRC_EMI_QOS1			(DVFSRC_BASE + 0x50)
#define DVFSRC_EMI_QOS2			(DVFSRC_BASE + 0x54)
#define DVFSRC_EMI_QOS3			(DVFSRC_BASE + 0x58)
#define DVFSRC_EMI_QOS4			(DVFSRC_BASE + 0x5C)
#define DVFSRC_EMI_QOS5			(DVFSRC_BASE + 0x60)
#define DVFSRC_EMI_QOS6			(DVFSRC_BASE + 0x64)
#define DVFSRC_VCORE_REQUEST		(DVFSRC_BASE + 0x80)
#define DVFSRC_VCORE_REQUEST3		(DVFSRC_BASE + 0x88)
#define DVFSRC_VCORE_QOS0		(DVFSRC_BASE + 0x94)
#define DVFSRC_VCORE_QOS1		(DVFSRC_BASE + 0x98)
#define DVFSRC_VCORE_QOS2		(DVFSRC_BASE + 0x9C)
#define DVFSRC_VCORE_QOS3		(DVFSRC_BASE + 0xA0)
#define DVFSRC_VCORE_QOS4		(DVFSRC_BASE + 0xA4)
#define DVFSRC_HALT_SW_CONTROL		(DVFSRC_BASE + 0xC4)
#define DVFSRC_INT			(DVFSRC_BASE + 0xC8)
#define DVFSRC_INT_EN			(DVFSRC_BASE + 0xCC)
#define DVFSRC_INT_CLR			(DVFSRC_BASE + 0xD0)
#define DVFSRC_BW_MON_WINDOW		(DVFSRC_BASE + 0xD4)
#define DVFSRC_BW_MON_THRES_1		(DVFSRC_BASE + 0xD8)
#define DVFSRC_BW_MON_THRES_2		(DVFSRC_BASE + 0xDC)
#define DVFSRC_MD_TURBO			(DVFSRC_BASE + 0xE0)
#define DVFSRC_PCIE_VCORE_REQ		(DVFSRC_BASE + 0xE4)
#define DVFSRC_VCORE_USER_REQ		(DVFSRC_BASE + 0xE8)
#define DVFSRC_BW_USER_REQ		(DVFSRC_BASE + 0xEC)
#define DVFSRC_TIMEOUT_NEXTREQ		(DVFSRC_BASE + 0xF8)
#define DVFSRC_LEVEL_LABEL_0_1		(DVFSRC_BASE + 0xFC)
#define DVFSRC_LEVEL_LABEL_2_3		(DVFSRC_BASE + 0x100)
#define DVFSRC_LEVEL_LABEL_4_5		(DVFSRC_BASE + 0x104)
#define DVFSRC_LEVEL_LABEL_6_7		(DVFSRC_BASE + 0x108)
#define DVFSRC_LEVEL_LABEL_8_9		(DVFSRC_BASE + 0x10C)
#define DVFSRC_LEVEL_LABEL_10_11	(DVFSRC_BASE + 0x110)
#define DVFSRC_LEVEL_LABEL_12_13	(DVFSRC_BASE + 0x114)
#define DVFSRC_LEVEL_LABEL_14_15	(DVFSRC_BASE + 0x118)
#define DVFSRC_LEVEL_LABEL_16_17	(DVFSRC_BASE + 0x11C)
#define DVFSRC_LEVEL_LABEL_18_19	(DVFSRC_BASE + 0x120)
#define DVFSRC_LEVEL_LABEL_20_21	(DVFSRC_BASE + 0x124)
#define DVFSRC_LEVEL_LABEL_22_23	(DVFSRC_BASE + 0x128)
#define DVFSRC_LEVEL_LABEL_24_25	(DVFSRC_BASE + 0x12C)
#define DVFSRC_LEVEL_LABEL_26_27	(DVFSRC_BASE + 0x130)
#define DVFSRC_LEVEL_LABEL_28_29	(DVFSRC_BASE + 0x134)
#define DVFSRC_LEVEL_LABEL_30_31	(DVFSRC_BASE + 0x138)
#define DVFSRC_LEVEL_LABEL_32_33	(DVFSRC_BASE + 0x13C)
#define DVFSRC_LEVEL_LABEL_34_35	(DVFSRC_BASE + 0x140)
#define DVFSRC_LEVEL_LABEL_36_37	(DVFSRC_BASE + 0x144)
#define DVFSRC_LEVEL_LABEL_38_39	(DVFSRC_BASE + 0x148)
#define DVFSRC_LEVEL_LABEL_40_41	(DVFSRC_BASE + 0x14C)
#define DVFSRC_LEVEL_LABEL_42_43	(DVFSRC_BASE + 0x150)
#define DVFSRC_LEVEL_LABEL_44_45	(DVFSRC_BASE + 0x154)
#define DVFSRC_LEVEL_LABEL_46_47	(DVFSRC_BASE + 0x158)
#define DVFSRC_LEVEL_LABEL_48_49	(DVFSRC_BASE + 0x15C)
#define DVFSRC_LEVEL_LABEL_50_51	(DVFSRC_BASE + 0x160)
#define DVFSRC_LEVEL_LABEL_52_53	(DVFSRC_BASE + 0x164)
#define DVFSRC_LEVEL_LABEL_54_55	(DVFSRC_BASE + 0x168)
#define DVFSRC_LEVEL_LABEL_56_57	(DVFSRC_BASE + 0x16C)
#define DVFSRC_LEVEL_LABEL_58_59	(DVFSRC_BASE + 0x170)
#define DVFSRC_LEVEL_LABEL_60_61	(DVFSRC_BASE + 0x174)
#define DVFSRC_LEVEL_LABEL_62_63	(DVFSRC_BASE + 0x178)
#define DVFSRC_SW_BW_0			(DVFSRC_BASE + 0x1DC)
#define DVFSRC_SW_BW_1			(DVFSRC_BASE + 0x1E0)
#define DVFSRC_SW_BW_2			(DVFSRC_BASE + 0x1E4)
#define DVFSRC_SW_BW_3			(DVFSRC_BASE + 0x1E8)
#define DVFSRC_SW_BW_4			(DVFSRC_BASE + 0x1EC)
#define DVFSRC_SW_BW_5			(DVFSRC_BASE + 0x1F0)
#define DVFSRC_SW_BW_6			(DVFSRC_BASE + 0x1F4)
#define DVFSRC_SW_BW_7			(DVFSRC_BASE + 0x1F8)
#define DVFSRC_SW_BW_8			(DVFSRC_BASE + 0x1FC)
#define DVFSRC_SW_BW_9			(DVFSRC_BASE + 0x200)
#define DVFSRC_QOS_EN			(DVFSRC_BASE + 0x204)
#define DVFSRC_ISP_HRT			(DVFSRC_BASE + 0x20C)
#define DVFSRC_HRT_BW_BASE		(DVFSRC_BASE + 0x210)
#define DVFSRC_SEC_SW_REQ		(DVFSRC_BASE + 0x214)
#define DVFSRC_EMI_MON_DEBOUNCE_TIME	(DVFSRC_BASE + 0x218)
#define DVFSRC_MD_LATENCY_IMPROVE	(DVFSRC_BASE + 0x21C)
#define DVFSRC_DEBOUNCE_TIME		(DVFSRC_BASE + 0x220)
#define DVFSRC_LEVEL_MASK_MD_1		(DVFSRC_BASE + 0x224)
#define DVFSRC_LEVEL_MASK_MD_2		(DVFSRC_BASE + 0x228)
#define DVFSRC_DEFAULT_OPP_1		(DVFSRC_BASE + 0x22C)
#define DVFSRC_DEFAULT_OPP_2		(DVFSRC_BASE + 0x230)
#define DVFSRC_95MD_SCEN_EMI0		(DVFSRC_BASE + 0x234)
#define DVFSRC_95MD_SCEN_EMI1		(DVFSRC_BASE + 0x238)
#define DVFSRC_95MD_SCEN_EMI2		(DVFSRC_BASE + 0x23C)
#define DVFSRC_95MD_SCEN_EMI3		(DVFSRC_BASE + 0x240)
#define DVFSRC_95MD_SCEN_EMI0_T		(DVFSRC_BASE + 0x244)
#define DVFSRC_95MD_SCEN_EMI1_T		(DVFSRC_BASE + 0x248)
#define DVFSRC_95MD_SCEN_EMI2_T		(DVFSRC_BASE + 0x24C)
#define DVFSRC_95MD_SCEN_EMI3_T		(DVFSRC_BASE + 0x250)
#define DVFSRC_95MD_SCEN_EMIU		(DVFSRC_BASE + 0x254)
#define DVFSRC_95MD_SCEN_BW0		(DVFSRC_BASE + 0x258)
#define DVFSRC_95MD_SCEN_BW1		(DVFSRC_BASE + 0x25C)
#define DVFSRC_95MD_SCEN_BW2		(DVFSRC_BASE + 0x260)
#define DVFSRC_95MD_SCEN_BW3		(DVFSRC_BASE + 0x264)
#define DVFSRC_95MD_SCEN_BW0_T		(DVFSRC_BASE + 0x268)
#define DVFSRC_95MD_SCEN_BW1_T		(DVFSRC_BASE + 0x26C)
#define DVFSRC_95MD_SCEN_BW2_T		(DVFSRC_BASE + 0x270)
#define DVFSRC_95MD_SCEN_BW3_T		(DVFSRC_BASE + 0x274)
#define DVFSRC_95MD_SCEN_BWU		(DVFSRC_BASE + 0x278)
#define DVFSRC_MD_LEVEL_SW_REG		(DVFSRC_BASE + 0x27C)
#define DVFSRC_RSRV_0			(DVFSRC_BASE + 0x280)
#define DVFSRC_RSRV_1			(DVFSRC_BASE + 0x284)
#define DVFSRC_RSRV_2			(DVFSRC_BASE + 0x288)
#define DVFSRC_RSRV_3			(DVFSRC_BASE + 0x28C)
#define DVFSRC_RSRV_4			(DVFSRC_BASE + 0x290)
#define DVFSRC_RSRV_5			(DVFSRC_BASE + 0x294)
#define DVFSRC_SPM_RESEND		(DVFSRC_BASE + 0x298)
#define DVFSRC_DEBUG_STA_0		(DVFSRC_BASE + 0x29C)
#define DVFSRC_DEBUG_STA_1		(DVFSRC_BASE + 0x2A0)
#define DVFSRC_DEBUG_STA_2		(DVFSRC_BASE + 0x2A4)
#define DVFSRC_DEBUG_STA_3		(DVFSRC_BASE + 0x2A8)
#define DVFSRC_DEBUG_STA_4		(DVFSRC_BASE + 0x2AC)
#define DVFSRC_DEBUG_STA_5		(DVFSRC_BASE + 0x2B0)
#define DVFSRC_DEBUG_STA_6		(DVFSRC_BASE + 0x2B4)
#define DVFSRC_DEBUG_STA_8		(DVFSRC_BASE + 0x2BC)
#define DVFSRC_DEBUG_STA_9		(DVFSRC_BASE + 0x2C0)
#define DVFSRC_DEBUG_STA_10		(DVFSRC_BASE + 0x2C4)
#define DVFSRC_DDR_REQUEST		(DVFSRC_BASE + 0x2C8)
#define DVFSRC_DDR_REQUEST3		(DVFSRC_BASE + 0x2D0)
#define DVFSRC_DDR_REQUEST5		(DVFSRC_BASE + 0x2D8)
#define DVFSRC_DDR_QOS0			(DVFSRC_BASE + 0x2E8)
#define DVFSRC_DDR_QOS1			(DVFSRC_BASE + 0x2EC)
#define DVFSRC_DDR_QOS2			(DVFSRC_BASE + 0x2F0)
#define DVFSRC_DDR_QOS3			(DVFSRC_BASE + 0x2F4)
#define DVFSRC_DDR_QOS4			(DVFSRC_BASE + 0x2F8)
#define DVFSRC_DDR_QOS5			(DVFSRC_BASE + 0x2FC)
#define DVFSRC_DDR_QOS6			(DVFSRC_BASE + 0x300)
#define DVFSRC_RSRV_6			(DVFSRC_BASE + 0x304)
#define DVFSRC_RSRV_7			(DVFSRC_BASE + 0x308)
#define DVFSRC_RSRV_8			(DVFSRC_BASE + 0x30C)
#define DVFSRC_RSRV_9			(DVFSRC_BASE + 0x310)
#define DVFSRC_RSRV_10			(DVFSRC_BASE + 0x314)
#define DVFSRC_RSRV_11			(DVFSRC_BASE + 0x318)
#define DVFSRC_HRT_REQ_MD_URG		(DVFSRC_BASE + 0x320)
#define DVFSRC_HRT_REQ_MD_BW_0		(DVFSRC_BASE + 0x324)
#define DVFSRC_HRT_REQ_MD_BW_1		(DVFSRC_BASE + 0x328)
#define DVFSRC_HRT_REQ_MD_BW_2		(DVFSRC_BASE + 0x32C)
#define DVFSRC_HRT_REQ_MD_BW_3		(DVFSRC_BASE + 0x330)
#define DVFSRC_HRT_REQ_MD_BW_4		(DVFSRC_BASE + 0x334)
#define DVFSRC_HRT_REQ_MD_BW_5		(DVFSRC_BASE + 0x338)
#define DVFSRC_HRT_REQ_MD_BW_6		(DVFSRC_BASE + 0x33C)
#define DVFSRC_HRT_REQ_MD_BW_7		(DVFSRC_BASE + 0x340)
#define DVFSRC_HRT_REQ_MD_BW_8		(DVFSRC_BASE + 0x344)
#define DVFSRC_HRT_REQ_MD_BW_9		(DVFSRC_BASE + 0x348)
#define DVFSRC_HRT_REQ_MD_BW_10		(DVFSRC_BASE + 0x34C)
#define DVFSRC_HRT1_REQ_MD_BW_0		(DVFSRC_BASE + 0x350)
#define DVFSRC_HRT1_REQ_MD_BW_1		(DVFSRC_BASE + 0x354)
#define DVFSRC_HRT1_REQ_MD_BW_2		(DVFSRC_BASE + 0x358)
#define DVFSRC_HRT1_REQ_MD_BW_3		(DVFSRC_BASE + 0x35C)
#define DVFSRC_HRT1_REQ_MD_BW_4		(DVFSRC_BASE + 0x360)
#define DVFSRC_HRT1_REQ_MD_BW_5		(DVFSRC_BASE + 0x364)
#define DVFSRC_HRT1_REQ_MD_BW_6		(DVFSRC_BASE + 0x368)
#define DVFSRC_HRT1_REQ_MD_BW_7		(DVFSRC_BASE + 0x36C)
#define DVFSRC_HRT1_REQ_MD_BW_8		(DVFSRC_BASE + 0x370)
#define DVFSRC_HRT1_REQ_MD_BW_9		(DVFSRC_BASE + 0x374)
#define DVFSRC_HRT1_REQ_MD_BW_10	(DVFSRC_BASE + 0x378)
#define DVFSRC_HRT_REQUEST		(DVFSRC_BASE + 0x380)
#define DVFSRC_HRT_HIGH_3		(DVFSRC_BASE + 0x384)
#define DVFSRC_HRT_HIGH_2		(DVFSRC_BASE + 0x388)
#define DVFSRC_HRT_HIGH_1		(DVFSRC_BASE + 0x38C)
#define DVFSRC_HRT_HIGH			(DVFSRC_BASE + 0x390)
#define DVFSRC_HRT_LOW_3		(DVFSRC_BASE + 0x394)
#define DVFSRC_HRT_LOW_2		(DVFSRC_BASE + 0x398)
#define DVFSRC_HRT_LOW_1		(DVFSRC_BASE + 0x39C)
#define DVFSRC_HRT_LOW			(DVFSRC_BASE + 0x3A0)
#define DVFSRC_DDR_ADD_REQUEST		(DVFSRC_BASE + 0x3A4)
#define DVFSRC_EMI_ADD_REQUEST		(DVFSRC_BASE + 0x3A8)
#define DVFSRC_LAST			(DVFSRC_BASE + 0x3AC)
#define DVFSRC_LAST_L			(DVFSRC_BASE + 0x3B0)
#define DVFSRC_MD_SCENARIO		(DVFSRC_BASE + 0x3B4)
#define DVFSRC_RECORD_0_0		(DVFSRC_BASE + 0x3B8)
#define DVFSRC_RECORD_0_1		(DVFSRC_BASE + 0x3BC)
#define DVFSRC_RECORD_0_2		(DVFSRC_BASE + 0x3C0)
#define DVFSRC_RECORD_0_3		(DVFSRC_BASE + 0x3C4)
#define DVFSRC_RECORD_0_4		(DVFSRC_BASE + 0x3C8)
#define DVFSRC_RECORD_0_5		(DVFSRC_BASE + 0x3CC)
#define DVFSRC_RECORD_0_6		(DVFSRC_BASE + 0x3D0)
#define DVFSRC_RECORD_0_7		(DVFSRC_BASE + 0x3D4)
#define DVFSRC_RECORD_1_0		(DVFSRC_BASE + 0x3D8)
#define DVFSRC_RECORD_1_1		(DVFSRC_BASE + 0x3DC)
#define DVFSRC_RECORD_1_2		(DVFSRC_BASE + 0x3E0)
#define DVFSRC_RECORD_1_3		(DVFSRC_BASE + 0x3E4)
#define DVFSRC_RECORD_1_4		(DVFSRC_BASE + 0x3E8)
#define DVFSRC_RECORD_1_5		(DVFSRC_BASE + 0x3EC)
#define DVFSRC_RECORD_1_6		(DVFSRC_BASE + 0x3F0)
#define DVFSRC_RECORD_1_7		(DVFSRC_BASE + 0x3F4)
#define DVFSRC_RECORD_2_0		(DVFSRC_BASE + 0x3F8)
#define DVFSRC_RECORD_2_1		(DVFSRC_BASE + 0x3FC)
#define DVFSRC_RECORD_2_2		(DVFSRC_BASE + 0x400)
#define DVFSRC_RECORD_2_3		(DVFSRC_BASE + 0x404)
#define DVFSRC_RECORD_2_4		(DVFSRC_BASE + 0x408)
#define DVFSRC_RECORD_2_5		(DVFSRC_BASE + 0x40C)
#define DVFSRC_RECORD_2_6		(DVFSRC_BASE + 0x410)
#define DVFSRC_RECORD_2_7		(DVFSRC_BASE + 0x414)
#define DVFSRC_RECORD_3_0		(DVFSRC_BASE + 0x418)
#define DVFSRC_RECORD_3_1		(DVFSRC_BASE + 0x41C)
#define DVFSRC_RECORD_3_2		(DVFSRC_BASE + 0x420)
#define DVFSRC_RECORD_3_3		(DVFSRC_BASE + 0x424)
#define DVFSRC_RECORD_3_4		(DVFSRC_BASE + 0x428)
#define DVFSRC_RECORD_3_5		(DVFSRC_BASE + 0x42C)
#define DVFSRC_RECORD_3_6		(DVFSRC_BASE + 0x430)
#define DVFSRC_RECORD_3_7		(DVFSRC_BASE + 0x434)
#define DVFSRC_RECORD_4_0		(DVFSRC_BASE + 0x438)
#define DVFSRC_RECORD_4_1		(DVFSRC_BASE + 0x43C)
#define DVFSRC_RECORD_4_2		(DVFSRC_BASE + 0x440)
#define DVFSRC_RECORD_4_3		(DVFSRC_BASE + 0x444)
#define DVFSRC_RECORD_4_4		(DVFSRC_BASE + 0x448)
#define DVFSRC_RECORD_4_5		(DVFSRC_BASE + 0x44C)
#define DVFSRC_RECORD_4_6		(DVFSRC_BASE + 0x450)
#define DVFSRC_RECORD_4_7		(DVFSRC_BASE + 0x454)
#define DVFSRC_RECORD_5_0		(DVFSRC_BASE + 0x458)
#define DVFSRC_RECORD_5_1		(DVFSRC_BASE + 0x45C)
#define DVFSRC_RECORD_5_2		(DVFSRC_BASE + 0x460)
#define DVFSRC_RECORD_5_3		(DVFSRC_BASE + 0x464)
#define DVFSRC_RECORD_5_4		(DVFSRC_BASE + 0x468)
#define DVFSRC_RECORD_5_5		(DVFSRC_BASE + 0x46C)
#define DVFSRC_RECORD_5_6		(DVFSRC_BASE + 0x470)
#define DVFSRC_RECORD_5_7		(DVFSRC_BASE + 0x474)
#define DVFSRC_RECORD_6_0		(DVFSRC_BASE + 0x478)
#define DVFSRC_RECORD_6_1		(DVFSRC_BASE + 0x47C)
#define DVFSRC_RECORD_6_2		(DVFSRC_BASE + 0x480)
#define DVFSRC_RECORD_6_3		(DVFSRC_BASE + 0x484)
#define DVFSRC_RECORD_6_4		(DVFSRC_BASE + 0x488)
#define DVFSRC_RECORD_6_5		(DVFSRC_BASE + 0x48C)
#define DVFSRC_RECORD_6_6		(DVFSRC_BASE + 0x490)
#define DVFSRC_RECORD_6_7		(DVFSRC_BASE + 0x494)
#define DVFSRC_RECORD_7_0		(DVFSRC_BASE + 0x498)
#define DVFSRC_RECORD_7_1		(DVFSRC_BASE + 0x49C)
#define DVFSRC_RECORD_7_2		(DVFSRC_BASE + 0x4A0)
#define DVFSRC_RECORD_7_3		(DVFSRC_BASE + 0x4A4)
#define DVFSRC_RECORD_7_4		(DVFSRC_BASE + 0x4A8)
#define DVFSRC_RECORD_7_5		(DVFSRC_BASE + 0x4AC)
#define DVFSRC_RECORD_7_6		(DVFSRC_BASE + 0x4B0)
#define DVFSRC_RECORD_7_7		(DVFSRC_BASE + 0x4B4)
#define DVFSRC_RECORD_0_L_0		(DVFSRC_BASE + 0x4B8)
#define DVFSRC_RECORD_0_L_1		(DVFSRC_BASE + 0x4BC)
#define DVFSRC_RECORD_0_L_2		(DVFSRC_BASE + 0x4C0)
#define DVFSRC_RECORD_0_L_3		(DVFSRC_BASE + 0x4C4)
#define DVFSRC_RECORD_0_L_4		(DVFSRC_BASE + 0x4C8)
#define DVFSRC_RECORD_0_L_5		(DVFSRC_BASE + 0x4CC)
#define DVFSRC_RECORD_0_L_6		(DVFSRC_BASE + 0x4D0)
#define DVFSRC_RECORD_0_L_7		(DVFSRC_BASE + 0x4D4)
#define DVFSRC_RECORD_1_L_0		(DVFSRC_BASE + 0x4D8)
#define DVFSRC_RECORD_1_L_1		(DVFSRC_BASE + 0x4DC)
#define DVFSRC_RECORD_1_L_2		(DVFSRC_BASE + 0x4E0)
#define DVFSRC_RECORD_1_L_3		(DVFSRC_BASE + 0x4E4)
#define DVFSRC_RECORD_1_L_4		(DVFSRC_BASE + 0x4E8)
#define DVFSRC_RECORD_1_L_5		(DVFSRC_BASE + 0x4EC)
#define DVFSRC_RECORD_1_L_6		(DVFSRC_BASE + 0x4F0)
#define DVFSRC_RECORD_1_L_7		(DVFSRC_BASE + 0x4F4)
#define DVFSRC_RECORD_2_L_0		(DVFSRC_BASE + 0x4F8)
#define DVFSRC_RECORD_2_L_1		(DVFSRC_BASE + 0x4FC)
#define DVFSRC_RECORD_2_L_2		(DVFSRC_BASE + 0x500)
#define DVFSRC_RECORD_2_L_3		(DVFSRC_BASE + 0x504)
#define DVFSRC_RECORD_2_L_4		(DVFSRC_BASE + 0x508)
#define DVFSRC_RECORD_2_L_5		(DVFSRC_BASE + 0x50C)
#define DVFSRC_RECORD_2_L_6		(DVFSRC_BASE + 0x510)
#define DVFSRC_RECORD_2_L_7		(DVFSRC_BASE + 0x514)
#define DVFSRC_RECORD_3_L_0		(DVFSRC_BASE + 0x518)
#define DVFSRC_RECORD_3_L_1		(DVFSRC_BASE + 0x51C)
#define DVFSRC_RECORD_3_L_2		(DVFSRC_BASE + 0x520)
#define DVFSRC_RECORD_3_L_3		(DVFSRC_BASE + 0x524)
#define DVFSRC_RECORD_3_L_4		(DVFSRC_BASE + 0x528)
#define DVFSRC_RECORD_3_L_5		(DVFSRC_BASE + 0x52C)
#define DVFSRC_RECORD_3_L_6		(DVFSRC_BASE + 0x530)
#define DVFSRC_RECORD_3_L_7		(DVFSRC_BASE + 0x534)
#define DVFSRC_RECORD_4_L_0		(DVFSRC_BASE + 0x538)
#define DVFSRC_RECORD_4_L_1		(DVFSRC_BASE + 0x53C)
#define DVFSRC_RECORD_4_L_2		(DVFSRC_BASE + 0x540)
#define DVFSRC_RECORD_4_L_3		(DVFSRC_BASE + 0x544)
#define DVFSRC_RECORD_4_L_4		(DVFSRC_BASE + 0x548)
#define DVFSRC_RECORD_4_L_5		(DVFSRC_BASE + 0x54C)
#define DVFSRC_RECORD_4_L_6		(DVFSRC_BASE + 0x550)
#define DVFSRC_RECORD_4_L_7		(DVFSRC_BASE + 0x554)
#define DVFSRC_RECORD_5_L_0		(DVFSRC_BASE + 0x558)
#define DVFSRC_RECORD_5_L_1		(DVFSRC_BASE + 0x55C)
#define DVFSRC_RECORD_5_L_2		(DVFSRC_BASE + 0x560)
#define DVFSRC_RECORD_5_L_3		(DVFSRC_BASE + 0x564)
#define DVFSRC_RECORD_5_L_4		(DVFSRC_BASE + 0x568)
#define DVFSRC_RECORD_5_L_5		(DVFSRC_BASE + 0x56C)
#define DVFSRC_RECORD_5_L_6		(DVFSRC_BASE + 0x570)
#define DVFSRC_RECORD_5_L_7		(DVFSRC_BASE + 0x574)
#define DVFSRC_RECORD_6_L_0		(DVFSRC_BASE + 0x578)
#define DVFSRC_RECORD_6_L_1		(DVFSRC_BASE + 0x57C)
#define DVFSRC_RECORD_6_L_2		(DVFSRC_BASE + 0x580)
#define DVFSRC_RECORD_6_L_3		(DVFSRC_BASE + 0x584)
#define DVFSRC_RECORD_6_L_4		(DVFSRC_BASE + 0x588)
#define DVFSRC_RECORD_6_L_5		(DVFSRC_BASE + 0x58C)
#define DVFSRC_RECORD_6_L_6		(DVFSRC_BASE + 0x590)
#define DVFSRC_RECORD_6_L_7		(DVFSRC_BASE + 0x594)
#define DVFSRC_RECORD_7_L_0		(DVFSRC_BASE + 0x598)
#define DVFSRC_RECORD_7_L_1		(DVFSRC_BASE + 0x59C)
#define DVFSRC_RECORD_7_L_2		(DVFSRC_BASE + 0x5A0)
#define DVFSRC_RECORD_7_L_3		(DVFSRC_BASE + 0x5A4)
#define DVFSRC_RECORD_7_L_4		(DVFSRC_BASE + 0x5A8)
#define DVFSRC_RECORD_7_L_5		(DVFSRC_BASE + 0x5AC)
#define DVFSRC_RECORD_7_L_6		(DVFSRC_BASE + 0x5B0)
#define DVFSRC_RECORD_7_L_7		(DVFSRC_BASE + 0x5B4)
#define DVFSRC_CURRENT_LEVEL_1		(DVFSRC_BASE + 0x5C4)
#define DVFSRC_CURRENT_LEVEL_2		(DVFSRC_BASE + 0x5C8)
#define DVFSRC_TARGET_LEVEL_1		(DVFSRC_BASE + 0x5CC)
#define DVFSRC_TARGET_LEVEL_2		(DVFSRC_BASE + 0x5D0)
#define DVFSRC_CURRENT_FORCE_1		(DVFSRC_BASE + 0x5D4)
#define DVFSRC_CURRENT_FORCE_2		(DVFSRC_BASE + 0x5D8)
#define DVFSRC_TARGET_FORCE_1		(DVFSRC_BASE + 0x5DC)
#define DVFSRC_TARGET_FORCE_2		(DVFSRC_BASE + 0x5E0)
#define DVFSRC_MD_DDR_FLOOR_REQUEST	(DVFSRC_BASE + 0x5E4)
#define DVFSRC_QOS_DDR_REQUEST		(DVFSRC_BASE + 0x5E8)
#define DVFSRC_FORCE_MASK		(DVFSRC_BASE + 0x5EC)
#define DVFSRC_LEVEL_HEX		(DVFSRC_BASE + 0x5F0)
#define DVFSRC_AVS_RETRY		(DVFSRC_BASE + 0x5F4)
#define DVFSRC_SW_REQ9			(DVFSRC_BASE + 0x5F8)
#define DVFSRC_SW_REQ10			(DVFSRC_BASE + 0x5FC)
#define DVFSRC_SW_REQ11			(DVFSRC_BASE + 0x600)
#define DVFSRC_SW_REQ12			(DVFSRC_BASE + 0x604)
#define DVFSRC_LEVEL_MASK_SW_1		(DVFSRC_BASE + 0x608)
#define DVFSRC_LEVEL_MASK_SW_2		(DVFSRC_BASE + 0x60C)
#define DVFSRC_ACCEPT_RETRY		(DVFSRC_BASE + 0x610)
#define DVFSRC_TARGET_LEVEL_SPM_1	(DVFSRC_BASE + 0x614)
#define DVFSRC_TARGET_LEVEL_SPM_2	(DVFSRC_BASE + 0x618)
#define DVFSRC_EMI_REQUEST8		(DVFSRC_BASE + 0x620)
#define DVFSRC_DDR_REQUEST8		(DVFSRC_BASE + 0x62C)
#define DVFSRC_EMI_QOS7			(DVFSRC_BASE + 0x64C)
#define DVFSRC_EMI_QOS8			(DVFSRC_BASE + 0x650)
#define DVFSRC_EMI_QOS9			(DVFSRC_BASE + 0x654)
#define DVFSRC_EMI_QOS10		(DVFSRC_BASE + 0x658)
#define DVFSRC_DDR_QOS7			(DVFSRC_BASE + 0x65C)
#define DVFSRC_DDR_QOS8			(DVFSRC_BASE + 0x660)
#define DVFSRC_DDR_QOS9			(DVFSRC_BASE + 0x664)
#define DVFSRC_DDR_QOS10		(DVFSRC_BASE + 0x668)
#define DVFSRC_HRT_HIGH_7		(DVFSRC_BASE + 0x66C)
#define DVFSRC_HRT_HIGH_6		(DVFSRC_BASE + 0x670)
#define DVFSRC_HRT_HIGH_5		(DVFSRC_BASE + 0x674)
#define DVFSRC_HRT_HIGH_4		(DVFSRC_BASE + 0x678)
#define DVFSRC_HRT_LOW_7		(DVFSRC_BASE + 0x67C)
#define DVFSRC_HRT_LOW_6		(DVFSRC_BASE + 0x680)
#define DVFSRC_HRT_LOW_5		(DVFSRC_BASE + 0x684)
#define DVFSRC_HRT_LOW_4		(DVFSRC_BASE + 0x688)
#define DVFSRC_DDR_ADD_REQUEST_1	(DVFSRC_BASE + 0x68C)
#define DVFSRC_EMI_ADD_REQUEST_1	(DVFSRC_BASE + 0x690)
#define DVFSRC_HRT_REQUEST_1		(DVFSRC_BASE + 0x694)
#define DVFSRC_VCORE_QOS5		(DVFSRC_BASE + 0x69C)
#define DVFSRC_VCORE_QOS6		(DVFSRC_BASE + 0x6A0)
#define DVFSRC_VCORE_QOS7		(DVFSRC_BASE + 0x6A4)
#define DVFSRC_CEILING_SET		(DVFSRC_BASE + 0x6A8)
#define DVFSRC_CUR_TARGET_GEAR		(DVFSRC_BASE + 0x6AC)
#define DVFSRC_LEVEL_LABEL_64_65	(DVFSRC_BASE + 0x6B0)
#define DVFSRC_LEVEL_LABEL_66_67	(DVFSRC_BASE + 0x6B4)
#define DVFSRC_LEVEL_LABEL_68_69	(DVFSRC_BASE + 0x6B8)
#define DVFSRC_LEVEL_LABEL_70_71	(DVFSRC_BASE + 0x6BC)
#define DVFSRC_LEVEL_LABEL_72_73	(DVFSRC_BASE + 0x6C0)
#define DVFSRC_LEVEL_LABEL_74_75	(DVFSRC_BASE + 0x6C4)
#define DVFSRC_LEVEL_LABEL_76_77	(DVFSRC_BASE + 0x6C8)
#define DVFSRC_LEVEL_LABEL_78_79	(DVFSRC_BASE + 0x6CC)
#define DVFSRC_LEVEL_LABEL_80_81	(DVFSRC_BASE + 0x6D0)
#define DVFSRC_LEVEL_LABEL_82_83	(DVFSRC_BASE + 0x6D4)
#define DVFSRC_LEVEL_LABEL_84_85	(DVFSRC_BASE + 0x6D8)
#define DVFSRC_LEVEL_LABEL_86_87	(DVFSRC_BASE + 0x6DC)
#define DVFSRC_LEVEL_LABEL_88_89	(DVFSRC_BASE + 0x6E0)
#define DVFSRC_LEVEL_LABEL_90_91	(DVFSRC_BASE + 0x6E4)
#define DVFSRC_LEVEL_LABEL_92_93	(DVFSRC_BASE + 0x6E8)
#define DVFSRC_LEVEL_LABEL_94_95	(DVFSRC_BASE + 0x6EC)
#define DVFSRC_LEVEL_LABEL_96_97	(DVFSRC_BASE + 0x6F0)
#define DVFSRC_LEVEL_LABEL_98_99	(DVFSRC_BASE + 0x6F4)
#define DVFSRC_LEVEL_LABEL_100_101	(DVFSRC_BASE + 0x6F8)
#define DVFSRC_LEVEL_LABEL_102_103	(DVFSRC_BASE + 0x6FC)
#define DVFSRC_LEVEL_LABEL_104_105	(DVFSRC_BASE + 0x700)
#define DVFSRC_LEVEL_LABEL_106_107	(DVFSRC_BASE + 0x704)
#define DVFSRC_LEVEL_LABEL_108_109	(DVFSRC_BASE + 0x708)
#define DVFSRC_LEVEL_LABEL_110_111	(DVFSRC_BASE + 0x70C)
#define DVFSRC_LEVEL_LABEL_112_113	(DVFSRC_BASE + 0x710)
#define DVFSRC_LEVEL_LABEL_114_115	(DVFSRC_BASE + 0x714)
#define DVFSRC_LEVEL_LABEL_116_117	(DVFSRC_BASE + 0x718)
#define DVFSRC_LEVEL_LABEL_118_119	(DVFSRC_BASE + 0x71C)
#define DVFSRC_LEVEL_LABEL_120_121	(DVFSRC_BASE + 0x720)
#define DVFSRC_LEVEL_LABEL_122_123	(DVFSRC_BASE + 0x724)
#define DVFSRC_LEVEL_LABEL_124_125	(DVFSRC_BASE + 0x728)
#define DVFSRC_LEVEL_LABEL_126_127	(DVFSRC_BASE + 0x72C)
#define DVFSRC_LEVEL_MASK_MD_3		(DVFSRC_BASE + 0x738)
#define DVFSRC_LEVEL_MASK_MD_4		(DVFSRC_BASE + 0x73C)
#define DVFSRC_DEFAULT_OPP_3		(DVFSRC_BASE + 0x740)
#define DVFSRC_DEFAULT_OPP_4		(DVFSRC_BASE + 0x744)
#define DVFSRC_LEVEL_MASK_SW_3		(DVFSRC_BASE + 0x748)
#define DVFSRC_LEVEL_MASK_SW_4		(DVFSRC_BASE + 0x74C)
#define DVFSRC_TARGET_LEVEL_SPM_3	(DVFSRC_BASE + 0x750)
#define DVFSRC_TARGET_LEVEL_SPM_4	(DVFSRC_BASE + 0x754)
#define DVFSRC_CURRENT_LEVEL_3		(DVFSRC_BASE + 0x758)
#define DVFSRC_CURRENT_LEVEL_4		(DVFSRC_BASE + 0x75C)
#define DVFSRC_TARGET_LEVEL_3		(DVFSRC_BASE + 0x760)
#define DVFSRC_TARGET_LEVEL_4		(DVFSRC_BASE + 0x764)
#define DVFSRC_CURRENT_FORCE_3		(DVFSRC_BASE + 0x768)
#define DVFSRC_CURRENT_FORCE_4		(DVFSRC_BASE + 0x76C)
#define DVFSRC_TARGET_FORCE_3		(DVFSRC_BASE + 0x770)
#define DVFSRC_TARGET_FORCE_4		(DVFSRC_BASE + 0x774)
#define DVFSRC_DDR_REQUEST10		(DVFSRC_BASE + 0x778)
#define DVFSRC_EMI_REQUEST10		(DVFSRC_BASE + 0x77C)
#define DVFSRC_DDR_REQUEST11		(DVFSRC_BASE + 0x780)
#define DVFSRC_EMI_REQUEST11		(DVFSRC_BASE + 0x784)
#define DVFSRC_TARGET_FORCE_5		(DVFSRC_BASE + 0x788)
#define DVFSRC_TARGET_FORCE_6		(DVFSRC_BASE + 0x78C)
#define DVFSRC_TARGET_FORCE_7		(DVFSRC_BASE + 0x790)
#define DVFSRC_TARGET_FORCE_8		(DVFSRC_BASE + 0x794)
#define DVFSRC_PMQOS_HRT_UNIT_SW_BW	(DVFSRC_BASE + 0x798)
#define DVFSRC_DISP_HRT_UNIT_SW_BW	(DVFSRC_BASE + 0x79C)
#define DVFSRC_ISP_HRT_UNIT_SW_BW	(DVFSRC_BASE + 0x7A0)
#define DVFSRC_MD_HRT_UNIT_SW_BW	(DVFSRC_BASE + 0x7A4)
#define DVFSRC_HRT_BASE_HRT_UNIT_SW_BW	(DVFSRC_BASE + 0x7A8)
#define DVFSRC_APU_HRT_UNIT_SW_BW	(DVFSRC_BASE + 0x7AC)
#define DVFSRC_SMMU_HRT_UNIT_SW_BW	(DVFSRC_BASE + 0x7B0)
#define DVFSRC_SMAP_CG_SET		(DVFSRC_BASE + 0x814)
#define DVFSRC_LEVEL_MASK_MD_5		(DVFSRC_BASE + 0x818)
#define DVFSRC_LEVEL_MASK_MD_6		(DVFSRC_BASE + 0x81C)
#define DVFSRC_LEVEL_MASK_MD_7		(DVFSRC_BASE + 0x820)
#define DVFSRC_LEVEL_MASK_MD_8		(DVFSRC_BASE + 0x824)
#define DVFSRC_DEFAULT_OPP_5		(DVFSRC_BASE + 0x828)
#define DVFSRC_DEFAULT_OPP_6		(DVFSRC_BASE + 0x82C)
#define DVFSRC_DEFAULT_OPP_7		(DVFSRC_BASE + 0x830)
#define DVFSRC_DEFAULT_OPP_8		(DVFSRC_BASE + 0x834)
#define DVFSRC_LEVEL_MASK_SW_5		(DVFSRC_BASE + 0x838)
#define DVFSRC_LEVEL_MASK_SW_6		(DVFSRC_BASE + 0x83C)
#define DVFSRC_LEVEL_MASK_SW_7		(DVFSRC_BASE + 0x840)
#define DVFSRC_LEVEL_MASK_SW_8		(DVFSRC_BASE + 0x844)
#define DVFSRC_TARGET_LEVEL_SPM_5	(DVFSRC_BASE + 0x848)
#define DVFSRC_TARGET_LEVEL_SPM_6	(DVFSRC_BASE + 0x84C)
#define DVFSRC_TARGET_LEVEL_SPM_7	(DVFSRC_BASE + 0x850)
#define DVFSRC_TARGET_LEVEL_SPM_8	(DVFSRC_BASE + 0x854)
#define DVFSRC_CURRENT_LEVEL_5		(DVFSRC_BASE + 0x858)
#define DVFSRC_CURRENT_LEVEL_6		(DVFSRC_BASE + 0x85C)
#define DVFSRC_CURRENT_LEVEL_7		(DVFSRC_BASE + 0x860)
#define DVFSRC_CURRENT_LEVEL_8		(DVFSRC_BASE + 0x864)
#define DVFSRC_TARGET_LEVEL_5		(DVFSRC_BASE + 0x868)
#define DVFSRC_TARGET_LEVEL_6		(DVFSRC_BASE + 0x86C)
#define DVFSRC_TARGET_LEVEL_7		(DVFSRC_BASE + 0x870)
#define DVFSRC_TARGET_LEVEL_8		(DVFSRC_BASE + 0x874)
#define DVFSRC_CURRENT_FORCE_5		(DVFSRC_BASE + 0x878)
#define DVFSRC_CURRENT_FORCE_6		(DVFSRC_BASE + 0x87C)
#define DVFSRC_CURRENT_FORCE_7		(DVFSRC_BASE + 0x880)
#define DVFSRC_CURRENT_FORCE_8		(DVFSRC_BASE + 0x884)
#define DVFSRC_HRT_REQ_MD_BW_11		(DVFSRC_BASE + 0x88C)
#define DVFSRC_HRT_REQ_MD_BW_12		(DVFSRC_BASE + 0x890)
#define DVFSRC_HRT_REQ_MD_BW_13		(DVFSRC_BASE + 0x894)
#define DVFSRC_HRT_REQ_MD_BW_14		(DVFSRC_BASE + 0x898)
#define DVFSRC_HRT_REQ_MD_BW_15		(DVFSRC_BASE + 0x89C)
#define DVFSRC_HRT_REQ_MD_BW_16		(DVFSRC_BASE + 0x8A0)
#define DVFSRC_HRT_REQ_MD_BW_17		(DVFSRC_BASE + 0x8A4)
#define DVFSRC_HRT_REQ_MD_BW_18		(DVFSRC_BASE + 0x8A8)
#define DVFSRC_HRT_REQ_MD_BW_19		(DVFSRC_BASE + 0x8AC)
#define DVFSRC_HRT_REQ_MD_BW_20		(DVFSRC_BASE + 0x8B0)
#define DVFSRC_HRT_REQ_MD_BW_21		(DVFSRC_BASE + 0x8B4)
#define DVFSRC_HRT1_REQ_MD_BW_11	(DVFSRC_BASE + 0x8B8)
#define DVFSRC_HRT1_REQ_MD_BW_12	(DVFSRC_BASE + 0x8BC)
#define DVFSRC_HRT1_REQ_MD_BW_13	(DVFSRC_BASE + 0x8C0)
#define DVFSRC_HRT1_REQ_MD_BW_14	(DVFSRC_BASE + 0x8C4)
#define DVFSRC_HRT1_REQ_MD_BW_15	(DVFSRC_BASE + 0x8C8)
#define DVFSRC_HRT1_REQ_MD_BW_16	(DVFSRC_BASE + 0x8CC)
#define DVFSRC_HRT1_REQ_MD_BW_17	(DVFSRC_BASE + 0x8D0)
#define DVFSRC_HRT1_REQ_MD_BW_18	(DVFSRC_BASE + 0x8D4)
#define DVFSRC_HRT1_REQ_MD_BW_19	(DVFSRC_BASE + 0x8D8)
#define DVFSRC_HRT1_REQ_MD_BW_20	(DVFSRC_BASE + 0x8DC)
#define DVFSRC_HRT1_REQ_MD_BW_21	(DVFSRC_BASE + 0x8E0)
#define DVFSRC_95MD_SCEN_EMI4		(DVFSRC_BASE + 0x904)
#define DVFSRC_95MD_SCEN_EMI5		(DVFSRC_BASE + 0x908)
#define DVFSRC_95MD_SCEN_EMI6		(DVFSRC_BASE + 0x90C)
#define DVFSRC_95MD_SCEN_EMI7		(DVFSRC_BASE + 0x910)
#define DVFSRC_95MD_SCEN_EMI4_T		(DVFSRC_BASE + 0x914)
#define DVFSRC_95MD_SCEN_EMI5_T		(DVFSRC_BASE + 0x918)
#define DVFSRC_95MD_SCEN_EMI6_T		(DVFSRC_BASE + 0x91C)
#define DVFSRC_95MD_SCEN_EMI7_T		(DVFSRC_BASE + 0x920)
#define DVFSRC_95MD_SCEN_BW4		(DVFSRC_BASE + 0x924)
#define DVFSRC_95MD_SCEN_BW5		(DVFSRC_BASE + 0x928)
#define DVFSRC_95MD_SCEN_BW6		(DVFSRC_BASE + 0x92C)
#define DVFSRC_95MD_SCEN_BW7		(DVFSRC_BASE + 0x930)
#define DVFSRC_95MD_SCEN_BW4_T		(DVFSRC_BASE + 0x934)
#define DVFSRC_95MD_SCEN_BW5_T		(DVFSRC_BASE + 0x938)
#define DVFSRC_95MD_SCEN_BW6_T		(DVFSRC_BASE + 0x93C)
#define DVFSRC_95MD_SCEN_BW7_T		(DVFSRC_BASE + 0x940)
#define DVFSRC_LEVEL_LABEL_128_129	(DVFSRC_BASE + 0x944)
#define DVFSRC_LEVEL_LABEL_130_131	(DVFSRC_BASE + 0x948)
#define DVFSRC_LEVEL_LABEL_132_133	(DVFSRC_BASE + 0x94C)
#define DVFSRC_LEVEL_LABEL_134_135	(DVFSRC_BASE + 0x950)
#define DVFSRC_LEVEL_LABEL_136_137	(DVFSRC_BASE + 0x954)
#define DVFSRC_LEVEL_LABEL_138_139	(DVFSRC_BASE + 0x958)
#define DVFSRC_LEVEL_LABEL_140_141	(DVFSRC_BASE + 0x95C)
#define DVFSRC_LEVEL_LABEL_142_143	(DVFSRC_BASE + 0x960)
#define DVFSRC_LEVEL_LABEL_144_145	(DVFSRC_BASE + 0x964)
#define DVFSRC_LEVEL_LABEL_146_147	(DVFSRC_BASE + 0x968)
#define DVFSRC_LEVEL_LABEL_148_149	(DVFSRC_BASE + 0x96C)
#define DVFSRC_LEVEL_LABEL_150_151	(DVFSRC_BASE + 0x970)
#define DVFSRC_LEVEL_LABEL_152_153	(DVFSRC_BASE + 0x974)
#define DVFSRC_LEVEL_LABEL_154_155	(DVFSRC_BASE + 0x978)
#define DVFSRC_LEVEL_LABEL_156_157	(DVFSRC_BASE + 0x97C)
#define DVFSRC_LEVEL_LABEL_158_159	(DVFSRC_BASE + 0x980)
#define DVFSRC_LEVEL_LABEL_160_161	(DVFSRC_BASE + 0x984)
#define DVFSRC_LEVEL_LABEL_162_163	(DVFSRC_BASE + 0x988)
#define DVFSRC_LEVEL_LABEL_164_165	(DVFSRC_BASE + 0x98C)
#define DVFSRC_LEVEL_LABEL_166_167	(DVFSRC_BASE + 0x990)
#define DVFSRC_LEVEL_LABEL_168_169	(DVFSRC_BASE + 0x994)
#define DVFSRC_LEVEL_LABEL_170_171	(DVFSRC_BASE + 0x998)
#define DVFSRC_LEVEL_LABEL_172_173	(DVFSRC_BASE + 0x99C)
#define DVFSRC_LEVEL_LABEL_174_175	(DVFSRC_BASE + 0x9A0)
#define DVFSRC_LEVEL_LABEL_176_177	(DVFSRC_BASE + 0x9A4)
#define DVFSRC_LEVEL_LABEL_178_179	(DVFSRC_BASE + 0x9A8)
#define DVFSRC_LEVEL_LABEL_180_181	(DVFSRC_BASE + 0x9AC)
#define DVFSRC_LEVEL_LABEL_182_183	(DVFSRC_BASE + 0x9B0)
#define DVFSRC_LEVEL_LABEL_184_185	(DVFSRC_BASE + 0x9B4)
#define DVFSRC_LEVEL_LABEL_186_187	(DVFSRC_BASE + 0x9B8)
#define DVFSRC_LEVEL_LABEL_188_189	(DVFSRC_BASE + 0x9BC)
#define DVFSRC_LEVEL_LABEL_190_191	(DVFSRC_BASE + 0x9C0)
#define DVFSRC_LEVEL_LABEL_192_193	(DVFSRC_BASE + 0x9C4)
#define DVFSRC_LEVEL_LABEL_194_195	(DVFSRC_BASE + 0x9C8)
#define DVFSRC_LEVEL_LABEL_196_197	(DVFSRC_BASE + 0x9CC)
#define DVFSRC_LEVEL_LABEL_198_199	(DVFSRC_BASE + 0x9D0)
#define DVFSRC_LEVEL_LABEL_200_201	(DVFSRC_BASE + 0x9D4)
#define DVFSRC_LEVEL_LABEL_202_203	(DVFSRC_BASE + 0x9D8)
#define DVFSRC_LEVEL_LABEL_204_205	(DVFSRC_BASE + 0x9DC)
#define DVFSRC_LEVEL_LABEL_206_207	(DVFSRC_BASE + 0x9E0)
#define DVFSRC_LEVEL_LABEL_208_209	(DVFSRC_BASE + 0x9E4)
#define DVFSRC_LEVEL_LABEL_210_211	(DVFSRC_BASE + 0x9E8)
#define DVFSRC_LEVEL_LABEL_212_213	(DVFSRC_BASE + 0x9EC)
#define DVFSRC_LEVEL_LABEL_214_215	(DVFSRC_BASE + 0x9F0)
#define DVFSRC_LEVEL_LABEL_216_217	(DVFSRC_BASE + 0x9F4)
#define DVFSRC_LEVEL_LABEL_218_219	(DVFSRC_BASE + 0x9F8)
#define DVFSRC_LEVEL_LABEL_220_221	(DVFSRC_BASE + 0x9FC)
#define DVFSRC_LEVEL_LABEL_222_223	(DVFSRC_BASE + 0xA00)
#define DVFSRC_LEVEL_LABEL_224_225	(DVFSRC_BASE + 0xA04)
#define DVFSRC_LEVEL_LABEL_226_227	(DVFSRC_BASE + 0xA08)
#define DVFSRC_LEVEL_LABEL_228_229	(DVFSRC_BASE + 0xA0C)
#define DVFSRC_LEVEL_LABEL_230_231	(DVFSRC_BASE + 0xA10)
#define DVFSRC_LEVEL_LABEL_232_233	(DVFSRC_BASE + 0xA14)
#define DVFSRC_LEVEL_LABEL_234_235	(DVFSRC_BASE + 0xA18)
#define DVFSRC_LEVEL_LABEL_236_237	(DVFSRC_BASE + 0xA1C)
#define DVFSRC_LEVEL_LABEL_238_239	(DVFSRC_BASE + 0xA20)
#define DVFSRC_LEVEL_LABEL_240_241	(DVFSRC_BASE + 0xA24)
#define DVFSRC_LEVEL_LABEL_242_243	(DVFSRC_BASE + 0xA28)
#define DVFSRC_LEVEL_LABEL_244_245	(DVFSRC_BASE + 0xA2C)
#define DVFSRC_LEVEL_LABEL_246_247	(DVFSRC_BASE + 0xA30)
#define DVFSRC_LEVEL_LABEL_248_249	(DVFSRC_BASE + 0xA34)
#define DVFSRC_LEVEL_LABEL_250_251	(DVFSRC_BASE + 0xA38)
#define DVFSRC_LEVEL_LABEL_252_253	(DVFSRC_BASE + 0xA3C)
#define DVFSRC_LEVEL_LABEL_254_255	(DVFSRC_BASE + 0xA40)
#define DVFSRC_HRT_HIGH_15		(DVFSRC_BASE + 0xA44)
#define DVFSRC_HRT_HIGH_14		(DVFSRC_BASE + 0xA48)
#define DVFSRC_HRT_HIGH_13		(DVFSRC_BASE + 0xA4C)
#define DVFSRC_HRT_HIGH_12		(DVFSRC_BASE + 0xA50)
#define DVFSRC_HRT_HIGH_11		(DVFSRC_BASE + 0xA54)
#define DVFSRC_HRT_HIGH_10		(DVFSRC_BASE + 0xA58)
#define DVFSRC_HRT_HIGH_9		(DVFSRC_BASE + 0xA5C)
#define DVFSRC_HRT_HIGH_8		(DVFSRC_BASE + 0xA60)
#define DVFSRC_HRT_LOW_15		(DVFSRC_BASE + 0xA64)
#define DVFSRC_HRT_LOW_14		(DVFSRC_BASE + 0xA68)
#define DVFSRC_HRT_LOW_13		(DVFSRC_BASE + 0xA6C)
#define DVFSRC_HRT_LOW_12		(DVFSRC_BASE + 0xA70)
#define DVFSRC_HRT_LOW_11		(DVFSRC_BASE + 0xA74)
#define DVFSRC_HRT_LOW_10		(DVFSRC_BASE + 0xA78)
#define DVFSRC_HRT_LOW_9		(DVFSRC_BASE + 0xA7C)
#define DVFSRC_HRT_LOW_8		(DVFSRC_BASE + 0xA80)
#define DVFSRC_DDR_QOS11		(DVFSRC_BASE + 0xA84)
#define DVFSRC_DDR_QOS12		(DVFSRC_BASE + 0xA88)
#define DVFSRC_DDR_QOS13		(DVFSRC_BASE + 0xA8C)
#define DVFSRC_DDR_QOS14		(DVFSRC_BASE + 0xA90)
#define DVFSRC_DDR_QOS15		(DVFSRC_BASE + 0xA94)
#define DVFSRC_EMI_QOS11		(DVFSRC_BASE + 0xA98)
#define DVFSRC_EMI_QOS12		(DVFSRC_BASE + 0xA9C)
#define DVFSRC_EMI_QOS13		(DVFSRC_BASE + 0xAA0)
#define DVFSRC_EMI_QOS14		(DVFSRC_BASE + 0xAA4)
#define DVFSRC_EMI_QOS15		(DVFSRC_BASE + 0xAA8)
#define DVFSRC_TARGET_REQ_MASK		BIT(16)
#define DVFSRC_EN_MASK			1
#endif /* MT_SPM_VCOREFS_REG_6991_H */
