/* SPDX-License-Identifier: BSD-3-Clause */
/*
 * Copyright (c) 2025, Rockchip Electronics Co., Ltd.
 */

#ifndef __FIREWALL_H__
#define __FIREWALL_H__

#include <plat_private.h>

/* FW SGRF */
#define FW_SGRF_MST_DOMAIN_CON(i)	((i) * 4)
#define FW_SGRF_MST_DOMAIN_CON_CNT	8
#define FW_SGRF_DDR_RGN(i)		(0x0100 + (i) * 4)
#define FW_SGRF_DDR_RGN_CNT		16
#define FW_SGRF_DDR_LOOKUP(i)		(0x0140 + (i) * 0x4)
#define FW_SGRF_DDR_LOOKUP_CNT		8
#define FW_SGRF_DDR_SIZE		0x0160
#define FW_SGRF_DDR_CON			0x0168
#define FW_SGRF_SYSMEM_RGN(i)		(0x0200 + (i) * 4)
#define FW_SGRF_SYSMEM_RGN_CNT		4
#define FW_SGRF_SYSMEM_LOOKUP(i)	(0x0210 + (i) * 4)
#define FW_SGRF_SYSMEM_LOOKUP_CNT	2
#define FW_SGRF_SYSMEM_CON		0x0218
#define FW_SGRF_CBUF_RGN(i)		(0x0300 + (i) * 4)
#define FW_SGRF_CBUF_RGN_CNT		8
#define FW_SGRF_CBUF_LOOKUP(i)		(0x0320 + (i) * 4)
#define FW_SGRF_CBUF_LOOKUP_CNT		4
#define FW_SGRF_CBUF_CON		0x0330
#define FW_SGRF_SLV_LOOKUP(i)		(0x0400 + (i) * 4)
#define FW_SGRF_SLV_LOOKUP_CNT		4
#define FW_SGRF_BUS_SLV_CON(i)		(0x0500 + (i) * 4)
#define FW_SGRF_BUS_SLV_CON_CNT		25
#define FW_SGRF_BUS_SLV_STAT		0x0580
#define FW_SGRF_TOP_SLV_CON(i)		(0x0600 + (i) * 4)
#define FW_SGRF_TOP_SLV_CON_CNT		16
#define FW_SGRF_TOP_SLV_STAT		0x0680
#define FW_SGRF_CENTER_SLV_CON(i)	(0x0700 + (i) * 4)
#define FW_SGRF_CENTER_SLV_CON_CNT	13
#define FW_SGRF_CCI_SLV_CON(i)		(0x0800 + (i) * 4)
#define FW_SGRF_CCI_SLV_CON_CNT		3
#define FW_SGRF_PHP_SLV_CON(i)		(0x0900 + (i) * 4)
#define FW_SGRF_PHP_SLV_CON_CNT		4
#define FW_SGRF_PHP_SLV_STAT		0x0940
#define FW_SGRF_GPU_SLV_CON		0x0980
#define FW_SGRF_NPU_SLV_CON(i)		(0x09a0 + (i) * 4)
#define FW_SGRF_NPU_SLV_CON_CNT		2
#define FW_SGRF_STATCLR_CON0		0x0a00
#define FW_SGRF_KEYUPD_CON0		0x0a80
#define FW_SGRF_KEYUPD_CON1		0x0a84
#define FW_SGRF_KEYUPD_STAT		0x0ab0

/* FW PMUSGRF */
#define FW_PMU_SGRF_SLV_CON(i)		((i) * 4)
#define FW_PMU_SGRF_SLV_CON_CNT		9
#define FW_PMU_SGRF_SLV_LOOKUP(i)	(0x0080 + (i) * 0x4)
#define FW_PMU_SGRF_SLV_LOOKUP_CNT	4
#define FW_PMU_SGRF_DOMAIN_CON		0x00a0
#define FW_PMU_SGRF_SLV_STAT		0x00c0

/* master id */
#define FW_MST_ID_USB0			FW_MST_ID(FW_MST_TYPE_SYS, 0)
#define FW_MST_ID_KEYLAD_APB		FW_MST_ID(FW_MST_TYPE_SYS, 1)
#define FW_MST_ID_DFT2APB		FW_MST_ID(FW_MST_TYPE_SYS, 2)
#define FW_MST_ID_PCIE0			FW_MST_ID(FW_MST_TYPE_SYS, 3)
#define FW_MST_ID_PCIE1			FW_MST_ID(FW_MST_TYPE_SYS, 4)
#define FW_MST_ID_SATA0			FW_MST_ID(FW_MST_TYPE_SYS, 6)
#define FW_MST_ID_SATA1			FW_MST_ID(FW_MST_TYPE_SYS, 7)
#define FW_MST_ID_CRYPTO		FW_MST_ID(FW_MST_TYPE_SYS, 8)
#define FW_MST_ID_FLEXBUS		FW_MST_ID(FW_MST_TYPE_SYS, 9)
#define FW_MST_ID_DECOM			FW_MST_ID(FW_MST_TYPE_SYS, 10)
#define FW_MST_ID_DMA2DDR		FW_MST_ID(FW_MST_TYPE_SYS, 11)
#define FW_MST_ID_DMAC0			FW_MST_ID(FW_MST_TYPE_SYS, 12)
#define FW_MST_ID_DMAC1			FW_MST_ID(FW_MST_TYPE_SYS, 13)
#define FW_MST_ID_DMAC2			FW_MST_ID(FW_MST_TYPE_SYS, 14)
#define FW_MST_ID_EBC			FW_MST_ID(FW_MST_TYPE_SYS, 15)
#define FW_MST_ID_EMMC			FW_MST_ID(FW_MST_TYPE_SYS, 16)
#define FW_MST_ID_GMAC0			FW_MST_ID(FW_MST_TYPE_SYS, 17)
#define FW_MST_ID_GMAC1			FW_MST_ID(FW_MST_TYPE_SYS, 18)
#define FW_MST_ID_GPU			FW_MST_ID(FW_MST_TYPE_SYS, 19)
#define FW_MST_ID_HDCP0			FW_MST_ID(FW_MST_TYPE_SYS, 20)
#define FW_MST_ID_HDCP1			FW_MST_ID(FW_MST_TYPE_SYS, 21)
#define FW_MST_ID_ISP			FW_MST_ID(FW_MST_TYPE_SYS, 22)
#define FW_MST_ID_RGA0			FW_MST_ID(FW_MST_TYPE_SYS, 23)
#define FW_MST_ID_RGA1			FW_MST_ID(FW_MST_TYPE_SYS, 24)
#define FW_MST_ID_JPEG			FW_MST_ID(FW_MST_TYPE_SYS, 25)
#define FW_MST_ID_RKVDEC		FW_MST_ID(FW_MST_TYPE_SYS, 26)
#define FW_MST_ID_VEPU0			FW_MST_ID(FW_MST_TYPE_SYS, 27)
#define FW_MST_ID_UFSHC			FW_MST_ID(FW_MST_TYPE_SYS, 28)
#define FW_MST_ID_VDPP			FW_MST_ID(FW_MST_TYPE_SYS, 29)
#define FW_MST_ID_VICAP			FW_MST_ID(FW_MST_TYPE_SYS, 30)
#define FW_MST_ID_VOP_M0		FW_MST_ID(FW_MST_TYPE_SYS, 31)
#define FW_MST_ID_VOP_M1		FW_MST_ID(FW_MST_TYPE_SYS, 32)
#define FW_MST_ID_VPSS			FW_MST_ID(FW_MST_TYPE_SYS, 33)
#define FW_MST_ID_FSPI0			FW_MST_ID(FW_MST_TYPE_SYS, 34)
#define FW_MST_ID_FSPI1			FW_MST_ID(FW_MST_TYPE_SYS, 35)
#define FW_MST_ID_BUS_MCU		FW_MST_ID(FW_MST_TYPE_SYS, 36)
#define FW_MST_ID_DDR_MCU		FW_MST_ID(FW_MST_TYPE_SYS, 37)
#define FW_MST_ID_NPU_MCU		FW_MST_ID(FW_MST_TYPE_SYS, 38)
#define FW_MST_ID_CAN0			FW_MST_ID(FW_MST_TYPE_SYS, 39)
#define FW_MST_ID_CAN1			FW_MST_ID(FW_MST_TYPE_SYS, 40)
#define FW_MST_ID_SDIO			FW_MST_ID(FW_MST_TYPE_SYS, 41)
#define FW_MST_ID_SDMMC0		FW_MST_ID(FW_MST_TYPE_SYS, 42)
#define FW_MST_ID_USB1			FW_MST_ID(FW_MST_TYPE_SYS, 43)
#define FW_MST_ID_NPU_M0		FW_MST_ID(FW_MST_TYPE_SYS, 44)
#define FW_MST_ID_NPU_M0RO		FW_MST_ID(FW_MST_TYPE_SYS, 45)
#define FW_MST_ID_NPU_M1		FW_MST_ID(FW_MST_TYPE_SYS, 46)
#define FW_MST_ID_NPU_M1RO		FW_MST_ID(FW_MST_TYPE_SYS, 47)
#define FW_MST_ID_A53_0			FW_MST_ID(FW_MST_TYPE_SYS, 48)
#define FW_MST_ID_A53_1			FW_MST_ID(FW_MST_TYPE_SYS, 49)
#define FW_MST_ID_A53_2			FW_MST_ID(FW_MST_TYPE_SYS, 50)
#define FW_MST_ID_A53_3			FW_MST_ID(FW_MST_TYPE_SYS, 51)
#define FW_MST_ID_A72_0			FW_MST_ID(FW_MST_TYPE_SYS, 52)
#define FW_MST_ID_A72_1			FW_MST_ID(FW_MST_TYPE_SYS, 53)
#define FW_MST_ID_A72_2			FW_MST_ID(FW_MST_TYPE_SYS, 54)
#define FW_MST_ID_A72_3			FW_MST_ID(FW_MST_TYPE_SYS, 55)
#define FW_MST_ID_DAP_LITE		FW_MST_ID(FW_MST_TYPE_SYS, 56)
#define FW_MST_ID_VEPU1			FW_MST_ID(FW_MST_TYPE_SYS, 57)
#define FW_MST_ID_SYS_CNT		64

#define FW_MST_ID_PMU_MCU		FW_MST_ID(FW_MST_TYPE_PMU, 0)
#define FW_MST_ID_VDMA			FW_MST_ID(FW_MST_TYPE_PMU, 1)
#define FW_MST_ID_PMU_CNT		8

/* slave id */
#define FW_SLV_ID_CAN0			FW_SLV_ID(FW_SLV_TYPE_BUS, 0)
#define FW_SLV_ID_CAN1			FW_SLV_ID(FW_SLV_TYPE_BUS, 1)
#define FW_SLV_ID_I3C0			FW_SLV_ID(FW_SLV_TYPE_BUS, 2)
#define FW_SLV_ID_I3C1			FW_SLV_ID(FW_SLV_TYPE_BUS, 3)
#define FW_SLV_ID_BUS_IOC		FW_SLV_ID(FW_SLV_TYPE_BUS, 4)
#define FW_SLV_ID_COMBO_PIPE_PHY0	FW_SLV_ID(FW_SLV_TYPE_BUS, 5)
#define FW_SLV_ID_COMBO_PIPE_PHY1	FW_SLV_ID(FW_SLV_TYPE_BUS, 6)
#define FW_SLV_ID_CRU			FW_SLV_ID(FW_SLV_TYPE_BUS, 7)
#define FW_SLV_ID_DECOM			FW_SLV_ID(FW_SLV_TYPE_BUS, 8)
#define FW_SLV_ID_CRU_PVTPLL		FW_SLV_ID(FW_SLV_TYPE_BUS, 9)
#define FW_SLV_ID_I2C1			FW_SLV_ID(FW_SLV_TYPE_BUS, 13)
#define FW_SLV_ID_I2C2			FW_SLV_ID(FW_SLV_TYPE_BUS, 14)
#define FW_SLV_ID_I2C3			FW_SLV_ID(FW_SLV_TYPE_BUS, 15)
#define FW_SLV_ID_I2C4			FW_SLV_ID(FW_SLV_TYPE_BUS, 16)
#define FW_SLV_ID_I2C5			FW_SLV_ID(FW_SLV_TYPE_BUS, 17)
#define FW_SLV_ID_I2C6			FW_SLV_ID(FW_SLV_TYPE_BUS, 18)
#define FW_SLV_ID_I2C7			FW_SLV_ID(FW_SLV_TYPE_BUS, 19)
#define FW_SLV_ID_I2C8			FW_SLV_ID(FW_SLV_TYPE_BUS, 20)
#define FW_SLV_ID_I2C9			FW_SLV_ID(FW_SLV_TYPE_BUS, 21)
#define FW_SLV_ID_INTMUX2BUS		FW_SLV_ID(FW_SLV_TYPE_BUS, 22)
#define FW_SLV_ID_INTMUX2DDR		FW_SLV_ID(FW_SLV_TYPE_BUS, 23)
#define FW_SLV_ID_INTMUX2PMU		FW_SLV_ID(FW_SLV_TYPE_BUS, 24)
#define FW_SLV_ID_PPLL_CRU		FW_SLV_ID(FW_SLV_TYPE_BUS, 25)
#define FW_SLV_ID_COMBO_PIPE_PHY0_GRF	FW_SLV_ID(FW_SLV_TYPE_BUS, 26)
#define FW_SLV_ID_COMBO_PIPE_PHY1_GRF	FW_SLV_ID(FW_SLV_TYPE_BUS, 27)
#define FW_SLV_ID_PMU2			FW_SLV_ID(FW_SLV_TYPE_BUS, 28)
#define FW_SLV_ID_SARADC		FW_SLV_ID(FW_SLV_TYPE_BUS, 32)
#define FW_SLV_ID_SPI0			FW_SLV_ID(FW_SLV_TYPE_BUS, 33)
#define FW_SLV_ID_SPI1			FW_SLV_ID(FW_SLV_TYPE_BUS, 34)
#define FW_SLV_ID_SPI2			FW_SLV_ID(FW_SLV_TYPE_BUS, 35)
#define FW_SLV_ID_SPI3			FW_SLV_ID(FW_SLV_TYPE_BUS, 36)
#define FW_SLV_ID_SPI4			FW_SLV_ID(FW_SLV_TYPE_BUS, 37)
#define FW_SLV_ID_SYS_GRF		FW_SLV_ID(FW_SLV_TYPE_BUS, 38)
#define FW_SLV_ID_TSADC			FW_SLV_ID(FW_SLV_TYPE_BUS, 41)
#define FW_SLV_ID_UART0			FW_SLV_ID(FW_SLV_TYPE_BUS, 42)
#define FW_SLV_ID_UART10		FW_SLV_ID(FW_SLV_TYPE_BUS, 43)
#define FW_SLV_ID_UART11		FW_SLV_ID(FW_SLV_TYPE_BUS, 44)
#define FW_SLV_ID_UART2			FW_SLV_ID(FW_SLV_TYPE_BUS, 45)
#define FW_SLV_ID_UART3			FW_SLV_ID(FW_SLV_TYPE_BUS, 46)
#define FW_SLV_ID_UART4			FW_SLV_ID(FW_SLV_TYPE_BUS, 47)
#define FW_SLV_ID_UART5			FW_SLV_ID(FW_SLV_TYPE_BUS, 48)
#define FW_SLV_ID_UART6			FW_SLV_ID(FW_SLV_TYPE_BUS, 49)
#define FW_SLV_ID_UART7			FW_SLV_ID(FW_SLV_TYPE_BUS, 50)
#define FW_SLV_ID_UART8			FW_SLV_ID(FW_SLV_TYPE_BUS, 51)
#define FW_SLV_ID_UART9			FW_SLV_ID(FW_SLV_TYPE_BUS, 52)
#define FW_SLV_ID_VCCIO0_1_3_IOC	FW_SLV_ID(FW_SLV_TYPE_BUS, 53)
#define FW_SLV_ID_VCCIO2_4_5_IOC	FW_SLV_ID(FW_SLV_TYPE_BUS, 54)
#define FW_SLV_ID_BUS_WDT		FW_SLV_ID(FW_SLV_TYPE_BUS, 55)
#define FW_SLV_ID_WDT_NS		FW_SLV_ID(FW_SLV_TYPE_BUS, 56)
#define FW_SLV_ID_DMAC0_NS		FW_SLV_ID(FW_SLV_TYPE_BUS, 57)
#define FW_SLV_ID_DMAC1_NS		FW_SLV_ID(FW_SLV_TYPE_BUS, 58)
#define FW_SLV_ID_DMAC2_NS		FW_SLV_ID(FW_SLV_TYPE_BUS, 59)
#define FW_SLV_ID_DMAC0_S		FW_SLV_ID(FW_SLV_TYPE_BUS, 60)
#define FW_SLV_ID_DMAC1_S		FW_SLV_ID(FW_SLV_TYPE_BUS, 61)
#define FW_SLV_ID_DMAC2_S		FW_SLV_ID(FW_SLV_TYPE_BUS, 62)
#define FW_SLV_ID_GIC400		FW_SLV_ID(FW_SLV_TYPE_BUS, 63)
#define FW_SLV_ID_SERVICE_BUS		FW_SLV_ID(FW_SLV_TYPE_BUS, 64)
#define FW_SLV_ID_SPINLOCK		FW_SLV_ID(FW_SLV_TYPE_BUS, 65)
#define FW_SLV_ID_MAILBOX_CH0		FW_SLV_ID(FW_SLV_TYPE_BUS, 66)
#define FW_SLV_ID_MAILBOX_CH1		FW_SLV_ID(FW_SLV_TYPE_BUS, 67)
#define FW_SLV_ID_MAILBOX_CH2		FW_SLV_ID(FW_SLV_TYPE_BUS, 68)
#define FW_SLV_ID_MAILBOX_CH3		FW_SLV_ID(FW_SLV_TYPE_BUS, 69)
#define FW_SLV_ID_MAILBOX_CH4		FW_SLV_ID(FW_SLV_TYPE_BUS, 70)
#define FW_SLV_ID_MAILBOX_CH5		FW_SLV_ID(FW_SLV_TYPE_BUS, 71)
#define FW_SLV_ID_MAILBOX_CH6		FW_SLV_ID(FW_SLV_TYPE_BUS, 72)
#define FW_SLV_ID_MAILBOX_CH7		FW_SLV_ID(FW_SLV_TYPE_BUS, 73)
#define FW_SLV_ID_MAILBOX_CH8		FW_SLV_ID(FW_SLV_TYPE_BUS, 74)
#define FW_SLV_ID_MAILBOX_CH9		FW_SLV_ID(FW_SLV_TYPE_BUS, 75)
#define FW_SLV_ID_MAILBOX_CH10		FW_SLV_ID(FW_SLV_TYPE_BUS, 76)
#define FW_SLV_ID_MAILBOX_CH11		FW_SLV_ID(FW_SLV_TYPE_BUS, 77)
#define FW_SLV_ID_MAILBOX_CH12		FW_SLV_ID(FW_SLV_TYPE_BUS, 78)
#define FW_SLV_ID_MAILBOX_CH13		FW_SLV_ID(FW_SLV_TYPE_BUS, 79)
#define FW_SLV_ID_PWM1_CH0		FW_SLV_ID(FW_SLV_TYPE_BUS, 82)
#define FW_SLV_ID_PWM1_CH1		FW_SLV_ID(FW_SLV_TYPE_BUS, 83)
#define FW_SLV_ID_PWM1_CH2		FW_SLV_ID(FW_SLV_TYPE_BUS, 84)
#define FW_SLV_ID_PWM1_CH3		FW_SLV_ID(FW_SLV_TYPE_BUS, 85)
#define FW_SLV_ID_PWM1_CH4		FW_SLV_ID(FW_SLV_TYPE_BUS, 86)
#define FW_SLV_ID_PWM1_CH5		FW_SLV_ID(FW_SLV_TYPE_BUS, 87)
#define FW_SLV_ID_PWM2_CH0		FW_SLV_ID(FW_SLV_TYPE_BUS, 88)
#define FW_SLV_ID_PWM2_CH1		FW_SLV_ID(FW_SLV_TYPE_BUS, 89)
#define FW_SLV_ID_PWM2_CH2		FW_SLV_ID(FW_SLV_TYPE_BUS, 90)
#define FW_SLV_ID_PWM2_CH3		FW_SLV_ID(FW_SLV_TYPE_BUS, 91)
#define FW_SLV_ID_PWM2_CH4		FW_SLV_ID(FW_SLV_TYPE_BUS, 92)
#define FW_SLV_ID_PWM2_CH5		FW_SLV_ID(FW_SLV_TYPE_BUS, 93)
#define FW_SLV_ID_PWM2_CH6		FW_SLV_ID(FW_SLV_TYPE_BUS, 94)
#define FW_SLV_ID_PWM2_CH7		FW_SLV_ID(FW_SLV_TYPE_BUS, 95)
#define FW_SLV_ID_TIMER_NS_0_CH0	FW_SLV_ID(FW_SLV_TYPE_BUS, 96)
#define FW_SLV_ID_TIMER_NS_0_CH1	FW_SLV_ID(FW_SLV_TYPE_BUS, 97)
#define FW_SLV_ID_TIMER_NS_0_CH2	FW_SLV_ID(FW_SLV_TYPE_BUS, 98)
#define FW_SLV_ID_TIMER_NS_0_CH3	FW_SLV_ID(FW_SLV_TYPE_BUS, 99)
#define FW_SLV_ID_TIMER_NS_0_CH4	FW_SLV_ID(FW_SLV_TYPE_BUS, 100)
#define FW_SLV_ID_TIMER_NS_0_CH5	FW_SLV_ID(FW_SLV_TYPE_BUS, 101)
#define FW_SLV_ID_TIMER_NS_1_CH0	FW_SLV_ID(FW_SLV_TYPE_BUS, 102)
#define FW_SLV_ID_TIMER_NS_1_CH1	FW_SLV_ID(FW_SLV_TYPE_BUS, 103)
#define FW_SLV_ID_TIMER_NS_1_CH2	FW_SLV_ID(FW_SLV_TYPE_BUS, 104)
#define FW_SLV_ID_TIMER_NS_1_CH3	FW_SLV_ID(FW_SLV_TYPE_BUS, 105)
#define FW_SLV_ID_TIMER_NS_1_CH4	FW_SLV_ID(FW_SLV_TYPE_BUS, 106)
#define FW_SLV_ID_TIMER_NS_1_CH5	FW_SLV_ID(FW_SLV_TYPE_BUS, 107)
#define FW_SLV_ID_GPIO1_CH0		FW_SLV_ID(FW_SLV_TYPE_BUS, 108)
#define FW_SLV_ID_GPIO1_CH1		FW_SLV_ID(FW_SLV_TYPE_BUS, 109)
#define FW_SLV_ID_GPIO1_CH2		FW_SLV_ID(FW_SLV_TYPE_BUS, 110)
#define FW_SLV_ID_GPIO1_CH3		FW_SLV_ID(FW_SLV_TYPE_BUS, 111)
#define FW_SLV_ID_GPIO2_CH0		FW_SLV_ID(FW_SLV_TYPE_BUS, 112)
#define FW_SLV_ID_GPIO2_CH1		FW_SLV_ID(FW_SLV_TYPE_BUS, 113)
#define FW_SLV_ID_GPIO2_CH2		FW_SLV_ID(FW_SLV_TYPE_BUS, 114)
#define FW_SLV_ID_GPIO2_CH3		FW_SLV_ID(FW_SLV_TYPE_BUS, 115)
#define FW_SLV_ID_GPIO3_CH0		FW_SLV_ID(FW_SLV_TYPE_BUS, 116)
#define FW_SLV_ID_GPIO3_CH1		FW_SLV_ID(FW_SLV_TYPE_BUS, 117)
#define FW_SLV_ID_GPIO3_CH2		FW_SLV_ID(FW_SLV_TYPE_BUS, 118)
#define FW_SLV_ID_GPIO3_CH3		FW_SLV_ID(FW_SLV_TYPE_BUS, 119)
#define FW_SLV_ID_GPIO4_CH0		FW_SLV_ID(FW_SLV_TYPE_BUS, 120)
#define FW_SLV_ID_GPIO4_CH1		FW_SLV_ID(FW_SLV_TYPE_BUS, 121)
#define FW_SLV_ID_GPIO4_CH2		FW_SLV_ID(FW_SLV_TYPE_BUS, 122)
#define FW_SLV_ID_GPIO4_CH3		FW_SLV_ID(FW_SLV_TYPE_BUS, 123)
#define FW_SLV_ID_BUS_CNT		125

#define FW_SLV_ID_ACDCDIG_DSM		FW_SLV_ID(FW_SLV_TYPE_TOP, 0)
#define FW_SLV_ID_ASRC2CH_0		FW_SLV_ID(FW_SLV_TYPE_TOP, 1)
#define FW_SLV_ID_ASRC2CH_1		FW_SLV_ID(FW_SLV_TYPE_TOP, 2)
#define FW_SLV_ID_ASRC4CH_0		FW_SLV_ID(FW_SLV_TYPE_TOP, 3)
#define FW_SLV_ID_ASRC4CH_1		FW_SLV_ID(FW_SLV_TYPE_TOP, 4)
#define FW_SLV_ID_PDM1			FW_SLV_ID(FW_SLV_TYPE_TOP, 5)
#define FW_SLV_ID_SAI0_8CH		FW_SLV_ID(FW_SLV_TYPE_TOP, 6)
#define FW_SLV_ID_SAI1_8CH		FW_SLV_ID(FW_SLV_TYPE_TOP, 7)
#define FW_SLV_ID_SAI2_8CH		FW_SLV_ID(FW_SLV_TYPE_TOP, 8)
#define FW_SLV_ID_SAI3_2CH		FW_SLV_ID(FW_SLV_TYPE_TOP, 9)
#define FW_SLV_ID_SAI4_2CH		FW_SLV_ID(FW_SLV_TYPE_TOP, 10)
#define FW_SLV_ID_SPDIF_RX0		FW_SLV_ID(FW_SLV_TYPE_TOP, 11)
#define FW_SLV_ID_SPDIF_RX1		FW_SLV_ID(FW_SLV_TYPE_TOP, 12)
#define FW_SLV_ID_SPDIF_TX0		FW_SLV_ID(FW_SLV_TYPE_TOP, 13)
#define FW_SLV_ID_SPDIF_TX1		FW_SLV_ID(FW_SLV_TYPE_TOP, 14)
#define FW_SLV_ID_DSMC_MEM		FW_SLV_ID(FW_SLV_TYPE_TOP, 15)
#define FW_SLV_ID_FSPI1			FW_SLV_ID(FW_SLV_TYPE_TOP, 16)
#define FW_SLV_ID_FLEXBUS		FW_SLV_ID(FW_SLV_TYPE_TOP, 17)
#define FW_SLV_ID_SDIO			FW_SLV_ID(FW_SLV_TYPE_TOP, 18)
#define FW_SLV_ID_SDMMC			FW_SLV_ID(FW_SLV_TYPE_TOP, 19)
#define FW_SLV_ID_DSMC_CFG		FW_SLV_ID(FW_SLV_TYPE_TOP, 20)
#define FW_SLV_ID_GMAC0			FW_SLV_ID(FW_SLV_TYPE_TOP, 21)
#define FW_SLV_ID_GMAC1			FW_SLV_ID(FW_SLV_TYPE_TOP, 22)
#define FW_SLV_ID_SDGMAC_GRF		FW_SLV_ID(FW_SLV_TYPE_TOP, 23)
#define FW_SLV_ID_EMMC			FW_SLV_ID(FW_SLV_TYPE_TOP, 24)
#define FW_SLV_ID_FSPI0			FW_SLV_ID(FW_SLV_TYPE_TOP, 25)
#define FW_SLV_ID_NSCRYPTO		FW_SLV_ID(FW_SLV_TYPE_TOP, 26)
#define FW_SLV_ID_RKRNG_NS		FW_SLV_ID(FW_SLV_TYPE_TOP, 27)
#define FW_SLV_ID_SCRYPTO		FW_SLV_ID(FW_SLV_TYPE_TOP, 28)
#define FW_SLV_ID_KEYLAD		FW_SLV_ID(FW_SLV_TYPE_TOP, 29)
#define FW_SLV_ID_RKRNG_S		FW_SLV_ID(FW_SLV_TYPE_TOP, 30)
#define FW_SLV_ID_OTPC_NS		FW_SLV_ID(FW_SLV_TYPE_TOP, 31)
#define FW_SLV_ID_JTAG_LOCK		FW_SLV_ID(FW_SLV_TYPE_TOP, 33)
#define FW_SLV_ID_OTPC_S		FW_SLV_ID(FW_SLV_TYPE_TOP, 34)
#define FW_SLV_ID_OTPMASK		FW_SLV_ID(FW_SLV_TYPE_TOP, 35)
#define FW_SLV_ID_SECURE_CRU		FW_SLV_ID(FW_SLV_TYPE_TOP, 36)
#define FW_SLV_ID_SECURE_CRU_S		FW_SLV_ID(FW_SLV_TYPE_TOP, 37)
#define FW_SLV_ID_SYS_SGRF		FW_SLV_ID(FW_SLV_TYPE_TOP, 38)
#define FW_SLV_ID_BOOTROM		FW_SLV_ID(FW_SLV_TYPE_TOP, 39)
#define FW_SLV_ID_WDT_S			FW_SLV_ID(FW_SLV_TYPE_TOP, 41)
#define FW_SLV_ID_SERVICE_GMAC		FW_SLV_ID(FW_SLV_TYPE_TOP, 42)
#define FW_SLV_ID_SERVICE_NVM		FW_SLV_ID(FW_SLV_TYPE_TOP, 43)
#define FW_SLV_ID_SERVICE_SECURE	FW_SLV_ID(FW_SLV_TYPE_TOP, 44)
#define FW_SLV_ID_SERVICE_VENC		FW_SLV_ID(FW_SLV_TYPE_TOP, 45)
#define FW_SLV_ID_SERVICE_VI		FW_SLV_ID(FW_SLV_TYPE_TOP, 46)
#define FW_SLV_ID_SERVICE_VPU		FW_SLV_ID(FW_SLV_TYPE_TOP, 47)
#define FW_SLV_ID_VEPU0			FW_SLV_ID(FW_SLV_TYPE_TOP, 48)
#define FW_SLV_ID_ISP			FW_SLV_ID(FW_SLV_TYPE_TOP, 49)
#define FW_SLV_ID_VICAP			FW_SLV_ID(FW_SLV_TYPE_TOP, 50)
#define FW_SLV_ID_VPSS			FW_SLV_ID(FW_SLV_TYPE_TOP, 51)
#define FW_SLV_ID_CSIHOST0		FW_SLV_ID(FW_SLV_TYPE_TOP, 52)
#define FW_SLV_ID_CSIHOST1		FW_SLV_ID(FW_SLV_TYPE_TOP, 53)
#define FW_SLV_ID_CSIHOST2		FW_SLV_ID(FW_SLV_TYPE_TOP, 54)
#define FW_SLV_ID_VI_GRF		FW_SLV_ID(FW_SLV_TYPE_TOP, 55)
#define FW_SLV_ID_EBC			FW_SLV_ID(FW_SLV_TYPE_TOP, 56)
#define FW_SLV_ID_JPEG			FW_SLV_ID(FW_SLV_TYPE_TOP, 57)
#define FW_SLV_ID_RGA0			FW_SLV_ID(FW_SLV_TYPE_TOP, 58)
#define FW_SLV_ID_RGA1			FW_SLV_ID(FW_SLV_TYPE_TOP, 59)
#define FW_SLV_ID_VDPP			FW_SLV_ID(FW_SLV_TYPE_TOP, 60)
#define FW_SLV_ID_TIMER_S_0_CH0		FW_SLV_ID(FW_SLV_TYPE_TOP, 61)
#define FW_SLV_ID_TIMER_S_0_CH1		FW_SLV_ID(FW_SLV_TYPE_TOP, 62)
#define FW_SLV_ID_TIMER_S_0_CH2		FW_SLV_ID(FW_SLV_TYPE_TOP, 63)
#define FW_SLV_ID_TIMER_S_0_CH3		FW_SLV_ID(FW_SLV_TYPE_TOP, 64)
#define FW_SLV_ID_TIMER_S_0_CH4		FW_SLV_ID(FW_SLV_TYPE_TOP, 65)
#define FW_SLV_ID_TIMER_S_0_CH5		FW_SLV_ID(FW_SLV_TYPE_TOP, 66)
#define FW_SLV_ID_TIMER_S_1_CH0		FW_SLV_ID(FW_SLV_TYPE_TOP, 67)
#define FW_SLV_ID_TIMER_S_1_CH1		FW_SLV_ID(FW_SLV_TYPE_TOP, 68)
#define FW_SLV_ID_TIMER_S_1_CH2		FW_SLV_ID(FW_SLV_TYPE_TOP, 69)
#define FW_SLV_ID_TIMER_S_1_CH3		FW_SLV_ID(FW_SLV_TYPE_TOP, 70)
#define FW_SLV_ID_TIMER_S_1_CH4		FW_SLV_ID(FW_SLV_TYPE_TOP, 71)
#define FW_SLV_ID_TIMER_S_1_CH5		FW_SLV_ID(FW_SLV_TYPE_TOP, 72)
#define FW_SLV_ID_SYS_FW		FW_SLV_ID(FW_SLV_TYPE_TOP, 73)
#define FW_SLV_ID_VEPU1			FW_SLV_ID(FW_SLV_TYPE_TOP, 75)
#define FW_SLV_ID_SERVICE_VEPU1		FW_SLV_ID(FW_SLV_TYPE_TOP, 76)
#define FW_SLV_ID_CSIHOST3		FW_SLV_ID(FW_SLV_TYPE_TOP, 77)
#define FW_SLV_ID_CSIHOST4		FW_SLV_ID(FW_SLV_TYPE_TOP, 78)
#define FW_SLV_ID_TOP_CNT		80

#define FW_SLV_ID_CENTER_GRF		FW_SLV_ID(FW_SLV_TYPE_CENTER, 0)
#define FW_SLV_ID_DMA2DDR		FW_SLV_ID(FW_SLV_TYPE_CENTER, 1)
#define FW_SLV_ID_AHB2APB		FW_SLV_ID(FW_SLV_TYPE_CENTER, 2)
#define FW_SLV_ID_DDR_GRF		FW_SLV_ID(FW_SLV_TYPE_CENTER, 3)
#define FW_SLV_ID_DDRCTL0		FW_SLV_ID(FW_SLV_TYPE_CENTER, 4)
#define FW_SLV_ID_DDRCTL_1		FW_SLV_ID(FW_SLV_TYPE_CENTER, 5)
#define FW_SLV_ID_DDRPHY0		FW_SLV_ID(FW_SLV_TYPE_CENTER, 6)
#define FW_SLV_ID_DDR0_CRU		FW_SLV_ID(FW_SLV_TYPE_CENTER, 7)
#define FW_SLV_ID_DDRPHY1		FW_SLV_ID(FW_SLV_TYPE_CENTER, 8)
#define FW_SLV_ID_DDR1_CRU		FW_SLV_ID(FW_SLV_TYPE_CENTER, 9)
#define FW_SLV_ID_DDRMON0		FW_SLV_ID(FW_SLV_TYPE_CENTER, 10)
#define FW_SLV_ID_DDRMON1		FW_SLV_ID(FW_SLV_TYPE_CENTER, 11)
#define FW_SLV_ID_HWLP0			FW_SLV_ID(FW_SLV_TYPE_CENTER, 12)
#define FW_SLV_ID_HWLP1			FW_SLV_ID(FW_SLV_TYPE_CENTER, 13)
#define FW_SLV_ID_DDR_PVTPLL		FW_SLV_ID(FW_SLV_TYPE_CENTER, 14)
#define FW_SLV_ID_DDR_WDT		FW_SLV_ID(FW_SLV_TYPE_CENTER, 15)
#define FW_SLV_ID_RKVDEC		FW_SLV_ID(FW_SLV_TYPE_CENTER, 16)
#define FW_SLV_ID_SERVICE_CCI2		FW_SLV_ID(FW_SLV_TYPE_CENTER, 17)
#define FW_SLV_ID_SERVICE_CENTER	FW_SLV_ID(FW_SLV_TYPE_CENTER, 18)
#define FW_SLV_ID_SERVICE_DDR		FW_SLV_ID(FW_SLV_TYPE_CENTER, 19)
#define FW_SLV_ID_SERVICE_RKVDEC	FW_SLV_ID(FW_SLV_TYPE_CENTER, 20)
#define FW_SLV_ID_SERVICE_USB		FW_SLV_ID(FW_SLV_TYPE_CENTER, 21)
#define FW_SLV_ID_SERVICE_VO0		FW_SLV_ID(FW_SLV_TYPE_CENTER, 22)
#define FW_SLV_ID_SERVICE_VO1		FW_SLV_ID(FW_SLV_TYPE_CENTER, 23)
#define FW_SLV_ID_SERVICE_VOP		FW_SLV_ID(FW_SLV_TYPE_CENTER, 24)
#define FW_SLV_ID_UFS_APBS		FW_SLV_ID(FW_SLV_TYPE_CENTER, 25)
#define FW_SLV_ID_UFS_AXIS		FW_SLV_ID(FW_SLV_TYPE_CENTER, 26)
#define FW_SLV_ID_USB0			FW_SLV_ID(FW_SLV_TYPE_CENTER, 27)
#define FW_SLV_ID_MMU2			FW_SLV_ID(FW_SLV_TYPE_CENTER, 28)
#define FW_SLV_ID_USB_GRF		FW_SLV_ID(FW_SLV_TYPE_CENTER, 29)
#define FW_SLV_ID_HDCP0_MMU		FW_SLV_ID(FW_SLV_TYPE_CENTER, 30)
#define FW_SLV_ID_SAI5_8CH		FW_SLV_ID(FW_SLV_TYPE_CENTER, 31)
#define FW_SLV_ID_SAI6_8CH		FW_SLV_ID(FW_SLV_TYPE_CENTER, 32)
#define FW_SLV_ID_SPDIF_RX2		FW_SLV_ID(FW_SLV_TYPE_CENTER, 33)
#define FW_SLV_ID_SPDIF_TX2		FW_SLV_ID(FW_SLV_TYPE_CENTER, 34)
#define FW_SLV_ID_HDCP0_KEY		FW_SLV_ID(FW_SLV_TYPE_CENTER, 35)
#define FW_SLV_ID_DSIHOST		FW_SLV_ID(FW_SLV_TYPE_CENTER, 36)
#define FW_SLV_ID_EDP0			FW_SLV_ID(FW_SLV_TYPE_CENTER, 37)
#define FW_SLV_ID_HDCP0			FW_SLV_ID(FW_SLV_TYPE_CENTER, 38)
#define FW_SLV_ID_HDCP0_TRNG		FW_SLV_ID(FW_SLV_TYPE_CENTER, 39)
#define FW_SLV_ID_HDMITX		FW_SLV_ID(FW_SLV_TYPE_CENTER, 40)
#define FW_SLV_ID_VO0_GRF		FW_SLV_ID(FW_SLV_TYPE_CENTER, 41)
#define FW_SLV_ID_EDP0_S		FW_SLV_ID(FW_SLV_TYPE_CENTER, 42)
#define FW_SLV_ID_HDCP1_MMU		FW_SLV_ID(FW_SLV_TYPE_CENTER, 43)
#define FW_SLV_ID_SAI7_8CH		FW_SLV_ID(FW_SLV_TYPE_CENTER, 44)
#define FW_SLV_ID_SPDIF_TX3		FW_SLV_ID(FW_SLV_TYPE_CENTER, 45)
#define FW_SLV_ID_HDCP1_KEY		FW_SLV_ID(FW_SLV_TYPE_CENTER, 46)
#define FW_SLV_ID_DP			FW_SLV_ID(FW_SLV_TYPE_CENTER, 47)
#define FW_SLV_ID_HDCP1			FW_SLV_ID(FW_SLV_TYPE_CENTER, 48)
#define FW_SLV_ID_HDCP1_TRNG		FW_SLV_ID(FW_SLV_TYPE_CENTER, 49)
#define FW_SLV_ID_VO1_GRF		FW_SLV_ID(FW_SLV_TYPE_CENTER, 50)
#define FW_SLV_ID_VOP_GRF		FW_SLV_ID(FW_SLV_TYPE_CENTER, 52)
#define FW_SLV_ID_UFS_GRF		FW_SLV_ID(FW_SLV_TYPE_CENTER, 53)
#define FW_SLV_ID_SPDIF_TX4		FW_SLV_ID(FW_SLV_TYPE_CENTER, 54)
#define FW_SLV_ID_SPDIF_TX5		FW_SLV_ID(FW_SLV_TYPE_CENTER, 55)
#define FW_SLV_ID_SAI8_8CH		FW_SLV_ID(FW_SLV_TYPE_CENTER, 56)
#define FW_SLV_ID_SAI9_8CH		FW_SLV_ID(FW_SLV_TYPE_CENTER, 57)
#define FW_SLV_ID_DDR_TIMER_CH0		FW_SLV_ID(FW_SLV_TYPE_CENTER, 58)
#define FW_SLV_ID_DDR_TIMER_CH1		FW_SLV_ID(FW_SLV_TYPE_CENTER, 59)
#define FW_SLV_ID_VOP_RGN0		FW_SLV_ID(FW_SLV_TYPE_CENTER, 60)
#define FW_SLV_ID_VOP_RGN1		FW_SLV_ID(FW_SLV_TYPE_CENTER, 61)
#define FW_SLV_ID_VOP_RGN2		FW_SLV_ID(FW_SLV_TYPE_CENTER, 62)
#define FW_SLV_ID_VOP_RGN3		FW_SLV_ID(FW_SLV_TYPE_CENTER, 63)
#define FW_SLV_ID_VOP_OTHERS		FW_SLV_ID(FW_SLV_TYPE_CENTER, 64)
#define FW_SLV_ID_CENTER_CNT		65

#define FW_SLV_ID_BIGCORE_CRU		FW_SLV_ID(FW_SLV_TYPE_CCI, 0)
#define FW_SLV_ID_BIGCORE_GRF		FW_SLV_ID(FW_SLV_TYPE_CCI, 1)
#define FW_SLV_ID_CCI			FW_SLV_ID(FW_SLV_TYPE_CCI, 2)
#define FW_SLV_ID_CCI_CRU		FW_SLV_ID(FW_SLV_TYPE_CCI, 3)
#define FW_SLV_ID_CCI_PVTPLL		FW_SLV_ID(FW_SLV_TYPE_CCI, 4)
#define FW_SLV_ID_CCI_GRF		FW_SLV_ID(FW_SLV_TYPE_CCI, 5)
#define FW_SLV_ID_DAP_LITE_A53		FW_SLV_ID(FW_SLV_TYPE_CCI, 6)
#define FW_SLV_ID_DAP_LITE_A72		FW_SLV_ID(FW_SLV_TYPE_CCI, 7)
#define FW_SLV_ID_LITCORE_GRF		FW_SLV_ID(FW_SLV_TYPE_CCI, 8)
#define FW_SLV_ID_LITCORE_CRU		FW_SLV_ID(FW_SLV_TYPE_CCI, 9)
#define FW_SLV_ID_SERVICE_CCI		FW_SLV_ID(FW_SLV_TYPE_CCI, 10)
#define FW_SLV_ID_BIGCORE_PVTPLL	FW_SLV_ID(FW_SLV_TYPE_CCI, 11)
#define FW_SLV_ID_LITCORE_PVTPLL	FW_SLV_ID(FW_SLV_TYPE_CCI, 12)
#define FW_SLV_ID_CCI_CNT		15

#define FW_SLV_ID_PCIE0_DBI		FW_SLV_ID(FW_SLV_TYPE_PHP, 0)
#define FW_SLV_ID_PCIE0_DBI_L		FW_SLV_ID(FW_SLV_TYPE_PHP, 1)
#define FW_SLV_ID_PCIE0_S		FW_SLV_ID(FW_SLV_TYPE_PHP, 2)
#define FW_SLV_ID_PCIE0_S_L		FW_SLV_ID(FW_SLV_TYPE_PHP, 3)
#define FW_SLV_ID_PCIE1_DBI		FW_SLV_ID(FW_SLV_TYPE_PHP, 4)
#define FW_SLV_ID_PCIE1_DBI_L		FW_SLV_ID(FW_SLV_TYPE_PHP, 5)
#define FW_SLV_ID_PCIE1_S		FW_SLV_ID(FW_SLV_TYPE_PHP, 6)
#define FW_SLV_ID_PCIE1_S_L		FW_SLV_ID(FW_SLV_TYPE_PHP, 7)
#define FW_SLV_ID_USB1			FW_SLV_ID(FW_SLV_TYPE_PHP, 8)
#define FW_SLV_ID_PCIE0_APB		FW_SLV_ID(FW_SLV_TYPE_PHP, 9)
#define FW_SLV_ID_PCIE1_APB		FW_SLV_ID(FW_SLV_TYPE_PHP, 10)
#define FW_SLV_ID_PHP_GRF		FW_SLV_ID(FW_SLV_TYPE_PHP, 11)
#define FW_SLV_ID_SATA0			FW_SLV_ID(FW_SLV_TYPE_PHP, 12)
#define FW_SLV_ID_SATA1			FW_SLV_ID(FW_SLV_TYPE_PHP, 13)
#define FW_SLV_ID_SERVICE_PHP		FW_SLV_ID(FW_SLV_TYPE_PHP, 14)
#define FW_SLV_ID_MMU0			FW_SLV_ID(FW_SLV_TYPE_PHP, 15)
#define FW_SLV_ID_MMU1			FW_SLV_ID(FW_SLV_TYPE_PHP, 16)
#define FW_SLV_ID_PHP_CNT		20

#define FW_SLV_ID_GPU_GRF		FW_SLV_ID(FW_SLV_TYPE_GPU, 0)
#define FW_SLV_ID_GPU			FW_SLV_ID(FW_SLV_TYPE_GPU, 1)
#define FW_SLV_ID_SERVICE_GPU		FW_SLV_ID(FW_SLV_TYPE_GPU, 2)
#define FW_SLV_ID_GPU_PVTPLL		FW_SLV_ID(FW_SLV_TYPE_GPU, 3)
#define FW_SLV_ID_GPU_CNT		5

#define FW_SLV_ID_RKNN_TOP		FW_SLV_ID(FW_SLV_TYPE_NPU, 0)
#define FW_SLV_ID_SERVICE_NPU0		FW_SLV_ID(FW_SLV_TYPE_NPU, 1)
#define FW_SLV_ID_SERVICE_NPU1		FW_SLV_ID(FW_SLV_TYPE_NPU, 2)
#define FW_SLV_ID_SERVICE_NPUSUBSYS	FW_SLV_ID(FW_SLV_TYPE_NPU, 3)
#define FW_SLV_ID_RKNN_NSP		FW_SLV_ID(FW_SLV_TYPE_NPU, 4)
#define FW_SLV_ID_NPU_GRF		FW_SLV_ID(FW_SLV_TYPE_NPU, 5)
#define FW_SLV_ID_NPU_PVTPLL		FW_SLV_ID(FW_SLV_TYPE_NPU, 6)
#define FW_SLV_ID_NPU_WDT		FW_SLV_ID(FW_SLV_TYPE_NPU, 7)
#define FW_SLV_ID_NPU_TIMER_CH0		FW_SLV_ID(FW_SLV_TYPE_NPU, 8)
#define FW_SLV_ID_NPU_TIMER_CH1		FW_SLV_ID(FW_SLV_TYPE_NPU, 9)
#define FW_SLV_ID_NPU_CNT		10

#define FW_SLV_ID_PDM0			FW_SLV_ID(FW_SLV_TYPE_PMU, 0)
#define FW_SLV_ID_PMU_MEM		FW_SLV_ID(FW_SLV_TYPE_PMU, 1)
#define FW_SLV_ID_CSIDPHY_GRF		FW_SLV_ID(FW_SLV_TYPE_PMU, 2)
#define FW_SLV_ID_VDMA			FW_SLV_ID(FW_SLV_TYPE_PMU, 3)
#define FW_SLV_ID_HDPTXPHY		FW_SLV_ID(FW_SLV_TYPE_PMU, 4)
#define FW_SLV_ID_HDPTXPHY0_GRF		FW_SLV_ID(FW_SLV_TYPE_PMU, 5)
#define FW_SLV_ID_I2C0			FW_SLV_ID(FW_SLV_TYPE_PMU, 6)
#define FW_SLV_ID_DCPHY			FW_SLV_ID(FW_SLV_TYPE_PMU, 7)
#define FW_SLV_ID_CSIDPHY0		FW_SLV_ID(FW_SLV_TYPE_PMU, 8)
#define FW_SLV_ID_DCPHY_GRF		FW_SLV_ID(FW_SLV_TYPE_PMU, 9)
#define FW_SLV_ID_PMU0			FW_SLV_ID(FW_SLV_TYPE_PMU, 10)
#define FW_SLV_ID_PMU0_GRF		FW_SLV_ID(FW_SLV_TYPE_PMU, 11)
#define FW_SLV_ID_PMU0_IOC		FW_SLV_ID(FW_SLV_TYPE_PMU, 12)
#define FW_SLV_ID_PMU1			FW_SLV_ID(FW_SLV_TYPE_PMU, 13)
#define FW_SLV_ID_PMU1_CRU		FW_SLV_ID(FW_SLV_TYPE_PMU, 14)
#define FW_SLV_ID_PMU1_CRU_S		FW_SLV_ID(FW_SLV_TYPE_PMU, 15)
#define FW_SLV_ID_PMU1_GRF		FW_SLV_ID(FW_SLV_TYPE_PMU, 16)
#define FW_SLV_ID_PMU1_IOC		FW_SLV_ID(FW_SLV_TYPE_PMU, 17)
#define FW_SLV_ID_PWM0_CH0		FW_SLV_ID(FW_SLV_TYPE_PMU, 18)
#define FW_SLV_ID_PWM0_CH1		FW_SLV_ID(FW_SLV_TYPE_PMU, 19)
#define FW_SLV_ID_UART1			FW_SLV_ID(FW_SLV_TYPE_PMU, 20)
#define FW_SLV_ID_MPHY_GRF		FW_SLV_ID(FW_SLV_TYPE_PMU, 21)
#define FW_SLV_ID_MPHY			FW_SLV_ID(FW_SLV_TYPE_PMU, 22)
#define FW_SLV_ID_USB2PHY0_GRF		FW_SLV_ID(FW_SLV_TYPE_PMU, 23)
#define FW_SLV_ID_USB2PHY1_GRF		FW_SLV_ID(FW_SLV_TYPE_PMU, 24)
#define FW_SLV_ID_USBDPPHY		FW_SLV_ID(FW_SLV_TYPE_PMU, 25)
#define FW_SLV_ID_USBDPPHY_GRF		FW_SLV_ID(FW_SLV_TYPE_PMU, 26)
#define FW_SLV_ID_VCCIO6_IOC		FW_SLV_ID(FW_SLV_TYPE_PMU, 27)
#define FW_SLV_ID_PMU_WDT		FW_SLV_ID(FW_SLV_TYPE_PMU, 28)
#define FW_SLV_ID_HPTIMER		FW_SLV_ID(FW_SLV_TYPE_PMU, 29)
#define FW_SLV_ID_OSC_CHK		FW_SLV_ID(FW_SLV_TYPE_PMU, 30)
#define FW_SLV_ID_PMU0_SGRF		FW_SLV_ID(FW_SLV_TYPE_PMU, 31)
#define FW_SLV_ID_PMU1_SGRF		FW_SLV_ID(FW_SLV_TYPE_PMU, 32)
#define FW_SLV_ID_PMU_PVTM		FW_SLV_ID(FW_SLV_TYPE_PMU, 33)
#define FW_SLV_ID_SCRAMBLE_KEY		FW_SLV_ID(FW_SLV_TYPE_PMU, 34)
#define FW_SLV_ID_SERVICE_PMU		FW_SLV_ID(FW_SLV_TYPE_PMU, 35)
#define FW_SLV_ID_PMU_SRAM_REMAP	FW_SLV_ID(FW_SLV_TYPE_PMU, 36)
#define FW_SLV_ID_PMU_TIMER_CH0		FW_SLV_ID(FW_SLV_TYPE_PMU, 37)
#define FW_SLV_ID_PMU_TIMER_CH1		FW_SLV_ID(FW_SLV_TYPE_PMU, 38)
#define FW_SLV_ID_GPIO0_CH0		FW_SLV_ID(FW_SLV_TYPE_PMU, 39)
#define FW_SLV_ID_GPIO0_CH1		FW_SLV_ID(FW_SLV_TYPE_PMU, 40)
#define FW_SLV_ID_GPIO0_CH2		FW_SLV_ID(FW_SLV_TYPE_PMU, 41)
#define FW_SLV_ID_GPIO0_CH3		FW_SLV_ID(FW_SLV_TYPE_PMU, 42)
#define FW_SLV_ID_PMU_FW		FW_SLV_ID(FW_SLV_TYPE_PMU, 43)
#define FW_SLV_ID_PMU_CNT		45

#define PLAT_MAX_DDR_CAPACITY_MB	0x8000	/* for 32Gb */
#define RG_MAP_SECURE(top, base)	\
	(((((top) - 1) & 0x7fff) << 16) | ((base) & 0x7fff))
#define RG_MAP_SRAM_SECURE(top_kb, base_kb)	\
	(((((top_kb) / 4 - 1) & 0xff) << 8) | ((base_kb) / 4 & 0xff))
#define RG_MAP_CBUF_SECURE(top_kb, base_kb)	\
	(((((top_kb) / 4 - 1) & 0xff) << 8) | ((base_kb) / 4 & 0xff))

#define FW_UPDATE_WAIT_LOOP		500000

__pmusramfunc void pmusram_fw_update_msk(uint32_t msk);
__pmusramfunc void pmusram_all_fw_bypass(void);

void fw_init(void);

#endif /* __FIREWALL_H__ */
