// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/videointelligence/v1p1beta1/video_intelligence.proto

package videointelligence

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	duration "github.com/golang/protobuf/ptypes/duration"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	status "google.golang.org/genproto/googleapis/rpc/status"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Video annotation feature.
type Feature int32

const (
	// Unspecified.
	Feature_FEATURE_UNSPECIFIED Feature = 0
	// Label detection. Detect objects, such as dog or flower.
	Feature_LABEL_DETECTION Feature = 1
	// Shot change detection.
	Feature_SHOT_CHANGE_DETECTION Feature = 2
	// Explicit content detection.
	Feature_EXPLICIT_CONTENT_DETECTION Feature = 3
	// Speech transcription.
	Feature_SPEECH_TRANSCRIPTION Feature = 6
)

var Feature_name = map[int32]string{
	0: "FEATURE_UNSPECIFIED",
	1: "LABEL_DETECTION",
	2: "SHOT_CHANGE_DETECTION",
	3: "EXPLICIT_CONTENT_DETECTION",
	6: "SPEECH_TRANSCRIPTION",
}

var Feature_value = map[string]int32{
	"FEATURE_UNSPECIFIED":        0,
	"LABEL_DETECTION":            1,
	"SHOT_CHANGE_DETECTION":      2,
	"EXPLICIT_CONTENT_DETECTION": 3,
	"SPEECH_TRANSCRIPTION":       6,
}

func (x Feature) String() string {
	return proto.EnumName(Feature_name, int32(x))
}

func (Feature) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_9e6ec0147460ac77, []int{0}
}

// Label detection mode.
type LabelDetectionMode int32

const (
	// Unspecified.
	LabelDetectionMode_LABEL_DETECTION_MODE_UNSPECIFIED LabelDetectionMode = 0
	// Detect shot-level labels.
	LabelDetectionMode_SHOT_MODE LabelDetectionMode = 1
	// Detect frame-level labels.
	LabelDetectionMode_FRAME_MODE LabelDetectionMode = 2
	// Detect both shot-level and frame-level labels.
	LabelDetectionMode_SHOT_AND_FRAME_MODE LabelDetectionMode = 3
)

var LabelDetectionMode_name = map[int32]string{
	0: "LABEL_DETECTION_MODE_UNSPECIFIED",
	1: "SHOT_MODE",
	2: "FRAME_MODE",
	3: "SHOT_AND_FRAME_MODE",
}

var LabelDetectionMode_value = map[string]int32{
	"LABEL_DETECTION_MODE_UNSPECIFIED": 0,
	"SHOT_MODE":                        1,
	"FRAME_MODE":                       2,
	"SHOT_AND_FRAME_MODE":              3,
}

func (x LabelDetectionMode) String() string {
	return proto.EnumName(LabelDetectionMode_name, int32(x))
}

func (LabelDetectionMode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_9e6ec0147460ac77, []int{1}
}

// Bucketized representation of likelihood.
type Likelihood int32

const (
	// Unspecified likelihood.
	Likelihood_LIKELIHOOD_UNSPECIFIED Likelihood = 0
	// Very unlikely.
	Likelihood_VERY_UNLIKELY Likelihood = 1
	// Unlikely.
	Likelihood_UNLIKELY Likelihood = 2
	// Possible.
	Likelihood_POSSIBLE Likelihood = 3
	// Likely.
	Likelihood_LIKELY Likelihood = 4
	// Very likely.
	Likelihood_VERY_LIKELY Likelihood = 5
)

var Likelihood_name = map[int32]string{
	0: "LIKELIHOOD_UNSPECIFIED",
	1: "VERY_UNLIKELY",
	2: "UNLIKELY",
	3: "POSSIBLE",
	4: "LIKELY",
	5: "VERY_LIKELY",
}

var Likelihood_value = map[string]int32{
	"LIKELIHOOD_UNSPECIFIED": 0,
	"VERY_UNLIKELY":          1,
	"UNLIKELY":               2,
	"POSSIBLE":               3,
	"LIKELY":                 4,
	"VERY_LIKELY":            5,
}

func (x Likelihood) String() string {
	return proto.EnumName(Likelihood_name, int32(x))
}

func (Likelihood) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_9e6ec0147460ac77, []int{2}
}

// Video annotation request.
type AnnotateVideoRequest struct {
	// Input video location. Currently, only
	// [Google Cloud Storage](https://cloud.google.com/storage/) URIs are
	// supported, which must be specified in the following format:
	// `gs://bucket-id/object-id` (other URI formats return
	// [google.rpc.Code.INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]). For
	// more information, see [Request URIs](/storage/docs/reference-uris). A video
	// URI may include wildcards in `object-id`, and thus identify multiple
	// videos. Supported wildcards: '*' to match 0 or more characters;
	// '?' to match 1 character. If unset, the input video should be embedded
	// in the request as `input_content`. If set, `input_content` should be unset.
	InputUri string `protobuf:"bytes,1,opt,name=input_uri,json=inputUri,proto3" json:"input_uri,omitempty"`
	// The video data bytes.
	// If unset, the input video(s) should be specified via `input_uri`.
	// If set, `input_uri` should be unset.
	InputContent []byte `protobuf:"bytes,6,opt,name=input_content,json=inputContent,proto3" json:"input_content,omitempty"`
	// Requested video annotation features.
	Features []Feature `protobuf:"varint,2,rep,packed,name=features,proto3,enum=google.cloud.videointelligence.v1p1beta1.Feature" json:"features,omitempty"`
	// Additional video context and/or feature-specific parameters.
	VideoContext *VideoContext `protobuf:"bytes,3,opt,name=video_context,json=videoContext,proto3" json:"video_context,omitempty"`
	// Optional location where the output (in JSON format) should be stored.
	// Currently, only [Google Cloud Storage](https://cloud.google.com/storage/)
	// URIs are supported, which must be specified in the following format:
	// `gs://bucket-id/object-id` (other URI formats return
	// [google.rpc.Code.INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]). For
	// more information, see [Request URIs](/storage/docs/reference-uris).
	OutputUri string `protobuf:"bytes,4,opt,name=output_uri,json=outputUri,proto3" json:"output_uri,omitempty"`
	// Optional cloud region where annotation should take place. Supported cloud
	// regions: `us-east1`, `us-west1`, `europe-west1`, `asia-east1`. If no region
	// is specified, a region will be determined based on video file location.
	LocationId           string   `protobuf:"bytes,5,opt,name=location_id,json=locationId,proto3" json:"location_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AnnotateVideoRequest) Reset()         { *m = AnnotateVideoRequest{} }
func (m *AnnotateVideoRequest) String() string { return proto.CompactTextString(m) }
func (*AnnotateVideoRequest) ProtoMessage()    {}
func (*AnnotateVideoRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9e6ec0147460ac77, []int{0}
}

func (m *AnnotateVideoRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AnnotateVideoRequest.Unmarshal(m, b)
}
func (m *AnnotateVideoRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AnnotateVideoRequest.Marshal(b, m, deterministic)
}
func (m *AnnotateVideoRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AnnotateVideoRequest.Merge(m, src)
}
func (m *AnnotateVideoRequest) XXX_Size() int {
	return xxx_messageInfo_AnnotateVideoRequest.Size(m)
}
func (m *AnnotateVideoRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AnnotateVideoRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AnnotateVideoRequest proto.InternalMessageInfo

func (m *AnnotateVideoRequest) GetInputUri() string {
	if m != nil {
		return m.InputUri
	}
	return ""
}

func (m *AnnotateVideoRequest) GetInputContent() []byte {
	if m != nil {
		return m.InputContent
	}
	return nil
}

func (m *AnnotateVideoRequest) GetFeatures() []Feature {
	if m != nil {
		return m.Features
	}
	return nil
}

func (m *AnnotateVideoRequest) GetVideoContext() *VideoContext {
	if m != nil {
		return m.VideoContext
	}
	return nil
}

func (m *AnnotateVideoRequest) GetOutputUri() string {
	if m != nil {
		return m.OutputUri
	}
	return ""
}

func (m *AnnotateVideoRequest) GetLocationId() string {
	if m != nil {
		return m.LocationId
	}
	return ""
}

// Video context and/or feature-specific parameters.
type VideoContext struct {
	// Video segments to annotate. The segments may overlap and are not required
	// to be contiguous or span the whole video. If unspecified, each video is
	// treated as a single segment.
	Segments []*VideoSegment `protobuf:"bytes,1,rep,name=segments,proto3" json:"segments,omitempty"`
	// Config for LABEL_DETECTION.
	LabelDetectionConfig *LabelDetectionConfig `protobuf:"bytes,2,opt,name=label_detection_config,json=labelDetectionConfig,proto3" json:"label_detection_config,omitempty"`
	// Config for SHOT_CHANGE_DETECTION.
	ShotChangeDetectionConfig *ShotChangeDetectionConfig `protobuf:"bytes,3,opt,name=shot_change_detection_config,json=shotChangeDetectionConfig,proto3" json:"shot_change_detection_config,omitempty"`
	// Config for EXPLICIT_CONTENT_DETECTION.
	ExplicitContentDetectionConfig *ExplicitContentDetectionConfig `protobuf:"bytes,4,opt,name=explicit_content_detection_config,json=explicitContentDetectionConfig,proto3" json:"explicit_content_detection_config,omitempty"`
	// Config for SPEECH_TRANSCRIPTION.
	SpeechTranscriptionConfig *SpeechTranscriptionConfig `protobuf:"bytes,6,opt,name=speech_transcription_config,json=speechTranscriptionConfig,proto3" json:"speech_transcription_config,omitempty"`
	XXX_NoUnkeyedLiteral      struct{}                   `json:"-"`
	XXX_unrecognized          []byte                     `json:"-"`
	XXX_sizecache             int32                      `json:"-"`
}

func (m *VideoContext) Reset()         { *m = VideoContext{} }
func (m *VideoContext) String() string { return proto.CompactTextString(m) }
func (*VideoContext) ProtoMessage()    {}
func (*VideoContext) Descriptor() ([]byte, []int) {
	return fileDescriptor_9e6ec0147460ac77, []int{1}
}

func (m *VideoContext) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VideoContext.Unmarshal(m, b)
}
func (m *VideoContext) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VideoContext.Marshal(b, m, deterministic)
}
func (m *VideoContext) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VideoContext.Merge(m, src)
}
func (m *VideoContext) XXX_Size() int {
	return xxx_messageInfo_VideoContext.Size(m)
}
func (m *VideoContext) XXX_DiscardUnknown() {
	xxx_messageInfo_VideoContext.DiscardUnknown(m)
}

var xxx_messageInfo_VideoContext proto.InternalMessageInfo

func (m *VideoContext) GetSegments() []*VideoSegment {
	if m != nil {
		return m.Segments
	}
	return nil
}

func (m *VideoContext) GetLabelDetectionConfig() *LabelDetectionConfig {
	if m != nil {
		return m.LabelDetectionConfig
	}
	return nil
}

func (m *VideoContext) GetShotChangeDetectionConfig() *ShotChangeDetectionConfig {
	if m != nil {
		return m.ShotChangeDetectionConfig
	}
	return nil
}

func (m *VideoContext) GetExplicitContentDetectionConfig() *ExplicitContentDetectionConfig {
	if m != nil {
		return m.ExplicitContentDetectionConfig
	}
	return nil
}

func (m *VideoContext) GetSpeechTranscriptionConfig() *SpeechTranscriptionConfig {
	if m != nil {
		return m.SpeechTranscriptionConfig
	}
	return nil
}

// Config for LABEL_DETECTION.
type LabelDetectionConfig struct {
	// What labels should be detected with LABEL_DETECTION, in addition to
	// video-level labels or segment-level labels.
	// If unspecified, defaults to `SHOT_MODE`.
	LabelDetectionMode LabelDetectionMode `protobuf:"varint,1,opt,name=label_detection_mode,json=labelDetectionMode,proto3,enum=google.cloud.videointelligence.v1p1beta1.LabelDetectionMode" json:"label_detection_mode,omitempty"`
	// Whether the video has been shot from a stationary (i.e. non-moving) camera.
	// When set to true, might improve detection accuracy for moving objects.
	// Should be used with `SHOT_AND_FRAME_MODE` enabled.
	StationaryCamera bool `protobuf:"varint,2,opt,name=stationary_camera,json=stationaryCamera,proto3" json:"stationary_camera,omitempty"`
	// Model to use for label detection.
	// Supported values: "builtin/stable" (the default if unset) and
	// "builtin/latest".
	Model                string   `protobuf:"bytes,3,opt,name=model,proto3" json:"model,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LabelDetectionConfig) Reset()         { *m = LabelDetectionConfig{} }
func (m *LabelDetectionConfig) String() string { return proto.CompactTextString(m) }
func (*LabelDetectionConfig) ProtoMessage()    {}
func (*LabelDetectionConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_9e6ec0147460ac77, []int{2}
}

func (m *LabelDetectionConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LabelDetectionConfig.Unmarshal(m, b)
}
func (m *LabelDetectionConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LabelDetectionConfig.Marshal(b, m, deterministic)
}
func (m *LabelDetectionConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelDetectionConfig.Merge(m, src)
}
func (m *LabelDetectionConfig) XXX_Size() int {
	return xxx_messageInfo_LabelDetectionConfig.Size(m)
}
func (m *LabelDetectionConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelDetectionConfig.DiscardUnknown(m)
}

var xxx_messageInfo_LabelDetectionConfig proto.InternalMessageInfo

func (m *LabelDetectionConfig) GetLabelDetectionMode() LabelDetectionMode {
	if m != nil {
		return m.LabelDetectionMode
	}
	return LabelDetectionMode_LABEL_DETECTION_MODE_UNSPECIFIED
}

func (m *LabelDetectionConfig) GetStationaryCamera() bool {
	if m != nil {
		return m.StationaryCamera
	}
	return false
}

func (m *LabelDetectionConfig) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

// Config for SHOT_CHANGE_DETECTION.
type ShotChangeDetectionConfig struct {
	// Model to use for shot change detection.
	// Supported values: "builtin/stable" (the default if unset) and
	// "builtin/latest".
	Model                string   `protobuf:"bytes,1,opt,name=model,proto3" json:"model,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ShotChangeDetectionConfig) Reset()         { *m = ShotChangeDetectionConfig{} }
func (m *ShotChangeDetectionConfig) String() string { return proto.CompactTextString(m) }
func (*ShotChangeDetectionConfig) ProtoMessage()    {}
func (*ShotChangeDetectionConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_9e6ec0147460ac77, []int{3}
}

func (m *ShotChangeDetectionConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ShotChangeDetectionConfig.Unmarshal(m, b)
}
func (m *ShotChangeDetectionConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ShotChangeDetectionConfig.Marshal(b, m, deterministic)
}
func (m *ShotChangeDetectionConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ShotChangeDetectionConfig.Merge(m, src)
}
func (m *ShotChangeDetectionConfig) XXX_Size() int {
	return xxx_messageInfo_ShotChangeDetectionConfig.Size(m)
}
func (m *ShotChangeDetectionConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ShotChangeDetectionConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ShotChangeDetectionConfig proto.InternalMessageInfo

func (m *ShotChangeDetectionConfig) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

// Config for EXPLICIT_CONTENT_DETECTION.
type ExplicitContentDetectionConfig struct {
	// Model to use for explicit content detection.
	// Supported values: "builtin/stable" (the default if unset) and
	// "builtin/latest".
	Model                string   `protobuf:"bytes,1,opt,name=model,proto3" json:"model,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ExplicitContentDetectionConfig) Reset()         { *m = ExplicitContentDetectionConfig{} }
func (m *ExplicitContentDetectionConfig) String() string { return proto.CompactTextString(m) }
func (*ExplicitContentDetectionConfig) ProtoMessage()    {}
func (*ExplicitContentDetectionConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_9e6ec0147460ac77, []int{4}
}

func (m *ExplicitContentDetectionConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExplicitContentDetectionConfig.Unmarshal(m, b)
}
func (m *ExplicitContentDetectionConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExplicitContentDetectionConfig.Marshal(b, m, deterministic)
}
func (m *ExplicitContentDetectionConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExplicitContentDetectionConfig.Merge(m, src)
}
func (m *ExplicitContentDetectionConfig) XXX_Size() int {
	return xxx_messageInfo_ExplicitContentDetectionConfig.Size(m)
}
func (m *ExplicitContentDetectionConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ExplicitContentDetectionConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ExplicitContentDetectionConfig proto.InternalMessageInfo

func (m *ExplicitContentDetectionConfig) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

// Video segment.
type VideoSegment struct {
	// Time-offset, relative to the beginning of the video,
	// corresponding to the start of the segment (inclusive).
	StartTimeOffset *duration.Duration `protobuf:"bytes,1,opt,name=start_time_offset,json=startTimeOffset,proto3" json:"start_time_offset,omitempty"`
	// Time-offset, relative to the beginning of the video,
	// corresponding to the end of the segment (inclusive).
	EndTimeOffset        *duration.Duration `protobuf:"bytes,2,opt,name=end_time_offset,json=endTimeOffset,proto3" json:"end_time_offset,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *VideoSegment) Reset()         { *m = VideoSegment{} }
func (m *VideoSegment) String() string { return proto.CompactTextString(m) }
func (*VideoSegment) ProtoMessage()    {}
func (*VideoSegment) Descriptor() ([]byte, []int) {
	return fileDescriptor_9e6ec0147460ac77, []int{5}
}

func (m *VideoSegment) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VideoSegment.Unmarshal(m, b)
}
func (m *VideoSegment) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VideoSegment.Marshal(b, m, deterministic)
}
func (m *VideoSegment) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VideoSegment.Merge(m, src)
}
func (m *VideoSegment) XXX_Size() int {
	return xxx_messageInfo_VideoSegment.Size(m)
}
func (m *VideoSegment) XXX_DiscardUnknown() {
	xxx_messageInfo_VideoSegment.DiscardUnknown(m)
}

var xxx_messageInfo_VideoSegment proto.InternalMessageInfo

func (m *VideoSegment) GetStartTimeOffset() *duration.Duration {
	if m != nil {
		return m.StartTimeOffset
	}
	return nil
}

func (m *VideoSegment) GetEndTimeOffset() *duration.Duration {
	if m != nil {
		return m.EndTimeOffset
	}
	return nil
}

// Video segment level annotation results for label detection.
type LabelSegment struct {
	// Video segment where a label was detected.
	Segment *VideoSegment `protobuf:"bytes,1,opt,name=segment,proto3" json:"segment,omitempty"`
	// Confidence that the label is accurate. Range: [0, 1].
	Confidence           float32  `protobuf:"fixed32,2,opt,name=confidence,proto3" json:"confidence,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LabelSegment) Reset()         { *m = LabelSegment{} }
func (m *LabelSegment) String() string { return proto.CompactTextString(m) }
func (*LabelSegment) ProtoMessage()    {}
func (*LabelSegment) Descriptor() ([]byte, []int) {
	return fileDescriptor_9e6ec0147460ac77, []int{6}
}

func (m *LabelSegment) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LabelSegment.Unmarshal(m, b)
}
func (m *LabelSegment) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LabelSegment.Marshal(b, m, deterministic)
}
func (m *LabelSegment) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelSegment.Merge(m, src)
}
func (m *LabelSegment) XXX_Size() int {
	return xxx_messageInfo_LabelSegment.Size(m)
}
func (m *LabelSegment) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelSegment.DiscardUnknown(m)
}

var xxx_messageInfo_LabelSegment proto.InternalMessageInfo

func (m *LabelSegment) GetSegment() *VideoSegment {
	if m != nil {
		return m.Segment
	}
	return nil
}

func (m *LabelSegment) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

// Video frame level annotation results for label detection.
type LabelFrame struct {
	// Time-offset, relative to the beginning of the video, corresponding to the
	// video frame for this location.
	TimeOffset *duration.Duration `protobuf:"bytes,1,opt,name=time_offset,json=timeOffset,proto3" json:"time_offset,omitempty"`
	// Confidence that the label is accurate. Range: [0, 1].
	Confidence           float32  `protobuf:"fixed32,2,opt,name=confidence,proto3" json:"confidence,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LabelFrame) Reset()         { *m = LabelFrame{} }
func (m *LabelFrame) String() string { return proto.CompactTextString(m) }
func (*LabelFrame) ProtoMessage()    {}
func (*LabelFrame) Descriptor() ([]byte, []int) {
	return fileDescriptor_9e6ec0147460ac77, []int{7}
}

func (m *LabelFrame) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LabelFrame.Unmarshal(m, b)
}
func (m *LabelFrame) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LabelFrame.Marshal(b, m, deterministic)
}
func (m *LabelFrame) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelFrame.Merge(m, src)
}
func (m *LabelFrame) XXX_Size() int {
	return xxx_messageInfo_LabelFrame.Size(m)
}
func (m *LabelFrame) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelFrame.DiscardUnknown(m)
}

var xxx_messageInfo_LabelFrame proto.InternalMessageInfo

func (m *LabelFrame) GetTimeOffset() *duration.Duration {
	if m != nil {
		return m.TimeOffset
	}
	return nil
}

func (m *LabelFrame) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

// Detected entity from video analysis.
type Entity struct {
	// Opaque entity ID. Some IDs may be available in
	// [Google Knowledge Graph Search
	// API](https://developers.google.com/knowledge-graph/).
	EntityId string `protobuf:"bytes,1,opt,name=entity_id,json=entityId,proto3" json:"entity_id,omitempty"`
	// Textual description, e.g. `Fixed-gear bicycle`.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Language code for `description` in BCP-47 format.
	LanguageCode         string   `protobuf:"bytes,3,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Entity) Reset()         { *m = Entity{} }
func (m *Entity) String() string { return proto.CompactTextString(m) }
func (*Entity) ProtoMessage()    {}
func (*Entity) Descriptor() ([]byte, []int) {
	return fileDescriptor_9e6ec0147460ac77, []int{8}
}

func (m *Entity) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Entity.Unmarshal(m, b)
}
func (m *Entity) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Entity.Marshal(b, m, deterministic)
}
func (m *Entity) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Entity.Merge(m, src)
}
func (m *Entity) XXX_Size() int {
	return xxx_messageInfo_Entity.Size(m)
}
func (m *Entity) XXX_DiscardUnknown() {
	xxx_messageInfo_Entity.DiscardUnknown(m)
}

var xxx_messageInfo_Entity proto.InternalMessageInfo

func (m *Entity) GetEntityId() string {
	if m != nil {
		return m.EntityId
	}
	return ""
}

func (m *Entity) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Entity) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

// Label annotation.
type LabelAnnotation struct {
	// Detected entity.
	Entity *Entity `protobuf:"bytes,1,opt,name=entity,proto3" json:"entity,omitempty"`
	// Common categories for the detected entity.
	// E.g. when the label is `Terrier` the category is likely `dog`. And in some
	// cases there might be more than one categories e.g. `Terrier` could also be
	// a `pet`.
	CategoryEntities []*Entity `protobuf:"bytes,2,rep,name=category_entities,json=categoryEntities,proto3" json:"category_entities,omitempty"`
	// All video segments where a label was detected.
	Segments []*LabelSegment `protobuf:"bytes,3,rep,name=segments,proto3" json:"segments,omitempty"`
	// All video frames where a label was detected.
	Frames               []*LabelFrame `protobuf:"bytes,4,rep,name=frames,proto3" json:"frames,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *LabelAnnotation) Reset()         { *m = LabelAnnotation{} }
func (m *LabelAnnotation) String() string { return proto.CompactTextString(m) }
func (*LabelAnnotation) ProtoMessage()    {}
func (*LabelAnnotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_9e6ec0147460ac77, []int{9}
}

func (m *LabelAnnotation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LabelAnnotation.Unmarshal(m, b)
}
func (m *LabelAnnotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LabelAnnotation.Marshal(b, m, deterministic)
}
func (m *LabelAnnotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelAnnotation.Merge(m, src)
}
func (m *LabelAnnotation) XXX_Size() int {
	return xxx_messageInfo_LabelAnnotation.Size(m)
}
func (m *LabelAnnotation) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelAnnotation.DiscardUnknown(m)
}

var xxx_messageInfo_LabelAnnotation proto.InternalMessageInfo

func (m *LabelAnnotation) GetEntity() *Entity {
	if m != nil {
		return m.Entity
	}
	return nil
}

func (m *LabelAnnotation) GetCategoryEntities() []*Entity {
	if m != nil {
		return m.CategoryEntities
	}
	return nil
}

func (m *LabelAnnotation) GetSegments() []*LabelSegment {
	if m != nil {
		return m.Segments
	}
	return nil
}

func (m *LabelAnnotation) GetFrames() []*LabelFrame {
	if m != nil {
		return m.Frames
	}
	return nil
}

// Video frame level annotation results for explicit content.
type ExplicitContentFrame struct {
	// Time-offset, relative to the beginning of the video, corresponding to the
	// video frame for this location.
	TimeOffset *duration.Duration `protobuf:"bytes,1,opt,name=time_offset,json=timeOffset,proto3" json:"time_offset,omitempty"`
	// Likelihood of the pornography content..
	PornographyLikelihood Likelihood `protobuf:"varint,2,opt,name=pornography_likelihood,json=pornographyLikelihood,proto3,enum=google.cloud.videointelligence.v1p1beta1.Likelihood" json:"pornography_likelihood,omitempty"`
	XXX_NoUnkeyedLiteral  struct{}   `json:"-"`
	XXX_unrecognized      []byte     `json:"-"`
	XXX_sizecache         int32      `json:"-"`
}

func (m *ExplicitContentFrame) Reset()         { *m = ExplicitContentFrame{} }
func (m *ExplicitContentFrame) String() string { return proto.CompactTextString(m) }
func (*ExplicitContentFrame) ProtoMessage()    {}
func (*ExplicitContentFrame) Descriptor() ([]byte, []int) {
	return fileDescriptor_9e6ec0147460ac77, []int{10}
}

func (m *ExplicitContentFrame) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExplicitContentFrame.Unmarshal(m, b)
}
func (m *ExplicitContentFrame) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExplicitContentFrame.Marshal(b, m, deterministic)
}
func (m *ExplicitContentFrame) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExplicitContentFrame.Merge(m, src)
}
func (m *ExplicitContentFrame) XXX_Size() int {
	return xxx_messageInfo_ExplicitContentFrame.Size(m)
}
func (m *ExplicitContentFrame) XXX_DiscardUnknown() {
	xxx_messageInfo_ExplicitContentFrame.DiscardUnknown(m)
}

var xxx_messageInfo_ExplicitContentFrame proto.InternalMessageInfo

func (m *ExplicitContentFrame) GetTimeOffset() *duration.Duration {
	if m != nil {
		return m.TimeOffset
	}
	return nil
}

func (m *ExplicitContentFrame) GetPornographyLikelihood() Likelihood {
	if m != nil {
		return m.PornographyLikelihood
	}
	return Likelihood_LIKELIHOOD_UNSPECIFIED
}

// Explicit content annotation (based on per-frame visual signals only).
// If no explicit content has been detected in a frame, no annotations are
// present for that frame.
type ExplicitContentAnnotation struct {
	// All video frames where explicit content was detected.
	Frames               []*ExplicitContentFrame `protobuf:"bytes,1,rep,name=frames,proto3" json:"frames,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *ExplicitContentAnnotation) Reset()         { *m = ExplicitContentAnnotation{} }
func (m *ExplicitContentAnnotation) String() string { return proto.CompactTextString(m) }
func (*ExplicitContentAnnotation) ProtoMessage()    {}
func (*ExplicitContentAnnotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_9e6ec0147460ac77, []int{11}
}

func (m *ExplicitContentAnnotation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExplicitContentAnnotation.Unmarshal(m, b)
}
func (m *ExplicitContentAnnotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExplicitContentAnnotation.Marshal(b, m, deterministic)
}
func (m *ExplicitContentAnnotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExplicitContentAnnotation.Merge(m, src)
}
func (m *ExplicitContentAnnotation) XXX_Size() int {
	return xxx_messageInfo_ExplicitContentAnnotation.Size(m)
}
func (m *ExplicitContentAnnotation) XXX_DiscardUnknown() {
	xxx_messageInfo_ExplicitContentAnnotation.DiscardUnknown(m)
}

var xxx_messageInfo_ExplicitContentAnnotation proto.InternalMessageInfo

func (m *ExplicitContentAnnotation) GetFrames() []*ExplicitContentFrame {
	if m != nil {
		return m.Frames
	}
	return nil
}

// Annotation results for a single video.
type VideoAnnotationResults struct {
	// Output only. Video file location in
	// [Google Cloud Storage](https://cloud.google.com/storage/).
	InputUri string `protobuf:"bytes,1,opt,name=input_uri,json=inputUri,proto3" json:"input_uri,omitempty"`
	// Label annotations on video level or user specified segment level.
	// There is exactly one element for each unique label.
	SegmentLabelAnnotations []*LabelAnnotation `protobuf:"bytes,2,rep,name=segment_label_annotations,json=segmentLabelAnnotations,proto3" json:"segment_label_annotations,omitempty"`
	// Label annotations on shot level.
	// There is exactly one element for each unique label.
	ShotLabelAnnotations []*LabelAnnotation `protobuf:"bytes,3,rep,name=shot_label_annotations,json=shotLabelAnnotations,proto3" json:"shot_label_annotations,omitempty"`
	// Label annotations on frame level.
	// There is exactly one element for each unique label.
	FrameLabelAnnotations []*LabelAnnotation `protobuf:"bytes,4,rep,name=frame_label_annotations,json=frameLabelAnnotations,proto3" json:"frame_label_annotations,omitempty"`
	// Shot annotations. Each shot is represented as a video segment.
	ShotAnnotations []*VideoSegment `protobuf:"bytes,6,rep,name=shot_annotations,json=shotAnnotations,proto3" json:"shot_annotations,omitempty"`
	// Explicit content annotation.
	ExplicitAnnotation *ExplicitContentAnnotation `protobuf:"bytes,7,opt,name=explicit_annotation,json=explicitAnnotation,proto3" json:"explicit_annotation,omitempty"`
	// Speech transcription.
	SpeechTranscriptions []*SpeechTranscription `protobuf:"bytes,11,rep,name=speech_transcriptions,json=speechTranscriptions,proto3" json:"speech_transcriptions,omitempty"`
	// Output only. If set, indicates an error. Note that for a single
	// `AnnotateVideoRequest` some videos may succeed and some may fail.
	Error                *status.Status `protobuf:"bytes,9,opt,name=error,proto3" json:"error,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *VideoAnnotationResults) Reset()         { *m = VideoAnnotationResults{} }
func (m *VideoAnnotationResults) String() string { return proto.CompactTextString(m) }
func (*VideoAnnotationResults) ProtoMessage()    {}
func (*VideoAnnotationResults) Descriptor() ([]byte, []int) {
	return fileDescriptor_9e6ec0147460ac77, []int{12}
}

func (m *VideoAnnotationResults) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VideoAnnotationResults.Unmarshal(m, b)
}
func (m *VideoAnnotationResults) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VideoAnnotationResults.Marshal(b, m, deterministic)
}
func (m *VideoAnnotationResults) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VideoAnnotationResults.Merge(m, src)
}
func (m *VideoAnnotationResults) XXX_Size() int {
	return xxx_messageInfo_VideoAnnotationResults.Size(m)
}
func (m *VideoAnnotationResults) XXX_DiscardUnknown() {
	xxx_messageInfo_VideoAnnotationResults.DiscardUnknown(m)
}

var xxx_messageInfo_VideoAnnotationResults proto.InternalMessageInfo

func (m *VideoAnnotationResults) GetInputUri() string {
	if m != nil {
		return m.InputUri
	}
	return ""
}

func (m *VideoAnnotationResults) GetSegmentLabelAnnotations() []*LabelAnnotation {
	if m != nil {
		return m.SegmentLabelAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetShotLabelAnnotations() []*LabelAnnotation {
	if m != nil {
		return m.ShotLabelAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetFrameLabelAnnotations() []*LabelAnnotation {
	if m != nil {
		return m.FrameLabelAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetShotAnnotations() []*VideoSegment {
	if m != nil {
		return m.ShotAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetExplicitAnnotation() *ExplicitContentAnnotation {
	if m != nil {
		return m.ExplicitAnnotation
	}
	return nil
}

func (m *VideoAnnotationResults) GetSpeechTranscriptions() []*SpeechTranscription {
	if m != nil {
		return m.SpeechTranscriptions
	}
	return nil
}

func (m *VideoAnnotationResults) GetError() *status.Status {
	if m != nil {
		return m.Error
	}
	return nil
}

// Video annotation response. Included in the `response`
// field of the `Operation` returned by the `GetOperation`
// call of the `google::longrunning::Operations` service.
type AnnotateVideoResponse struct {
	// Annotation results for all videos specified in `AnnotateVideoRequest`.
	AnnotationResults    []*VideoAnnotationResults `protobuf:"bytes,1,rep,name=annotation_results,json=annotationResults,proto3" json:"annotation_results,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_unrecognized     []byte                    `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *AnnotateVideoResponse) Reset()         { *m = AnnotateVideoResponse{} }
func (m *AnnotateVideoResponse) String() string { return proto.CompactTextString(m) }
func (*AnnotateVideoResponse) ProtoMessage()    {}
func (*AnnotateVideoResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_9e6ec0147460ac77, []int{13}
}

func (m *AnnotateVideoResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AnnotateVideoResponse.Unmarshal(m, b)
}
func (m *AnnotateVideoResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AnnotateVideoResponse.Marshal(b, m, deterministic)
}
func (m *AnnotateVideoResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AnnotateVideoResponse.Merge(m, src)
}
func (m *AnnotateVideoResponse) XXX_Size() int {
	return xxx_messageInfo_AnnotateVideoResponse.Size(m)
}
func (m *AnnotateVideoResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_AnnotateVideoResponse.DiscardUnknown(m)
}

var xxx_messageInfo_AnnotateVideoResponse proto.InternalMessageInfo

func (m *AnnotateVideoResponse) GetAnnotationResults() []*VideoAnnotationResults {
	if m != nil {
		return m.AnnotationResults
	}
	return nil
}

// Annotation progress for a single video.
type VideoAnnotationProgress struct {
	// Output only. Video file location in
	// [Google Cloud Storage](https://cloud.google.com/storage/).
	InputUri string `protobuf:"bytes,1,opt,name=input_uri,json=inputUri,proto3" json:"input_uri,omitempty"`
	// Output only. Approximate percentage processed thus far. Guaranteed to be
	// 100 when fully processed.
	ProgressPercent int32 `protobuf:"varint,2,opt,name=progress_percent,json=progressPercent,proto3" json:"progress_percent,omitempty"`
	// Output only. Time when the request was received.
	StartTime *timestamp.Timestamp `protobuf:"bytes,3,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Output only. Time of the most recent update.
	UpdateTime           *timestamp.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *VideoAnnotationProgress) Reset()         { *m = VideoAnnotationProgress{} }
func (m *VideoAnnotationProgress) String() string { return proto.CompactTextString(m) }
func (*VideoAnnotationProgress) ProtoMessage()    {}
func (*VideoAnnotationProgress) Descriptor() ([]byte, []int) {
	return fileDescriptor_9e6ec0147460ac77, []int{14}
}

func (m *VideoAnnotationProgress) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VideoAnnotationProgress.Unmarshal(m, b)
}
func (m *VideoAnnotationProgress) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VideoAnnotationProgress.Marshal(b, m, deterministic)
}
func (m *VideoAnnotationProgress) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VideoAnnotationProgress.Merge(m, src)
}
func (m *VideoAnnotationProgress) XXX_Size() int {
	return xxx_messageInfo_VideoAnnotationProgress.Size(m)
}
func (m *VideoAnnotationProgress) XXX_DiscardUnknown() {
	xxx_messageInfo_VideoAnnotationProgress.DiscardUnknown(m)
}

var xxx_messageInfo_VideoAnnotationProgress proto.InternalMessageInfo

func (m *VideoAnnotationProgress) GetInputUri() string {
	if m != nil {
		return m.InputUri
	}
	return ""
}

func (m *VideoAnnotationProgress) GetProgressPercent() int32 {
	if m != nil {
		return m.ProgressPercent
	}
	return 0
}

func (m *VideoAnnotationProgress) GetStartTime() *timestamp.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *VideoAnnotationProgress) GetUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

// Video annotation progress. Included in the `metadata`
// field of the `Operation` returned by the `GetOperation`
// call of the `google::longrunning::Operations` service.
type AnnotateVideoProgress struct {
	// Progress metadata for all videos specified in `AnnotateVideoRequest`.
	AnnotationProgress   []*VideoAnnotationProgress `protobuf:"bytes,1,rep,name=annotation_progress,json=annotationProgress,proto3" json:"annotation_progress,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *AnnotateVideoProgress) Reset()         { *m = AnnotateVideoProgress{} }
func (m *AnnotateVideoProgress) String() string { return proto.CompactTextString(m) }
func (*AnnotateVideoProgress) ProtoMessage()    {}
func (*AnnotateVideoProgress) Descriptor() ([]byte, []int) {
	return fileDescriptor_9e6ec0147460ac77, []int{15}
}

func (m *AnnotateVideoProgress) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AnnotateVideoProgress.Unmarshal(m, b)
}
func (m *AnnotateVideoProgress) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AnnotateVideoProgress.Marshal(b, m, deterministic)
}
func (m *AnnotateVideoProgress) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AnnotateVideoProgress.Merge(m, src)
}
func (m *AnnotateVideoProgress) XXX_Size() int {
	return xxx_messageInfo_AnnotateVideoProgress.Size(m)
}
func (m *AnnotateVideoProgress) XXX_DiscardUnknown() {
	xxx_messageInfo_AnnotateVideoProgress.DiscardUnknown(m)
}

var xxx_messageInfo_AnnotateVideoProgress proto.InternalMessageInfo

func (m *AnnotateVideoProgress) GetAnnotationProgress() []*VideoAnnotationProgress {
	if m != nil {
		return m.AnnotationProgress
	}
	return nil
}

// Config for SPEECH_TRANSCRIPTION.
type SpeechTranscriptionConfig struct {
	// *Required* The language of the supplied audio as a
	// [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag.
	// Example: "en-US".
	// See [Language Support](https://cloud.google.com/speech/docs/languages)
	// for a list of the currently supported language codes.
	LanguageCode string `protobuf:"bytes,1,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// *Optional* Maximum number of recognition hypotheses to be returned.
	// Specifically, the maximum number of `SpeechRecognitionAlternative` messages
	// within each `SpeechRecognitionResult`. The server may return fewer than
	// `max_alternatives`. Valid values are `0`-`30`. A value of `0` or `1` will
	// return a maximum of one. If omitted, will return a maximum of one.
	MaxAlternatives int32 `protobuf:"varint,2,opt,name=max_alternatives,json=maxAlternatives,proto3" json:"max_alternatives,omitempty"`
	// *Optional* If set to `true`, the server will attempt to filter out
	// profanities, replacing all but the initial character in each filtered word
	// with asterisks, e.g. "f***". If set to `false` or omitted, profanities
	// won't be filtered out.
	FilterProfanity bool `protobuf:"varint,3,opt,name=filter_profanity,json=filterProfanity,proto3" json:"filter_profanity,omitempty"`
	// *Optional* A means to provide context to assist the speech recognition.
	SpeechContexts []*SpeechContext `protobuf:"bytes,4,rep,name=speech_contexts,json=speechContexts,proto3" json:"speech_contexts,omitempty"`
	// *Optional* If 'true', adds punctuation to recognition result hypotheses.
	// This feature is only available in select languages. Setting this for
	// requests in other languages has no effect at all. The default 'false' value
	// does not add punctuation to result hypotheses. NOTE: "This is currently
	// offered as an experimental service, complimentary to all users. In the
	// future this may be exclusively available as a premium feature."
	EnableAutomaticPunctuation bool `protobuf:"varint,5,opt,name=enable_automatic_punctuation,json=enableAutomaticPunctuation,proto3" json:"enable_automatic_punctuation,omitempty"`
	// *Optional* For file formats, such as MXF or MKV, supporting multiple audio
	// tracks, specify up to two tracks. Default: track 0.
	AudioTracks          []int32  `protobuf:"varint,6,rep,packed,name=audio_tracks,json=audioTracks,proto3" json:"audio_tracks,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SpeechTranscriptionConfig) Reset()         { *m = SpeechTranscriptionConfig{} }
func (m *SpeechTranscriptionConfig) String() string { return proto.CompactTextString(m) }
func (*SpeechTranscriptionConfig) ProtoMessage()    {}
func (*SpeechTranscriptionConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_9e6ec0147460ac77, []int{16}
}

func (m *SpeechTranscriptionConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SpeechTranscriptionConfig.Unmarshal(m, b)
}
func (m *SpeechTranscriptionConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SpeechTranscriptionConfig.Marshal(b, m, deterministic)
}
func (m *SpeechTranscriptionConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SpeechTranscriptionConfig.Merge(m, src)
}
func (m *SpeechTranscriptionConfig) XXX_Size() int {
	return xxx_messageInfo_SpeechTranscriptionConfig.Size(m)
}
func (m *SpeechTranscriptionConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_SpeechTranscriptionConfig.DiscardUnknown(m)
}

var xxx_messageInfo_SpeechTranscriptionConfig proto.InternalMessageInfo

func (m *SpeechTranscriptionConfig) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

func (m *SpeechTranscriptionConfig) GetMaxAlternatives() int32 {
	if m != nil {
		return m.MaxAlternatives
	}
	return 0
}

func (m *SpeechTranscriptionConfig) GetFilterProfanity() bool {
	if m != nil {
		return m.FilterProfanity
	}
	return false
}

func (m *SpeechTranscriptionConfig) GetSpeechContexts() []*SpeechContext {
	if m != nil {
		return m.SpeechContexts
	}
	return nil
}

func (m *SpeechTranscriptionConfig) GetEnableAutomaticPunctuation() bool {
	if m != nil {
		return m.EnableAutomaticPunctuation
	}
	return false
}

func (m *SpeechTranscriptionConfig) GetAudioTracks() []int32 {
	if m != nil {
		return m.AudioTracks
	}
	return nil
}

// Provides "hints" to the speech recognizer to favor specific words and phrases
// in the results.
type SpeechContext struct {
	// *Optional* A list of strings containing words and phrases "hints" so that
	// the speech recognition is more likely to recognize them. This can be used
	// to improve the accuracy for specific words and phrases, for example, if
	// specific commands are typically spoken by the user. This can also be used
	// to add additional words to the vocabulary of the recognizer. See
	// [usage limits](https://cloud.google.com/speech/limits#content).
	Phrases              []string `protobuf:"bytes,1,rep,name=phrases,proto3" json:"phrases,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SpeechContext) Reset()         { *m = SpeechContext{} }
func (m *SpeechContext) String() string { return proto.CompactTextString(m) }
func (*SpeechContext) ProtoMessage()    {}
func (*SpeechContext) Descriptor() ([]byte, []int) {
	return fileDescriptor_9e6ec0147460ac77, []int{17}
}

func (m *SpeechContext) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SpeechContext.Unmarshal(m, b)
}
func (m *SpeechContext) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SpeechContext.Marshal(b, m, deterministic)
}
func (m *SpeechContext) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SpeechContext.Merge(m, src)
}
func (m *SpeechContext) XXX_Size() int {
	return xxx_messageInfo_SpeechContext.Size(m)
}
func (m *SpeechContext) XXX_DiscardUnknown() {
	xxx_messageInfo_SpeechContext.DiscardUnknown(m)
}

var xxx_messageInfo_SpeechContext proto.InternalMessageInfo

func (m *SpeechContext) GetPhrases() []string {
	if m != nil {
		return m.Phrases
	}
	return nil
}

// A speech recognition result corresponding to a portion of the audio.
type SpeechTranscription struct {
	// Output only. May contain one or more recognition hypotheses (up to the
	// maximum specified in `max_alternatives`).
	// These alternatives are ordered in terms of accuracy, with the top (first)
	// alternative being the most probable, as ranked by the recognizer.
	Alternatives         []*SpeechRecognitionAlternative `protobuf:"bytes,1,rep,name=alternatives,proto3" json:"alternatives,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                        `json:"-"`
	XXX_unrecognized     []byte                          `json:"-"`
	XXX_sizecache        int32                           `json:"-"`
}

func (m *SpeechTranscription) Reset()         { *m = SpeechTranscription{} }
func (m *SpeechTranscription) String() string { return proto.CompactTextString(m) }
func (*SpeechTranscription) ProtoMessage()    {}
func (*SpeechTranscription) Descriptor() ([]byte, []int) {
	return fileDescriptor_9e6ec0147460ac77, []int{18}
}

func (m *SpeechTranscription) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SpeechTranscription.Unmarshal(m, b)
}
func (m *SpeechTranscription) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SpeechTranscription.Marshal(b, m, deterministic)
}
func (m *SpeechTranscription) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SpeechTranscription.Merge(m, src)
}
func (m *SpeechTranscription) XXX_Size() int {
	return xxx_messageInfo_SpeechTranscription.Size(m)
}
func (m *SpeechTranscription) XXX_DiscardUnknown() {
	xxx_messageInfo_SpeechTranscription.DiscardUnknown(m)
}

var xxx_messageInfo_SpeechTranscription proto.InternalMessageInfo

func (m *SpeechTranscription) GetAlternatives() []*SpeechRecognitionAlternative {
	if m != nil {
		return m.Alternatives
	}
	return nil
}

// Alternative hypotheses (a.k.a. n-best list).
type SpeechRecognitionAlternative struct {
	// Output only. Transcript text representing the words that the user spoke.
	Transcript string `protobuf:"bytes,1,opt,name=transcript,proto3" json:"transcript,omitempty"`
	// Output only. The confidence estimate between 0.0 and 1.0. A higher number
	// indicates an estimated greater likelihood that the recognized words are
	// correct. This field is typically provided only for the top hypothesis, and
	// only for `is_final=true` results. Clients should not rely on the
	// `confidence` field as it is not guaranteed to be accurate or consistent.
	// The default of 0.0 is a sentinel value indicating `confidence` was not set.
	Confidence float32 `protobuf:"fixed32,2,opt,name=confidence,proto3" json:"confidence,omitempty"`
	// Output only. A list of word-specific information for each recognized word.
	Words                []*WordInfo `protobuf:"bytes,3,rep,name=words,proto3" json:"words,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *SpeechRecognitionAlternative) Reset()         { *m = SpeechRecognitionAlternative{} }
func (m *SpeechRecognitionAlternative) String() string { return proto.CompactTextString(m) }
func (*SpeechRecognitionAlternative) ProtoMessage()    {}
func (*SpeechRecognitionAlternative) Descriptor() ([]byte, []int) {
	return fileDescriptor_9e6ec0147460ac77, []int{19}
}

func (m *SpeechRecognitionAlternative) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SpeechRecognitionAlternative.Unmarshal(m, b)
}
func (m *SpeechRecognitionAlternative) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SpeechRecognitionAlternative.Marshal(b, m, deterministic)
}
func (m *SpeechRecognitionAlternative) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SpeechRecognitionAlternative.Merge(m, src)
}
func (m *SpeechRecognitionAlternative) XXX_Size() int {
	return xxx_messageInfo_SpeechRecognitionAlternative.Size(m)
}
func (m *SpeechRecognitionAlternative) XXX_DiscardUnknown() {
	xxx_messageInfo_SpeechRecognitionAlternative.DiscardUnknown(m)
}

var xxx_messageInfo_SpeechRecognitionAlternative proto.InternalMessageInfo

func (m *SpeechRecognitionAlternative) GetTranscript() string {
	if m != nil {
		return m.Transcript
	}
	return ""
}

func (m *SpeechRecognitionAlternative) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

func (m *SpeechRecognitionAlternative) GetWords() []*WordInfo {
	if m != nil {
		return m.Words
	}
	return nil
}

// Word-specific information for recognized words. Word information is only
// included in the response when certain request parameters are set, such
// as `enable_word_time_offsets`.
type WordInfo struct {
	// Output only. Time offset relative to the beginning of the audio, and
	// corresponding to the start of the spoken word. This field is only set if
	// `enable_word_time_offsets=true` and only in the top hypothesis. This is an
	// experimental feature and the accuracy of the time offset can vary.
	StartTime *duration.Duration `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Output only. Time offset relative to the beginning of the audio, and
	// corresponding to the end of the spoken word. This field is only set if
	// `enable_word_time_offsets=true` and only in the top hypothesis. This is an
	// experimental feature and the accuracy of the time offset can vary.
	EndTime *duration.Duration `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. The word corresponding to this set of information.
	Word                 string   `protobuf:"bytes,3,opt,name=word,proto3" json:"word,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *WordInfo) Reset()         { *m = WordInfo{} }
func (m *WordInfo) String() string { return proto.CompactTextString(m) }
func (*WordInfo) ProtoMessage()    {}
func (*WordInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_9e6ec0147460ac77, []int{20}
}

func (m *WordInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_WordInfo.Unmarshal(m, b)
}
func (m *WordInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_WordInfo.Marshal(b, m, deterministic)
}
func (m *WordInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WordInfo.Merge(m, src)
}
func (m *WordInfo) XXX_Size() int {
	return xxx_messageInfo_WordInfo.Size(m)
}
func (m *WordInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_WordInfo.DiscardUnknown(m)
}

var xxx_messageInfo_WordInfo proto.InternalMessageInfo

func (m *WordInfo) GetStartTime() *duration.Duration {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *WordInfo) GetEndTime() *duration.Duration {
	if m != nil {
		return m.EndTime
	}
	return nil
}

func (m *WordInfo) GetWord() string {
	if m != nil {
		return m.Word
	}
	return ""
}

func init() {
	proto.RegisterEnum("google.cloud.videointelligence.v1p1beta1.Feature", Feature_name, Feature_value)
	proto.RegisterEnum("google.cloud.videointelligence.v1p1beta1.LabelDetectionMode", LabelDetectionMode_name, LabelDetectionMode_value)
	proto.RegisterEnum("google.cloud.videointelligence.v1p1beta1.Likelihood", Likelihood_name, Likelihood_value)
	proto.RegisterType((*AnnotateVideoRequest)(nil), "google.cloud.videointelligence.v1p1beta1.AnnotateVideoRequest")
	proto.RegisterType((*VideoContext)(nil), "google.cloud.videointelligence.v1p1beta1.VideoContext")
	proto.RegisterType((*LabelDetectionConfig)(nil), "google.cloud.videointelligence.v1p1beta1.LabelDetectionConfig")
	proto.RegisterType((*ShotChangeDetectionConfig)(nil), "google.cloud.videointelligence.v1p1beta1.ShotChangeDetectionConfig")
	proto.RegisterType((*ExplicitContentDetectionConfig)(nil), "google.cloud.videointelligence.v1p1beta1.ExplicitContentDetectionConfig")
	proto.RegisterType((*VideoSegment)(nil), "google.cloud.videointelligence.v1p1beta1.VideoSegment")
	proto.RegisterType((*LabelSegment)(nil), "google.cloud.videointelligence.v1p1beta1.LabelSegment")
	proto.RegisterType((*LabelFrame)(nil), "google.cloud.videointelligence.v1p1beta1.LabelFrame")
	proto.RegisterType((*Entity)(nil), "google.cloud.videointelligence.v1p1beta1.Entity")
	proto.RegisterType((*LabelAnnotation)(nil), "google.cloud.videointelligence.v1p1beta1.LabelAnnotation")
	proto.RegisterType((*ExplicitContentFrame)(nil), "google.cloud.videointelligence.v1p1beta1.ExplicitContentFrame")
	proto.RegisterType((*ExplicitContentAnnotation)(nil), "google.cloud.videointelligence.v1p1beta1.ExplicitContentAnnotation")
	proto.RegisterType((*VideoAnnotationResults)(nil), "google.cloud.videointelligence.v1p1beta1.VideoAnnotationResults")
	proto.RegisterType((*AnnotateVideoResponse)(nil), "google.cloud.videointelligence.v1p1beta1.AnnotateVideoResponse")
	proto.RegisterType((*VideoAnnotationProgress)(nil), "google.cloud.videointelligence.v1p1beta1.VideoAnnotationProgress")
	proto.RegisterType((*AnnotateVideoProgress)(nil), "google.cloud.videointelligence.v1p1beta1.AnnotateVideoProgress")
	proto.RegisterType((*SpeechTranscriptionConfig)(nil), "google.cloud.videointelligence.v1p1beta1.SpeechTranscriptionConfig")
	proto.RegisterType((*SpeechContext)(nil), "google.cloud.videointelligence.v1p1beta1.SpeechContext")
	proto.RegisterType((*SpeechTranscription)(nil), "google.cloud.videointelligence.v1p1beta1.SpeechTranscription")
	proto.RegisterType((*SpeechRecognitionAlternative)(nil), "google.cloud.videointelligence.v1p1beta1.SpeechRecognitionAlternative")
	proto.RegisterType((*WordInfo)(nil), "google.cloud.videointelligence.v1p1beta1.WordInfo")
}

func init() {
	proto.RegisterFile("google/cloud/videointelligence/v1p1beta1/video_intelligence.proto", fileDescriptor_9e6ec0147460ac77)
}

var fileDescriptor_9e6ec0147460ac77 = []byte{
	// 1827 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x58, 0x4f, 0x6f, 0x23, 0x49,
	0x15, 0xa7, 0x9d, 0xc4, 0x89, 0x9f, 0x9d, 0xd8, 0x53, 0x71, 0x12, 0x27, 0x3b, 0x93, 0xc9, 0xf6,
	0x82, 0x94, 0x9d, 0x45, 0x36, 0x09, 0xab, 0x85, 0xf5, 0xc2, 0x6a, 0x1d, 0xa7, 0xb3, 0xb1, 0xc8,
	0xc4, 0x56, 0xd9, 0x13, 0x18, 0x18, 0xd4, 0x74, 0xba, 0xcb, 0x9d, 0x66, 0xda, 0x5d, 0xbd, 0xdd,
	0xd5, 0x61, 0xe6, 0xc6, 0x3f, 0x09, 0x24, 0x10, 0x97, 0x15, 0x12, 0x1f, 0x01, 0x71, 0xe0, 0xc0,
	0x17, 0xe0, 0xc2, 0x05, 0xae, 0x9c, 0x90, 0xe0, 0xc6, 0x89, 0xaf, 0xc0, 0x65, 0xd5, 0x55, 0xd5,
	0x76, 0xdb, 0x4e, 0x26, 0x71, 0x72, 0x73, 0xbf, 0x3f, 0xbf, 0xf7, 0xa7, 0x5e, 0xbd, 0xf7, 0xca,
	0xd0, 0xb0, 0x29, 0xb5, 0x5d, 0x52, 0x33, 0x5d, 0x1a, 0x59, 0xb5, 0x4b, 0xc7, 0x22, 0xd4, 0xf1,
	0x18, 0x71, 0x5d, 0xc7, 0x26, 0x9e, 0x49, 0x6a, 0x97, 0x7b, 0xfe, 0xde, 0x39, 0x61, 0xc6, 0x9e,
	0xe0, 0xe9, 0x69, 0x66, 0xd5, 0x0f, 0x28, 0xa3, 0x68, 0x57, 0x40, 0x54, 0x39, 0x44, 0x75, 0x0a,
	0xa2, 0x3a, 0x84, 0xd8, 0x7a, 0x28, 0x8d, 0x19, 0xbe, 0x53, 0x33, 0x3c, 0x8f, 0x32, 0x83, 0x39,
	0xd4, 0x0b, 0x05, 0xce, 0xd6, 0x3b, 0x92, 0xeb, 0x52, 0xcf, 0x0e, 0x22, 0xcf, 0x73, 0x3c, 0xbb,
	0x46, 0x7d, 0x12, 0x8c, 0x09, 0x6d, 0x4b, 0x21, 0xfe, 0x75, 0x1e, 0xf5, 0x6b, 0x56, 0x24, 0x04,
	0x24, 0xff, 0xf1, 0x24, 0x9f, 0x39, 0x03, 0x12, 0x32, 0x63, 0xe0, 0x4b, 0x81, 0x0d, 0x29, 0x10,
	0xf8, 0x66, 0x2d, 0x64, 0x06, 0x8b, 0x24, 0xb2, 0xfa, 0xb7, 0x0c, 0x94, 0x1b, 0xc2, 0x29, 0x72,
	0x16, 0x07, 0x81, 0xc9, 0x67, 0x11, 0x09, 0x19, 0x7a, 0x0b, 0x72, 0x8e, 0xe7, 0x47, 0x4c, 0x8f,
	0x02, 0xa7, 0xa2, 0xec, 0x28, 0xbb, 0x39, 0xbc, 0xc4, 0x09, 0xcf, 0x02, 0x07, 0xbd, 0x03, 0xcb,
	0x82, 0x69, 0x52, 0x8f, 0x11, 0x8f, 0x55, 0xb2, 0x3b, 0xca, 0x6e, 0x01, 0x17, 0x38, 0xb1, 0x29,
	0x68, 0xe8, 0x29, 0x2c, 0xf5, 0x89, 0xc1, 0xa2, 0x80, 0x84, 0x95, 0xcc, 0xce, 0xdc, 0xee, 0xca,
	0xfe, 0x5e, 0xf5, 0xb6, 0x49, 0xab, 0x1e, 0x09, 0x4d, 0x3c, 0x84, 0x40, 0x3f, 0x80, 0x65, 0x71,
	0x18, 0xdc, 0xe6, 0x2b, 0x56, 0x99, 0xdb, 0x51, 0x76, 0xf3, 0xfb, 0x1f, 0xdc, 0x1e, 0x93, 0xc7,
	0xd7, 0x14, 0xda, 0xb8, 0x70, 0x99, 0xfa, 0x42, 0x8f, 0x00, 0x68, 0xc4, 0x92, 0x70, 0xe7, 0x79,
	0xb8, 0x39, 0x41, 0x89, 0xe3, 0x7d, 0x0c, 0x79, 0x97, 0x9a, 0x3c, 0xe3, 0xba, 0x63, 0x55, 0x16,
	0x38, 0x1f, 0x12, 0x52, 0xcb, 0x52, 0xff, 0x3f, 0x0f, 0x85, 0x34, 0x3c, 0xc2, 0xb0, 0x14, 0x12,
	0x7b, 0x40, 0x3c, 0x16, 0x56, 0x94, 0x9d, 0xb9, 0x3b, 0x38, 0xda, 0x15, 0xea, 0x78, 0x88, 0x83,
	0x18, 0xac, 0xbb, 0xc6, 0x39, 0x71, 0x75, 0x8b, 0x30, 0x62, 0x72, 0x67, 0x4c, 0xea, 0xf5, 0x1d,
	0xbb, 0x92, 0xe1, 0xa9, 0xf8, 0xf8, 0xf6, 0x16, 0x4e, 0x62, 0x9c, 0xc3, 0x04, 0xa6, 0xc9, 0x51,
	0x70, 0xd9, 0xbd, 0x82, 0x8a, 0x7e, 0xa9, 0xc0, 0xc3, 0xf0, 0x82, 0x32, 0xdd, 0xbc, 0x30, 0x3c,
	0x9b, 0x4c, 0x1b, 0x17, 0xe7, 0xd0, 0xbc, 0xbd, 0xf1, 0xee, 0x05, 0x65, 0x4d, 0x0e, 0x36, 0xe9,
	0xc1, 0x66, 0x78, 0x1d, 0x0b, 0x7d, 0xae, 0xc0, 0xdb, 0xe4, 0x95, 0xef, 0x3a, 0xa6, 0x33, 0x2c,
	0xbb, 0x69, 0x5f, 0xe6, 0xb9, 0x2f, 0xc7, 0xb7, 0xf7, 0x45, 0x93, 0x90, 0xb2, 0x68, 0x27, 0x1d,
	0xda, 0x26, 0x6f, 0xe4, 0xa3, 0x5f, 0x28, 0xf0, 0x56, 0xe8, 0x13, 0x62, 0x5e, 0xe8, 0x2c, 0x30,
	0xbc, 0xd0, 0x0c, 0x1c, 0x3f, 0xed, 0x4f, 0x76, 0xe6, 0xdc, 0x70, 0xb0, 0x5e, 0x1a, 0x6b, 0x98,
	0x9b, 0xeb, 0x58, 0xea, 0xdf, 0x15, 0x28, 0x5f, 0x75, 0xa2, 0xc8, 0x83, 0xf2, 0x64, 0xc5, 0x0c,
	0xa8, 0x45, 0xf8, 0x7d, 0x5e, 0xd9, 0xff, 0xd6, 0x5d, 0xeb, 0xe5, 0x29, 0xb5, 0x08, 0x46, 0xee,
	0x14, 0x0d, 0xbd, 0x07, 0x0f, 0x42, 0xd1, 0xde, 0x8c, 0xe0, 0xb5, 0x6e, 0x1a, 0x03, 0x12, 0x18,
	0xbc, 0x38, 0x97, 0x70, 0x69, 0xc4, 0x68, 0x72, 0x3a, 0x2a, 0xc3, 0x42, 0xec, 0x8c, 0xcb, 0x0b,
	0x28, 0x87, 0xc5, 0x87, 0xba, 0x07, 0x9b, 0xd7, 0xd6, 0xc7, 0x48, 0x45, 0x49, 0xab, 0x7c, 0x00,
	0xdb, 0x6f, 0x3e, 0xc6, 0x6b, 0xf4, 0xfe, 0xa0, 0xc8, 0x4b, 0x2b, 0xaf, 0x1a, 0xd2, 0xb8, 0xfb,
	0x01, 0xd3, 0xe3, 0xf6, 0xa9, 0xd3, 0x7e, 0x3f, 0x24, 0x8c, 0xab, 0xe4, 0xf7, 0x37, 0x93, 0x5c,
	0x25, 0x2d, 0xb6, 0x7a, 0x28, 0x5b, 0x30, 0x2e, 0x72, 0x9d, 0x9e, 0x33, 0x20, 0x6d, 0xae, 0x81,
	0x1a, 0x50, 0x24, 0x9e, 0x35, 0x06, 0x92, 0xb9, 0x09, 0x64, 0x99, 0x78, 0xd6, 0x08, 0x42, 0xfd,
	0xa9, 0x02, 0x05, 0x9e, 0xf3, 0xc4, 0xb5, 0x0e, 0x2c, 0xca, 0x3e, 0x20, 0x1d, 0xba, 0x6b, 0x3b,
	0x49, 0x60, 0xd0, 0x36, 0x00, 0x2f, 0x52, 0x2b, 0x96, 0xe6, 0x0e, 0x66, 0x70, 0x8a, 0xa2, 0x5e,
	0x00, 0x70, 0x0f, 0x8e, 0x02, 0x63, 0x40, 0x50, 0x1d, 0xf2, 0x33, 0x25, 0x05, 0xd8, 0x28, 0x1f,
	0x37, 0x59, 0x72, 0x21, 0xab, 0x79, 0xcc, 0x61, 0xaf, 0xe3, 0xa1, 0x43, 0xf8, 0xaf, 0xb8, 0xcb,
	0xca, 0xa1, 0x23, 0x08, 0x2d, 0x0b, 0xed, 0x40, 0xde, 0x22, 0xc3, 0xd2, 0xe7, 0x38, 0x39, 0x9c,
	0x26, 0xc5, 0x63, 0xc9, 0x35, 0x3c, 0x3b, 0x32, 0x6c, 0xa2, 0x9b, 0x71, 0x9d, 0x8b, 0xca, 0x2a,
	0x24, 0xc4, 0x26, 0xb5, 0x88, 0xfa, 0xef, 0x0c, 0x14, 0x79, 0x60, 0x8d, 0xe1, 0x2c, 0x46, 0xc7,
	0x90, 0x15, 0x66, 0x64, 0x60, 0x5f, 0x9b, 0xa1, 0x81, 0x70, 0x3d, 0x2c, 0xf5, 0xd1, 0x0f, 0xe1,
	0x81, 0x69, 0x30, 0x62, 0xd3, 0xe0, 0xb5, 0xce, 0x49, 0x8e, 0x9c, 0x7e, 0x77, 0x01, 0x2d, 0x25,
	0x50, 0x9a, 0x44, 0x1a, 0x1b, 0x2b, 0x73, 0xb3, 0x8e, 0x95, 0x74, 0x41, 0xa5, 0xc6, 0xca, 0x09,
	0x64, 0xfb, 0xf1, 0x19, 0x87, 0x95, 0x79, 0x8e, 0xf8, 0xfe, 0x8c, 0x88, 0xbc, 0x40, 0xb0, 0xc4,
	0x50, 0xff, 0xaa, 0x40, 0x79, 0xe2, 0x36, 0xde, 0xbf, 0x82, 0x5e, 0xc2, 0xba, 0x4f, 0x03, 0x8f,
	0xda, 0x81, 0xe1, 0x5f, 0xbc, 0xd6, 0x5d, 0xe7, 0x25, 0x71, 0x9d, 0x0b, 0x4a, 0x2d, 0x5e, 0x05,
	0x2b, 0x33, 0xb9, 0x3c, 0xd4, 0xc5, 0x6b, 0x29, 0xcc, 0x11, 0x59, 0x0d, 0x61, 0x73, 0x22, 0x80,
	0x54, 0xa5, 0x9c, 0x0d, 0x93, 0x25, 0xa6, 0xfa, 0xc7, 0x77, 0x1e, 0x35, 0xe3, 0x69, 0xfb, 0x55,
	0x16, 0xd6, 0xf9, 0x3d, 0x1d, 0xd9, 0xc2, 0x24, 0x8c, 0x5c, 0x16, 0xbe, 0x79, 0x13, 0x8b, 0x60,
	0x53, 0x1e, 0xa4, 0x2e, 0x3a, 0x7d, 0x6a, 0xc3, 0x94, 0x75, 0xf7, 0xe1, 0x8c, 0xe7, 0x99, 0xf2,
	0x60, 0x43, 0x62, 0x4f, 0xd0, 0x43, 0x44, 0x61, 0x9d, 0xef, 0x04, 0xd3, 0x36, 0xe7, 0xee, 0x6b,
	0xb3, 0x1c, 0x03, 0x4f, 0x19, 0xfc, 0x0c, 0x36, 0x78, 0xa6, 0xae, 0xb0, 0x38, 0x7f, 0x5f, 0x8b,
	0x6b, 0x1c, 0x79, 0xca, 0xa4, 0x01, 0x25, 0x1e, 0x63, 0xda, 0x56, 0xf6, 0x5e, 0xab, 0x5c, 0x31,
	0xc6, 0x4b, 0x9b, 0x60, 0xb0, 0x3a, 0xdc, 0x69, 0x46, 0x66, 0x2a, 0x8b, 0xb3, 0x6e, 0x0d, 0xd7,
	0xd6, 0x2b, 0x46, 0x09, 0x7e, 0xaa, 0x86, 0x03, 0x58, 0xbb, 0x6a, 0x67, 0x09, 0x2b, 0x79, 0x1e,
	0xdd, 0xb7, 0xef, 0xb5, 0xad, 0xe0, 0xf2, 0x15, 0x7b, 0x4a, 0x88, 0x76, 0x61, 0x81, 0x04, 0x01,
	0x0d, 0x2a, 0x39, 0x1e, 0x1b, 0x4a, 0x6c, 0x04, 0xbe, 0x59, 0xed, 0xf2, 0x07, 0x09, 0x16, 0x02,
	0xea, 0xaf, 0x15, 0x58, 0x9b, 0x78, 0x91, 0x84, 0x3e, 0xf5, 0x42, 0x82, 0x28, 0xa0, 0x51, 0x92,
	0xf4, 0x40, 0x5c, 0x0f, 0x79, 0x0f, 0x3f, 0x99, 0xf1, 0x48, 0xa6, 0xae, 0x19, 0x7e, 0x60, 0x4c,
	0x92, 0xd4, 0x7f, 0x29, 0xb0, 0x31, 0x21, 0xdd, 0x09, 0xa8, 0x1d, 0x90, 0xf0, 0x86, 0x5b, 0xf9,
	0x2e, 0x94, 0x7c, 0x29, 0xa8, 0xfb, 0x24, 0x30, 0xe3, 0xb1, 0x1d, 0x77, 0xaa, 0x05, 0x5c, 0x4c,
	0xe8, 0x1d, 0x41, 0x46, 0x1f, 0x02, 0x8c, 0x76, 0x0e, 0xb9, 0x4b, 0x6f, 0x4d, 0x75, 0xc5, 0x5e,
	0xf2, 0x9e, 0xc3, 0xb9, 0xe1, 0xb6, 0x81, 0x3e, 0x82, 0x7c, 0xe4, 0x5b, 0x06, 0x23, 0x42, 0x77,
	0xfe, 0x46, 0x5d, 0x10, 0xe2, 0x31, 0x41, 0xfd, 0xcd, 0x64, 0x9a, 0x87, 0x91, 0x05, 0xb0, 0x9a,
	0x4a, 0x73, 0xe2, 0xaf, 0xcc, 0x73, 0xe3, 0xce, 0x79, 0x4e, 0xf0, 0x71, 0xea, 0x10, 0x13, 0x9a,
	0xfa, 0x9f, 0x0c, 0x6c, 0x5e, 0xbb, 0xfa, 0x4e, 0xcf, 0x75, 0x65, 0x7a, 0xae, 0xc7, 0x39, 0x1f,
	0x18, 0xaf, 0x74, 0xc3, 0x65, 0x24, 0xf0, 0x0c, 0xe6, 0x5c, 0xf2, 0xc1, 0xcb, 0x73, 0x3e, 0x30,
	0x5e, 0x35, 0x52, 0xe4, 0x58, 0xb4, 0xef, 0xc4, 0x84, 0x38, 0xba, 0xbe, 0xe1, 0xc5, 0x83, 0x7f,
	0x8e, 0x6f, 0xa9, 0x45, 0x41, 0xef, 0x24, 0x64, 0xf4, 0x23, 0x28, 0xca, 0xbb, 0x22, 0x9f, 0x9d,
	0x49, 0xbf, 0xf9, 0xc6, 0xac, 0xb7, 0x24, 0x79, 0x78, 0xae, 0x84, 0xe9, 0xcf, 0x10, 0x7d, 0x02,
	0x0f, 0x89, 0x67, 0x9c, 0xbb, 0x44, 0x37, 0x22, 0x46, 0x07, 0x06, 0x73, 0x4c, 0xdd, 0x8f, 0x3c,
	0x93, 0x45, 0xa2, 0x19, 0x2c, 0x70, 0xc7, 0xb6, 0x84, 0x4c, 0x23, 0x11, 0xe9, 0x8c, 0x24, 0xd0,
	0xdb, 0x50, 0x30, 0x22, 0xcb, 0xa1, 0xf1, 0x75, 0x36, 0x5f, 0x8a, 0x26, 0xb5, 0x80, 0xf3, 0x9c,
	0xd6, 0xe3, 0x24, 0xf5, 0x5d, 0x58, 0x1e, 0xf3, 0x02, 0x55, 0x60, 0xd1, 0xbf, 0x08, 0x8c, 0x50,
	0x0e, 0xb2, 0x1c, 0x4e, 0x3e, 0xd5, 0x9f, 0x29, 0xb0, 0x7a, 0xc5, 0x51, 0xa0, 0x1f, 0x43, 0x61,
	0x2c, 0xb7, 0xa2, 0x1e, 0x8e, 0x66, 0x4d, 0x03, 0x26, 0x26, 0xb5, 0x3d, 0x27, 0x86, 0x4c, 0x9d,
	0x09, 0x1e, 0xc3, 0x56, 0xff, 0xa8, 0xc0, 0xc3, 0x37, 0x89, 0xc7, 0x2b, 0xe5, 0xa8, 0x77, 0xc9,
	0x72, 0x48, 0x51, 0x6e, 0x5a, 0x39, 0xd1, 0x31, 0x2c, 0xfc, 0x84, 0x06, 0x56, 0x32, 0xae, 0xf6,
	0x6f, 0x1f, 0xc5, 0x77, 0x69, 0x60, 0xb5, 0xbc, 0x3e, 0xc5, 0x02, 0x40, 0xfd, 0x9d, 0x02, 0x4b,
	0x09, 0x0d, 0x7d, 0x73, 0xec, 0x32, 0xdf, 0xb8, 0xe2, 0xa4, 0xee, 0xf2, 0xfb, 0xb0, 0x94, 0xbc,
	0x19, 0x6e, 0x7e, 0x2c, 0x2c, 0xca, 0xc7, 0x02, 0x42, 0x30, 0x1f, 0x7b, 0x21, 0xf7, 0x5c, 0xfe,
	0xfb, 0xc9, 0x6f, 0x15, 0x58, 0x94, 0xff, 0x9e, 0xa0, 0x0d, 0x58, 0x3d, 0xd2, 0x1a, 0xbd, 0x67,
	0x58, 0xd3, 0x9f, 0x9d, 0x76, 0x3b, 0x5a, 0xb3, 0x75, 0xd4, 0xd2, 0x0e, 0x4b, 0x5f, 0x42, 0xab,
	0x50, 0x3c, 0x69, 0x1c, 0x68, 0x27, 0xfa, 0xa1, 0xd6, 0xd3, 0x9a, 0xbd, 0x56, 0xfb, 0xb4, 0xa4,
	0xa0, 0x4d, 0x58, 0xeb, 0x1e, 0xb7, 0x7b, 0x7a, 0xf3, 0xb8, 0x71, 0xfa, 0xa9, 0x96, 0x62, 0x65,
	0xd0, 0x36, 0x6c, 0x69, 0xdf, 0xeb, 0x9c, 0xb4, 0x9a, 0xad, 0x9e, 0xde, 0x6c, 0x9f, 0xf6, 0xb4,
	0xd3, 0x5e, 0x8a, 0x3f, 0x87, 0x2a, 0x50, 0xee, 0x76, 0x34, 0xad, 0x79, 0xac, 0xf7, 0x70, 0xe3,
	0xb4, 0xdb, 0xc4, 0xad, 0x0e, 0xe7, 0x64, 0x9f, 0x04, 0x80, 0xa6, 0x1f, 0x8f, 0xe8, 0xcb, 0xb0,
	0x33, 0x61, 0x5f, 0x7f, 0xda, 0x3e, 0x9c, 0xf4, 0x72, 0x19, 0x72, 0xdc, 0xa1, 0x98, 0x55, 0x52,
	0xd0, 0x0a, 0xc0, 0x11, 0x6e, 0x3c, 0xd5, 0xc4, 0x77, 0x26, 0x8e, 0x8e, 0xb3, 0x1b, 0xa7, 0x87,
	0x7a, 0x8a, 0x31, 0xf7, 0x84, 0x01, 0x8c, 0xf6, 0x39, 0xb4, 0x05, 0xeb, 0x27, 0xad, 0xef, 0x68,
	0x27, 0xad, 0xe3, 0x76, 0xfb, 0x70, 0xc2, 0xc2, 0x03, 0x58, 0x3e, 0xd3, 0xf0, 0x73, 0xfd, 0xd9,
	0x29, 0x17, 0x79, 0x5e, 0x52, 0x50, 0x01, 0x96, 0x86, 0x5f, 0x99, 0xf8, 0xab, 0xd3, 0xee, 0x76,
	0x5b, 0x07, 0x27, 0x5a, 0x69, 0x0e, 0x01, 0x64, 0x25, 0x67, 0x1e, 0x15, 0x21, 0xcf, 0x55, 0x25,
	0x61, 0x61, 0xff, 0x2f, 0x0a, 0x54, 0x78, 0xcf, 0x6b, 0xa5, 0x2a, 0xa7, 0x4b, 0x82, 0x4b, 0xc7,
	0x24, 0xe8, 0xf7, 0x0a, 0x2c, 0x8f, 0xb5, 0x5b, 0x34, 0xc3, 0xe6, 0x78, 0xd5, 0x1f, 0x74, 0x5b,
	0x8f, 0x12, 0xfd, 0xd4, 0x3f, 0x87, 0xd5, 0x76, 0xf2, 0xcf, 0xa1, 0xfa, 0x95, 0x9f, 0xff, 0xf3,
	0xbf, 0x9f, 0x67, 0x1e, 0xab, 0x5b, 0x93, 0x7f, 0x66, 0x86, 0x75, 0xd9, 0x7f, 0x49, 0x5d, 0x79,
	0x72, 0xf0, 0xe7, 0x0c, 0x7c, 0xd5, 0xa4, 0x83, 0x5b, 0xfb, 0x72, 0xf0, 0xe8, 0xba, 0x10, 0x3b,
	0x71, 0x99, 0x76, 0x94, 0xef, 0x3f, 0x97, 0x50, 0x36, 0x8d, 0xdb, 0x73, 0x95, 0x06, 0x76, 0xcd,
	0x26, 0x1e, 0x2f, 0xe2, 0x9a, 0x60, 0x19, 0xbe, 0x13, 0xde, 0xfc, 0xd7, 0xeb, 0x47, 0x53, 0xbc,
	0x3f, 0x65, 0x76, 0x3f, 0x15, 0xd8, 0x4d, 0xee, 0xe6, 0x94, 0x27, 0xd5, 0xb3, 0xbd, 0xce, 0xde,
	0x41, 0xac, 0xfc, 0x8f, 0x44, 0xf4, 0x05, 0x17, 0x7d, 0x31, 0x25, 0xfa, 0xe2, 0x2c, 0xb1, 0xf3,
	0xbf, 0xcc, 0x7b, 0x42, 0xb4, 0x5e, 0xe7, 0xb2, 0xf5, 0xfa, 0x94, 0x70, 0xbd, 0x3e, 0x94, 0x3e,
	0xcf, 0xf2, 0x48, 0xbe, 0xfe, 0x45, 0x00, 0x00, 0x00, 0xff, 0xff, 0x6b, 0x30, 0x3a, 0x70, 0x43,
	0x16, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// VideoIntelligenceServiceClient is the client API for VideoIntelligenceService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type VideoIntelligenceServiceClient interface {
	// Performs asynchronous video annotation. Progress and results can be
	// retrieved through the `google.longrunning.Operations` interface.
	// `Operation.metadata` contains `AnnotateVideoProgress` (progress).
	// `Operation.response` contains `AnnotateVideoResponse` (results).
	AnnotateVideo(ctx context.Context, in *AnnotateVideoRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
}

type videoIntelligenceServiceClient struct {
	cc *grpc.ClientConn
}

func NewVideoIntelligenceServiceClient(cc *grpc.ClientConn) VideoIntelligenceServiceClient {
	return &videoIntelligenceServiceClient{cc}
}

func (c *videoIntelligenceServiceClient) AnnotateVideo(ctx context.Context, in *AnnotateVideoRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.videointelligence.v1p1beta1.VideoIntelligenceService/AnnotateVideo", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// VideoIntelligenceServiceServer is the server API for VideoIntelligenceService service.
type VideoIntelligenceServiceServer interface {
	// Performs asynchronous video annotation. Progress and results can be
	// retrieved through the `google.longrunning.Operations` interface.
	// `Operation.metadata` contains `AnnotateVideoProgress` (progress).
	// `Operation.response` contains `AnnotateVideoResponse` (results).
	AnnotateVideo(context.Context, *AnnotateVideoRequest) (*longrunning.Operation, error)
}

// UnimplementedVideoIntelligenceServiceServer can be embedded to have forward compatible implementations.
type UnimplementedVideoIntelligenceServiceServer struct {
}

func (*UnimplementedVideoIntelligenceServiceServer) AnnotateVideo(ctx context.Context, req *AnnotateVideoRequest) (*longrunning.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method AnnotateVideo not implemented")
}

func RegisterVideoIntelligenceServiceServer(s *grpc.Server, srv VideoIntelligenceServiceServer) {
	s.RegisterService(&_VideoIntelligenceService_serviceDesc, srv)
}

func _VideoIntelligenceService_AnnotateVideo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AnnotateVideoRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoIntelligenceServiceServer).AnnotateVideo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.videointelligence.v1p1beta1.VideoIntelligenceService/AnnotateVideo",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoIntelligenceServiceServer).AnnotateVideo(ctx, req.(*AnnotateVideoRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _VideoIntelligenceService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.videointelligence.v1p1beta1.VideoIntelligenceService",
	HandlerType: (*VideoIntelligenceServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "AnnotateVideo",
			Handler:    _VideoIntelligenceService_AnnotateVideo_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/videointelligence/v1p1beta1/video_intelligence.proto",
}
