// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/bigquery/storage/v1beta2/stream.proto

package storage

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Data format for input or output data.
type DataFormat int32

const (
	DataFormat_DATA_FORMAT_UNSPECIFIED DataFormat = 0
	// Avro is a standard open source row based file format.
	// See https://avro.apache.org/ for more details.
	DataFormat_AVRO DataFormat = 1
	// Arrow is a standard open source column-based message format.
	// See https://arrow.apache.org/ for more details.
	DataFormat_ARROW DataFormat = 2
)

var DataFormat_name = map[int32]string{
	0: "DATA_FORMAT_UNSPECIFIED",
	1: "AVRO",
	2: "ARROW",
}

var DataFormat_value = map[string]int32{
	"DATA_FORMAT_UNSPECIFIED": 0,
	"AVRO":                    1,
	"ARROW":                   2,
}

func (x DataFormat) String() string {
	return proto.EnumName(DataFormat_name, int32(x))
}

func (DataFormat) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_c242eb28e47086d8, []int{0}
}

// Information about the ReadSession.
type ReadSession struct {
	// Output only. Unique identifier for the session, in the form
	// `projects/{project_id}/locations/{location}/sessions/{session_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Time at which the session becomes invalid. After this time,
	// subsequent requests to read this Session will return errors. The
	// expire_time is automatically assigned and currently cannot be specified or
	// updated.
	ExpireTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=expire_time,json=expireTime,proto3" json:"expire_time,omitempty"`
	// Immutable. Data format of the output data. Behavior defaults to Apache
	// Avro.
	DataFormat DataFormat `protobuf:"varint,3,opt,name=data_format,json=dataFormat,proto3,enum=google.cloud.bigquery.storage.v1beta2.DataFormat" json:"data_format,omitempty"`
	// The schema for the read. If read_options.selected_fields is set, the
	// schema may be different from the table schema as it will only contain
	// the selected fields.
	//
	// Types that are valid to be assigned to Schema:
	//	*ReadSession_AvroSchema
	//	*ReadSession_ArrowSchema
	Schema isReadSession_Schema `protobuf_oneof:"schema"`
	// Table that this ReadSession is reading from, in the form
	// `projects/{project_id}/datasets/{dataset_id}/tables/{table_id}
	Table string `protobuf:"bytes,6,opt,name=table,proto3" json:"table,omitempty"`
	// Optional. Any modifiers which are applied when reading from the specified
	// table.
	TableModifiers *ReadSession_TableModifiers `protobuf:"bytes,7,opt,name=table_modifiers,json=tableModifiers,proto3" json:"table_modifiers,omitempty"`
	// Optional. Read options for this session (e.g. column selection, filters).
	ReadOptions *ReadSession_TableReadOptions `protobuf:"bytes,8,opt,name=read_options,json=readOptions,proto3" json:"read_options,omitempty"`
	// Output only. A list of streams created with the session.
	//
	// At least one stream is created with the session. In the future, larger
	// request_stream_count values *may* result in this list being unpopulated,
	// in that case, the user will need to use a List method to get the streams
	// instead, which is not yet available.
	Streams              []*ReadStream `protobuf:"bytes,10,rep,name=streams,proto3" json:"streams,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *ReadSession) Reset()         { *m = ReadSession{} }
func (m *ReadSession) String() string { return proto.CompactTextString(m) }
func (*ReadSession) ProtoMessage()    {}
func (*ReadSession) Descriptor() ([]byte, []int) {
	return fileDescriptor_c242eb28e47086d8, []int{0}
}

func (m *ReadSession) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReadSession.Unmarshal(m, b)
}
func (m *ReadSession) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReadSession.Marshal(b, m, deterministic)
}
func (m *ReadSession) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReadSession.Merge(m, src)
}
func (m *ReadSession) XXX_Size() int {
	return xxx_messageInfo_ReadSession.Size(m)
}
func (m *ReadSession) XXX_DiscardUnknown() {
	xxx_messageInfo_ReadSession.DiscardUnknown(m)
}

var xxx_messageInfo_ReadSession proto.InternalMessageInfo

func (m *ReadSession) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ReadSession) GetExpireTime() *timestamp.Timestamp {
	if m != nil {
		return m.ExpireTime
	}
	return nil
}

func (m *ReadSession) GetDataFormat() DataFormat {
	if m != nil {
		return m.DataFormat
	}
	return DataFormat_DATA_FORMAT_UNSPECIFIED
}

type isReadSession_Schema interface {
	isReadSession_Schema()
}

type ReadSession_AvroSchema struct {
	AvroSchema *AvroSchema `protobuf:"bytes,4,opt,name=avro_schema,json=avroSchema,proto3,oneof"`
}

type ReadSession_ArrowSchema struct {
	ArrowSchema *ArrowSchema `protobuf:"bytes,5,opt,name=arrow_schema,json=arrowSchema,proto3,oneof"`
}

func (*ReadSession_AvroSchema) isReadSession_Schema() {}

func (*ReadSession_ArrowSchema) isReadSession_Schema() {}

func (m *ReadSession) GetSchema() isReadSession_Schema {
	if m != nil {
		return m.Schema
	}
	return nil
}

func (m *ReadSession) GetAvroSchema() *AvroSchema {
	if x, ok := m.GetSchema().(*ReadSession_AvroSchema); ok {
		return x.AvroSchema
	}
	return nil
}

func (m *ReadSession) GetArrowSchema() *ArrowSchema {
	if x, ok := m.GetSchema().(*ReadSession_ArrowSchema); ok {
		return x.ArrowSchema
	}
	return nil
}

func (m *ReadSession) GetTable() string {
	if m != nil {
		return m.Table
	}
	return ""
}

func (m *ReadSession) GetTableModifiers() *ReadSession_TableModifiers {
	if m != nil {
		return m.TableModifiers
	}
	return nil
}

func (m *ReadSession) GetReadOptions() *ReadSession_TableReadOptions {
	if m != nil {
		return m.ReadOptions
	}
	return nil
}

func (m *ReadSession) GetStreams() []*ReadStream {
	if m != nil {
		return m.Streams
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ReadSession) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ReadSession_AvroSchema)(nil),
		(*ReadSession_ArrowSchema)(nil),
	}
}

// Additional attributes when reading a table.
type ReadSession_TableModifiers struct {
	// The snapshot time of the table. If not set, interpreted as now.
	SnapshotTime         *timestamp.Timestamp `protobuf:"bytes,1,opt,name=snapshot_time,json=snapshotTime,proto3" json:"snapshot_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *ReadSession_TableModifiers) Reset()         { *m = ReadSession_TableModifiers{} }
func (m *ReadSession_TableModifiers) String() string { return proto.CompactTextString(m) }
func (*ReadSession_TableModifiers) ProtoMessage()    {}
func (*ReadSession_TableModifiers) Descriptor() ([]byte, []int) {
	return fileDescriptor_c242eb28e47086d8, []int{0, 0}
}

func (m *ReadSession_TableModifiers) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReadSession_TableModifiers.Unmarshal(m, b)
}
func (m *ReadSession_TableModifiers) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReadSession_TableModifiers.Marshal(b, m, deterministic)
}
func (m *ReadSession_TableModifiers) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReadSession_TableModifiers.Merge(m, src)
}
func (m *ReadSession_TableModifiers) XXX_Size() int {
	return xxx_messageInfo_ReadSession_TableModifiers.Size(m)
}
func (m *ReadSession_TableModifiers) XXX_DiscardUnknown() {
	xxx_messageInfo_ReadSession_TableModifiers.DiscardUnknown(m)
}

var xxx_messageInfo_ReadSession_TableModifiers proto.InternalMessageInfo

func (m *ReadSession_TableModifiers) GetSnapshotTime() *timestamp.Timestamp {
	if m != nil {
		return m.SnapshotTime
	}
	return nil
}

// Options dictating how we read a table.
type ReadSession_TableReadOptions struct {
	// Names of the fields in the table that should be read. If empty, all
	// fields will be read. If the specified field is a nested field, all
	// the sub-fields in the field will be selected. The output field order is
	// unrelated to the order of fields in selected_fields.
	SelectedFields []string `protobuf:"bytes,1,rep,name=selected_fields,json=selectedFields,proto3" json:"selected_fields,omitempty"`
	// SQL text filtering statement, similar to a WHERE clause in a query.
	// Currently, only a single predicate that is a comparison between a column
	// and a constant value is supported. Aggregates are not supported.
	//
	// Examples: "int_field > 5"
	//           "date_field = CAST('2014-9-27' as DATE)"
	//           "nullable_field is not NULL"
	//           "st_equals(geo_field, st_geofromtext("POINT(2, 2)"))"
	//           "numeric_field BETWEEN 1.0 AND 5.0"
	RowRestriction       string   `protobuf:"bytes,2,opt,name=row_restriction,json=rowRestriction,proto3" json:"row_restriction,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ReadSession_TableReadOptions) Reset()         { *m = ReadSession_TableReadOptions{} }
func (m *ReadSession_TableReadOptions) String() string { return proto.CompactTextString(m) }
func (*ReadSession_TableReadOptions) ProtoMessage()    {}
func (*ReadSession_TableReadOptions) Descriptor() ([]byte, []int) {
	return fileDescriptor_c242eb28e47086d8, []int{0, 1}
}

func (m *ReadSession_TableReadOptions) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReadSession_TableReadOptions.Unmarshal(m, b)
}
func (m *ReadSession_TableReadOptions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReadSession_TableReadOptions.Marshal(b, m, deterministic)
}
func (m *ReadSession_TableReadOptions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReadSession_TableReadOptions.Merge(m, src)
}
func (m *ReadSession_TableReadOptions) XXX_Size() int {
	return xxx_messageInfo_ReadSession_TableReadOptions.Size(m)
}
func (m *ReadSession_TableReadOptions) XXX_DiscardUnknown() {
	xxx_messageInfo_ReadSession_TableReadOptions.DiscardUnknown(m)
}

var xxx_messageInfo_ReadSession_TableReadOptions proto.InternalMessageInfo

func (m *ReadSession_TableReadOptions) GetSelectedFields() []string {
	if m != nil {
		return m.SelectedFields
	}
	return nil
}

func (m *ReadSession_TableReadOptions) GetRowRestriction() string {
	if m != nil {
		return m.RowRestriction
	}
	return ""
}

// Information about a single stream that gets data out of the storage system.
// Most of the information about `ReadStream` instances is aggregated, making
// `ReadStream` lightweight.
type ReadStream struct {
	// Output only. Name of the stream, in the form
	// `projects/{project_id}/locations/{location}/sessions/{session_id}/streams/{stream_id}`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ReadStream) Reset()         { *m = ReadStream{} }
func (m *ReadStream) String() string { return proto.CompactTextString(m) }
func (*ReadStream) ProtoMessage()    {}
func (*ReadStream) Descriptor() ([]byte, []int) {
	return fileDescriptor_c242eb28e47086d8, []int{1}
}

func (m *ReadStream) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReadStream.Unmarshal(m, b)
}
func (m *ReadStream) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReadStream.Marshal(b, m, deterministic)
}
func (m *ReadStream) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReadStream.Merge(m, src)
}
func (m *ReadStream) XXX_Size() int {
	return xxx_messageInfo_ReadStream.Size(m)
}
func (m *ReadStream) XXX_DiscardUnknown() {
	xxx_messageInfo_ReadStream.DiscardUnknown(m)
}

var xxx_messageInfo_ReadStream proto.InternalMessageInfo

func (m *ReadStream) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func init() {
	proto.RegisterEnum("google.cloud.bigquery.storage.v1beta2.DataFormat", DataFormat_name, DataFormat_value)
	proto.RegisterType((*ReadSession)(nil), "google.cloud.bigquery.storage.v1beta2.ReadSession")
	proto.RegisterType((*ReadSession_TableModifiers)(nil), "google.cloud.bigquery.storage.v1beta2.ReadSession.TableModifiers")
	proto.RegisterType((*ReadSession_TableReadOptions)(nil), "google.cloud.bigquery.storage.v1beta2.ReadSession.TableReadOptions")
	proto.RegisterType((*ReadStream)(nil), "google.cloud.bigquery.storage.v1beta2.ReadStream")
}

func init() {
	proto.RegisterFile("google/cloud/bigquery/storage/v1beta2/stream.proto", fileDescriptor_c242eb28e47086d8)
}

var fileDescriptor_c242eb28e47086d8 = []byte{
	// 697 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x94, 0x41, 0x4f, 0xdb, 0x48,
	0x14, 0xc7, 0x31, 0x21, 0x40, 0x9e, 0xd9, 0x10, 0x59, 0x2b, 0xe1, 0xcd, 0x1e, 0x36, 0x42, 0x5a,
	0x6d, 0xe0, 0xe0, 0x59, 0xb2, 0x37, 0x56, 0xda, 0xad, 0x03, 0x44, 0x45, 0x2d, 0x4d, 0x6a, 0xd2,
	0xa2, 0x56, 0x95, 0xac, 0x89, 0x3d, 0x71, 0x5c, 0xe2, 0x8c, 0x3b, 0x33, 0x09, 0x54, 0x51, 0xee,
	0xfd, 0x1c, 0xfd, 0x64, 0x3d, 0x73, 0xea, 0x47, 0xa8, 0x66, 0xc6, 0x26, 0x50, 0xa9, 0xc2, 0xe5,
	0x36, 0xf3, 0xf7, 0xfc, 0xfe, 0xef, 0xbd, 0x99, 0xf7, 0x0c, 0xad, 0x88, 0xd2, 0x68, 0x4c, 0x50,
	0x30, 0xa6, 0xd3, 0x10, 0x0d, 0xe2, 0xe8, 0xc3, 0x94, 0xb0, 0x8f, 0x88, 0x0b, 0xca, 0x70, 0x44,
	0xd0, 0xec, 0x60, 0x40, 0x04, 0x6e, 0x21, 0x2e, 0x18, 0xc1, 0x89, 0x93, 0x32, 0x2a, 0xa8, 0xf5,
	0xa7, 0x66, 0x1c, 0xc5, 0x38, 0x39, 0xe3, 0x64, 0x8c, 0x93, 0x31, 0xf5, 0x3f, 0x32, 0x6b, 0x9c,
	0xc6, 0x68, 0x18, 0x93, 0x71, 0xe8, 0x0f, 0xc8, 0x08, 0xcf, 0x62, 0xca, 0xb4, 0x4f, 0xfd, 0xb7,
	0x3b, 0x07, 0x18, 0xe1, 0x74, 0xca, 0x02, 0x92, 0x7d, 0x3a, 0x28, 0x96, 0x16, 0x66, 0x8c, 0x5e,
	0x65, 0xc8, 0xdf, 0x05, 0x91, 0x19, 0xa3, 0x19, 0x91, 0x27, 0xa8, 0x76, 0x83, 0xe9, 0x10, 0x89,
	0x38, 0x21, 0x5c, 0xe0, 0x24, 0xd5, 0x07, 0x76, 0xbf, 0x6e, 0x80, 0xe9, 0x11, 0x1c, 0x9e, 0x13,
	0xce, 0x63, 0x3a, 0xb1, 0x76, 0x60, 0x6d, 0x82, 0x13, 0x62, 0x1b, 0x0d, 0xa3, 0x59, 0x69, 0x97,
	0xbe, 0xb8, 0x25, 0x4f, 0x09, 0xd6, 0x13, 0x30, 0xc9, 0x75, 0x1a, 0x33, 0xe2, 0x4b, 0x0b, 0x7b,
	0xb5, 0x61, 0x34, 0xcd, 0x56, 0xdd, 0xc9, 0xee, 0x29, 0xf7, 0x77, 0xfa, 0xb9, 0xbf, 0x66, 0x41,
	0x33, 0x52, 0xb5, 0x2e, 0xc0, 0x0c, 0xb1, 0xc0, 0xfe, 0x90, 0xb2, 0x04, 0x0b, 0xbb, 0xd4, 0x30,
	0x9a, 0xd5, 0xd6, 0x81, 0x53, 0xe8, 0xa6, 0x9d, 0x63, 0x2c, 0x70, 0x47, 0x81, 0xd2, 0xb8, 0xec,
	0x41, 0x78, 0x2b, 0x58, 0x6f, 0xc0, 0x94, 0x25, 0xfb, 0x3c, 0x18, 0x91, 0x04, 0xdb, 0x6b, 0x2a,
	0xb5, 0xa2, 0xc6, 0xee, 0x8c, 0xd1, 0x73, 0x05, 0xaa, 0x8c, 0x9f, 0xae, 0x78, 0x80, 0x6f, 0x25,
	0xeb, 0x1d, 0x6c, 0xa9, 0x07, 0xc8, 0xbd, 0xcb, 0xca, 0xbb, 0x55, 0xd4, 0x5b, 0xa2, 0xf7, 0xcd,
	0x4d, 0xbc, 0xd4, 0xac, 0x5f, 0xa1, 0x2c, 0xf0, 0x60, 0x4c, 0xec, 0x75, 0x79, 0xdb, 0x9e, 0xde,
	0x58, 0x14, 0xb6, 0xd5, 0xc2, 0x4f, 0x68, 0x18, 0x0f, 0x63, 0xc2, 0xb8, 0xbd, 0xa1, 0xc2, 0xba,
	0x05, 0xc3, 0xde, 0x79, 0x4f, 0xa7, 0x2f, 0x9d, 0xce, 0x72, 0x23, 0x99, 0x85, 0xe1, 0x55, 0xc5,
	0x3d, 0xd1, 0xba, 0x84, 0x2d, 0x46, 0x70, 0xe8, 0xd3, 0x54, 0xc4, 0x74, 0xc2, 0xed, 0x4d, 0x15,
	0xed, 0xe8, 0xb1, 0xd1, 0xa4, 0xd0, 0xd5, 0x56, 0x3a, 0x9e, 0xc9, 0x96, 0x8a, 0xd5, 0x83, 0x0d,
	0x3d, 0x69, 0xdc, 0x86, 0x46, 0xe9, 0x27, 0x1e, 0x4a, 0xc5, 0x51, 0xa4, 0x6e, 0xad, 0xdc, 0xa6,
	0xfe, 0x12, 0xaa, 0xf7, 0xab, 0xb4, 0xfe, 0x87, 0x5f, 0xf8, 0x04, 0xa7, 0x7c, 0x44, 0x85, 0xee,
	0x56, 0xe3, 0xa1, 0x6e, 0xf5, 0xb6, 0x72, 0x40, 0x4a, 0xf5, 0x10, 0x6a, 0xdf, 0x97, 0x62, 0xfd,
	0x05, 0xdb, 0x9c, 0x8c, 0x49, 0x20, 0x48, 0xe8, 0xab, 0x59, 0xe7, 0xb6, 0xd1, 0x28, 0x35, 0x2b,
	0x5e, 0x35, 0x97, 0x3b, 0x4a, 0x95, 0x07, 0x65, 0xc7, 0x30, 0xc2, 0x05, 0x8b, 0x03, 0x09, 0xab,
	0x69, 0xa9, 0x78, 0x55, 0x46, 0xaf, 0xbc, 0xa5, 0x7a, 0x78, 0x79, 0xe3, 0x8e, 0x60, 0x3f, 0x2f,
	0x38, 0xaf, 0x57, 0xe7, 0x88, 0xd3, 0x98, 0x3b, 0x01, 0x4d, 0xd0, 0xdd, 0xe1, 0x3c, 0x4c, 0x19,
	0x7d, 0x4f, 0x02, 0xc1, 0xd1, 0x3c, 0x5b, 0x2d, 0xd0, 0x98, 0x06, 0x58, 0x25, 0x88, 0xe6, 0xf9,
	0x72, 0x81, 0xb8, 0x06, 0x38, 0x9a, 0x67, 0xab, 0x45, 0x7b, 0x13, 0xd6, 0x75, 0x0f, 0xef, 0x7e,
	0x36, 0x00, 0x96, 0x97, 0xf9, 0xc3, 0x89, 0x3f, 0x9c, 0xdf, 0xb8, 0xd7, 0xb0, 0x57, 0x24, 0x3d,
	0x6d, 0xf4, 0xec, 0xf1, 0xd9, 0x65, 0x3f, 0x5f, 0xa9, 0xa8, 0xc5, 0x62, 0xff, 0x3f, 0x80, 0xe5,
	0xc8, 0x5b, 0xbf, 0xc3, 0xce, 0xb1, 0xdb, 0x77, 0xfd, 0x4e, 0xd7, 0x3b, 0x73, 0xfb, 0xfe, 0xab,
	0x17, 0xe7, 0xbd, 0x93, 0xa3, 0xd3, 0xce, 0xe9, 0xc9, 0x71, 0x6d, 0xc5, 0xda, 0x84, 0x35, 0xf7,
	0xb5, 0xd7, 0xad, 0x19, 0x56, 0x05, 0xca, 0xae, 0xe7, 0x75, 0x2f, 0x6a, 0xab, 0xed, 0x4f, 0x06,
	0xec, 0x05, 0x34, 0x29, 0xd6, 0x5b, 0x6d, 0x53, 0x97, 0xd0, 0x93, 0x7d, 0xd1, 0x33, 0xde, 0x3e,
	0xcf, 0xa8, 0x88, 0x8e, 0xf1, 0x24, 0x72, 0x28, 0x8b, 0x50, 0x44, 0x26, 0xaa, 0x6b, 0xd0, 0xb2,
	0xfe, 0x07, 0x7e, 0xc3, 0xff, 0x66, 0xfb, 0xc1, 0xba, 0x02, 0xff, 0xf9, 0x16, 0x00, 0x00, 0xff,
	0xff, 0xc9, 0xa8, 0xe6, 0xe9, 0x88, 0x06, 0x00, 0x00,
}
