// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/datacatalog/v1beta1/datacatalog.proto

package datacatalog

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	v1 "google.golang.org/genproto/googleapis/iam/v1"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Entry resources in Data Catalog can be of different types e.g. a BigQuery
// Table entry is of type `TABLE`. This enum describes all the possible types
// Data Catalog contains.
type EntryType int32

const (
	// Default unknown type
	EntryType_ENTRY_TYPE_UNSPECIFIED EntryType = 0
	// Output only. The type of entry that has a GoogleSQL schema, including
	// logical views.
	EntryType_TABLE EntryType = 2
	// Output only. An entry type which is used for streaming entries. Example:
	// Cloud Pub/Sub topic.
	EntryType_DATA_STREAM EntryType = 3
	// Alpha feature. An entry type which is a set of files or objects. Example:
	// Cloud Storage fileset.
	EntryType_FILESET EntryType = 4
)

var EntryType_name = map[int32]string{
	0: "ENTRY_TYPE_UNSPECIFIED",
	2: "TABLE",
	3: "DATA_STREAM",
	4: "FILESET",
}

var EntryType_value = map[string]int32{
	"ENTRY_TYPE_UNSPECIFIED": 0,
	"TABLE":                  2,
	"DATA_STREAM":            3,
	"FILESET":                4,
}

func (x EntryType) String() string {
	return proto.EnumName(EntryType_name, int32(x))
}

func (EntryType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_2054d97e7b16f897, []int{0}
}

// Request message for
// [SearchCatalog][google.cloud.datacatalog.v1beta1.DataCatalog.SearchCatalog].
type SearchCatalogRequest struct {
	// Required. The scope of this search request.
	Scope *SearchCatalogRequest_Scope `protobuf:"bytes,6,opt,name=scope,proto3" json:"scope,omitempty"`
	// Required. The query string in search query syntax. The query must be non-empty.
	//
	// Query strings can be simple as "x" or more qualified as:
	//
	// * name:x
	// * column:x
	// * description:y
	//
	// Note: Query tokens need to have a minimum of 3 characters for substring
	// matching to work correctly. See [Data Catalog Search
	// Syntax](/data-catalog/docs/how-to/search-reference) for more information.
	Query string `protobuf:"bytes,1,opt,name=query,proto3" json:"query,omitempty"`
	// Number of results in the search page. If <=0 then defaults to 10. Max limit
	// for page_size is 1000. Throws an invalid argument for page_size > 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. Pagination token returned in an earlier
	// [SearchCatalogResponse.next_page_token][google.cloud.datacatalog.v1beta1.SearchCatalogResponse.next_page_token], which
	// indicates that this is a continuation of a prior
	// [SearchCatalogRequest][google.cloud.datacatalog.v1beta1.DataCatalog.SearchCatalog]
	// call, and that the system should return the next page of data. If empty,
	// the first page is returned.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Specifies the ordering of results, currently supported case-sensitive
	// choices are:
	//
	//   * `relevance`, only supports desecending
	//   * `last_access_timestamp [asc|desc]`, defaults to descending if not
	//     specified
	//   * `last_modified_timestamp [asc|desc]`, defaults to descending if not
	//     specified
	//
	// If not specified, defaults to `relevance` descending.
	OrderBy              string   `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SearchCatalogRequest) Reset()         { *m = SearchCatalogRequest{} }
func (m *SearchCatalogRequest) String() string { return proto.CompactTextString(m) }
func (*SearchCatalogRequest) ProtoMessage()    {}
func (*SearchCatalogRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2054d97e7b16f897, []int{0}
}

func (m *SearchCatalogRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SearchCatalogRequest.Unmarshal(m, b)
}
func (m *SearchCatalogRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SearchCatalogRequest.Marshal(b, m, deterministic)
}
func (m *SearchCatalogRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchCatalogRequest.Merge(m, src)
}
func (m *SearchCatalogRequest) XXX_Size() int {
	return xxx_messageInfo_SearchCatalogRequest.Size(m)
}
func (m *SearchCatalogRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchCatalogRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SearchCatalogRequest proto.InternalMessageInfo

func (m *SearchCatalogRequest) GetScope() *SearchCatalogRequest_Scope {
	if m != nil {
		return m.Scope
	}
	return nil
}

func (m *SearchCatalogRequest) GetQuery() string {
	if m != nil {
		return m.Query
	}
	return ""
}

func (m *SearchCatalogRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *SearchCatalogRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *SearchCatalogRequest) GetOrderBy() string {
	if m != nil {
		return m.OrderBy
	}
	return ""
}

type SearchCatalogRequest_Scope struct {
	// Data Catalog tries to automatically choose the right corpus of data to
	// search through. You can ensure an organization is included by adding it
	// to `include_org_ids`. You can ensure a project's org is included with
	// `include_project_ids`. You must specify at least one organization
	// using `include_org_ids` or `include_project_ids` in all search requests.
	//
	// List of organization IDs to search within. To find your organization ID,
	// follow instructions in
	// https://cloud.google.com/resource-manager/docs/creating-managing-organization.
	IncludeOrgIds []string `protobuf:"bytes,2,rep,name=include_org_ids,json=includeOrgIds,proto3" json:"include_org_ids,omitempty"`
	// List of project IDs to search within. To learn more about the
	// distinction between project names/IDs/numbers, go to
	// https://cloud.google.com/docs/overview/#projects.
	IncludeProjectIds []string `protobuf:"bytes,3,rep,name=include_project_ids,json=includeProjectIds,proto3" json:"include_project_ids,omitempty"`
	// If `true`, include Google Cloud Platform (GCP) public datasets in the
	// search results. Info on GCP public datasets is available at
	// https://cloud.google.com/public-datasets/. By default, GCP public
	// datasets are excluded.
	IncludeGcpPublicDatasets bool     `protobuf:"varint,7,opt,name=include_gcp_public_datasets,json=includeGcpPublicDatasets,proto3" json:"include_gcp_public_datasets,omitempty"`
	XXX_NoUnkeyedLiteral     struct{} `json:"-"`
	XXX_unrecognized         []byte   `json:"-"`
	XXX_sizecache            int32    `json:"-"`
}

func (m *SearchCatalogRequest_Scope) Reset()         { *m = SearchCatalogRequest_Scope{} }
func (m *SearchCatalogRequest_Scope) String() string { return proto.CompactTextString(m) }
func (*SearchCatalogRequest_Scope) ProtoMessage()    {}
func (*SearchCatalogRequest_Scope) Descriptor() ([]byte, []int) {
	return fileDescriptor_2054d97e7b16f897, []int{0, 0}
}

func (m *SearchCatalogRequest_Scope) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SearchCatalogRequest_Scope.Unmarshal(m, b)
}
func (m *SearchCatalogRequest_Scope) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SearchCatalogRequest_Scope.Marshal(b, m, deterministic)
}
func (m *SearchCatalogRequest_Scope) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchCatalogRequest_Scope.Merge(m, src)
}
func (m *SearchCatalogRequest_Scope) XXX_Size() int {
	return xxx_messageInfo_SearchCatalogRequest_Scope.Size(m)
}
func (m *SearchCatalogRequest_Scope) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchCatalogRequest_Scope.DiscardUnknown(m)
}

var xxx_messageInfo_SearchCatalogRequest_Scope proto.InternalMessageInfo

func (m *SearchCatalogRequest_Scope) GetIncludeOrgIds() []string {
	if m != nil {
		return m.IncludeOrgIds
	}
	return nil
}

func (m *SearchCatalogRequest_Scope) GetIncludeProjectIds() []string {
	if m != nil {
		return m.IncludeProjectIds
	}
	return nil
}

func (m *SearchCatalogRequest_Scope) GetIncludeGcpPublicDatasets() bool {
	if m != nil {
		return m.IncludeGcpPublicDatasets
	}
	return false
}

// Response message for
// [SearchCatalog][google.cloud.datacatalog.v1beta1.DataCatalog.SearchCatalog].
type SearchCatalogResponse struct {
	// Search results.
	Results []*SearchCatalogResult `protobuf:"bytes,1,rep,name=results,proto3" json:"results,omitempty"`
	// The token that can be used to retrieve the next page of results.
	NextPageToken        string   `protobuf:"bytes,3,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SearchCatalogResponse) Reset()         { *m = SearchCatalogResponse{} }
func (m *SearchCatalogResponse) String() string { return proto.CompactTextString(m) }
func (*SearchCatalogResponse) ProtoMessage()    {}
func (*SearchCatalogResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_2054d97e7b16f897, []int{1}
}

func (m *SearchCatalogResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SearchCatalogResponse.Unmarshal(m, b)
}
func (m *SearchCatalogResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SearchCatalogResponse.Marshal(b, m, deterministic)
}
func (m *SearchCatalogResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchCatalogResponse.Merge(m, src)
}
func (m *SearchCatalogResponse) XXX_Size() int {
	return xxx_messageInfo_SearchCatalogResponse.Size(m)
}
func (m *SearchCatalogResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchCatalogResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SearchCatalogResponse proto.InternalMessageInfo

func (m *SearchCatalogResponse) GetResults() []*SearchCatalogResult {
	if m != nil {
		return m.Results
	}
	return nil
}

func (m *SearchCatalogResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request message for
// [CreateEntryGroup][google.cloud.datacatalog.v1beta1.DataCatalog.CreateEntryGroup].
type CreateEntryGroupRequest struct {
	// Required. The name of the project this entry group is in. Example:
	//
	// * projects/{project_id}/locations/{location}
	//
	// Note that this EntryGroup and its child resources may not actually be
	// stored in the location in this name.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The id of the entry group to create.
	// The id must begin with a letter or underscore, contain only English
	// letters, numbers and underscores, and be at most 64 characters.
	EntryGroupId string `protobuf:"bytes,3,opt,name=entry_group_id,json=entryGroupId,proto3" json:"entry_group_id,omitempty"`
	// The entry group to create. Defaults to an empty entry group.
	EntryGroup           *EntryGroup `protobuf:"bytes,2,opt,name=entry_group,json=entryGroup,proto3" json:"entry_group,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *CreateEntryGroupRequest) Reset()         { *m = CreateEntryGroupRequest{} }
func (m *CreateEntryGroupRequest) String() string { return proto.CompactTextString(m) }
func (*CreateEntryGroupRequest) ProtoMessage()    {}
func (*CreateEntryGroupRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2054d97e7b16f897, []int{2}
}

func (m *CreateEntryGroupRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateEntryGroupRequest.Unmarshal(m, b)
}
func (m *CreateEntryGroupRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateEntryGroupRequest.Marshal(b, m, deterministic)
}
func (m *CreateEntryGroupRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateEntryGroupRequest.Merge(m, src)
}
func (m *CreateEntryGroupRequest) XXX_Size() int {
	return xxx_messageInfo_CreateEntryGroupRequest.Size(m)
}
func (m *CreateEntryGroupRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateEntryGroupRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateEntryGroupRequest proto.InternalMessageInfo

func (m *CreateEntryGroupRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateEntryGroupRequest) GetEntryGroupId() string {
	if m != nil {
		return m.EntryGroupId
	}
	return ""
}

func (m *CreateEntryGroupRequest) GetEntryGroup() *EntryGroup {
	if m != nil {
		return m.EntryGroup
	}
	return nil
}

// Request message for
// [GetEntryGroup][google.cloud.datacatalog.v1beta1.DataCatalog.GetEntryGroup].
type GetEntryGroupRequest struct {
	// Required. The name of the entry group. For example,
	// `projects/{project_id}/locations/{location}/entryGroups/{entry_group_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The fields to return. If not set or empty, all fields are returned.
	ReadMask             *field_mask.FieldMask `protobuf:"bytes,2,opt,name=read_mask,json=readMask,proto3" json:"read_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *GetEntryGroupRequest) Reset()         { *m = GetEntryGroupRequest{} }
func (m *GetEntryGroupRequest) String() string { return proto.CompactTextString(m) }
func (*GetEntryGroupRequest) ProtoMessage()    {}
func (*GetEntryGroupRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2054d97e7b16f897, []int{3}
}

func (m *GetEntryGroupRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetEntryGroupRequest.Unmarshal(m, b)
}
func (m *GetEntryGroupRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetEntryGroupRequest.Marshal(b, m, deterministic)
}
func (m *GetEntryGroupRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetEntryGroupRequest.Merge(m, src)
}
func (m *GetEntryGroupRequest) XXX_Size() int {
	return xxx_messageInfo_GetEntryGroupRequest.Size(m)
}
func (m *GetEntryGroupRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetEntryGroupRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetEntryGroupRequest proto.InternalMessageInfo

func (m *GetEntryGroupRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *GetEntryGroupRequest) GetReadMask() *field_mask.FieldMask {
	if m != nil {
		return m.ReadMask
	}
	return nil
}

// Request message for
// [DeleteEntryGroup][google.cloud.datacatalog.v1beta1.DataCatalog.DeleteEntryGroup].
type DeleteEntryGroupRequest struct {
	// Required. The name of the entry group. For example,
	// `projects/{project_id}/locations/{location}/entryGroups/{entry_group_id}`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteEntryGroupRequest) Reset()         { *m = DeleteEntryGroupRequest{} }
func (m *DeleteEntryGroupRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteEntryGroupRequest) ProtoMessage()    {}
func (*DeleteEntryGroupRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2054d97e7b16f897, []int{4}
}

func (m *DeleteEntryGroupRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteEntryGroupRequest.Unmarshal(m, b)
}
func (m *DeleteEntryGroupRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteEntryGroupRequest.Marshal(b, m, deterministic)
}
func (m *DeleteEntryGroupRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteEntryGroupRequest.Merge(m, src)
}
func (m *DeleteEntryGroupRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteEntryGroupRequest.Size(m)
}
func (m *DeleteEntryGroupRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteEntryGroupRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteEntryGroupRequest proto.InternalMessageInfo

func (m *DeleteEntryGroupRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for
// [CreateEntry][google.cloud.datacatalog.v1beta1.DataCatalog.CreateEntry].
type CreateEntryRequest struct {
	// Required. The name of the entry group this entry is in. Example:
	//
	// * projects/{project_id}/locations/{location}/entryGroups/{entry_group_id}
	//
	// Note that this Entry and its child resources may not actually be stored in
	// the location in this name.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The id of the entry to create.
	EntryId string `protobuf:"bytes,3,opt,name=entry_id,json=entryId,proto3" json:"entry_id,omitempty"`
	// Required. The entry to create.
	Entry                *Entry   `protobuf:"bytes,2,opt,name=entry,proto3" json:"entry,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateEntryRequest) Reset()         { *m = CreateEntryRequest{} }
func (m *CreateEntryRequest) String() string { return proto.CompactTextString(m) }
func (*CreateEntryRequest) ProtoMessage()    {}
func (*CreateEntryRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2054d97e7b16f897, []int{5}
}

func (m *CreateEntryRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateEntryRequest.Unmarshal(m, b)
}
func (m *CreateEntryRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateEntryRequest.Marshal(b, m, deterministic)
}
func (m *CreateEntryRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateEntryRequest.Merge(m, src)
}
func (m *CreateEntryRequest) XXX_Size() int {
	return xxx_messageInfo_CreateEntryRequest.Size(m)
}
func (m *CreateEntryRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateEntryRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateEntryRequest proto.InternalMessageInfo

func (m *CreateEntryRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateEntryRequest) GetEntryId() string {
	if m != nil {
		return m.EntryId
	}
	return ""
}

func (m *CreateEntryRequest) GetEntry() *Entry {
	if m != nil {
		return m.Entry
	}
	return nil
}

// Request message for
// [UpdateEntry][google.cloud.datacatalog.v1beta1.DataCatalog.UpdateEntry].
type UpdateEntryRequest struct {
	// Required. The updated entry. The "name" field must be set.
	Entry *Entry `protobuf:"bytes,1,opt,name=entry,proto3" json:"entry,omitempty"`
	// The fields to update on the entry. If absent or empty, all modifiable
	// fields are updated.
	//
	// The following fields are modifiable:
	// * For entries with type `DATA_STREAM`:
	//    * `schema`
	// * For entries with type `FILESET`
	//    * `schema`
	//    * `display_name`
	//    * `description`
	//    * `gcs_fileset_spec`
	//    * `gcs_fileset_spec.file_patterns`
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateEntryRequest) Reset()         { *m = UpdateEntryRequest{} }
func (m *UpdateEntryRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateEntryRequest) ProtoMessage()    {}
func (*UpdateEntryRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2054d97e7b16f897, []int{6}
}

func (m *UpdateEntryRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateEntryRequest.Unmarshal(m, b)
}
func (m *UpdateEntryRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateEntryRequest.Marshal(b, m, deterministic)
}
func (m *UpdateEntryRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateEntryRequest.Merge(m, src)
}
func (m *UpdateEntryRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateEntryRequest.Size(m)
}
func (m *UpdateEntryRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateEntryRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateEntryRequest proto.InternalMessageInfo

func (m *UpdateEntryRequest) GetEntry() *Entry {
	if m != nil {
		return m.Entry
	}
	return nil
}

func (m *UpdateEntryRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request message for
// [DeleteEntry][google.cloud.datacatalog.v1beta1.DataCatalog.DeleteEntry].
type DeleteEntryRequest struct {
	// Required. The name of the entry. Example:
	//
	// * projects/{project_id}/locations/{location}/entryGroups/{entry_group_id}/entries/{entry_id}
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteEntryRequest) Reset()         { *m = DeleteEntryRequest{} }
func (m *DeleteEntryRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteEntryRequest) ProtoMessage()    {}
func (*DeleteEntryRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2054d97e7b16f897, []int{7}
}

func (m *DeleteEntryRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteEntryRequest.Unmarshal(m, b)
}
func (m *DeleteEntryRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteEntryRequest.Marshal(b, m, deterministic)
}
func (m *DeleteEntryRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteEntryRequest.Merge(m, src)
}
func (m *DeleteEntryRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteEntryRequest.Size(m)
}
func (m *DeleteEntryRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteEntryRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteEntryRequest proto.InternalMessageInfo

func (m *DeleteEntryRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for
// [GetEntry][google.cloud.datacatalog.v1beta1.DataCatalog.GetEntry].
type GetEntryRequest struct {
	// Required. The name of the entry. Example:
	//
	// * projects/{project_id}/locations/{location}/entryGroups/{entry_group_id}/entries/{entry_id}
	//
	// Entry groups are logical groupings of entries. Currently, users cannot
	// create/modify entry groups. They are created by Data Catalog; they include
	// `@bigquery` for all BigQuery entries, and `@pubsub` for all Cloud Pub/Sub
	// entries.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetEntryRequest) Reset()         { *m = GetEntryRequest{} }
func (m *GetEntryRequest) String() string { return proto.CompactTextString(m) }
func (*GetEntryRequest) ProtoMessage()    {}
func (*GetEntryRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2054d97e7b16f897, []int{8}
}

func (m *GetEntryRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetEntryRequest.Unmarshal(m, b)
}
func (m *GetEntryRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetEntryRequest.Marshal(b, m, deterministic)
}
func (m *GetEntryRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetEntryRequest.Merge(m, src)
}
func (m *GetEntryRequest) XXX_Size() int {
	return xxx_messageInfo_GetEntryRequest.Size(m)
}
func (m *GetEntryRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetEntryRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetEntryRequest proto.InternalMessageInfo

func (m *GetEntryRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for
// [LookupEntry][google.cloud.datacatalog.v1beta1.DataCatalog.LookupEntry].
type LookupEntryRequest struct {
	// Required. Represents either the Google Cloud Platform resource or SQL name
	// for a Google Cloud Platform resource.
	//
	// Types that are valid to be assigned to TargetName:
	//	*LookupEntryRequest_LinkedResource
	//	*LookupEntryRequest_SqlResource
	TargetName           isLookupEntryRequest_TargetName `protobuf_oneof:"target_name"`
	XXX_NoUnkeyedLiteral struct{}                        `json:"-"`
	XXX_unrecognized     []byte                          `json:"-"`
	XXX_sizecache        int32                           `json:"-"`
}

func (m *LookupEntryRequest) Reset()         { *m = LookupEntryRequest{} }
func (m *LookupEntryRequest) String() string { return proto.CompactTextString(m) }
func (*LookupEntryRequest) ProtoMessage()    {}
func (*LookupEntryRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2054d97e7b16f897, []int{9}
}

func (m *LookupEntryRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LookupEntryRequest.Unmarshal(m, b)
}
func (m *LookupEntryRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LookupEntryRequest.Marshal(b, m, deterministic)
}
func (m *LookupEntryRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LookupEntryRequest.Merge(m, src)
}
func (m *LookupEntryRequest) XXX_Size() int {
	return xxx_messageInfo_LookupEntryRequest.Size(m)
}
func (m *LookupEntryRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_LookupEntryRequest.DiscardUnknown(m)
}

var xxx_messageInfo_LookupEntryRequest proto.InternalMessageInfo

type isLookupEntryRequest_TargetName interface {
	isLookupEntryRequest_TargetName()
}

type LookupEntryRequest_LinkedResource struct {
	LinkedResource string `protobuf:"bytes,1,opt,name=linked_resource,json=linkedResource,proto3,oneof"`
}

type LookupEntryRequest_SqlResource struct {
	SqlResource string `protobuf:"bytes,3,opt,name=sql_resource,json=sqlResource,proto3,oneof"`
}

func (*LookupEntryRequest_LinkedResource) isLookupEntryRequest_TargetName() {}

func (*LookupEntryRequest_SqlResource) isLookupEntryRequest_TargetName() {}

func (m *LookupEntryRequest) GetTargetName() isLookupEntryRequest_TargetName {
	if m != nil {
		return m.TargetName
	}
	return nil
}

func (m *LookupEntryRequest) GetLinkedResource() string {
	if x, ok := m.GetTargetName().(*LookupEntryRequest_LinkedResource); ok {
		return x.LinkedResource
	}
	return ""
}

func (m *LookupEntryRequest) GetSqlResource() string {
	if x, ok := m.GetTargetName().(*LookupEntryRequest_SqlResource); ok {
		return x.SqlResource
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*LookupEntryRequest) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*LookupEntryRequest_LinkedResource)(nil),
		(*LookupEntryRequest_SqlResource)(nil),
	}
}

// Entry Metadata.
// A Data Catalog Entry resource represents another resource in Google
// Cloud Platform, such as a BigQuery dataset or a Cloud Pub/Sub topic.
// Clients can use the `linked_resource` field in the Entry resource to refer to
// the original resource ID of the source system.
//
// An Entry resource contains resource details, such as its schema. An Entry can
// also be used to attach flexible metadata, such as a
// [Tag][google.cloud.datacatalog.v1beta1.Tag].
type Entry struct {
	// The Data Catalog resource name of the entry in URL format. Example:
	//
	// * projects/{project_id}/locations/{location}/entryGroups/{entry_group_id}/entries/{entry_id}
	//
	// Note that this Entry and its child resources may not actually be stored in
	// the location in this name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The resource this metadata entry refers to.
	//
	// For Google Cloud Platform resources, `linked_resource` is the [full name of
	// the
	// resource](https://cloud.google.com/apis/design/resource_names#full_resource_name).
	// For example, the `linked_resource` for a table resource from BigQuery is:
	//
	// * //bigquery.googleapis.com/projects/projectId/datasets/datasetId/tables/tableId
	LinkedResource string `protobuf:"bytes,9,opt,name=linked_resource,json=linkedResource,proto3" json:"linked_resource,omitempty"`
	// Required. Entry type.
	//
	// Types that are valid to be assigned to EntryType:
	//	*Entry_Type
	EntryType isEntry_EntryType `protobuf_oneof:"entry_type"`
	// Type specification information.
	//
	// Types that are valid to be assigned to TypeSpec:
	//	*Entry_GcsFilesetSpec
	//	*Entry_BigqueryTableSpec
	//	*Entry_BigqueryDateShardedSpec
	TypeSpec isEntry_TypeSpec `protobuf_oneof:"type_spec"`
	// Display information such as title and description. A short name to identify
	// the entry, for example, "Analytics Data - Jan 2011". Default value is an
	// empty string.
	DisplayName string `protobuf:"bytes,3,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Entry description, which can consist of several sentences or paragraphs
	// that describe entry contents. Default value is an empty string.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Schema of the entry. An entry might not have any schema attached to it.
	Schema *Schema `protobuf:"bytes,5,opt,name=schema,proto3" json:"schema,omitempty"`
	// Output only. Timestamps about the underlying Google Cloud Platform
	// resource, not about this Data Catalog Entry.
	SourceSystemTimestamps *SystemTimestamps `protobuf:"bytes,7,opt,name=source_system_timestamps,json=sourceSystemTimestamps,proto3" json:"source_system_timestamps,omitempty"`
	XXX_NoUnkeyedLiteral   struct{}          `json:"-"`
	XXX_unrecognized       []byte            `json:"-"`
	XXX_sizecache          int32             `json:"-"`
}

func (m *Entry) Reset()         { *m = Entry{} }
func (m *Entry) String() string { return proto.CompactTextString(m) }
func (*Entry) ProtoMessage()    {}
func (*Entry) Descriptor() ([]byte, []int) {
	return fileDescriptor_2054d97e7b16f897, []int{10}
}

func (m *Entry) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Entry.Unmarshal(m, b)
}
func (m *Entry) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Entry.Marshal(b, m, deterministic)
}
func (m *Entry) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Entry.Merge(m, src)
}
func (m *Entry) XXX_Size() int {
	return xxx_messageInfo_Entry.Size(m)
}
func (m *Entry) XXX_DiscardUnknown() {
	xxx_messageInfo_Entry.DiscardUnknown(m)
}

var xxx_messageInfo_Entry proto.InternalMessageInfo

func (m *Entry) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Entry) GetLinkedResource() string {
	if m != nil {
		return m.LinkedResource
	}
	return ""
}

type isEntry_EntryType interface {
	isEntry_EntryType()
}

type Entry_Type struct {
	Type EntryType `protobuf:"varint,2,opt,name=type,proto3,enum=google.cloud.datacatalog.v1beta1.EntryType,oneof"`
}

func (*Entry_Type) isEntry_EntryType() {}

func (m *Entry) GetEntryType() isEntry_EntryType {
	if m != nil {
		return m.EntryType
	}
	return nil
}

func (m *Entry) GetType() EntryType {
	if x, ok := m.GetEntryType().(*Entry_Type); ok {
		return x.Type
	}
	return EntryType_ENTRY_TYPE_UNSPECIFIED
}

type isEntry_TypeSpec interface {
	isEntry_TypeSpec()
}

type Entry_GcsFilesetSpec struct {
	GcsFilesetSpec *GcsFilesetSpec `protobuf:"bytes,6,opt,name=gcs_fileset_spec,json=gcsFilesetSpec,proto3,oneof"`
}

type Entry_BigqueryTableSpec struct {
	BigqueryTableSpec *BigQueryTableSpec `protobuf:"bytes,12,opt,name=bigquery_table_spec,json=bigqueryTableSpec,proto3,oneof"`
}

type Entry_BigqueryDateShardedSpec struct {
	BigqueryDateShardedSpec *BigQueryDateShardedSpec `protobuf:"bytes,15,opt,name=bigquery_date_sharded_spec,json=bigqueryDateShardedSpec,proto3,oneof"`
}

func (*Entry_GcsFilesetSpec) isEntry_TypeSpec() {}

func (*Entry_BigqueryTableSpec) isEntry_TypeSpec() {}

func (*Entry_BigqueryDateShardedSpec) isEntry_TypeSpec() {}

func (m *Entry) GetTypeSpec() isEntry_TypeSpec {
	if m != nil {
		return m.TypeSpec
	}
	return nil
}

func (m *Entry) GetGcsFilesetSpec() *GcsFilesetSpec {
	if x, ok := m.GetTypeSpec().(*Entry_GcsFilesetSpec); ok {
		return x.GcsFilesetSpec
	}
	return nil
}

func (m *Entry) GetBigqueryTableSpec() *BigQueryTableSpec {
	if x, ok := m.GetTypeSpec().(*Entry_BigqueryTableSpec); ok {
		return x.BigqueryTableSpec
	}
	return nil
}

func (m *Entry) GetBigqueryDateShardedSpec() *BigQueryDateShardedSpec {
	if x, ok := m.GetTypeSpec().(*Entry_BigqueryDateShardedSpec); ok {
		return x.BigqueryDateShardedSpec
	}
	return nil
}

func (m *Entry) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *Entry) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Entry) GetSchema() *Schema {
	if m != nil {
		return m.Schema
	}
	return nil
}

func (m *Entry) GetSourceSystemTimestamps() *SystemTimestamps {
	if m != nil {
		return m.SourceSystemTimestamps
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Entry) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Entry_Type)(nil),
		(*Entry_GcsFilesetSpec)(nil),
		(*Entry_BigqueryTableSpec)(nil),
		(*Entry_BigqueryDateShardedSpec)(nil),
	}
}

// EntryGroup Metadata.
// An EntryGroup resource represents a logical grouping of zero or more
// Data Catalog [Entry][google.cloud.datacatalog.v1beta1.Entry] resources.
type EntryGroup struct {
	// The resource name of the entry group in URL format. Example:
	//
	// * projects/{project_id}/locations/{location}/entryGroups/{entry_group_id}
	//
	// Note that this EntryGroup and its child resources may not actually be
	// stored in the location in this name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// A short name to identify the entry group, for example,
	// "analytics data - jan 2011". Default value is an empty string.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Entry group description, which can consist of several sentences or
	// paragraphs that describe entry group contents. Default value is an empty
	// string.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. Timestamps about this EntryGroup. Default value is empty timestamps.
	DataCatalogTimestamps *SystemTimestamps `protobuf:"bytes,4,opt,name=data_catalog_timestamps,json=dataCatalogTimestamps,proto3" json:"data_catalog_timestamps,omitempty"`
	XXX_NoUnkeyedLiteral  struct{}          `json:"-"`
	XXX_unrecognized      []byte            `json:"-"`
	XXX_sizecache         int32             `json:"-"`
}

func (m *EntryGroup) Reset()         { *m = EntryGroup{} }
func (m *EntryGroup) String() string { return proto.CompactTextString(m) }
func (*EntryGroup) ProtoMessage()    {}
func (*EntryGroup) Descriptor() ([]byte, []int) {
	return fileDescriptor_2054d97e7b16f897, []int{11}
}

func (m *EntryGroup) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EntryGroup.Unmarshal(m, b)
}
func (m *EntryGroup) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EntryGroup.Marshal(b, m, deterministic)
}
func (m *EntryGroup) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EntryGroup.Merge(m, src)
}
func (m *EntryGroup) XXX_Size() int {
	return xxx_messageInfo_EntryGroup.Size(m)
}
func (m *EntryGroup) XXX_DiscardUnknown() {
	xxx_messageInfo_EntryGroup.DiscardUnknown(m)
}

var xxx_messageInfo_EntryGroup proto.InternalMessageInfo

func (m *EntryGroup) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *EntryGroup) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *EntryGroup) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *EntryGroup) GetDataCatalogTimestamps() *SystemTimestamps {
	if m != nil {
		return m.DataCatalogTimestamps
	}
	return nil
}

// Request message for
// [CreateTagTemplate][google.cloud.datacatalog.v1beta1.DataCatalog.CreateTagTemplate].
type CreateTagTemplateRequest struct {
	// Required. The name of the project and the location this template is in.
	// Example:
	//
	// * projects/{project_id}/locations/{location}
	//
	// TagTemplate and its child resources may not actually be stored in the
	// location in this name.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The id of the tag template to create.
	TagTemplateId string `protobuf:"bytes,3,opt,name=tag_template_id,json=tagTemplateId,proto3" json:"tag_template_id,omitempty"`
	// Required. The tag template to create.
	TagTemplate          *TagTemplate `protobuf:"bytes,2,opt,name=tag_template,json=tagTemplate,proto3" json:"tag_template,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *CreateTagTemplateRequest) Reset()         { *m = CreateTagTemplateRequest{} }
func (m *CreateTagTemplateRequest) String() string { return proto.CompactTextString(m) }
func (*CreateTagTemplateRequest) ProtoMessage()    {}
func (*CreateTagTemplateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2054d97e7b16f897, []int{12}
}

func (m *CreateTagTemplateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateTagTemplateRequest.Unmarshal(m, b)
}
func (m *CreateTagTemplateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateTagTemplateRequest.Marshal(b, m, deterministic)
}
func (m *CreateTagTemplateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateTagTemplateRequest.Merge(m, src)
}
func (m *CreateTagTemplateRequest) XXX_Size() int {
	return xxx_messageInfo_CreateTagTemplateRequest.Size(m)
}
func (m *CreateTagTemplateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateTagTemplateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateTagTemplateRequest proto.InternalMessageInfo

func (m *CreateTagTemplateRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateTagTemplateRequest) GetTagTemplateId() string {
	if m != nil {
		return m.TagTemplateId
	}
	return ""
}

func (m *CreateTagTemplateRequest) GetTagTemplate() *TagTemplate {
	if m != nil {
		return m.TagTemplate
	}
	return nil
}

// Request message for
// [GetTagTemplate][google.cloud.datacatalog.v1beta1.DataCatalog.GetTagTemplate].
type GetTagTemplateRequest struct {
	// Required. The name of the tag template. Example:
	//
	// * projects/{project_id}/locations/{location}/tagTemplates/{tag_template_id}
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetTagTemplateRequest) Reset()         { *m = GetTagTemplateRequest{} }
func (m *GetTagTemplateRequest) String() string { return proto.CompactTextString(m) }
func (*GetTagTemplateRequest) ProtoMessage()    {}
func (*GetTagTemplateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2054d97e7b16f897, []int{13}
}

func (m *GetTagTemplateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetTagTemplateRequest.Unmarshal(m, b)
}
func (m *GetTagTemplateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetTagTemplateRequest.Marshal(b, m, deterministic)
}
func (m *GetTagTemplateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetTagTemplateRequest.Merge(m, src)
}
func (m *GetTagTemplateRequest) XXX_Size() int {
	return xxx_messageInfo_GetTagTemplateRequest.Size(m)
}
func (m *GetTagTemplateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetTagTemplateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetTagTemplateRequest proto.InternalMessageInfo

func (m *GetTagTemplateRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for
// [UpdateTagTemplate][google.cloud.datacatalog.v1beta1.DataCatalog.UpdateTagTemplate].
type UpdateTagTemplateRequest struct {
	// Required. The template to update. The "name" field must be set.
	TagTemplate *TagTemplate `protobuf:"bytes,1,opt,name=tag_template,json=tagTemplate,proto3" json:"tag_template,omitempty"`
	// The field mask specifies the parts of the template to overwrite.
	//
	// Allowed fields:
	//
	//   * `display_name`
	//
	// If absent or empty, all of the allowed fields above will be updated.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateTagTemplateRequest) Reset()         { *m = UpdateTagTemplateRequest{} }
func (m *UpdateTagTemplateRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateTagTemplateRequest) ProtoMessage()    {}
func (*UpdateTagTemplateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2054d97e7b16f897, []int{14}
}

func (m *UpdateTagTemplateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateTagTemplateRequest.Unmarshal(m, b)
}
func (m *UpdateTagTemplateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateTagTemplateRequest.Marshal(b, m, deterministic)
}
func (m *UpdateTagTemplateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateTagTemplateRequest.Merge(m, src)
}
func (m *UpdateTagTemplateRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateTagTemplateRequest.Size(m)
}
func (m *UpdateTagTemplateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateTagTemplateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateTagTemplateRequest proto.InternalMessageInfo

func (m *UpdateTagTemplateRequest) GetTagTemplate() *TagTemplate {
	if m != nil {
		return m.TagTemplate
	}
	return nil
}

func (m *UpdateTagTemplateRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request message for
// [DeleteTagTemplate][google.cloud.datacatalog.v1beta1.DataCatalog.DeleteTagTemplate].
type DeleteTagTemplateRequest struct {
	// Required. The name of the tag template to delete. Example:
	//
	// * projects/{project_id}/locations/{location}/tagTemplates/{tag_template_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Currently, this field must always be set to `true`.
	// This confirms the deletion of any possible tags using this template.
	// `force = false` will be supported in the future.
	Force                bool     `protobuf:"varint,2,opt,name=force,proto3" json:"force,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteTagTemplateRequest) Reset()         { *m = DeleteTagTemplateRequest{} }
func (m *DeleteTagTemplateRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteTagTemplateRequest) ProtoMessage()    {}
func (*DeleteTagTemplateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2054d97e7b16f897, []int{15}
}

func (m *DeleteTagTemplateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteTagTemplateRequest.Unmarshal(m, b)
}
func (m *DeleteTagTemplateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteTagTemplateRequest.Marshal(b, m, deterministic)
}
func (m *DeleteTagTemplateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteTagTemplateRequest.Merge(m, src)
}
func (m *DeleteTagTemplateRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteTagTemplateRequest.Size(m)
}
func (m *DeleteTagTemplateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteTagTemplateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteTagTemplateRequest proto.InternalMessageInfo

func (m *DeleteTagTemplateRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *DeleteTagTemplateRequest) GetForce() bool {
	if m != nil {
		return m.Force
	}
	return false
}

// Request message for
// [CreateTag][google.cloud.datacatalog.v1beta1.DataCatalog.CreateTag].
type CreateTagRequest struct {
	// Required. The name of the resource to attach this tag to. Tags can be attached to
	// Entries. Example:
	//
	// * projects/{project_id}/locations/{location}/entryGroups/{entry_group_id}/entries/{entry_id}
	//
	// Note that this Tag and its child resources may not actually be stored in
	// the location in this name.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The tag to create.
	Tag                  *Tag     `protobuf:"bytes,2,opt,name=tag,proto3" json:"tag,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateTagRequest) Reset()         { *m = CreateTagRequest{} }
func (m *CreateTagRequest) String() string { return proto.CompactTextString(m) }
func (*CreateTagRequest) ProtoMessage()    {}
func (*CreateTagRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2054d97e7b16f897, []int{16}
}

func (m *CreateTagRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateTagRequest.Unmarshal(m, b)
}
func (m *CreateTagRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateTagRequest.Marshal(b, m, deterministic)
}
func (m *CreateTagRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateTagRequest.Merge(m, src)
}
func (m *CreateTagRequest) XXX_Size() int {
	return xxx_messageInfo_CreateTagRequest.Size(m)
}
func (m *CreateTagRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateTagRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateTagRequest proto.InternalMessageInfo

func (m *CreateTagRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateTagRequest) GetTag() *Tag {
	if m != nil {
		return m.Tag
	}
	return nil
}

// Request message for
// [UpdateTag][google.cloud.datacatalog.v1beta1.DataCatalog.UpdateTag].
type UpdateTagRequest struct {
	// Required. The updated tag. The "name" field must be set.
	Tag *Tag `protobuf:"bytes,1,opt,name=tag,proto3" json:"tag,omitempty"`
	// The fields to update on the Tag. If absent or empty, all modifiable fields
	// are updated. Currently the only modifiable field is the field `fields`.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateTagRequest) Reset()         { *m = UpdateTagRequest{} }
func (m *UpdateTagRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateTagRequest) ProtoMessage()    {}
func (*UpdateTagRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2054d97e7b16f897, []int{17}
}

func (m *UpdateTagRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateTagRequest.Unmarshal(m, b)
}
func (m *UpdateTagRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateTagRequest.Marshal(b, m, deterministic)
}
func (m *UpdateTagRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateTagRequest.Merge(m, src)
}
func (m *UpdateTagRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateTagRequest.Size(m)
}
func (m *UpdateTagRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateTagRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateTagRequest proto.InternalMessageInfo

func (m *UpdateTagRequest) GetTag() *Tag {
	if m != nil {
		return m.Tag
	}
	return nil
}

func (m *UpdateTagRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request message for
// [DeleteTag][google.cloud.datacatalog.v1beta1.DataCatalog.DeleteTag].
type DeleteTagRequest struct {
	// Required. The name of the tag to delete. Example:
	//
	// * projects/{project_id}/locations/{location}/entryGroups/{entry_group_id}/entries/{entry_id}/tags/{tag_id}
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteTagRequest) Reset()         { *m = DeleteTagRequest{} }
func (m *DeleteTagRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteTagRequest) ProtoMessage()    {}
func (*DeleteTagRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2054d97e7b16f897, []int{18}
}

func (m *DeleteTagRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteTagRequest.Unmarshal(m, b)
}
func (m *DeleteTagRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteTagRequest.Marshal(b, m, deterministic)
}
func (m *DeleteTagRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteTagRequest.Merge(m, src)
}
func (m *DeleteTagRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteTagRequest.Size(m)
}
func (m *DeleteTagRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteTagRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteTagRequest proto.InternalMessageInfo

func (m *DeleteTagRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for
// [CreateTagTemplateField][google.cloud.datacatalog.v1beta1.DataCatalog.CreateTagTemplateField].
type CreateTagTemplateFieldRequest struct {
	// Required. The name of the project this template is in. Example:
	//
	// * projects/{project_id}/locations/{location}/tagTemplates/{tag_template_id}
	//
	// Note that this TagTemplateField may not actually be stored in the location
	// in this name.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The ID of the tag template field to create.
	// Field ids can contain letters (both uppercase and lowercase), numbers
	// (0-9), underscores (_) and dashes (-). Field IDs must be at least 1
	// character long and at most 128 characters long. Field IDs must also be
	// unique within their template.
	TagTemplateFieldId string `protobuf:"bytes,2,opt,name=tag_template_field_id,json=tagTemplateFieldId,proto3" json:"tag_template_field_id,omitempty"`
	// Required. The tag template field to create.
	TagTemplateField     *TagTemplateField `protobuf:"bytes,3,opt,name=tag_template_field,json=tagTemplateField,proto3" json:"tag_template_field,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *CreateTagTemplateFieldRequest) Reset()         { *m = CreateTagTemplateFieldRequest{} }
func (m *CreateTagTemplateFieldRequest) String() string { return proto.CompactTextString(m) }
func (*CreateTagTemplateFieldRequest) ProtoMessage()    {}
func (*CreateTagTemplateFieldRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2054d97e7b16f897, []int{19}
}

func (m *CreateTagTemplateFieldRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateTagTemplateFieldRequest.Unmarshal(m, b)
}
func (m *CreateTagTemplateFieldRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateTagTemplateFieldRequest.Marshal(b, m, deterministic)
}
func (m *CreateTagTemplateFieldRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateTagTemplateFieldRequest.Merge(m, src)
}
func (m *CreateTagTemplateFieldRequest) XXX_Size() int {
	return xxx_messageInfo_CreateTagTemplateFieldRequest.Size(m)
}
func (m *CreateTagTemplateFieldRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateTagTemplateFieldRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateTagTemplateFieldRequest proto.InternalMessageInfo

func (m *CreateTagTemplateFieldRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateTagTemplateFieldRequest) GetTagTemplateFieldId() string {
	if m != nil {
		return m.TagTemplateFieldId
	}
	return ""
}

func (m *CreateTagTemplateFieldRequest) GetTagTemplateField() *TagTemplateField {
	if m != nil {
		return m.TagTemplateField
	}
	return nil
}

// Request message for
// [UpdateTagTemplateField][google.cloud.datacatalog.v1beta1.DataCatalog.UpdateTagTemplateField].
type UpdateTagTemplateFieldRequest struct {
	// Required. The name of the tag template field. Example:
	//
	// * projects/{project_id}/locations/{location}/tagTemplates/{tag_template_id}/fields/{tag_template_field_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The template to update.
	TagTemplateField *TagTemplateField `protobuf:"bytes,2,opt,name=tag_template_field,json=tagTemplateField,proto3" json:"tag_template_field,omitempty"`
	// Optional. The field mask specifies the parts of the template to be updated.
	// Allowed fields:
	//
	//   * `display_name`
	//   * `type.enum_type`
	//   * `is_required`
	//
	// If `update_mask` is not set or empty, all of the allowed fields above will
	// be updated.
	//
	// When updating an enum type, the provided values will be merged with the
	// existing values. Therefore, enum values can only be added, existing enum
	// values cannot be deleted nor renamed. Updating a template field from
	// optional to required is NOT allowed.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateTagTemplateFieldRequest) Reset()         { *m = UpdateTagTemplateFieldRequest{} }
func (m *UpdateTagTemplateFieldRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateTagTemplateFieldRequest) ProtoMessage()    {}
func (*UpdateTagTemplateFieldRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2054d97e7b16f897, []int{20}
}

func (m *UpdateTagTemplateFieldRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateTagTemplateFieldRequest.Unmarshal(m, b)
}
func (m *UpdateTagTemplateFieldRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateTagTemplateFieldRequest.Marshal(b, m, deterministic)
}
func (m *UpdateTagTemplateFieldRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateTagTemplateFieldRequest.Merge(m, src)
}
func (m *UpdateTagTemplateFieldRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateTagTemplateFieldRequest.Size(m)
}
func (m *UpdateTagTemplateFieldRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateTagTemplateFieldRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateTagTemplateFieldRequest proto.InternalMessageInfo

func (m *UpdateTagTemplateFieldRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UpdateTagTemplateFieldRequest) GetTagTemplateField() *TagTemplateField {
	if m != nil {
		return m.TagTemplateField
	}
	return nil
}

func (m *UpdateTagTemplateFieldRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request message for
// [RenameTagTemplateField][google.cloud.datacatalog.v1beta1.DataCatalog.RenameTagTemplateField].
type RenameTagTemplateFieldRequest struct {
	// Required. The name of the tag template. Example:
	//
	// * projects/{project_id}/locations/{location}/tagTemplates/{tag_template_id}/fields/{tag_template_field_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The new ID of this tag template field. For example, `my_new_field`.
	NewTagTemplateFieldId string   `protobuf:"bytes,2,opt,name=new_tag_template_field_id,json=newTagTemplateFieldId,proto3" json:"new_tag_template_field_id,omitempty"`
	XXX_NoUnkeyedLiteral  struct{} `json:"-"`
	XXX_unrecognized      []byte   `json:"-"`
	XXX_sizecache         int32    `json:"-"`
}

func (m *RenameTagTemplateFieldRequest) Reset()         { *m = RenameTagTemplateFieldRequest{} }
func (m *RenameTagTemplateFieldRequest) String() string { return proto.CompactTextString(m) }
func (*RenameTagTemplateFieldRequest) ProtoMessage()    {}
func (*RenameTagTemplateFieldRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2054d97e7b16f897, []int{21}
}

func (m *RenameTagTemplateFieldRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RenameTagTemplateFieldRequest.Unmarshal(m, b)
}
func (m *RenameTagTemplateFieldRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RenameTagTemplateFieldRequest.Marshal(b, m, deterministic)
}
func (m *RenameTagTemplateFieldRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RenameTagTemplateFieldRequest.Merge(m, src)
}
func (m *RenameTagTemplateFieldRequest) XXX_Size() int {
	return xxx_messageInfo_RenameTagTemplateFieldRequest.Size(m)
}
func (m *RenameTagTemplateFieldRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RenameTagTemplateFieldRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RenameTagTemplateFieldRequest proto.InternalMessageInfo

func (m *RenameTagTemplateFieldRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *RenameTagTemplateFieldRequest) GetNewTagTemplateFieldId() string {
	if m != nil {
		return m.NewTagTemplateFieldId
	}
	return ""
}

// Request message for
// [DeleteTagTemplateField][google.cloud.datacatalog.v1beta1.DataCatalog.DeleteTagTemplateField].
type DeleteTagTemplateFieldRequest struct {
	// Required. The name of the tag template field to delete. Example:
	//
	// * projects/{project_id}/locations/{location}/tagTemplates/{tag_template_id}/fields/{tag_template_field_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Currently, this field must always be set to `true`.
	// This confirms the deletion of this field from any tags using this field.
	// `force = false` will be supported in the future.
	Force                bool     `protobuf:"varint,2,opt,name=force,proto3" json:"force,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteTagTemplateFieldRequest) Reset()         { *m = DeleteTagTemplateFieldRequest{} }
func (m *DeleteTagTemplateFieldRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteTagTemplateFieldRequest) ProtoMessage()    {}
func (*DeleteTagTemplateFieldRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2054d97e7b16f897, []int{22}
}

func (m *DeleteTagTemplateFieldRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteTagTemplateFieldRequest.Unmarshal(m, b)
}
func (m *DeleteTagTemplateFieldRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteTagTemplateFieldRequest.Marshal(b, m, deterministic)
}
func (m *DeleteTagTemplateFieldRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteTagTemplateFieldRequest.Merge(m, src)
}
func (m *DeleteTagTemplateFieldRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteTagTemplateFieldRequest.Size(m)
}
func (m *DeleteTagTemplateFieldRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteTagTemplateFieldRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteTagTemplateFieldRequest proto.InternalMessageInfo

func (m *DeleteTagTemplateFieldRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *DeleteTagTemplateFieldRequest) GetForce() bool {
	if m != nil {
		return m.Force
	}
	return false
}

// Request message for
// [ListTags][google.cloud.datacatalog.v1beta1.DataCatalog.ListTags].
type ListTagsRequest struct {
	// Required. The name of the Data Catalog resource to list the tags of. The
	// resource could be an [Entry][google.cloud.datacatalog.v1beta1.Entry].
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of tags to return. Default is 10. Max limit is 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Token that specifies which page is requested. If empty, the first page is
	// returned.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListTagsRequest) Reset()         { *m = ListTagsRequest{} }
func (m *ListTagsRequest) String() string { return proto.CompactTextString(m) }
func (*ListTagsRequest) ProtoMessage()    {}
func (*ListTagsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2054d97e7b16f897, []int{23}
}

func (m *ListTagsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListTagsRequest.Unmarshal(m, b)
}
func (m *ListTagsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListTagsRequest.Marshal(b, m, deterministic)
}
func (m *ListTagsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListTagsRequest.Merge(m, src)
}
func (m *ListTagsRequest) XXX_Size() int {
	return xxx_messageInfo_ListTagsRequest.Size(m)
}
func (m *ListTagsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListTagsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListTagsRequest proto.InternalMessageInfo

func (m *ListTagsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListTagsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListTagsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response message for
// [ListTags][google.cloud.datacatalog.v1beta1.DataCatalog.ListTags].
type ListTagsResponse struct {
	// [Tag][google.cloud.datacatalog.v1beta1.Tag] details.
	Tags []*Tag `protobuf:"bytes,1,rep,name=tags,proto3" json:"tags,omitempty"`
	// Token to retrieve the next page of results. It is set to empty if no items
	// remain in results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListTagsResponse) Reset()         { *m = ListTagsResponse{} }
func (m *ListTagsResponse) String() string { return proto.CompactTextString(m) }
func (*ListTagsResponse) ProtoMessage()    {}
func (*ListTagsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_2054d97e7b16f897, []int{24}
}

func (m *ListTagsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListTagsResponse.Unmarshal(m, b)
}
func (m *ListTagsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListTagsResponse.Marshal(b, m, deterministic)
}
func (m *ListTagsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListTagsResponse.Merge(m, src)
}
func (m *ListTagsResponse) XXX_Size() int {
	return xxx_messageInfo_ListTagsResponse.Size(m)
}
func (m *ListTagsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListTagsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListTagsResponse proto.InternalMessageInfo

func (m *ListTagsResponse) GetTags() []*Tag {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *ListTagsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func init() {
	proto.RegisterEnum("google.cloud.datacatalog.v1beta1.EntryType", EntryType_name, EntryType_value)
	proto.RegisterType((*SearchCatalogRequest)(nil), "google.cloud.datacatalog.v1beta1.SearchCatalogRequest")
	proto.RegisterType((*SearchCatalogRequest_Scope)(nil), "google.cloud.datacatalog.v1beta1.SearchCatalogRequest.Scope")
	proto.RegisterType((*SearchCatalogResponse)(nil), "google.cloud.datacatalog.v1beta1.SearchCatalogResponse")
	proto.RegisterType((*CreateEntryGroupRequest)(nil), "google.cloud.datacatalog.v1beta1.CreateEntryGroupRequest")
	proto.RegisterType((*GetEntryGroupRequest)(nil), "google.cloud.datacatalog.v1beta1.GetEntryGroupRequest")
	proto.RegisterType((*DeleteEntryGroupRequest)(nil), "google.cloud.datacatalog.v1beta1.DeleteEntryGroupRequest")
	proto.RegisterType((*CreateEntryRequest)(nil), "google.cloud.datacatalog.v1beta1.CreateEntryRequest")
	proto.RegisterType((*UpdateEntryRequest)(nil), "google.cloud.datacatalog.v1beta1.UpdateEntryRequest")
	proto.RegisterType((*DeleteEntryRequest)(nil), "google.cloud.datacatalog.v1beta1.DeleteEntryRequest")
	proto.RegisterType((*GetEntryRequest)(nil), "google.cloud.datacatalog.v1beta1.GetEntryRequest")
	proto.RegisterType((*LookupEntryRequest)(nil), "google.cloud.datacatalog.v1beta1.LookupEntryRequest")
	proto.RegisterType((*Entry)(nil), "google.cloud.datacatalog.v1beta1.Entry")
	proto.RegisterType((*EntryGroup)(nil), "google.cloud.datacatalog.v1beta1.EntryGroup")
	proto.RegisterType((*CreateTagTemplateRequest)(nil), "google.cloud.datacatalog.v1beta1.CreateTagTemplateRequest")
	proto.RegisterType((*GetTagTemplateRequest)(nil), "google.cloud.datacatalog.v1beta1.GetTagTemplateRequest")
	proto.RegisterType((*UpdateTagTemplateRequest)(nil), "google.cloud.datacatalog.v1beta1.UpdateTagTemplateRequest")
	proto.RegisterType((*DeleteTagTemplateRequest)(nil), "google.cloud.datacatalog.v1beta1.DeleteTagTemplateRequest")
	proto.RegisterType((*CreateTagRequest)(nil), "google.cloud.datacatalog.v1beta1.CreateTagRequest")
	proto.RegisterType((*UpdateTagRequest)(nil), "google.cloud.datacatalog.v1beta1.UpdateTagRequest")
	proto.RegisterType((*DeleteTagRequest)(nil), "google.cloud.datacatalog.v1beta1.DeleteTagRequest")
	proto.RegisterType((*CreateTagTemplateFieldRequest)(nil), "google.cloud.datacatalog.v1beta1.CreateTagTemplateFieldRequest")
	proto.RegisterType((*UpdateTagTemplateFieldRequest)(nil), "google.cloud.datacatalog.v1beta1.UpdateTagTemplateFieldRequest")
	proto.RegisterType((*RenameTagTemplateFieldRequest)(nil), "google.cloud.datacatalog.v1beta1.RenameTagTemplateFieldRequest")
	proto.RegisterType((*DeleteTagTemplateFieldRequest)(nil), "google.cloud.datacatalog.v1beta1.DeleteTagTemplateFieldRequest")
	proto.RegisterType((*ListTagsRequest)(nil), "google.cloud.datacatalog.v1beta1.ListTagsRequest")
	proto.RegisterType((*ListTagsResponse)(nil), "google.cloud.datacatalog.v1beta1.ListTagsResponse")
}

func init() {
	proto.RegisterFile("google/cloud/datacatalog/v1beta1/datacatalog.proto", fileDescriptor_2054d97e7b16f897)
}

var fileDescriptor_2054d97e7b16f897 = []byte{
	// 2660 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x5a, 0x4d, 0x6c, 0x1b, 0xc7,
	0x15, 0xce, 0x90, 0x92, 0x25, 0x3d, 0xea, 0x77, 0x12, 0x49, 0x34, 0x13, 0x3b, 0xca, 0xa6, 0x49,
	0x14, 0x5a, 0x26, 0x23, 0x3a, 0xb6, 0x11, 0xc6, 0x76, 0xbd, 0xb2, 0x28, 0x59, 0x89, 0x6c, 0x2b,
	0x14, 0xdd, 0x22, 0x6e, 0x80, 0xc5, 0x8a, 0x1c, 0xaf, 0x36, 0x26, 0xb9, 0xab, 0xdd, 0xa5, 0x6d,
	0xc5, 0x30, 0x50, 0x24, 0x80, 0x7b, 0xa9, 0x81, 0xfe, 0xa0, 0x97, 0xa2, 0xe8, 0xb5, 0x80, 0x81,
	0xf6, 0xd0, 0xa2, 0xd7, 0xb6, 0x97, 0xfe, 0xdf, 0x1a, 0xa0, 0x07, 0x02, 0x05, 0x72, 0x28, 0x7a,
	0x30, 0xd0, 0x43, 0x8b, 0x1e, 0x8a, 0x5e, 0x5a, 0xec, 0xcc, 0x2c, 0xb9, 0x3f, 0xa4, 0x38, 0xa4,
	0xe4, 0x9e, 0x44, 0xce, 0xbc, 0xf7, 0xe6, 0xbd, 0xef, 0xbd, 0x99, 0xf7, 0x23, 0x42, 0x4e, 0x33,
	0x0c, 0xad, 0x4a, 0xb2, 0xe5, 0xaa, 0xd1, 0xa8, 0x64, 0x2b, 0xaa, 0xa3, 0x96, 0x55, 0x47, 0xad,
	0x1a, 0x5a, 0xf6, 0xee, 0xf2, 0x0e, 0x71, 0xd4, 0x65, 0xff, 0x5a, 0xc6, 0xb4, 0x0c, 0xc7, 0xc0,
	0x0b, 0x8c, 0x27, 0x43, 0x79, 0x32, 0xfe, 0x7d, 0xce, 0x93, 0x7a, 0x89, 0x4b, 0x55, 0x4d, 0x3d,
	0xab, 0xd6, 0xeb, 0x86, 0xa3, 0x3a, 0xba, 0x51, 0xb7, 0x19, 0x7f, 0x6a, 0xde, 0xb7, 0x5b, 0xae,
	0xea, 0xa4, 0xee, 0xf0, 0x8d, 0x97, 0x7d, 0x1b, 0xb7, 0x75, 0x52, 0xad, 0x28, 0x3b, 0x64, 0x57,
	0xbd, 0xab, 0x1b, 0x16, 0x27, 0x38, 0xee, 0x23, 0xb0, 0x88, 0x6d, 0x34, 0xac, 0x32, 0xe1, 0x5b,
	0xe7, 0x7b, 0x1a, 0xa2, 0x95, 0x6d, 0xe5, 0xb6, 0x5e, 0x25, 0x36, 0x71, 0x14, 0xdb, 0x24, 0x65,
	0xce, 0x78, 0xba, 0x27, 0xa3, 0x5d, 0xde, 0x25, 0x35, 0x55, 0x9c, 0x9c, 0xa8, 0x56, 0x79, 0x97,
	0x93, 0x2f, 0xf7, 0x24, 0x77, 0xd4, 0x9d, 0x2a, 0xf1, 0x2b, 0x74, 0x4a, 0x80, 0x45, 0xb3, 0xc5,
	0xe5, 0xeb, 0x35, 0x62, 0x3b, 0x6a, 0xcd, 0xf4, 0x58, 0x4e, 0x72, 0x16, 0x5d, 0xad, 0x65, 0xef,
	0x2e, 0xbb, 0x7f, 0x14, 0xd3, 0xa8, 0xea, 0xe5, 0x7d, 0xbe, 0x9f, 0x0a, 0xee, 0x07, 0xf6, 0x5e,
	0xe4, 0x7b, 0xf4, 0xdb, 0x4e, 0xe3, 0x76, 0x96, 0xd4, 0x4c, 0xc7, 0xdb, 0x5c, 0x08, 0x6f, 0x32,
	0x1f, 0xd6, 0x54, 0xfb, 0x0e, 0xa3, 0x90, 0xbe, 0x11, 0x87, 0x17, 0xb6, 0x29, 0x3c, 0x57, 0x98,
	0x96, 0x45, 0xb2, 0xd7, 0x20, 0xb6, 0x83, 0xbf, 0x0a, 0xc3, 0x76, 0xd9, 0x30, 0x49, 0xf2, 0xd8,
	0x02, 0x5a, 0x4c, 0xe4, 0x2e, 0x64, 0x7a, 0x85, 0x58, 0xa6, 0x93, 0x98, 0xcc, 0xb6, 0x2b, 0x63,
	0x25, 0xfe, 0x85, 0x1c, 0x2b, 0x32, 0x79, 0xf8, 0x38, 0x0c, 0xef, 0x35, 0x88, 0xb5, 0x9f, 0x44,
	0x0b, 0x68, 0x71, 0x8c, 0x6f, 0xd1, 0x15, 0xfc, 0x22, 0x8c, 0x99, 0xaa, 0x46, 0x14, 0x5b, 0xff,
	0x84, 0x24, 0x63, 0x0b, 0x68, 0x71, 0xb8, 0x38, 0xea, 0x2e, 0x6c, 0xeb, 0x9f, 0x10, 0x2c, 0x01,
	0xd0, 0x4d, 0xc7, 0xb8, 0x43, 0xea, 0xc9, 0xb8, 0xc7, 0x8c, 0x8a, 0x94, 0xa7, 0xe4, 0xae, 0xe2,
	0xe3, 0x30, 0x6a, 0x58, 0x15, 0x62, 0x29, 0x3b, 0xfb, 0xc9, 0x61, 0x97, 0xa2, 0x38, 0x42, 0xbf,
	0xaf, 0xec, 0xa7, 0x7e, 0x88, 0x60, 0x98, 0x2a, 0x83, 0x5f, 0x87, 0x29, 0xbd, 0x5e, 0xae, 0x36,
	0x2a, 0x44, 0x31, 0x2c, 0x4d, 0xd1, 0x2b, 0x76, 0x32, 0xb6, 0x10, 0x5f, 0x1c, 0x2b, 0x4e, 0xf0,
	0xe5, 0x1b, 0x96, 0xb6, 0x51, 0xb1, 0x71, 0x06, 0x9e, 0xf7, 0xe8, 0x4c, 0xcb, 0xf8, 0x98, 0x94,
	0x1d, 0x4a, 0x1b, 0xa7, 0xb4, 0x33, 0x7c, 0x6b, 0x8b, 0xed, 0xb8, 0xf4, 0x17, 0xe1, 0x45, 0x8f,
	0x5e, 0x2b, 0x9b, 0x8a, 0xd9, 0xd8, 0xa9, 0xea, 0x65, 0xc5, 0x45, 0xca, 0x26, 0x8e, 0x9d, 0x1c,
	0x59, 0x40, 0x8b, 0xa3, 0xc5, 0x24, 0x27, 0x59, 0x2f, 0x9b, 0x5b, 0x94, 0x60, 0x95, 0xef, 0x4b,
	0xdf, 0x42, 0x30, 0x1b, 0x82, 0xd0, 0x36, 0x8d, 0xba, 0x4d, 0xf0, 0x0d, 0x18, 0xb1, 0x88, 0xdd,
	0xa8, 0x3a, 0x76, 0x12, 0x2d, 0xc4, 0x17, 0x13, 0xb9, 0xb3, 0x7d, 0x3b, 0xc3, 0xe5, 0x2e, 0x7a,
	0x52, 0x5c, 0x04, 0xea, 0xe4, 0xbe, 0xa3, 0x84, 0xf1, 0x2c, 0x4e, 0xb8, 0xcb, 0x5b, 0x1e, 0x9c,
	0x52, 0x13, 0xc1, 0xfc, 0x15, 0x8b, 0xa8, 0x0e, 0x29, 0xd4, 0x1d, 0x6b, 0x7f, 0xdd, 0x32, 0x1a,
	0xa6, 0x17, 0x1f, 0x05, 0x38, 0x66, 0xaa, 0x16, 0xa9, 0x3b, 0xdc, 0x8f, 0xa7, 0xbf, 0x90, 0x63,
	0xff, 0x91, 0xdf, 0xc0, 0xaf, 0xf9, 0xb5, 0x61, 0x6a, 0xaa, 0xa6, 0x6e, 0x67, 0xca, 0x46, 0x2d,
	0xeb, 0x93, 0xc2, 0x99, 0xf1, 0x9b, 0x30, 0x49, 0xdc, 0x55, 0x45, 0x73, 0x97, 0x15, 0xbd, 0xd2,
	0xf6, 0x6c, 0xac, 0x38, 0x4e, 0x5a, 0x0c, 0x1b, 0x15, 0x7c, 0x0d, 0x12, 0x3e, 0x52, 0x1a, 0x1f,
	0x89, 0xdc, 0x52, 0x6f, 0x28, 0x7c, 0xa7, 0x42, 0x5b, 0xa0, 0xf4, 0x1d, 0x04, 0x2f, 0xac, 0x13,
	0x27, 0x6a, 0x99, 0x0c, 0x43, 0x75, 0xb5, 0x46, 0x82, 0x76, 0x81, 0xa0, 0x5d, 0x94, 0x15, 0x9f,
	0x87, 0x31, 0x8b, 0xa8, 0xec, 0xa2, 0x71, 0x45, 0x53, 0x9e, 0xa2, 0xde, 0x5d, 0xcc, 0xac, 0xb9,
	0x77, 0xf1, 0x9a, 0x6a, 0xdf, 0x29, 0x8e, 0xba, 0xc4, 0xee, 0x27, 0xe9, 0x23, 0x98, 0x5f, 0x25,
	0x55, 0xd2, 0x09, 0xf0, 0xc3, 0xab, 0x25, 0xfd, 0x12, 0x01, 0xf6, 0xf9, 0xb3, 0x87, 0x2b, 0xa1,
	0x4f, 0x57, 0x9e, 0x84, 0x51, 0xe6, 0x9f, 0xa0, 0x13, 0x47, 0xe8, 0xe2, 0x46, 0x05, 0xaf, 0xc0,
	0x30, 0xfd, 0xc8, 0x01, 0x79, 0x43, 0xd0, 0x73, 0xfc, 0x85, 0xa0, 0xac, 0xd2, 0xf7, 0x10, 0xe0,
	0x9b, 0x66, 0x25, 0x6c, 0x41, 0x4b, 0x34, 0x1a, 0x58, 0x34, 0x7e, 0x17, 0x12, 0x0d, 0x2a, 0x59,
	0xd4, 0x6b, 0xc0, 0xc8, 0xa9, 0xdf, 0x8a, 0x80, 0x7d, 0x7e, 0xf3, 0xd4, 0xba, 0x10, 0x70, 0xd9,
	0x22, 0x85, 0x55, 0x82, 0x85, 0x5e, 0xb0, 0x72, 0x6f, 0xdd, 0x80, 0x29, 0x2f, 0x3e, 0x8f, 0x46,
	0xa0, 0x0d, 0x78, 0xd3, 0x30, 0xee, 0x34, 0xcc, 0x80, 0xcc, 0x37, 0x61, 0xaa, 0xaa, 0xd7, 0xef,
	0x90, 0x8a, 0xe2, 0xe5, 0x6f, 0x26, 0xfe, 0xea, 0x73, 0xc5, 0x49, 0xb6, 0x51, 0xe4, 0xeb, 0xf8,
	0x55, 0x18, 0xb7, 0xf7, 0xaa, 0x6d, 0xba, 0x38, 0xa7, 0x4b, 0xd8, 0x7b, 0x55, 0x8f, 0x68, 0x65,
	0x02, 0x12, 0x8e, 0x6a, 0x69, 0xc4, 0x51, 0xe8, 0xa1, 0x8f, 0x46, 0x60, 0x98, 0x9e, 0x87, 0x2f,
	0x05, 0x94, 0x4f, 0xf7, 0x7d, 0xa9, 0x96, 0xa2, 0x8a, 0x8e, 0x79, 0x61, 0x16, 0x8f, 0xe8, 0x2a,
	0xc3, 0x90, 0xb3, 0x6f, 0xb2, 0x34, 0x32, 0x99, 0x3b, 0x25, 0x18, 0x11, 0xa5, 0x7d, 0x93, 0x5c,
	0x7d, 0xae, 0x48, 0x59, 0xf1, 0x47, 0x30, 0x1d, 0xae, 0x50, 0x78, 0x36, 0x7c, 0xab, 0xb7, 0xb8,
	0xf5, 0xb2, 0xbd, 0xc6, 0x18, 0xb7, 0x4d, 0x52, 0xbe, 0x8a, 0x8a, 0x93, 0x5a, 0x60, 0x05, 0x13,
	0x78, 0x7e, 0x47, 0xd7, 0x68, 0xe2, 0x53, 0xda, 0x15, 0x47, 0x72, 0x9c, 0x1e, 0x70, 0xa6, 0xf7,
	0x01, 0x2b, 0xba, 0xf6, 0x81, 0xcb, 0x5c, 0x72, 0x79, 0xf9, 0x19, 0x33, 0x9e, 0xc4, 0xd6, 0x22,
	0xbe, 0x0f, 0xa9, 0xd6, 0x31, 0x34, 0xba, 0xed, 0x5d, 0xd5, 0xaa, 0x90, 0x0a, 0x3b, 0x6d, 0x8a,
	0x9e, 0xf6, 0x8e, 0xf8, 0x69, 0xab, 0xaa, 0x43, 0xb6, 0x99, 0x04, 0x7e, 0xe6, 0xbc, 0x27, 0x3e,
	0xb4, 0x85, 0x5f, 0x81, 0xf1, 0x8a, 0x6e, 0x9b, 0x55, 0x75, 0x9f, 0x46, 0x02, 0x4f, 0x31, 0x09,
	0xbe, 0x76, 0xdd, 0x75, 0xe9, 0x02, 0x24, 0x2a, 0xc4, 0x2e, 0x5b, 0xba, 0xe9, 0x56, 0xa3, 0xc9,
	0x21, 0x4e, 0xd1, 0x5e, 0xc2, 0x97, 0xe1, 0x18, 0x2b, 0xf6, 0x68, 0x3e, 0x4f, 0xe4, 0x16, 0x05,
	0x52, 0x1f, 0xa5, 0x2f, 0x72, 0x3e, 0xbc, 0x07, 0x49, 0x16, 0x12, 0x8a, 0xbd, 0x6f, 0x3b, 0xa4,
	0xa6, 0xb4, 0xcb, 0x2f, 0x9a, 0x93, 0x13, 0xb9, 0x9c, 0x80, 0x4c, 0xca, 0x5a, 0x6a, 0x71, 0xb2,
	0x98, 0x9b, 0x63, 0x82, 0xc3, 0x9b, 0xf9, 0xfb, 0x4f, 0xe5, 0x46, 0xef, 0x5b, 0x89, 0x3f, 0xe0,
	0x65, 0x85, 0x9d, 0x7d, 0xc0, 0x3f, 0x3d, 0xcc, 0x56, 0x8d, 0x32, 0xab, 0xcc, 0xb3, 0x0f, 0xbc,
	0x8f, 0x0f, 0xb3, 0xed, 0xac, 0x65, 0x67, 0x1f, 0xf8, 0x72, 0x20, 0xdb, 0xd1, 0x89, 0xb7, 0xfa,
	0x70, 0x65, 0x1c, 0x58, 0x8a, 0x53, 0xdc, 0x00, 0x5e, 0x49, 0xc0, 0x98, 0xfb, 0x97, 0xba, 0x5a,
	0xfa, 0x75, 0x0c, 0xa0, 0x7d, 0xa7, 0x30, 0xf6, 0xdf, 0x46, 0x7e, 0xc3, 0xc2, 0x1e, 0x8b, 0xf5,
	0xf4, 0x58, 0x3c, 0xea, 0x31, 0x03, 0xe6, 0x5d, 0xcb, 0x15, 0x6e, 0xba, 0x1f, 0xee, 0xa1, 0xc3,
	0xc1, 0x3d, 0xeb, 0x92, 0xf2, 0x92, 0xc6, 0x87, 0x76, 0xed, 0xa9, 0xfc, 0xb1, 0xe0, 0x4b, 0x82,
	0xe5, 0x43, 0x43, 0x2e, 0xfd, 0x0d, 0x41, 0x92, 0x25, 0xd1, 0x92, 0xaa, 0x95, 0x48, 0xcd, 0xac,
	0xaa, 0x0e, 0xf1, 0x1e, 0xd3, 0xb5, 0x50, 0x2a, 0xcd, 0xd0, 0x27, 0x7a, 0x11, 0xbf, 0x7e, 0x80,
	0x7a, 0x7e, 0x31, 0x5e, 0x2e, 0x3d, 0x05, 0x53, 0x8e, 0xaa, 0x29, 0x0e, 0x5f, 0x0f, 0xa5, 0xd4,
	0x09, 0xa7, 0xcd, 0xb2, 0x51, 0xc1, 0x37, 0x61, 0xdc, 0x4f, 0xcc, 0x53, 0xd7, 0xe9, 0xde, 0x30,
	0xfb, 0x4e, 0x66, 0x82, 0x13, 0x3e, 0xc1, 0xd2, 0xd7, 0x60, 0x76, 0x9d, 0x38, 0x1d, 0x8c, 0x5c,
	0x09, 0x3c, 0xe4, 0xdc, 0x44, 0x10, 0x35, 0x91, 0xe5, 0xa2, 0x9f, 0x20, 0x48, 0xb2, 0x44, 0xde,
	0xe1, 0x80, 0xb0, 0x41, 0xe8, 0x48, 0x0c, 0x3a, 0x5c, 0x86, 0xdf, 0x87, 0x24, 0xcb, 0xf0, 0xcf,
	0x06, 0x10, 0xb7, 0x2d, 0xba, 0x6d, 0xb8, 0x39, 0xcd, 0x55, 0x6b, 0x94, 0x57, 0x26, 0x74, 0xc5,
	0xed, 0x0c, 0xa6, 0x5b, 0x11, 0xe7, 0x9d, 0x79, 0x29, 0x14, 0x69, 0xaf, 0xd3, 0x53, 0x17, 0xe0,
	0xe4, 0xc1, 0xa7, 0xb6, 0x22, 0xec, 0x02, 0xc4, 0x1d, 0x55, 0xe3, 0x20, 0xbc, 0x26, 0x04, 0x2d,
	0x53, 0xca, 0x65, 0x93, 0x1e, 0x23, 0x98, 0x6e, 0xb9, 0xaf, 0x5d, 0x9d, 0x50, 0x91, 0x68, 0x20,
	0x91, 0x87, 0xf3, 0xce, 0x75, 0x98, 0x6e, 0x79, 0xc7, 0x53, 0x27, 0x1f, 0xf0, 0x0a, 0xc7, 0x07,
	0xf7, 0xc2, 0x87, 0x85, 0xe7, 0xa3, 0x18, 0x9c, 0x88, 0x5c, 0x72, 0x7a, 0x74, 0x8f, 0x9b, 0x0e,
	0xfd, 0xde, 0xf4, 0x73, 0x30, 0x1b, 0xb8, 0xe9, 0xac, 0x43, 0xd7, 0x2b, 0xec, 0xf1, 0x65, 0xf8,
	0x60, 0x27, 0xa4, 0xc4, 0x46, 0x05, 0x13, 0xc0, 0x51, 0x3e, 0xfa, 0x48, 0x08, 0xbd, 0xb0, 0x61,
	0xb3, 0xd8, 0x41, 0xd3, 0xe1, 0x83, 0xa4, 0x6f, 0xc7, 0xe0, 0x44, 0xe4, 0x9e, 0x06, 0x80, 0x58,
	0x0f, 0xc0, 0x7c, 0x86, 0xc2, 0x70, 0x1a, 0x4e, 0x89, 0xc1, 0xc0, 0x24, 0xb1, 0x1b, 0xd0, 0xd9,
	0xa2, 0xd8, 0x11, 0x5b, 0x84, 0x2f, 0x07, 0xe3, 0x2c, 0xde, 0x2b, 0xce, 0xd8, 0x90, 0xc1, 0x1f,
	0x6c, 0x3f, 0x42, 0x70, 0xa2, 0x48, 0x5c, 0x9d, 0x9f, 0x39, 0x26, 0x17, 0xe1, 0x78, 0x9d, 0xdc,
	0x53, 0x7a, 0x46, 0xc8, 0x6c, 0x9d, 0xdc, 0x2b, 0x45, 0x82, 0x44, 0xfa, 0x0c, 0xc1, 0x89, 0xc8,
	0xab, 0xf5, 0x6c, 0x34, 0x3d, 0xe0, 0xfd, 0x7a, 0x8c, 0x60, 0x6a, 0x53, 0xb7, 0xdd, 0x54, 0x62,
	0xf7, 0x78, 0xbe, 0xb0, 0xe8, 0xf3, 0x75, 0xe0, 0xa8, 0xe8, 0x44, 0x74, 0x54, 0xe4, 0x9b, 0x12,
	0x49, 0x0d, 0x98, 0x6e, 0xab, 0xc3, 0x67, 0x2c, 0xef, 0xc0, 0x90, 0xa3, 0x6a, 0xde, 0x80, 0x45,
	0xec, 0xf1, 0x2a, 0x52, 0x96, 0x4e, 0xd3, 0x94, 0x58, 0x87, 0x69, 0x4a, 0x7a, 0x0b, 0xc6, 0x5a,
	0x3d, 0x06, 0x4e, 0xc1, 0x5c, 0xe1, 0x7a, 0xa9, 0xf8, 0xa1, 0x52, 0xfa, 0x70, 0xab, 0xa0, 0xdc,
	0xbc, 0xbe, 0xbd, 0x55, 0xb8, 0xb2, 0xb1, 0xb6, 0x51, 0x58, 0x9d, 0x7e, 0x0e, 0x8f, 0xc1, 0x70,
	0x49, 0x5e, 0xd9, 0x2c, 0x4c, 0xc7, 0xf0, 0x14, 0x24, 0x56, 0xe5, 0x92, 0xac, 0x6c, 0x97, 0x8a,
	0x05, 0xf9, 0xda, 0x74, 0x1c, 0x27, 0x60, 0x64, 0x6d, 0x63, 0xb3, 0xb0, 0x5d, 0x28, 0x4d, 0x0f,
	0xe5, 0x7e, 0x77, 0x0a, 0x12, 0xab, 0xed, 0x9a, 0x08, 0xff, 0x14, 0xc1, 0x44, 0x60, 0xf0, 0x83,
	0xcf, 0x0d, 0x36, 0xb6, 0x4b, 0x9d, 0xef, 0x7f, 0xc2, 0x44, 0x71, 0x94, 0xde, 0x6a, 0xca, 0x09,
	0x3a, 0xe7, 0x5b, 0xa2, 0x3d, 0xc1, 0xa7, 0x9f, 0xff, 0xf5, 0xbb, 0xb1, 0x97, 0xa4, 0xf9, 0xd6,
	0xec, 0x93, 0x4b, 0xc9, 0xb3, 0x91, 0x6c, 0x1e, 0xa5, 0xf1, 0xd3, 0x56, 0x76, 0xf3, 0xd5, 0x69,
	0x02, 0x1d, 0x49, 0x97, 0xc1, 0x54, 0xaa, 0xaf, 0x89, 0x90, 0x54, 0x6b, 0xca, 0xaf, 0xb0, 0x90,
	0x5a, 0x0a, 0xce, 0xa1, 0xfc, 0x5f, 0xa9, 0x15, 0x57, 0xa4, 0xb7, 0x5b, 0x56, 0x3c, 0x60, 0x2c,
	0x17, 0x5b, 0xd5, 0x64, 0xda, 0x57, 0x45, 0xa6, 0x03, 0xd5, 0x63, 0xde, 0x3f, 0xb4, 0xc2, 0x7f,
	0x44, 0x30, 0x11, 0x18, 0x3a, 0x89, 0x78, 0xa8, 0xd3, 0x94, 0xaa, 0x4f, 0x33, 0x4b, 0x4d, 0x99,
	0x5e, 0xd3, 0xa6, 0x3c, 0xe9, 0xfe, 0x59, 0x6a, 0x4d, 0xa7, 0xa8, 0x69, 0xe7, 0xb0, 0xcf, 0x34,
	0x77, 0xbf, 0x8b, 0x61, 0x81, 0xaa, 0x38, 0xfd, 0x10, 0x3f, 0x41, 0x5e, 0xda, 0xed, 0xcf, 0x75,
	0x5d, 0x46, 0x5c, 0xa9, 0xb9, 0xc8, 0x2b, 0x5c, 0xa8, 0x99, 0xce, 0xbe, 0x74, 0x85, 0x6b, 0xcf,
	0x94, 0x4d, 0x0f, 0xa6, 0xec, 0xe7, 0x08, 0x12, 0xbe, 0x98, 0xc1, 0x6f, 0xf7, 0x15, 0x62, 0x9e,
	0x8a, 0xa2, 0xa3, 0x25, 0x89, 0x34, 0xe5, 0xd9, 0x40, 0x60, 0x79, 0x21, 0x45, 0x8d, 0x58, 0x97,
	0x2e, 0x09, 0x06, 0x53, 0xc8, 0x0c, 0xaf, 0xe3, 0xcb, 0xf3, 0xa9, 0xd5, 0x5f, 0x10, 0x24, 0x7c,
	0x03, 0x31, 0x11, 0xab, 0xa2, 0xf3, 0x33, 0x71, 0xab, 0x8c, 0xa6, 0xcc, 0x0e, 0x6e, 0xca, 0x33,
	0xf4, 0xef, 0x92, 0x2f, 0x97, 0x52, 0xcb, 0xae, 0xe5, 0x56, 0xdb, 0x96, 0x51, 0x92, 0x8c, 0xb0,
	0x93, 0x5a, 0xed, 0x6c, 0xfa, 0xa1, 0x67, 0xdf, 0x13, 0x04, 0x09, 0x5f, 0xb8, 0x88, 0xd8, 0x17,
	0x1d, 0xc4, 0x75, 0x0d, 0xac, 0x6b, 0xfe, 0xc0, 0xba, 0x9c, 0xbe, 0x34, 0x40, 0x60, 0xf9, 0x74,
	0xc6, 0x3f, 0x47, 0x30, 0xea, 0x5d, 0x56, 0xbc, 0x2c, 0x7e, 0xb1, 0xfb, 0x76, 0x43, 0x50, 0x6f,
	0x7c, 0x58, 0xbd, 0x1f, 0x23, 0x48, 0xf8, 0x26, 0x83, 0x22, 0x20, 0x47, 0x07, 0x89, 0xe2, 0xda,
	0xbf, 0x4c, 0xd5, 0x3e, 0x8e, 0xdb, 0x59, 0xc1, 0x0b, 0xea, 0x2a, 0x95, 0x8a, 0xff, 0x81, 0x60,
	0x26, 0x52, 0x7d, 0xe3, 0xbc, 0xe8, 0x85, 0x8d, 0x76, 0x68, 0xa9, 0xfe, 0x7a, 0x47, 0x69, 0xaf,
	0x29, 0xbf, 0xca, 0x2f, 0x6f, 0xa8, 0x0d, 0x0f, 0x7c, 0xa7, 0x76, 0x14, 0xa4, 0xb3, 0xc2, 0x79,
	0xc1, 0x57, 0x8c, 0xda, 0xf9, 0x40, 0x8f, 0x8b, 0x7f, 0x81, 0x60, 0x32, 0xd8, 0x6e, 0xe3, 0xf3,
	0x42, 0x11, 0x74, 0x78, 0x6b, 0x57, 0xfd, 0xd1, 0x74, 0x1e, 0x9f, 0x15, 0x8b, 0x26, 0xbf, 0x2d,
	0x6e, 0x10, 0x7d, 0x16, 0x83, 0x99, 0x48, 0xa7, 0x20, 0xe2, 0xb4, 0x6e, 0x63, 0x80, 0x7e, 0xcd,
	0xf8, 0x14, 0x35, 0xe5, 0x00, 0xa6, 0x4d, 0x39, 0xe9, 0xff, 0x1a, 0x79, 0xaa, 0x8a, 0xb9, 0x95,
	0xb6, 0xa9, 0x7e, 0xca, 0x4c, 0x1f, 0x76, 0x87, 0xdc, 0xf8, 0x33, 0x04, 0x33, 0x91, 0x8a, 0x5b,
	0x04, 0x85, 0x6e, 0xc3, 0x85, 0xae, 0x6f, 0xd7, 0x7b, 0x4d, 0x19, 0x68, 0x2e, 0xa7, 0x45, 0x36,
	0xf3, 0x5d, 0x7a, 0x40, 0xdf, 0xfd, 0x20, 0x06, 0x73, 0x9d, 0xdb, 0x5d, 0xfc, 0xe5, 0x01, 0x6e,
	0x9d, 0xbf, 0xc3, 0x48, 0x0d, 0xd0, 0xba, 0x49, 0xdf, 0x44, 0x4d, 0x39, 0xdb, 0xe9, 0x02, 0x7a,
	0xbd, 0x4f, 0x87, 0x55, 0x8a, 0x40, 0x49, 0x3c, 0xaf, 0x86, 0x30, 0x60, 0xff, 0x1a, 0xb7, 0xf3,
	0x1d, 0x7a, 0x50, 0xfc, 0x24, 0x06, 0x73, 0x9d, 0x9b, 0x60, 0x11, 0x78, 0x0e, 0x6c, 0x9f, 0x07,
	0x82, 0xe7, 0xfb, 0xa8, 0x29, 0xcf, 0x53, 0xdf, 0x47, 0x95, 0x6d, 0xca, 0xaf, 0x76, 0xd9, 0x89,
	0xc4, 0x7f, 0x29, 0x77, 0x69, 0x90, 0x70, 0xe1, 0x48, 0xb9, 0xb1, 0xdf, 0x09, 0xac, 0xaf, 0xc7,
	0x60, 0xae, 0x73, 0x77, 0x2c, 0x02, 0xd6, 0x81, 0x7d, 0xf5, 0x40, 0x60, 0xed, 0x35, 0xe5, 0x93,
	0x14, 0x91, 0xae, 0x8d, 0x34, 0x05, 0xe3, 0x3d, 0xa9, 0x70, 0x48, 0x30, 0x2c, 0xaa, 0xba, 0xdb,
	0xd2, 0xfc, 0x06, 0xc1, 0x5c, 0xe7, 0xb6, 0x5b, 0x04, 0x82, 0x03, 0x1b, 0xf6, 0xae, 0xcf, 0xc1,
	0x76, 0xf4, 0x39, 0x10, 0x2e, 0x68, 0xba, 0x99, 0x84, 0x7f, 0x8b, 0x60, 0xac, 0x75, 0xbb, 0x71,
	0xae, 0x8f, 0xa7, 0xc0, 0x53, 0x57, 0xac, 0x93, 0x96, 0x94, 0xa6, 0x0c, 0xed, 0xfb, 0x4e, 0xb5,
	0xdf, 0xf4, 0x3b, 0xa4, 0x8f, 0x12, 0xd9, 0x57, 0xd8, 0xd0, 0x9f, 0xe5, 0xe4, 0xe9, 0x74, 0xf1,
	0xcf, 0x08, 0xc6, 0x5a, 0x17, 0x51, 0xc4, 0x92, 0xf0, 0x74, 0x53, 0xd4, 0x92, 0x7a, 0x53, 0x76,
	0x0f, 0x6c, 0xca, 0x53, 0x8e, 0xaa, 0x45, 0xae, 0xdc, 0x56, 0x6e, 0x23, 0x90, 0x72, 0x06, 0xa9,
	0x8d, 0xa9, 0x55, 0x6e, 0xc0, 0x51, 0xc3, 0x7e, 0x8c, 0x60, 0xac, 0x15, 0x31, 0x22, 0x86, 0x85,
	0xe7, 0xa4, 0x5d, 0x23, 0xaa, 0xe4, 0x2f, 0x0b, 0xd6, 0xd3, 0x85, 0x43, 0x15, 0x99, 0x9e, 0xd2,
	0xf8, 0xf7, 0x08, 0x46, 0xbd, 0xe9, 0x8b, 0x48, 0x8d, 0x1c, 0x1a, 0x1c, 0x89, 0x3c, 0x01, 0xe1,
	0xe1, 0x8e, 0xf4, 0x95, 0xa6, 0xcc, 0xe7, 0x46, 0xcc, 0x16, 0x7c, 0x34, 0x91, 0x85, 0x7f, 0x15,
	0x83, 0xf1, 0x6d, 0xe2, 0x6c, 0xa8, 0xb5, 0x2d, 0xfa, 0x93, 0x2c, 0x2c, 0x79, 0xca, 0xe9, 0x6a,
	0x2d, 0x73, 0x77, 0x39, 0xe3, 0xdf, 0xf4, 0x0c, 0x98, 0x0d, 0xd1, 0xb0, 0x5d, 0xe9, 0x5f, 0x88,
	0xea, 0xf6, 0x77, 0x24, 0xad, 0xb5, 0x95, 0xf3, 0xfe, 0xd1, 0x2d, 0x5a, 0x8b, 0xd8, 0xbe, 0xf3,
	0xf2, 0x28, 0x7d, 0x2b, 0xf0, 0xa8, 0xf5, 0x12, 0x16, 0x6c, 0x34, 0x23, 0xb2, 0x4a, 0xd2, 0x8d,
	0x01, 0x65, 0xf9, 0xdb, 0xba, 0x90, 0x54, 0x0a, 0xe1, 0xfa, 0x41, 0x10, 0xae, 0xff, 0x9f, 0x21,
	0xd4, 0x8e, 0x10, 0x42, 0xed, 0x99, 0x40, 0x18, 0x92, 0x8a, 0xff, 0x19, 0x03, 0x5c, 0x22, 0x36,
	0x5d, 0x24, 0x56, 0x4d, 0xb7, 0x6d, 0x57, 0x02, 0x5e, 0x0c, 0x81, 0x14, 0x25, 0xf1, 0xe0, 0x7c,
	0x53, 0x80, 0x92, 0xdf, 0xa4, 0x47, 0x31, 0x0a, 0xf1, 0x7f, 0x91, 0xb4, 0x39, 0x38, 0xc4, 0x4e,
	0x44, 0xbe, 0x0b, 0xce, 0x96, 0xf4, 0xfe, 0xc0, 0x40, 0x77, 0x96, 0x78, 0x4b, 0xba, 0x79, 0x04,
	0x70, 0x77, 0x94, 0x9d, 0xba, 0xfe, 0x07, 0x39, 0xd5, 0x7d, 0x54, 0xfd, 0x27, 0x39, 0xb3, 0xeb,
	0x38, 0xa6, 0x9d, 0xcf, 0x66, 0xef, 0xdd, 0xbb, 0x17, 0x9e, 0x63, 0xab, 0x0d, 0x67, 0x97, 0xfd,
	0x3c, 0xf4, 0xb4, 0x0b, 0xca, 0x6d, 0xc3, 0xaa, 0xad, 0xdc, 0x87, 0x2f, 0x95, 0x8d, 0x5a, 0xcf,
	0xb7, 0x6d, 0x0b, 0xdd, 0x7a, 0x9f, 0xd3, 0x68, 0x46, 0x55, 0xad, 0x6b, 0x19, 0xc3, 0xd2, 0xb2,
	0x1a, 0xa9, 0xd3, 0xb7, 0x3b, 0xdb, 0x3e, 0xa8, 0xfb, 0xcf, 0x4f, 0xdf, 0xf5, 0xad, 0xfd, 0x1b,
	0xa1, 0x9d, 0x63, 0x94, 0xf5, 0xcc, 0xff, 0x02, 0x00, 0x00, 0xff, 0xff, 0x12, 0x0b, 0x1f, 0xb9,
	0x78, 0x2c, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// DataCatalogClient is the client API for DataCatalog service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type DataCatalogClient interface {
	// Searches Data Catalog for multiple resources like entries, tags that
	// match a query.
	//
	// This is a custom method
	// (https://cloud.google.com/apis/design/custom_methods) and does not return
	// the complete resource, only the resource identifier and high level
	// fields. Clients can subsequentally call `Get` methods.
	//
	// Note that searches do not have full recall. There may be results that match
	// your query but are not returned, even in subsequent pages of results. These
	// missing results may vary across repeated calls to search. Do not rely on
	// this method if you need to guarantee full recall.
	//
	// See [Data Catalog Search
	// Syntax](/data-catalog/docs/how-to/search-reference) for more information.
	SearchCatalog(ctx context.Context, in *SearchCatalogRequest, opts ...grpc.CallOption) (*SearchCatalogResponse, error)
	// Alpha feature.
	// Creates an EntryGroup.
	// The user should enable the Data Catalog API in the project identified by
	// the `parent` parameter (see [Data Catalog Resource Project]
	// (/data-catalog/docs/concepts/resource-project) for more information).
	CreateEntryGroup(ctx context.Context, in *CreateEntryGroupRequest, opts ...grpc.CallOption) (*EntryGroup, error)
	// Alpha feature.
	// Gets an EntryGroup.
	GetEntryGroup(ctx context.Context, in *GetEntryGroupRequest, opts ...grpc.CallOption) (*EntryGroup, error)
	// Alpha feature.
	// Deletes an EntryGroup. Only entry groups that do not contain entries can be
	// deleted. The user should enable the Data Catalog API in the project
	// identified by the `name` parameter (see [Data Catalog Resource Project]
	// (/data-catalog/docs/concepts/resource-project) for more information).
	DeleteEntryGroup(ctx context.Context, in *DeleteEntryGroupRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Alpha feature.
	// Creates an entry. Currently only entries of 'FILESET' type can be created.
	// The user should enable the Data Catalog API in the project identified by
	// the `parent` parameter (see [Data Catalog Resource Project]
	// (/data-catalog/docs/concepts/resource-project) for more information).
	CreateEntry(ctx context.Context, in *CreateEntryRequest, opts ...grpc.CallOption) (*Entry, error)
	// Updates an existing entry.
	// The user should enable the Data Catalog API in the project identified by
	// the `entry.name` parameter (see [Data Catalog Resource Project]
	// (/data-catalog/docs/concepts/resource-project) for more information).
	UpdateEntry(ctx context.Context, in *UpdateEntryRequest, opts ...grpc.CallOption) (*Entry, error)
	// Alpha feature.
	// Deletes an existing entry. Only entries created through
	// [CreateEntry][google.cloud.datacatalog.v1beta1.DataCatalog.CreateEntry]
	// method can be deleted.
	// The user should enable the Data Catalog API in the project identified by
	// the `name` parameter (see [Data Catalog Resource Project]
	// (/data-catalog/docs/concepts/resource-project) for more information).
	DeleteEntry(ctx context.Context, in *DeleteEntryRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Gets an entry.
	GetEntry(ctx context.Context, in *GetEntryRequest, opts ...grpc.CallOption) (*Entry, error)
	// Get an entry by target resource name. This method allows clients to use
	// the resource name from the source Google Cloud Platform service to get the
	// Data Catalog Entry.
	LookupEntry(ctx context.Context, in *LookupEntryRequest, opts ...grpc.CallOption) (*Entry, error)
	// Creates a tag template. The user should enable the Data Catalog API in
	// the project identified by the `parent` parameter (see [Data Catalog
	// Resource Project](/data-catalog/docs/concepts/resource-project) for more
	// information).
	CreateTagTemplate(ctx context.Context, in *CreateTagTemplateRequest, opts ...grpc.CallOption) (*TagTemplate, error)
	// Gets a tag template.
	GetTagTemplate(ctx context.Context, in *GetTagTemplateRequest, opts ...grpc.CallOption) (*TagTemplate, error)
	// Updates a tag template. This method cannot be used to update the fields of
	// a template. The tag template fields are represented as separate resources
	// and should be updated using their own create/update/delete methods.
	// The user should enable the Data Catalog API in the project identified by
	// the `tag_template.name` parameter (see [Data Catalog Resource Project]
	// (/data-catalog/docs/concepts/resource-project) for more information).
	UpdateTagTemplate(ctx context.Context, in *UpdateTagTemplateRequest, opts ...grpc.CallOption) (*TagTemplate, error)
	// Deletes a tag template and all tags using the template.
	// The user should enable the Data Catalog API in the project identified by
	// the `name` parameter (see [Data Catalog Resource Project]
	// (/data-catalog/docs/concepts/resource-project) for more information).
	DeleteTagTemplate(ctx context.Context, in *DeleteTagTemplateRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Creates a field in a tag template. The user should enable the Data Catalog
	// API in the project identified by the `parent` parameter (see
	// [Data Catalog Resource
	// Project](/data-catalog/docs/concepts/resource-project) for more
	// information).
	CreateTagTemplateField(ctx context.Context, in *CreateTagTemplateFieldRequest, opts ...grpc.CallOption) (*TagTemplateField, error)
	// Updates a field in a tag template. This method cannot be used to update the
	// field type. The user should enable the Data Catalog API in the project
	// identified by the `name` parameter (see [Data Catalog Resource Project]
	// (/data-catalog/docs/concepts/resource-project) for more information).
	UpdateTagTemplateField(ctx context.Context, in *UpdateTagTemplateFieldRequest, opts ...grpc.CallOption) (*TagTemplateField, error)
	// Renames a field in a tag template. The user should enable the Data Catalog
	// API in the project identified by the `name` parameter (see [Data Catalog
	// Resource Project](/data-catalog/docs/concepts/resource-project) for more
	// information).
	RenameTagTemplateField(ctx context.Context, in *RenameTagTemplateFieldRequest, opts ...grpc.CallOption) (*TagTemplateField, error)
	// Deletes a field in a tag template and all uses of that field.
	// The user should enable the Data Catalog API in the project identified by
	// the `name` parameter (see [Data Catalog Resource Project]
	// (/data-catalog/docs/concepts/resource-project) for more information).
	DeleteTagTemplateField(ctx context.Context, in *DeleteTagTemplateFieldRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Creates a tag on an [Entry][google.cloud.datacatalog.v1beta1.Entry].
	// Note: The project identified by the `parent` parameter for the
	// [tag](/data-catalog/docs/reference/rest/v1beta1/projects.locations.entryGroups.entries.tags/create#path-parameters)
	// and the
	// [tag
	// template](/data-catalog/docs/reference/rest/v1beta1/projects.locations.tagTemplates/create#path-parameters)
	// used to create the tag must be from the same organization.
	CreateTag(ctx context.Context, in *CreateTagRequest, opts ...grpc.CallOption) (*Tag, error)
	// Updates an existing tag.
	UpdateTag(ctx context.Context, in *UpdateTagRequest, opts ...grpc.CallOption) (*Tag, error)
	// Deletes a tag.
	DeleteTag(ctx context.Context, in *DeleteTagRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Lists the tags on an [Entry][google.cloud.datacatalog.v1beta1.Entry].
	ListTags(ctx context.Context, in *ListTagsRequest, opts ...grpc.CallOption) (*ListTagsResponse, error)
	// Sets the access control policy for a resource. Replaces any existing
	// policy.
	// Supported resources are:
	//   - Tag templates.
	//   - Entries.
	//   - Entry groups.
	// Note, this method cannot be used to manage policies for BigQuery, Cloud
	// Pub/Sub and any external Google Cloud Platform resources synced to Cloud
	// Data Catalog.
	//
	// Callers must have following Google IAM permission
	//   - `datacatalog.tagTemplates.setIamPolicy` to set policies on tag
	//     templates.
	//   - `datacatalog.entries.setIamPolicy` to set policies on entries.
	//   - `datacatalog.entryGroups.setIamPolicy` to set policies on entry groups.
	SetIamPolicy(ctx context.Context, in *v1.SetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error)
	// Gets the access control policy for a resource. A `NOT_FOUND` error
	// is returned if the resource does not exist. An empty policy is returned
	// if the resource exists but does not have a policy set on it.
	//
	// Supported resources are:
	//   - Tag templates.
	//   - Entries.
	//   - Entry groups.
	// Note, this method cannot be used to manage policies for BigQuery, Cloud
	// Pub/Sub and any external Google Cloud Platform resources synced to Cloud
	// Data Catalog.
	//
	// Callers must have following Google IAM permission
	//   - `datacatalog.tagTemplates.getIamPolicy` to get policies on tag
	//     templates.
	//   - `datacatalog.entries.getIamPolicy` to get policies on entries.
	//   - `datacatalog.entryGroups.getIamPolicy` to get policies on entry groups.
	GetIamPolicy(ctx context.Context, in *v1.GetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error)
	// Returns the caller's permissions on a resource.
	// If the resource does not exist, an empty set of permissions is returned
	// (We don't return a `NOT_FOUND` error).
	//
	// Supported resources are:
	//   - Tag templates.
	//   - Entries.
	//   - Entry groups.
	// Note, this method cannot be used to manage policies for BigQuery, Cloud
	// Pub/Sub and any external Google Cloud Platform resources synced to Cloud
	// Data Catalog.
	//
	// A caller is not required to have Google IAM permission to make this
	// request.
	TestIamPermissions(ctx context.Context, in *v1.TestIamPermissionsRequest, opts ...grpc.CallOption) (*v1.TestIamPermissionsResponse, error)
}

type dataCatalogClient struct {
	cc *grpc.ClientConn
}

func NewDataCatalogClient(cc *grpc.ClientConn) DataCatalogClient {
	return &dataCatalogClient{cc}
}

func (c *dataCatalogClient) SearchCatalog(ctx context.Context, in *SearchCatalogRequest, opts ...grpc.CallOption) (*SearchCatalogResponse, error) {
	out := new(SearchCatalogResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1beta1.DataCatalog/SearchCatalog", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) CreateEntryGroup(ctx context.Context, in *CreateEntryGroupRequest, opts ...grpc.CallOption) (*EntryGroup, error) {
	out := new(EntryGroup)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1beta1.DataCatalog/CreateEntryGroup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) GetEntryGroup(ctx context.Context, in *GetEntryGroupRequest, opts ...grpc.CallOption) (*EntryGroup, error) {
	out := new(EntryGroup)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1beta1.DataCatalog/GetEntryGroup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) DeleteEntryGroup(ctx context.Context, in *DeleteEntryGroupRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1beta1.DataCatalog/DeleteEntryGroup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) CreateEntry(ctx context.Context, in *CreateEntryRequest, opts ...grpc.CallOption) (*Entry, error) {
	out := new(Entry)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1beta1.DataCatalog/CreateEntry", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) UpdateEntry(ctx context.Context, in *UpdateEntryRequest, opts ...grpc.CallOption) (*Entry, error) {
	out := new(Entry)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1beta1.DataCatalog/UpdateEntry", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) DeleteEntry(ctx context.Context, in *DeleteEntryRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1beta1.DataCatalog/DeleteEntry", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) GetEntry(ctx context.Context, in *GetEntryRequest, opts ...grpc.CallOption) (*Entry, error) {
	out := new(Entry)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1beta1.DataCatalog/GetEntry", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) LookupEntry(ctx context.Context, in *LookupEntryRequest, opts ...grpc.CallOption) (*Entry, error) {
	out := new(Entry)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1beta1.DataCatalog/LookupEntry", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) CreateTagTemplate(ctx context.Context, in *CreateTagTemplateRequest, opts ...grpc.CallOption) (*TagTemplate, error) {
	out := new(TagTemplate)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1beta1.DataCatalog/CreateTagTemplate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) GetTagTemplate(ctx context.Context, in *GetTagTemplateRequest, opts ...grpc.CallOption) (*TagTemplate, error) {
	out := new(TagTemplate)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1beta1.DataCatalog/GetTagTemplate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) UpdateTagTemplate(ctx context.Context, in *UpdateTagTemplateRequest, opts ...grpc.CallOption) (*TagTemplate, error) {
	out := new(TagTemplate)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1beta1.DataCatalog/UpdateTagTemplate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) DeleteTagTemplate(ctx context.Context, in *DeleteTagTemplateRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1beta1.DataCatalog/DeleteTagTemplate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) CreateTagTemplateField(ctx context.Context, in *CreateTagTemplateFieldRequest, opts ...grpc.CallOption) (*TagTemplateField, error) {
	out := new(TagTemplateField)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1beta1.DataCatalog/CreateTagTemplateField", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) UpdateTagTemplateField(ctx context.Context, in *UpdateTagTemplateFieldRequest, opts ...grpc.CallOption) (*TagTemplateField, error) {
	out := new(TagTemplateField)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1beta1.DataCatalog/UpdateTagTemplateField", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) RenameTagTemplateField(ctx context.Context, in *RenameTagTemplateFieldRequest, opts ...grpc.CallOption) (*TagTemplateField, error) {
	out := new(TagTemplateField)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1beta1.DataCatalog/RenameTagTemplateField", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) DeleteTagTemplateField(ctx context.Context, in *DeleteTagTemplateFieldRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1beta1.DataCatalog/DeleteTagTemplateField", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) CreateTag(ctx context.Context, in *CreateTagRequest, opts ...grpc.CallOption) (*Tag, error) {
	out := new(Tag)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1beta1.DataCatalog/CreateTag", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) UpdateTag(ctx context.Context, in *UpdateTagRequest, opts ...grpc.CallOption) (*Tag, error) {
	out := new(Tag)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1beta1.DataCatalog/UpdateTag", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) DeleteTag(ctx context.Context, in *DeleteTagRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1beta1.DataCatalog/DeleteTag", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) ListTags(ctx context.Context, in *ListTagsRequest, opts ...grpc.CallOption) (*ListTagsResponse, error) {
	out := new(ListTagsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1beta1.DataCatalog/ListTags", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) SetIamPolicy(ctx context.Context, in *v1.SetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error) {
	out := new(v1.Policy)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1beta1.DataCatalog/SetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) GetIamPolicy(ctx context.Context, in *v1.GetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error) {
	out := new(v1.Policy)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1beta1.DataCatalog/GetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) TestIamPermissions(ctx context.Context, in *v1.TestIamPermissionsRequest, opts ...grpc.CallOption) (*v1.TestIamPermissionsResponse, error) {
	out := new(v1.TestIamPermissionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1beta1.DataCatalog/TestIamPermissions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DataCatalogServer is the server API for DataCatalog service.
type DataCatalogServer interface {
	// Searches Data Catalog for multiple resources like entries, tags that
	// match a query.
	//
	// This is a custom method
	// (https://cloud.google.com/apis/design/custom_methods) and does not return
	// the complete resource, only the resource identifier and high level
	// fields. Clients can subsequentally call `Get` methods.
	//
	// Note that searches do not have full recall. There may be results that match
	// your query but are not returned, even in subsequent pages of results. These
	// missing results may vary across repeated calls to search. Do not rely on
	// this method if you need to guarantee full recall.
	//
	// See [Data Catalog Search
	// Syntax](/data-catalog/docs/how-to/search-reference) for more information.
	SearchCatalog(context.Context, *SearchCatalogRequest) (*SearchCatalogResponse, error)
	// Alpha feature.
	// Creates an EntryGroup.
	// The user should enable the Data Catalog API in the project identified by
	// the `parent` parameter (see [Data Catalog Resource Project]
	// (/data-catalog/docs/concepts/resource-project) for more information).
	CreateEntryGroup(context.Context, *CreateEntryGroupRequest) (*EntryGroup, error)
	// Alpha feature.
	// Gets an EntryGroup.
	GetEntryGroup(context.Context, *GetEntryGroupRequest) (*EntryGroup, error)
	// Alpha feature.
	// Deletes an EntryGroup. Only entry groups that do not contain entries can be
	// deleted. The user should enable the Data Catalog API in the project
	// identified by the `name` parameter (see [Data Catalog Resource Project]
	// (/data-catalog/docs/concepts/resource-project) for more information).
	DeleteEntryGroup(context.Context, *DeleteEntryGroupRequest) (*empty.Empty, error)
	// Alpha feature.
	// Creates an entry. Currently only entries of 'FILESET' type can be created.
	// The user should enable the Data Catalog API in the project identified by
	// the `parent` parameter (see [Data Catalog Resource Project]
	// (/data-catalog/docs/concepts/resource-project) for more information).
	CreateEntry(context.Context, *CreateEntryRequest) (*Entry, error)
	// Updates an existing entry.
	// The user should enable the Data Catalog API in the project identified by
	// the `entry.name` parameter (see [Data Catalog Resource Project]
	// (/data-catalog/docs/concepts/resource-project) for more information).
	UpdateEntry(context.Context, *UpdateEntryRequest) (*Entry, error)
	// Alpha feature.
	// Deletes an existing entry. Only entries created through
	// [CreateEntry][google.cloud.datacatalog.v1beta1.DataCatalog.CreateEntry]
	// method can be deleted.
	// The user should enable the Data Catalog API in the project identified by
	// the `name` parameter (see [Data Catalog Resource Project]
	// (/data-catalog/docs/concepts/resource-project) for more information).
	DeleteEntry(context.Context, *DeleteEntryRequest) (*empty.Empty, error)
	// Gets an entry.
	GetEntry(context.Context, *GetEntryRequest) (*Entry, error)
	// Get an entry by target resource name. This method allows clients to use
	// the resource name from the source Google Cloud Platform service to get the
	// Data Catalog Entry.
	LookupEntry(context.Context, *LookupEntryRequest) (*Entry, error)
	// Creates a tag template. The user should enable the Data Catalog API in
	// the project identified by the `parent` parameter (see [Data Catalog
	// Resource Project](/data-catalog/docs/concepts/resource-project) for more
	// information).
	CreateTagTemplate(context.Context, *CreateTagTemplateRequest) (*TagTemplate, error)
	// Gets a tag template.
	GetTagTemplate(context.Context, *GetTagTemplateRequest) (*TagTemplate, error)
	// Updates a tag template. This method cannot be used to update the fields of
	// a template. The tag template fields are represented as separate resources
	// and should be updated using their own create/update/delete methods.
	// The user should enable the Data Catalog API in the project identified by
	// the `tag_template.name` parameter (see [Data Catalog Resource Project]
	// (/data-catalog/docs/concepts/resource-project) for more information).
	UpdateTagTemplate(context.Context, *UpdateTagTemplateRequest) (*TagTemplate, error)
	// Deletes a tag template and all tags using the template.
	// The user should enable the Data Catalog API in the project identified by
	// the `name` parameter (see [Data Catalog Resource Project]
	// (/data-catalog/docs/concepts/resource-project) for more information).
	DeleteTagTemplate(context.Context, *DeleteTagTemplateRequest) (*empty.Empty, error)
	// Creates a field in a tag template. The user should enable the Data Catalog
	// API in the project identified by the `parent` parameter (see
	// [Data Catalog Resource
	// Project](/data-catalog/docs/concepts/resource-project) for more
	// information).
	CreateTagTemplateField(context.Context, *CreateTagTemplateFieldRequest) (*TagTemplateField, error)
	// Updates a field in a tag template. This method cannot be used to update the
	// field type. The user should enable the Data Catalog API in the project
	// identified by the `name` parameter (see [Data Catalog Resource Project]
	// (/data-catalog/docs/concepts/resource-project) for more information).
	UpdateTagTemplateField(context.Context, *UpdateTagTemplateFieldRequest) (*TagTemplateField, error)
	// Renames a field in a tag template. The user should enable the Data Catalog
	// API in the project identified by the `name` parameter (see [Data Catalog
	// Resource Project](/data-catalog/docs/concepts/resource-project) for more
	// information).
	RenameTagTemplateField(context.Context, *RenameTagTemplateFieldRequest) (*TagTemplateField, error)
	// Deletes a field in a tag template and all uses of that field.
	// The user should enable the Data Catalog API in the project identified by
	// the `name` parameter (see [Data Catalog Resource Project]
	// (/data-catalog/docs/concepts/resource-project) for more information).
	DeleteTagTemplateField(context.Context, *DeleteTagTemplateFieldRequest) (*empty.Empty, error)
	// Creates a tag on an [Entry][google.cloud.datacatalog.v1beta1.Entry].
	// Note: The project identified by the `parent` parameter for the
	// [tag](/data-catalog/docs/reference/rest/v1beta1/projects.locations.entryGroups.entries.tags/create#path-parameters)
	// and the
	// [tag
	// template](/data-catalog/docs/reference/rest/v1beta1/projects.locations.tagTemplates/create#path-parameters)
	// used to create the tag must be from the same organization.
	CreateTag(context.Context, *CreateTagRequest) (*Tag, error)
	// Updates an existing tag.
	UpdateTag(context.Context, *UpdateTagRequest) (*Tag, error)
	// Deletes a tag.
	DeleteTag(context.Context, *DeleteTagRequest) (*empty.Empty, error)
	// Lists the tags on an [Entry][google.cloud.datacatalog.v1beta1.Entry].
	ListTags(context.Context, *ListTagsRequest) (*ListTagsResponse, error)
	// Sets the access control policy for a resource. Replaces any existing
	// policy.
	// Supported resources are:
	//   - Tag templates.
	//   - Entries.
	//   - Entry groups.
	// Note, this method cannot be used to manage policies for BigQuery, Cloud
	// Pub/Sub and any external Google Cloud Platform resources synced to Cloud
	// Data Catalog.
	//
	// Callers must have following Google IAM permission
	//   - `datacatalog.tagTemplates.setIamPolicy` to set policies on tag
	//     templates.
	//   - `datacatalog.entries.setIamPolicy` to set policies on entries.
	//   - `datacatalog.entryGroups.setIamPolicy` to set policies on entry groups.
	SetIamPolicy(context.Context, *v1.SetIamPolicyRequest) (*v1.Policy, error)
	// Gets the access control policy for a resource. A `NOT_FOUND` error
	// is returned if the resource does not exist. An empty policy is returned
	// if the resource exists but does not have a policy set on it.
	//
	// Supported resources are:
	//   - Tag templates.
	//   - Entries.
	//   - Entry groups.
	// Note, this method cannot be used to manage policies for BigQuery, Cloud
	// Pub/Sub and any external Google Cloud Platform resources synced to Cloud
	// Data Catalog.
	//
	// Callers must have following Google IAM permission
	//   - `datacatalog.tagTemplates.getIamPolicy` to get policies on tag
	//     templates.
	//   - `datacatalog.entries.getIamPolicy` to get policies on entries.
	//   - `datacatalog.entryGroups.getIamPolicy` to get policies on entry groups.
	GetIamPolicy(context.Context, *v1.GetIamPolicyRequest) (*v1.Policy, error)
	// Returns the caller's permissions on a resource.
	// If the resource does not exist, an empty set of permissions is returned
	// (We don't return a `NOT_FOUND` error).
	//
	// Supported resources are:
	//   - Tag templates.
	//   - Entries.
	//   - Entry groups.
	// Note, this method cannot be used to manage policies for BigQuery, Cloud
	// Pub/Sub and any external Google Cloud Platform resources synced to Cloud
	// Data Catalog.
	//
	// A caller is not required to have Google IAM permission to make this
	// request.
	TestIamPermissions(context.Context, *v1.TestIamPermissionsRequest) (*v1.TestIamPermissionsResponse, error)
}

// UnimplementedDataCatalogServer can be embedded to have forward compatible implementations.
type UnimplementedDataCatalogServer struct {
}

func (*UnimplementedDataCatalogServer) SearchCatalog(ctx context.Context, req *SearchCatalogRequest) (*SearchCatalogResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchCatalog not implemented")
}
func (*UnimplementedDataCatalogServer) CreateEntryGroup(ctx context.Context, req *CreateEntryGroupRequest) (*EntryGroup, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateEntryGroup not implemented")
}
func (*UnimplementedDataCatalogServer) GetEntryGroup(ctx context.Context, req *GetEntryGroupRequest) (*EntryGroup, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetEntryGroup not implemented")
}
func (*UnimplementedDataCatalogServer) DeleteEntryGroup(ctx context.Context, req *DeleteEntryGroupRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteEntryGroup not implemented")
}
func (*UnimplementedDataCatalogServer) CreateEntry(ctx context.Context, req *CreateEntryRequest) (*Entry, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateEntry not implemented")
}
func (*UnimplementedDataCatalogServer) UpdateEntry(ctx context.Context, req *UpdateEntryRequest) (*Entry, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateEntry not implemented")
}
func (*UnimplementedDataCatalogServer) DeleteEntry(ctx context.Context, req *DeleteEntryRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteEntry not implemented")
}
func (*UnimplementedDataCatalogServer) GetEntry(ctx context.Context, req *GetEntryRequest) (*Entry, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetEntry not implemented")
}
func (*UnimplementedDataCatalogServer) LookupEntry(ctx context.Context, req *LookupEntryRequest) (*Entry, error) {
	return nil, status.Errorf(codes.Unimplemented, "method LookupEntry not implemented")
}
func (*UnimplementedDataCatalogServer) CreateTagTemplate(ctx context.Context, req *CreateTagTemplateRequest) (*TagTemplate, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateTagTemplate not implemented")
}
func (*UnimplementedDataCatalogServer) GetTagTemplate(ctx context.Context, req *GetTagTemplateRequest) (*TagTemplate, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTagTemplate not implemented")
}
func (*UnimplementedDataCatalogServer) UpdateTagTemplate(ctx context.Context, req *UpdateTagTemplateRequest) (*TagTemplate, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateTagTemplate not implemented")
}
func (*UnimplementedDataCatalogServer) DeleteTagTemplate(ctx context.Context, req *DeleteTagTemplateRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteTagTemplate not implemented")
}
func (*UnimplementedDataCatalogServer) CreateTagTemplateField(ctx context.Context, req *CreateTagTemplateFieldRequest) (*TagTemplateField, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateTagTemplateField not implemented")
}
func (*UnimplementedDataCatalogServer) UpdateTagTemplateField(ctx context.Context, req *UpdateTagTemplateFieldRequest) (*TagTemplateField, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateTagTemplateField not implemented")
}
func (*UnimplementedDataCatalogServer) RenameTagTemplateField(ctx context.Context, req *RenameTagTemplateFieldRequest) (*TagTemplateField, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RenameTagTemplateField not implemented")
}
func (*UnimplementedDataCatalogServer) DeleteTagTemplateField(ctx context.Context, req *DeleteTagTemplateFieldRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteTagTemplateField not implemented")
}
func (*UnimplementedDataCatalogServer) CreateTag(ctx context.Context, req *CreateTagRequest) (*Tag, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateTag not implemented")
}
func (*UnimplementedDataCatalogServer) UpdateTag(ctx context.Context, req *UpdateTagRequest) (*Tag, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateTag not implemented")
}
func (*UnimplementedDataCatalogServer) DeleteTag(ctx context.Context, req *DeleteTagRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteTag not implemented")
}
func (*UnimplementedDataCatalogServer) ListTags(ctx context.Context, req *ListTagsRequest) (*ListTagsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTags not implemented")
}
func (*UnimplementedDataCatalogServer) SetIamPolicy(ctx context.Context, req *v1.SetIamPolicyRequest) (*v1.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (*UnimplementedDataCatalogServer) GetIamPolicy(ctx context.Context, req *v1.GetIamPolicyRequest) (*v1.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (*UnimplementedDataCatalogServer) TestIamPermissions(ctx context.Context, req *v1.TestIamPermissionsRequest) (*v1.TestIamPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}

func RegisterDataCatalogServer(s *grpc.Server, srv DataCatalogServer) {
	s.RegisterService(&_DataCatalog_serviceDesc, srv)
}

func _DataCatalog_SearchCatalog_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchCatalogRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).SearchCatalog(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1beta1.DataCatalog/SearchCatalog",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).SearchCatalog(ctx, req.(*SearchCatalogRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_CreateEntryGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateEntryGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).CreateEntryGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1beta1.DataCatalog/CreateEntryGroup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).CreateEntryGroup(ctx, req.(*CreateEntryGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_GetEntryGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEntryGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).GetEntryGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1beta1.DataCatalog/GetEntryGroup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).GetEntryGroup(ctx, req.(*GetEntryGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_DeleteEntryGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteEntryGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).DeleteEntryGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1beta1.DataCatalog/DeleteEntryGroup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).DeleteEntryGroup(ctx, req.(*DeleteEntryGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_CreateEntry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateEntryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).CreateEntry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1beta1.DataCatalog/CreateEntry",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).CreateEntry(ctx, req.(*CreateEntryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_UpdateEntry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateEntryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).UpdateEntry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1beta1.DataCatalog/UpdateEntry",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).UpdateEntry(ctx, req.(*UpdateEntryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_DeleteEntry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteEntryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).DeleteEntry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1beta1.DataCatalog/DeleteEntry",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).DeleteEntry(ctx, req.(*DeleteEntryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_GetEntry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEntryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).GetEntry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1beta1.DataCatalog/GetEntry",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).GetEntry(ctx, req.(*GetEntryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_LookupEntry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LookupEntryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).LookupEntry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1beta1.DataCatalog/LookupEntry",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).LookupEntry(ctx, req.(*LookupEntryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_CreateTagTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTagTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).CreateTagTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1beta1.DataCatalog/CreateTagTemplate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).CreateTagTemplate(ctx, req.(*CreateTagTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_GetTagTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTagTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).GetTagTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1beta1.DataCatalog/GetTagTemplate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).GetTagTemplate(ctx, req.(*GetTagTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_UpdateTagTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTagTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).UpdateTagTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1beta1.DataCatalog/UpdateTagTemplate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).UpdateTagTemplate(ctx, req.(*UpdateTagTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_DeleteTagTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTagTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).DeleteTagTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1beta1.DataCatalog/DeleteTagTemplate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).DeleteTagTemplate(ctx, req.(*DeleteTagTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_CreateTagTemplateField_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTagTemplateFieldRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).CreateTagTemplateField(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1beta1.DataCatalog/CreateTagTemplateField",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).CreateTagTemplateField(ctx, req.(*CreateTagTemplateFieldRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_UpdateTagTemplateField_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTagTemplateFieldRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).UpdateTagTemplateField(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1beta1.DataCatalog/UpdateTagTemplateField",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).UpdateTagTemplateField(ctx, req.(*UpdateTagTemplateFieldRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_RenameTagTemplateField_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RenameTagTemplateFieldRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).RenameTagTemplateField(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1beta1.DataCatalog/RenameTagTemplateField",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).RenameTagTemplateField(ctx, req.(*RenameTagTemplateFieldRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_DeleteTagTemplateField_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTagTemplateFieldRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).DeleteTagTemplateField(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1beta1.DataCatalog/DeleteTagTemplateField",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).DeleteTagTemplateField(ctx, req.(*DeleteTagTemplateFieldRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_CreateTag_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTagRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).CreateTag(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1beta1.DataCatalog/CreateTag",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).CreateTag(ctx, req.(*CreateTagRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_UpdateTag_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTagRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).UpdateTag(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1beta1.DataCatalog/UpdateTag",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).UpdateTag(ctx, req.(*UpdateTagRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_DeleteTag_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTagRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).DeleteTag(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1beta1.DataCatalog/DeleteTag",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).DeleteTag(ctx, req.(*DeleteTagRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_ListTags_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTagsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).ListTags(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1beta1.DataCatalog/ListTags",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).ListTags(ctx, req.(*ListTagsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1beta1.DataCatalog/SetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).SetIamPolicy(ctx, req.(*v1.SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1beta1.DataCatalog/GetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).GetIamPolicy(ctx, req.(*v1.GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1beta1.DataCatalog/TestIamPermissions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).TestIamPermissions(ctx, req.(*v1.TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _DataCatalog_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.datacatalog.v1beta1.DataCatalog",
	HandlerType: (*DataCatalogServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "SearchCatalog",
			Handler:    _DataCatalog_SearchCatalog_Handler,
		},
		{
			MethodName: "CreateEntryGroup",
			Handler:    _DataCatalog_CreateEntryGroup_Handler,
		},
		{
			MethodName: "GetEntryGroup",
			Handler:    _DataCatalog_GetEntryGroup_Handler,
		},
		{
			MethodName: "DeleteEntryGroup",
			Handler:    _DataCatalog_DeleteEntryGroup_Handler,
		},
		{
			MethodName: "CreateEntry",
			Handler:    _DataCatalog_CreateEntry_Handler,
		},
		{
			MethodName: "UpdateEntry",
			Handler:    _DataCatalog_UpdateEntry_Handler,
		},
		{
			MethodName: "DeleteEntry",
			Handler:    _DataCatalog_DeleteEntry_Handler,
		},
		{
			MethodName: "GetEntry",
			Handler:    _DataCatalog_GetEntry_Handler,
		},
		{
			MethodName: "LookupEntry",
			Handler:    _DataCatalog_LookupEntry_Handler,
		},
		{
			MethodName: "CreateTagTemplate",
			Handler:    _DataCatalog_CreateTagTemplate_Handler,
		},
		{
			MethodName: "GetTagTemplate",
			Handler:    _DataCatalog_GetTagTemplate_Handler,
		},
		{
			MethodName: "UpdateTagTemplate",
			Handler:    _DataCatalog_UpdateTagTemplate_Handler,
		},
		{
			MethodName: "DeleteTagTemplate",
			Handler:    _DataCatalog_DeleteTagTemplate_Handler,
		},
		{
			MethodName: "CreateTagTemplateField",
			Handler:    _DataCatalog_CreateTagTemplateField_Handler,
		},
		{
			MethodName: "UpdateTagTemplateField",
			Handler:    _DataCatalog_UpdateTagTemplateField_Handler,
		},
		{
			MethodName: "RenameTagTemplateField",
			Handler:    _DataCatalog_RenameTagTemplateField_Handler,
		},
		{
			MethodName: "DeleteTagTemplateField",
			Handler:    _DataCatalog_DeleteTagTemplateField_Handler,
		},
		{
			MethodName: "CreateTag",
			Handler:    _DataCatalog_CreateTag_Handler,
		},
		{
			MethodName: "UpdateTag",
			Handler:    _DataCatalog_UpdateTag_Handler,
		},
		{
			MethodName: "DeleteTag",
			Handler:    _DataCatalog_DeleteTag_Handler,
		},
		{
			MethodName: "ListTags",
			Handler:    _DataCatalog_ListTags_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _DataCatalog_SetIamPolicy_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _DataCatalog_GetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _DataCatalog_TestIamPermissions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/datacatalog/v1beta1/datacatalog.proto",
}
