# Copyright 2023 gRPC authors.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto generated by tools/codegen/core/gen_experiments.py

"""Dictionary of tags to experiments so we know when to test different experiments."""

EXPERIMENT_ENABLES = {
    "call_tracer_in_transport": "call_tracer_in_transport",
    "channelz_use_v2_for_v1_api": "channelz_use_v2_for_v1_api",
    "channelz_use_v2_for_v1_service": "channelz_use_v2_for_v1_service",
    "chaotic_good_connect_deadline": "chaotic_good_connect_deadline",
    "chaotic_good_framing_layer": "chaotic_good_framing_layer",
    "chttp2_bound_write_size": "chttp2_bound_write_size",
    "error_flatten": "error_flatten",
    "event_engine_client": "event_engine_client",
    "event_engine_dns": "event_engine_dns",
    "event_engine_dns_non_client_channel": "event_engine_dns_non_client_channel",
    "event_engine_fork": "event_engine_fork",
    "event_engine_listener": "event_engine_listener",
    "event_engine_callback_cq": "event_engine_callback_cq,event_engine_client,event_engine_listener",
    "event_engine_for_all_other_endpoints": "event_engine_client,event_engine_dns,event_engine_dns_non_client_channel,event_engine_for_all_other_endpoints,event_engine_listener",
    "event_engine_poller_for_python": "event_engine_poller_for_python",
    "event_engine_secure_endpoint": "event_engine_secure_endpoint",
    "fail_recv_metadata_on_deadline_exceeded": "fail_recv_metadata_on_deadline_exceeded",
    "free_large_allocator": "free_large_allocator",
    "fuse_filters": "fuse_filters",
    "graceful_external_connection_failure": "graceful_external_connection_failure",
    "keep_alive_ping_timer_batch": "keep_alive_ping_timer_batch",
    "local_connector_secure": "local_connector_secure",
    "max_inflight_pings_strict_limit": "max_inflight_pings_strict_limit",
    "monitoring_experiment": "monitoring_experiment",
    "multiping": "multiping",
    "otel_export_telemetry_domains": "otel_export_telemetry_domains",
    "pick_first_ignore_empty_updates": "pick_first_ignore_empty_updates",
    "pick_first_ready_to_connecting": "pick_first_ready_to_connecting",
    "pipelined_read_secure_endpoint": "event_engine_client,event_engine_listener,event_engine_secure_endpoint,pipelined_read_secure_endpoint",
    "pollset_alternative": "event_engine_client,event_engine_listener,pollset_alternative",
    "prioritize_finished_requests": "prioritize_finished_requests",
    "promise_based_http2_client_transport": "promise_based_http2_client_transport",
    "promise_based_http2_server_transport": "promise_based_http2_server_transport",
    "promise_based_inproc_transport": "promise_based_inproc_transport",
    "retry_in_callv3": "retry_in_callv3",
    "rr_wrr_connect_from_random_index": "rr_wrr_connect_from_random_index",
    "schedule_cancellation_over_write": "schedule_cancellation_over_write",
    "secure_endpoint_offload_large_reads": "event_engine_client,event_engine_listener,event_engine_secure_endpoint,secure_endpoint_offload_large_reads",
    "secure_endpoint_offload_large_writes": "event_engine_client,event_engine_listener,event_engine_secure_endpoint,secure_endpoint_offload_large_writes",
    "skip_clear_peer_on_cancellation": "skip_clear_peer_on_cancellation",
    "sleep_promise_exec_ctx_removal": "sleep_promise_exec_ctx_removal",
    "sleep_use_non_owning_waker": "sleep_use_non_owning_waker",
    "subchannel_wrapper_cleanup_on_orphan": "subchannel_wrapper_cleanup_on_orphan",
    "tcp_frame_size_tuning": "tcp_frame_size_tuning",
    "tcp_rcv_lowat": "tcp_rcv_lowat",
    "track_writes_in_resource_quota": "track_writes_in_resource_quota",
    "track_zero_copy_allocations_in_resource_quota": "track_zero_copy_allocations_in_resource_quota",
    "transport_state_watcher": "transport_state_watcher",
    "tsi_frame_protector_without_locks": "tsi_frame_protector_without_locks",
    "unconstrained_max_quota_buffer_size": "unconstrained_max_quota_buffer_size",
}

EXPERIMENT_POLLERS = [
    "event_engine_client",
    "event_engine_dns",
    "event_engine_dns_non_client_channel",
    "event_engine_fork",
    "event_engine_listener",
    "event_engine_for_all_other_endpoints",
    "event_engine_poller_for_python",
    "event_engine_secure_endpoint",
    "pipelined_read_secure_endpoint",
]

EXPERIMENTS = {
    "windows": {
        "dbg": {
        },
        "off": {
            "channelz_test": [
                "channelz_use_v2_for_v1_api",
                "channelz_use_v2_for_v1_service",
            ],
            "chttp2_keepalive_tests": [
                "transport_state_watcher",
            ],
            "core_end2end_test": [
                "chttp2_bound_write_size",
                "error_flatten",
                "event_engine_fork",
                "local_connector_secure",
                "otel_export_telemetry_domains",
                "pipelined_read_secure_endpoint",
                "pollset_alternative",
                "promise_based_http2_client_transport",
                "retry_in_callv3",
                "secure_endpoint_offload_large_reads",
                "secure_endpoint_offload_large_writes",
            ],
            "cpp_end2end_test": [
                "error_flatten",
                "subchannel_wrapper_cleanup_on_orphan",
            ],
            "cpp_lb_end2end_test": [
                "pick_first_ready_to_connecting",
                "rr_wrr_connect_from_random_index",
                "transport_state_watcher",
            ],
            "endpoint_test": [
                "tcp_frame_size_tuning",
                "tcp_rcv_lowat",
            ],
            "error_tests": [
                "error_flatten",
            ],
            "event_engine_fork_test": [
                "event_engine_fork",
            ],
            "flow_control_test": [
                "multiping",
                "tcp_frame_size_tuning",
                "tcp_rcv_lowat",
            ],
            "lb_unit_test": [
                "pick_first_ready_to_connecting",
                "rr_wrr_connect_from_random_index",
            ],
            "minimal_stack_test": [
                "fuse_filters",
            ],
            "posix_endpoint_test": [
                "pipelined_read_secure_endpoint",
            ],
            "promise_test": [
                "sleep_promise_exec_ctx_removal",
            ],
            "resource_quota_test": [
                "free_large_allocator",
                "track_writes_in_resource_quota",
                "track_zero_copy_allocations_in_resource_quota",
                "unconstrained_max_quota_buffer_size",
            ],
            "secure_endpoint_test": [
                "pipelined_read_secure_endpoint",
            ],
            "xds_end2end_test": [
                "error_flatten",
                "subchannel_wrapper_cleanup_on_orphan",
            ],
        },
        "on": {
            "cancel_ares_query_test": [
                "event_engine_dns",
            ],
            "core_end2end_test": [
                "chaotic_good_connect_deadline",
                "chaotic_good_framing_layer",
                "event_engine_client",
                "event_engine_dns_non_client_channel",
                "event_engine_for_all_other_endpoints",
                "event_engine_listener",
                "event_engine_secure_endpoint",
            ],
            "event_engine_client_test": [
                "event_engine_client",
            ],
            "event_engine_listener_test": [
                "event_engine_listener",
            ],
            "posix_endpoint_test": [
                "event_engine_secure_endpoint",
            ],
            "promise_test": [
                "sleep_use_non_owning_waker",
            ],
            "resolver_component_tests_runner_invoker": [
                "event_engine_dns",
            ],
            "secure_endpoint_test": [
                "event_engine_secure_endpoint",
            ],
        },
    },
    "ios": {
        "dbg": {
        },
        "off": {
            "channelz_test": [
                "channelz_use_v2_for_v1_api",
                "channelz_use_v2_for_v1_service",
            ],
            "chttp2_keepalive_tests": [
                "transport_state_watcher",
            ],
            "core_end2end_test": [
                "chttp2_bound_write_size",
                "error_flatten",
                "event_engine_fork",
                "local_connector_secure",
                "otel_export_telemetry_domains",
                "pipelined_read_secure_endpoint",
                "pollset_alternative",
                "promise_based_http2_client_transport",
                "retry_in_callv3",
                "secure_endpoint_offload_large_reads",
                "secure_endpoint_offload_large_writes",
            ],
            "cpp_end2end_test": [
                "error_flatten",
                "subchannel_wrapper_cleanup_on_orphan",
            ],
            "cpp_lb_end2end_test": [
                "pick_first_ready_to_connecting",
                "rr_wrr_connect_from_random_index",
                "transport_state_watcher",
            ],
            "endpoint_test": [
                "tcp_frame_size_tuning",
                "tcp_rcv_lowat",
            ],
            "error_tests": [
                "error_flatten",
            ],
            "event_engine_fork_test": [
                "event_engine_fork",
            ],
            "flow_control_test": [
                "multiping",
                "tcp_frame_size_tuning",
                "tcp_rcv_lowat",
            ],
            "lb_unit_test": [
                "pick_first_ready_to_connecting",
                "rr_wrr_connect_from_random_index",
            ],
            "minimal_stack_test": [
                "fuse_filters",
            ],
            "posix_endpoint_test": [
                "pipelined_read_secure_endpoint",
            ],
            "promise_test": [
                "sleep_promise_exec_ctx_removal",
            ],
            "resource_quota_test": [
                "free_large_allocator",
                "track_writes_in_resource_quota",
                "track_zero_copy_allocations_in_resource_quota",
                "unconstrained_max_quota_buffer_size",
            ],
            "secure_endpoint_test": [
                "pipelined_read_secure_endpoint",
            ],
            "xds_end2end_test": [
                "error_flatten",
                "subchannel_wrapper_cleanup_on_orphan",
            ],
        },
        "on": {
            "cancel_ares_query_test": [
                "event_engine_dns",
            ],
            "core_end2end_test": [
                "chaotic_good_connect_deadline",
                "chaotic_good_framing_layer",
                "event_engine_client",
                "event_engine_dns_non_client_channel",
                "event_engine_for_all_other_endpoints",
                "event_engine_listener",
                "event_engine_secure_endpoint",
            ],
            "event_engine_client_test": [
                "event_engine_client",
            ],
            "event_engine_listener_test": [
                "event_engine_listener",
            ],
            "posix_endpoint_test": [
                "event_engine_secure_endpoint",
            ],
            "promise_test": [
                "sleep_use_non_owning_waker",
            ],
            "resolver_component_tests_runner_invoker": [
                "event_engine_dns",
            ],
            "secure_endpoint_test": [
                "event_engine_secure_endpoint",
            ],
        },
    },
    "posix": {
        "dbg": {
        },
        "off": {
            "channelz_test": [
                "channelz_use_v2_for_v1_api",
                "channelz_use_v2_for_v1_service",
            ],
            "chttp2_keepalive_tests": [
                "transport_state_watcher",
            ],
            "core_end2end_test": [
                "chttp2_bound_write_size",
                "error_flatten",
                "event_engine_fork",
                "local_connector_secure",
                "otel_export_telemetry_domains",
                "pipelined_read_secure_endpoint",
                "pollset_alternative",
                "promise_based_http2_client_transport",
                "retry_in_callv3",
                "secure_endpoint_offload_large_reads",
                "secure_endpoint_offload_large_writes",
            ],
            "cpp_end2end_test": [
                "error_flatten",
                "subchannel_wrapper_cleanup_on_orphan",
            ],
            "cpp_lb_end2end_test": [
                "pick_first_ready_to_connecting",
                "rr_wrr_connect_from_random_index",
                "transport_state_watcher",
            ],
            "endpoint_test": [
                "tcp_frame_size_tuning",
                "tcp_rcv_lowat",
            ],
            "error_tests": [
                "error_flatten",
            ],
            "event_engine_fork_test": [
                "event_engine_fork",
            ],
            "flow_control_test": [
                "multiping",
                "tcp_frame_size_tuning",
                "tcp_rcv_lowat",
            ],
            "lb_unit_test": [
                "pick_first_ready_to_connecting",
                "rr_wrr_connect_from_random_index",
            ],
            "minimal_stack_test": [
                "fuse_filters",
            ],
            "posix_endpoint_test": [
                "pipelined_read_secure_endpoint",
            ],
            "promise_test": [
                "sleep_promise_exec_ctx_removal",
            ],
            "resource_quota_test": [
                "free_large_allocator",
                "track_writes_in_resource_quota",
                "track_zero_copy_allocations_in_resource_quota",
                "unconstrained_max_quota_buffer_size",
            ],
            "secure_endpoint_test": [
                "pipelined_read_secure_endpoint",
            ],
            "xds_end2end_test": [
                "error_flatten",
                "subchannel_wrapper_cleanup_on_orphan",
            ],
        },
        "on": {
            "cancel_ares_query_test": [
                "event_engine_dns",
            ],
            "core_end2end_test": [
                "chaotic_good_connect_deadline",
                "chaotic_good_framing_layer",
                "event_engine_client",
                "event_engine_dns_non_client_channel",
                "event_engine_for_all_other_endpoints",
                "event_engine_listener",
                "event_engine_secure_endpoint",
            ],
            "event_engine_client_test": [
                "event_engine_client",
            ],
            "event_engine_listener_test": [
                "event_engine_listener",
            ],
            "posix_endpoint_test": [
                "event_engine_secure_endpoint",
            ],
            "promise_test": [
                "sleep_use_non_owning_waker",
            ],
            "resolver_component_tests_runner_invoker": [
                "event_engine_dns",
            ],
            "secure_endpoint_test": [
                "event_engine_secure_endpoint",
            ],
        },
    },
}
