/*
  Copyright(C) 2002-2007 Pierre Mazire
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

/*
  mamory.h

  libmamory header
*/

#ifndef MAMORY_MAMORY_H
#define MAMORY_MAMORY_H

#define LIB_VER_MAJ 0
#define LIB_VER_MIN 2
#define LIB_VER_MISC 25

#include <stdio.h>
#include <mamory/chainlst.h>
#include <mamory/readinfo.h>
#include <mamory/rommngr.h>
#include <mamory/writerom.h>
#include <mamory/printrom.h>
#include <mamory/modeconv.h>

extern unsigned int Libmamory_WARNING_On;               // Print warning msg
extern unsigned int Libmamory_ERROR_On;                 // Print error msg
extern unsigned int Libmamory_OUTPUT_On;                // Print output msg
extern unsigned int Libmamory_DEBUG_On;                 // Print debug msg
extern unsigned int Libmamory_HEADER_OUTPUT_On;         // Print [OUTPUT] 
extern unsigned int Libmamory_HEADER_WARNING_On;        // Print [WARNING]
extern unsigned int Libmamory_HEADER_ERROR_On;          // Print [ERROR]
extern unsigned int Libmamory_HEADER_DEBUG_On;          // Print [DEBUG]
extern unsigned int Libmamory_HEADER_OUTPUT_LIBNAME_On; // 
extern unsigned int Libmamory_HEADER_WARNING_LIBNAME_On;// Print the lib name
extern unsigned int Libmamory_HEADER_ERROR_LIBNAME_On;  //
extern unsigned int Libmamory_HEADER_DEBUG_LIBNAME_On;  //

extern FILE *Libmamory_out;
extern FILE *Libmamory_err;


#endif
