/*
  Copyright(C) 2002-2007 Pierre Mazire
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

/*
  modeconv.c

  Storage mode conversion functions
*/

#include "common.h"
#include <stdio.h>
#include <mamory/readinfo.h>
#include <mamory/modeconv.h>

void AddRomToGameRoms(s_GameInfo *GameInfo,
		      s_RomInfo *Rom)
{
  unsigned int i;
  
  GameInfo->Roms=XREALLOC(GameInfo->Roms,
			  s_RomInfo*,GameInfo->NbrRoms+1);

  GameInfo->Roms[GameInfo->NbrRoms]=Rom;
  GameInfo->NbrRoms++;

  for(i=0;i<Rom->Content->NbrAssociatedGames;i++)
    if(Rom->Content->AssociatedGames[i]->Game==GameInfo)
      break;
  
  if(i==Rom->Content->NbrAssociatedGames)
    {		      
      Rom->Content->AssociatedGames=
	XREALLOC(Rom->Content->AssociatedGames,
		 s_RomAssociatedGame*,
		 Rom->Content->NbrAssociatedGames+1);

      Rom->Content->AssociatedGames[Rom->Content->NbrAssociatedGames]=
	XCALLOC(s_RomAssociatedGame,1);

      Rom->Content->AssociatedGames[Rom->Content->NbrAssociatedGames]->NbFiles=1;
      Rom->Content->AssociatedGames[Rom->Content->NbrAssociatedGames]->Game=GameInfo;
      Rom->Content->NbrAssociatedGames++;
    }
  else
    Rom->Content->AssociatedGames[i]->NbFiles++;
};

void AddRomToGameMergedRoms(s_GameInfo *GameInfo,
			    s_RomInfo *Rom)
{
  GameInfo->More->MergedRoms=XREALLOC(GameInfo->More->MergedRoms,
				      s_RomInfo*,
				      GameInfo->More->NbrMergedRoms+1);

  GameInfo->More->MergedRoms[GameInfo->More->NbrMergedRoms]=Rom;
  GameInfo->More->NbrMergedRoms++;
};

s_RomInfo *AddRomToRomSharedRoms(s_GameInfo *GameInfo,
				 s_RomInfo *Rom,
				 unsigned char *CloneGameName)
{
  unsigned int i,j;
  unsigned char *Name=NULL;
  s_RomInfo *RomInfo=NULL;

  if(Rom->Merge!=NULL)
    Name=Rom->Merge;
  else
    Name=Rom->Name;

  for(i=0;i<GameInfo->NbrRoms;i++)
    if((strcmp(GameInfo->Roms[i]->Name,Name)==0 &&
	GameInfo->Roms[i]->Content->CRC==Rom->Content->CRC &&
	GameInfo->Roms[i]->Content->Size==Rom->Content->Size) ||
       (strcmp(GameInfo->Roms[i]->Name,Name)==0 &&
	GameInfo->Roms[i]->Content->CRC==~Rom->Content->CRC &&
	GameInfo->Roms[i]->Content->Size==Rom->Content->Size))
      {
	if(CloneGameName!=NULL)
	  {
	    for(j=0;j<GameInfo->Roms[i]->NbrShared;j++)
	      if(((GameInfo->Roms[i]->Shared[j]->RomName!=NULL && strcmp(GameInfo->Roms[i]->Shared[j]->RomName,Rom->Name)==0) ||
		  (GameInfo->Roms[i]->Shared[j]->RomName==NULL && strcmp(GameInfo->Roms[i]->Name,Rom->Name)==0)) &&
		 strcmp(GameInfo->Roms[i]->Shared[j]->CloneName,CloneGameName)==0)
		break;
	    if(j!=GameInfo->Roms[i]->NbrShared)
	      continue;
	    else
	      break;
	  }
	break;
      };

    
  if(i==GameInfo->NbrRoms && CloneGameName!=NULL)
    {
      for(i=0;i<GameInfo->NbrRoms;i++)
	if((strcmp(GameInfo->Roms[i]->Name,Name)!=0 &&
	    GameInfo->Roms[i]->Content->CRC==Rom->Content->CRC &&
	    GameInfo->Roms[i]->Content->Size==Rom->Content->Size) ||
	   (strcmp(GameInfo->Roms[i]->Name,Name)!=0 &&
	    GameInfo->Roms[i]->Content->CRC==~Rom->Content->CRC &&
	    GameInfo->Roms[i]->Content->Size==Rom->Content->Size))
	  {
	    for(j=0;j<GameInfo->Roms[i]->NbrShared;j++)
	      if(((GameInfo->Roms[i]->Shared[j]->RomName!=NULL &&strcmp(GameInfo->Roms[i]->Shared[j]->RomName,Rom->Name)==0) ||
		  (GameInfo->Roms[i]->Shared[j]->RomName==NULL && strcmp(GameInfo->Roms[i]->Name,Rom->Name)==0)) &&
		 strcmp(GameInfo->Roms[i]->Shared[j]->CloneName,CloneGameName)==0)
		break;
	    if(j!=GameInfo->Roms[i]->NbrShared)
	      continue;
	    else
	      break;
	  };
    };

  // !! VERIFIER QUE LA ROM TROUVER NE POSSEDE PAS DEJA CE SHARE
  // !! SI OUI c'est surement que la rom est en double dans le game
  // !! donc il faut trouver le double pour y associer un nouveau shared
  
/*
  if(i!=GameInfo->NbrRoms && CloneGamename!=NULL)
    {
      for(j=0;j<GameInfo->Roms[i]->NbrShared;j++)
	{
	  if(strcmp(GameInfo->Roms[i]->Shared[j]->RomName,Rom->Name)==0 &&
	     strcmp(CloneGameName,Rom->GameName)==0)
*/    

  switch(GameInfo->NbrRoms!=i)
    {
    case FALSE:
      if(Rom->Merge!=NULL)
	{
	  if(GameInfo->More->Resource!=NULL)
	    {
	      for(i=0;i<GameInfo->More->NbrMergedRoms;i++)
		if(strcmp(GameInfo->More->MergedRoms[i]->Name,Name)==0)
		  break;
	      
	      if (i==GameInfo->More->NbrMergedRoms)
		{
		  LPRINTF(WARNING,
			  "Merged Rom from %s (%s) not found in %s",
			  Rom->Name,Name,GameInfo->Name);
		  break;
		}
	      break;
	    }
	  else
	    {
	      LPRINTF(WARNING,
		      "Merged Rom from %s (%s) not found in %s",
		      Rom->Name,Name,GameInfo->Name);
	      break;
	    };
	}
      else
	return Rom;
    default:
      if(RomInfo==NULL)
	RomInfo=GameInfo->Roms[i];

      RomInfo->Shared=XREALLOC(RomInfo->Shared,
			       s_SharedRomInfo*,RomInfo->NbrShared+1);

      RomInfo->Shared[RomInfo->NbrShared]=XMALLOC(s_SharedRomInfo,1);

      if(CloneGameName!=NULL)
	RomInfo->Shared[RomInfo->NbrShared]->CloneName=XSTRDUP(CloneGameName);
      else
	RomInfo->Shared[RomInfo->NbrShared]->CloneName=XSTRDUP(Rom->GameName);
      if(strcmp(Rom->Name,Name)!=0)
	RomInfo->Shared[RomInfo->NbrShared]->RomName=XSTRDUP(Rom->Name);
      else
	RomInfo->Shared[RomInfo->NbrShared]->RomName=NULL;
      RomInfo->Shared[RomInfo->NbrShared]->Status=Rom->Status; 
      // TODO: verify if crc is a complement of the original
      //       if yes, then one of the rom has a NO_GOOD_DUMP_KNOWN status
      if(Rom->Hardware!=NULL)
	{
	  RomInfo->Shared[RomInfo->NbrShared]->Hardware=XCALLOC(s_RomHardwareInfo,1);

	  RomInfo->Shared[RomInfo->NbrShared]->Hardware->Region=XSTRDUP(Rom->Hardware->Region);
	  RomInfo->Shared[RomInfo->NbrShared]->Hardware->Flags=XSTRDUP(Rom->Hardware->Flags);
	  RomInfo->Shared[RomInfo->NbrShared]->Hardware->Offset=Rom->Hardware->Offset;
	}
      else
	RomInfo->Shared[RomInfo->NbrShared]->Hardware=NULL;
      RomInfo->NbrShared++;
    };
  
  FreeRomInfo(Rom);
  Rom=NULL;
  return(Rom);
};

s_GameInfo *ConvertGameInfoSTMODEFromSPLITToMERGE(s_GamesList *GamesList,
						  unsigned char *Name)
{
  s_GameInfo *GameInfo1, *GameInfo2;
  s_RomInfo *Rom;
  unsigned int i,j,k,z;

  for(i=0;i<GamesList->NbrGames;i++)
    if(GamesList->Games[i]!=NULL &&
       strcmp(GamesList->Games[i]->Name,Name)==0)
      break;
  
  if(i==GamesList->NbrGames)
    return NULL;
  
  GameInfo1=GamesList->Games[i];
  z=i;
  
  if(GameInfo1->More->CloneOf!=NULL)
    {
      for(i=0;i<GamesList->NbrGames;i++)
	if(GamesList->Games[i]!=NULL &&
	   strcmp(GamesList->Games[i]->Name,
		  GameInfo1->More->CloneOf)==0)
	  break; 
      
      if(i==GamesList->NbrGames)
	{
	  LPRINTF(ERROR,"SPLIT to MERGE conversion: cloneof %s not found",
		  GameInfo1->More->CloneOf);
	  return NULL;
	};
      
      GameInfo2=GamesList->Games[i];
      
      GameInfo2->More->Clones=XREALLOC(GameInfo2->More->Clones,
				       s_CloneInfo*,
				       GameInfo2->More->NbrClones+1);

      GameInfo2->More->Clones[GameInfo2->More->NbrClones]=XCALLOC(s_CloneInfo,1);

      GameInfo2->More->Clones[GameInfo2->More->NbrClones]->Name=XSTRDUP(GameInfo1->Name);
      GameInfo2->More->Clones[GameInfo2->More->NbrClones]->Description=XSTRDUP(GameInfo1->More->Description);
      GameInfo2->More->NbrClones++;
      
      for(i=0;i<GameInfo1->NbrRoms;i++)
	{
	  Rom=AddRomToRomSharedRoms(GameInfo2,GameInfo1->Roms[i],NULL);
	  if(Rom!=NULL)
	    AddRomToGameRoms(GameInfo2,Rom);

	  GameInfo1->Roms[i]=NULL;
	};
      
      for(i=0;i<GameInfo1->More->NbrMergedRoms;i++)
	{
	  Rom=AddRomToRomSharedRoms(GameInfo2,GameInfo1->More->MergedRoms[i],GameInfo1->Name);
	  if(Rom==NULL)
	    GameInfo1->More->MergedRoms[i]=NULL;
	  else
	    {
//	    LPRINTF(WARNING,"SPLIT to MERGE Conversion:  merged rom from %s (%s) not found in %s",
//		    Rom->Name,Rom->Merge,GameInfo2->Name);
	      // Rom is not part of the parent game but is stored as shared
	      // therefore it should be a resource rom which should be added
	      // to the mergedroms of GameInfo2
	      AddRomToGameMergedRoms(GameInfo2,Rom);
	      GameInfo1->More->MergedRoms[i]=NULL;	      
	    };

	};
            
      if(GameInfo1->More->Resource!=NULL)
	for(i=0;i<GamesList->NbrResources;i++)
	  if(strcmp(GamesList->Resources[i]->Name,GameInfo1->More->Resource)==0)
	    {
	      for(j=0;j<GamesList->Resources[i]->NbrAssociatedGames;j++)
		if(GamesList->Resources[i]->AssociatedGames[j]==GameInfo1)
		  {
		    GamesList->Resources[i]->AssociatedGames[j]=NULL;
		    break;
		  };
	      if(j!=GamesList->Resources[i]->NbrAssociatedGames)
		{
		  for(k=j+1;k<GamesList->Resources[i]->NbrAssociatedGames;k++)
		    GamesList->Resources[i]->AssociatedGames[k-1]=
		      GamesList->Resources[i]->AssociatedGames[k];
		  GamesList->Resources[i]->AssociatedGames[k-1]=NULL;
		  GamesList->Resources[i]->AssociatedGames=
		    XREALLOC(GamesList->Resources[i]->AssociatedGames,
			     s_GameInfo*,
			     GamesList->Resources[i]->NbrAssociatedGames-1);
		  GamesList->Resources[i]->NbrAssociatedGames--;
		};
	      break;
	    };
       
      FreeGameInfo(GameInfo1);
      GamesList->Games[z]=NULL;

      return GameInfo2;
    };

  return NULL;
};
	  
void ConvertGameInfoSTMODEFromMERGEToSPLIT(s_GamesList *GamesList,
					   s_GameInfo *GameInfo)
{
  unsigned int i,j,k,l,nbrroms;
  s_GameInfo **GameClones=NULL;
  s_RomAssociatedGame **AssociatedGames=NULL;
  s_RomInfo **Roms=NULL;
  s_RomInfo *Rom=NULL;

//  printf("%s\n",GameInfo->Name);
  GameClones=XMALLOC(s_GameInfo*,GameInfo->More->NbrClones);


  for(i=0;i<GameInfo->More->NbrClones;i++)
    {
      GameClones[i]=XCALLOC(s_GameInfo,1);

      GameClones[i]->Name=XSTRDUP(GameInfo->More->Clones[i]->Name);
      
      GameClones[i]->More=XCALLOC(s_MoreGameInfo,1);

      GameClones[i]->More->Description=XSTRDUP(GameInfo->More->Clones[i]->Description);
      GameClones[i]->More->CloneOf=XSTRDUP(GameInfo->Name);

      if(GameInfo->More->Resource!=NULL)
	{
	  GameClones[i]->More->Resource=XSTRDUP(GameInfo->More->Resource);
	  for(j=0;j<GamesList->NbrResources;j++)
	    if(strcmp(GamesList->Resources[j]->Name,
		      GameInfo->More->Resource)==0)
	      {
		GamesList->Resources[j]->AssociatedGames=
		  XREALLOC(GamesList->Resources[j]->AssociatedGames,
			   s_GameInfo*,
			   GamesList->Resources[j]->NbrAssociatedGames+1);
		GamesList->Resources[j]->AssociatedGames[GamesList->Resources[j]->NbrAssociatedGames]=GameClones[i];
		GamesList->Resources[j]->NbrAssociatedGames++;
		break;
	      };
	};
		  
      GameClones[i]->More->RomOf=XSTRDUP(GameInfo->Name);
      
/*
      if(GameInfo->More->Misc[i]!=NULL)
	GameClones[i]->More->Misc=XCALLOC(s_MiscGameInfo,1);
*/      
      for(j=0;j<GameInfo->NbrRoms;j++)
	{
	  if(GameInfo->Roms[j]!=NULL &&
	     strcmp(GameInfo->Roms[j]->GameName,GameClones[i]->Name)==0)
	    {
	      GameClones[i]->Roms=XREALLOC(GameClones[i]->Roms,
					   s_RomInfo*,
					   GameClones[i]->NbrRoms+1);

	      GameClones[i]->Roms[GameClones[i]->NbrRoms]=GameInfo->Roms[j];
	      for(k=0;k<GameInfo->Roms[j]->Content->NbrAssociatedGames;k++)
		if(GameInfo->Roms[j]->Content->AssociatedGames[k]->Game==GameInfo)
		  {
		    GameInfo->Roms[j]->Content->AssociatedGames[k]->NbFiles--;
		    break;
		  };

	      if(k!=GameInfo->Roms[j]->Content->NbrAssociatedGames &&
		 GameInfo->Roms[j]->Content->AssociatedGames[k]->NbFiles==0)
		{
		  for(l=0;l<GameInfo->Roms[j]->Content->NbrAssociatedGames;l++)
		    if(GameInfo->Roms[j]->Content->AssociatedGames[l]->Game==GameClones[i])
		      {
			GameInfo->Roms[j]->Content->AssociatedGames[l]->NbFiles++;
			break;
		      };

		  if(l==GameInfo->Roms[j]->Content->NbrAssociatedGames)
		    {
		      GameInfo->Roms[j]->Content->AssociatedGames[k]->NbFiles++;
		      GameInfo->Roms[j]->Content->AssociatedGames[k]->Game=GameClones[i];
		    }
		  else
		    {
		      XFREE(GameInfo->Roms[j]->Content->AssociatedGames[k]);
		      AssociatedGames=
			XCALLOC(s_RomAssociatedGame*,
				GameInfo->Roms[j]->Content->NbrAssociatedGames-1);

		      for(l=0;l<k;l++)
			AssociatedGames[l]=GameInfo->Roms[j]->Content->AssociatedGames[l];
		      for(l=k+1;l<GameInfo->Roms[j]->Content->NbrAssociatedGames;l++)
			AssociatedGames[l-1]=GameInfo->Roms[j]->Content->AssociatedGames[l];
		      XFREE(GameInfo->Roms[j]->Content->AssociatedGames);
		      GameInfo->Roms[j]->Content->AssociatedGames=AssociatedGames;
		      GameInfo->Roms[j]->Content->NbrAssociatedGames--;
		    };
		};
	      GameClones[i]->NbrRoms++;
	      // !!!! CF: ROMS COMMUNES ...
	      // GameInfo->Roms[j]=NULL; // !!! NETTOYER LA LISTE A LA FIN 
	    };

	  if(GameInfo->Roms[j]!=NULL &&
	     strcmp(GameInfo->Roms[j]->GameName,GameInfo->Name)==0)
	    {
	      // si Shared->CloneName=GameClones[i]->Name, 
	      // ajout de ces roms aux MergedRoms
	      for(k=0;k<GameInfo->Roms[j]->NbrShared;k++)
		if(GameInfo->Roms[j]->Shared[k]!=NULL &&
		   strcmp(GameInfo->Roms[j]->Shared[k]->CloneName,
			  GameClones[i]->Name)==0)
		  break;
	      
	      if(k!=GameInfo->Roms[j]->NbrShared)
		{
		  Rom=XMALLOC(s_RomInfo,1);

		  Rom->Source=GameInfo->Roms[j]->Source;
		  if(GameInfo->Roms[j]->Shared[k]->RomName!=NULL)
		    Rom->Name=XSTRDUP(GameInfo->Roms[j]->Shared[k]->RomName);
		  else
		    Rom->Name=XSTRDUP(GameInfo->Roms[j]->Name);
		  Rom->GameName=XSTRDUP(GameInfo->Name);
		  Rom->Merge=XSTRDUP(GameInfo->Roms[j]->Name);
		  Rom->Status=GameInfo->Roms[j]->Shared[k]->Status;
		  Rom->Content=GameInfo->Roms[j]->Content;
		  Rom->NbrShared=0;
		  Rom->Shared=NULL;
		  if(GameInfo->Roms[j]->Shared[k]->Hardware!=NULL)
		    {
		      Rom->Hardware=XCALLOC(s_RomHardwareInfo,1);

		      Rom->Hardware->Region=XSTRDUP(GameInfo->Roms[j]->Shared[k]->Hardware->Region);
		      Rom->Hardware->Flags=XSTRDUP(GameInfo->Roms[j]->Shared[k]->Hardware->Flags);
		      Rom->Hardware->Offset=GameInfo->Roms[j]->Shared[k]->Hardware->Offset;
		    }
		  else
		    Rom->Hardware=NULL;
		  
		  GameClones[i]->More->MergedRoms=
		    XREALLOC(GameClones[i]->More->MergedRoms,
			     s_RomInfo*,
			     GameClones[i]->More->NbrMergedRoms+1);

		  GameClones[i]->More->MergedRoms[GameClones[i]->More->NbrMergedRoms]=Rom;
		  GameClones[i]->More->NbrMergedRoms++;

		  FreeSharedRomInfo(GameInfo->Roms[j]->Shared[k]);
		  GameInfo->Roms[j]->Shared[k]=NULL;
		};
	    };    

	  if(GameInfo->Roms[j]!=NULL &&
	     strcmp(GameInfo->Roms[j]->GameName,GameInfo->Name)!=0 &&
	     strcmp(GameInfo->Roms[j]->GameName,GameClones[i]->Name)!=0)
	    {
	      // ROMS COMMUNES DANS LES MERGED COMME 
	      // PUCKMAN: pacman.6e, pacman.6f, pacman.6h
	      for(k=0;k<GameInfo->Roms[j]->NbrShared;k++)
		if(GameInfo->Roms[j]->Shared[k]!=NULL &&
		   strcmp(GameInfo->Roms[j]->Shared[k]->CloneName,
			  GameClones[i]->Name)==0)
		  break;	      
	      if(k!=GameInfo->Roms[j]->NbrShared)
		{
		  Rom=XMALLOC(s_RomInfo,1);

		  Rom->Source=GameInfo->Roms[j]->Source;
		  if(GameInfo->Roms[j]->Shared[k]->RomName!=NULL)
		    Rom->Name=XSTRDUP(GameInfo->Roms[j]->Shared[k]->RomName);
		  else
		    Rom->Name=XSTRDUP(GameInfo->Roms[j]->Name);
		  Rom->GameName=XSTRDUP(GameClones[i]->Name);
		  Rom->Merge=NULL;
		  Rom->Status=GameInfo->Roms[j]->Shared[k]->Status;
		  Rom->Content=GameInfo->Roms[j]->Content;
		  Rom->NbrShared=0;
		  Rom->Shared=NULL;

		  if(GameInfo->Roms[j]->Shared[k]->Hardware!=NULL)
		    {
		      Rom->Hardware=XCALLOC(s_RomHardwareInfo,1);

		      Rom->Hardware->Region=XSTRDUP(GameInfo->Roms[j]->Shared[k]->Hardware->Region);
		      Rom->Hardware->Flags=XSTRDUP(GameInfo->Roms[j]->Shared[k]->Hardware->Flags);
		      Rom->Hardware->Offset=GameInfo->Roms[j]->Shared[k]->Hardware->Offset;
		    }
		  else
		    Rom->Hardware=NULL;
		  
		  GameClones[i]->Roms=XREALLOC(GameClones[i]->Roms,
					       s_RomInfo*,
					       GameClones[i]->NbrRoms+1);

		  GameClones[i]->Roms[GameClones[i]->NbrRoms]=Rom;
		  GameClones[i]->NbrRoms++;

		  for(l=0;l<Rom->Content->NbrAssociatedGames;l++)
		    if(Rom->Content->AssociatedGames[l]->Game==GameClones[i])
		      {
			Rom->Content->AssociatedGames[l]->NbFiles++;
			break;
		      };
		  
		  if(l==Rom->Content->NbrAssociatedGames)
		    {
		      Rom->Content->AssociatedGames=
			XREALLOC(Rom->Content->AssociatedGames,
				 s_RomAssociatedGame*,
				 Rom->Content->NbrAssociatedGames+1);

		      Rom->Content->AssociatedGames[Rom->Content->NbrAssociatedGames]=calloc(1,sizeof(s_RomAssociatedGame));
		      
		      Rom->Content->AssociatedGames[Rom->Content->NbrAssociatedGames]->NbFiles++;
		      Rom->Content->AssociatedGames[Rom->Content->NbrAssociatedGames]->Game=GameClones[i];
		      Rom->Content->NbrAssociatedGames++;
		    };
		  
		  FreeSharedRomInfo(GameInfo->Roms[j]->Shared[k]);
		  GameInfo->Roms[j]->Shared[k]=NULL;
		};
	    };    
	};
	      
      // Copier les MergedRoms dans GameClones[i]
      if(GameInfo->More->NbrMergedRoms!=0)
	{
	  GameClones[i]->More->MergedRoms=
	    XREALLOC(GameClones[i]->More->MergedRoms,
		     s_RomInfo*,
		     GameClones[i]->More->NbrMergedRoms+GameInfo->More->NbrMergedRoms);

	  for(j=0;j<GameInfo->More->NbrMergedRoms;j++)
	    {
	      GameClones[i]->More->MergedRoms[GameClones[i]->More->NbrMergedRoms+j]=XCALLOC(s_RomInfo,1);

	      GameClones[i]->More->MergedRoms[GameClones[i]->More->NbrMergedRoms+j]->Source=GameInfo->More->MergedRoms[j]->Source;
	      GameClones[i]->More->MergedRoms[GameClones[i]->More->NbrMergedRoms+j]->Name=XSTRDUP(GameInfo->More->MergedRoms[j]->Name);
	      GameClones[i]->More->MergedRoms[GameClones[i]->More->NbrMergedRoms+j]->GameName=XSTRDUP(GameInfo->More->MergedRoms[j]->GameName);
	      if(GameInfo->More->MergedRoms[j]->Merge!=NULL)
		GameClones[i]->More->MergedRoms[GameClones[i]->More->NbrMergedRoms+j]->Merge=XSTRDUP(GameInfo->More->MergedRoms[j]->Merge);
	      GameClones[i]->More->MergedRoms[GameClones[i]->More->NbrMergedRoms+j]->Status=GameInfo->More->MergedRoms[j]->Status;
	      GameClones[i]->More->MergedRoms[GameClones[i]->More->NbrMergedRoms+j]->Content=GameInfo->More->MergedRoms[j]->Content;
	      if(GameInfo->More->MergedRoms[j]->Hardware!=NULL)
		{
		  GameClones[i]->More->MergedRoms[GameClones[i]->More->NbrMergedRoms+j]->Hardware=XCALLOC(s_RomHardwareInfo,1);

		  if(GameInfo->More->MergedRoms[GameClones[i]->More->NbrMergedRoms+j]->Hardware->Region!=NULL)
		    GameClones[i]->More->MergedRoms[GameClones[i]->More->NbrMergedRoms+j]->Hardware->Region=XSTRDUP(GameInfo->More->MergedRoms[j]->Hardware->Region);
		  if(GameInfo->More->MergedRoms[GameClones[i]->More->NbrMergedRoms+j]->Hardware->Flags!=NULL)
		    GameClones[i]->More->MergedRoms[GameClones[i]->More->NbrMergedRoms+j]->Hardware->Flags=XSTRDUP(GameInfo->More->MergedRoms[j]->Hardware->Flags);
		  GameClones[i]->More->MergedRoms[GameClones[i]->More->NbrMergedRoms+j]->Hardware->Offset=GameInfo->More->MergedRoms[j]->Hardware->Offset;
		};
	    };
	  GameClones[i]->More->NbrMergedRoms+=GameInfo->More->NbrMergedRoms;
	};

      GamesList->Games=XREALLOC(GamesList->Games,
				s_GameInfo*,
				GamesList->NbrGames+1);

      GamesList->Games[GamesList->NbrGames]=GameClones[i];
      GamesList->NbrGames++;
    };

  // 1) pour chaque rom :
  //        - verifier que tous les shared==NULL ou NbrShared=0 et 
  //          free(Shared)
  //        - si GameName!=GameInfo->Name, Rom=NULL (pas free, car transfert)
  nbrroms=0;
  for(i=0;i<GameInfo->NbrRoms;i++)
    {
      if(GameInfo->Roms[i]!=NULL)
	{
	  for(j=0;j<GameInfo->Roms[i]->NbrShared;j++)
	    if(GameInfo->Roms[i]->Shared[j]!=NULL)
	      {
		LPRINTF(DEBUG,"Game %s, Rom %s shared with %s",
			GameInfo->Name,GameInfo->Roms[i]->Name,GameInfo->Roms[i]->Shared[j]->CloneName);
		FreeSharedRomInfo(GameInfo->Roms[i]->Shared[j]);
//		break;
	      };
	  
	  XFREE(GameInfo->Roms[i]->Shared);
	  GameInfo->Roms[i]->NbrShared=0;
	  if(strcmp(GameInfo->Roms[i]->GameName,GameInfo->Name)!=0)
	    GameInfo->Roms[i]=NULL;
	  else
	    nbrroms++;
	};
    };
  
  // 2) refaire la liste des Roms
  Roms=XCALLOC(s_RomInfo*,nbrroms);

  j=0;
  for(i=0;i<GameInfo->NbrRoms;i++)
    if(GameInfo->Roms[i]!=NULL)
      {
	Roms[j]=GameInfo->Roms[i];
	GameInfo->Roms[i]=NULL;
	j++;
      };
  if(j!=nbrroms)
    LPRINTF(ERROR,"Roms reallocation problems");
  
  XFREE(GameInfo->Roms);
  GameInfo->Roms=Roms;
  GameInfo->NbrRoms=nbrroms;

  //3) eliminer les clonesinfos
  for(i=0;i<GameInfo->More->NbrClones;i++)
    {
      XFREE(GameInfo->More->Clones[i]->Name);
      XFREE(GameInfo->More->Clones[i]->Description);
      XFREE(GameInfo->More->Clones[i]);
    };
  XFREE(GameInfo->More->Clones);
  GameInfo->More->NbrClones=0;

  XFREE(GameClones);  
  
}

void ConvertGameInfoSTMODEFromSPLITToFULL(s_GamesList *GamesList,
					  s_GameInfo *GameInfo)
{
  unsigned int i;

  GameInfo->Roms=XREALLOC(GameInfo->Roms,
			  s_RomInfo*,
			  GameInfo->NbrRoms+GameInfo->More->NbrMergedRoms);


  for(i=0;i<GameInfo->More->NbrMergedRoms;i++)
    {
      GameInfo->Roms[GameInfo->NbrRoms+i]=GameInfo->More->MergedRoms[i];
      GameInfo->More->MergedRoms[i]=NULL;
    }

  XFREE(GameInfo->More->MergedRoms);
  GameInfo->NbrRoms=GameInfo->NbrRoms+GameInfo->More->NbrMergedRoms;
  GameInfo->More->NbrMergedRoms=0;

}

void ConvertGameInfoSTMODEFromMERGEToFULL(s_GamesList *GamesList,
					  s_GameInfo *GameInfo)
{
  unsigned int nbrgames,i;

  nbrgames=GamesList->NbrGames;
  ConvertGameInfoSTMODEFromMERGEToSPLIT(GamesList,GameInfo);
  nbrgames=GamesList->NbrGames-nbrgames;
  
  for(i=GamesList->NbrGames-nbrgames;i<GamesList->NbrGames;i++)
    ConvertGameInfoSTMODEFromSPLITToFULL(GamesList,
					 GamesList->Games[i]);
}

void ConvertGameInfoSTMODEFromFULLToSPLIT(s_GamesList *GamesList,
					  s_GameInfo *GameInfo)
{
  unsigned int i,nbrmergedroms;
  s_RomInfo **roms;

  nbrmergedroms=0;
  for(i=0;i<GameInfo->NbrRoms;i++)
    if(strcmp(GameInfo->Roms[i]->GameName,GameInfo->Name)!=0)
      nbrmergedroms++;

  GameInfo->More->MergedRoms=XCALLOC(s_RomInfo*,nbrmergedroms);

  GameInfo->More->NbrMergedRoms=nbrmergedroms;

  nbrmergedroms=0;
  for(i=0;i<GameInfo->NbrRoms;i++)
    {
      if(strcmp(GameInfo->Roms[i]->GameName,GameInfo->Name)!=0)
	{
	  GameInfo->More->MergedRoms[nbrmergedroms]=GameInfo->Roms[i];
	  GameInfo->Roms[i]=NULL;
	  nbrmergedroms++;
	}
    }

  roms=XCALLOC(s_RomInfo*,GameInfo->NbrRoms-nbrmergedroms);


  nbrmergedroms=0;
  for(i=0;i<GameInfo->NbrRoms;i++)
    if(GameInfo->Roms[i]!=NULL)
      roms[i-nbrmergedroms]=GameInfo->Roms[i];
    else
      nbrmergedroms++;
  
  XFREE(GameInfo->Roms);
  GameInfo->Roms=roms;
  GameInfo->NbrRoms=GameInfo->NbrRoms-nbrmergedroms;
}

s_GamesList *ConvertGamesListToSTMODE(s_GamesList *GamesList,
				      unsigned int StorageMode)
{
  unsigned int i;
  unsigned int InitialStorageMode;
  s_GameInfo **Games=NULL;
  unsigned int NbrConverted=0,NbrErased=0;

  if(!GamesList)
    return NULL;

  if(GamesList->MergedGamesList!=FALSE)
    {
      LPRINTF(WARNING,"ConvertGamesListToSTMODE does not accept Merged GamesList");
      return GamesList;
    };

  InitialStorageMode=GamesList->Sources[0]->StorageMode;

  for(i=1;i<GamesList->NbrSources;i++)
    if(GamesList->Sources[i]->StorageMode!=InitialStorageMode)
      {
	LPRINTF(WARNING,"ConvertGamesListToSTMODE does not accept multi Storage Mode Sources");
	return GamesList;
      };      

  if(InitialStorageMode==StorageMode)
    return GamesList;

  switch(InitialStorageMode)
    {
    case STMODE_SPLIT:
      switch(StorageMode)
	{
	case STMODE_MERGE: 
	  for(i=0;i<GamesList->NbrGames;i++)
	    if(GamesList->Games[i]!=NULL &&
	       GamesList->Games[i]->More->CloneOf!=NULL)
	      {
		if(ConvertGameInfoSTMODEFromSPLITToMERGE(GamesList,
							 GamesList->Games[i]->Name)!=NULL)
		  NbrConverted++;
	      };
	  Games=XCALLOC(s_GameInfo*,GamesList->NbrGames-NbrConverted);

	  for(i=0;i<GamesList->NbrGames;i++)
	    {
	      if(GamesList->Games[i]!=NULL)
		Games[i-NbrErased]=GamesList->Games[i];
	      else
		NbrErased++;
	    };
	  
	  XFREE(GamesList->Games);
	  GamesList->Games=Games;
	      
	  GamesList->NbrGames=GamesList->NbrGames-NbrErased;	   
	  break;
	case STMODE_FULL:
	  for(i=0;i<GamesList->NbrGames;i++)
	    if(GamesList->Games[i]->More->NbrMergedRoms!=0)
	      ConvertGameInfoSTMODEFromSPLITToFULL(GamesList,
						   GamesList->Games[i]);
	  break;
	};
      break;
    case STMODE_MERGE:
      switch(StorageMode)
	{
	case STMODE_SPLIT: 
	  for(i=0;i<GamesList->NbrGames;i++)
	    if(GamesList->Games[i]->More->NbrClones!=0)
	      ConvertGameInfoSTMODEFromMERGEToSPLIT(GamesList,
						    GamesList->Games[i]);
	  break;
	case STMODE_FULL:
	  for(i=0;i<GamesList->NbrGames;i++)
	    if(GamesList->Games[i]->More->NbrClones!=0)
	      ConvertGameInfoSTMODEFromMERGEToFULL(GamesList,
						   GamesList->Games[i]);
	  break;
	};      
      break;
    case STMODE_FULL:
      switch(StorageMode)
	{
	case STMODE_SPLIT: 
	  for(i=0;i<GamesList->NbrGames;i++)
	    if(GamesList->Games[i]->More->Resource!=NULL ||
	       GamesList->Games[i]->More->CloneOf!=NULL)
	      ConvertGameInfoSTMODEFromFULLToSPLIT(GamesList,
						   GamesList->Games[i]);
	  break;
	case STMODE_MERGE:
	  for(i=0;i<GamesList->NbrGames;i++)
	    if(GamesList->Games[i]!=NULL &&
	       (GamesList->Games[i]->More->Resource!=NULL ||
		GamesList->Games[i]->More->CloneOf!=NULL))
	      {
		ConvertGameInfoSTMODEFromFULLToSPLIT(GamesList,
						     GamesList->Games[i]);
		if(ConvertGameInfoSTMODEFromSPLITToMERGE(GamesList,
							 GamesList->Games[i]->Name)!=NULL)
		  NbrConverted++;
	      };

	  Games=XCALLOC(s_GameInfo*,GamesList->NbrGames-NbrConverted);

	  for(i=0;i<GamesList->NbrGames;i++)
	    {
	      if(GamesList->Games[i]!=NULL)
		Games[i-NbrErased]=GamesList->Games[i];
	      else
		NbrErased++;
	    };
	  
	  XFREE(GamesList->Games);
	  GamesList->Games=Games;
	      
	  GamesList->NbrGames=GamesList->NbrGames-NbrErased;	  
	  break;
	}; 
      break;
    };
  
  for(i=0;i<GamesList->NbrSources;i++)
    GamesList->Sources[i]->StorageMode=StorageMode;
  
  return GamesList;
};

