;;; DO NOT MODIFY THIS FILE
(if (featurep 'ispell-autoloads) (error "Already loaded"))

;;;### (autoloads nil "_pkg" "ispell/_pkg.el")

(package-provide 'ispell :version 1.37 :author-version "3.6" :type 'regular)

;;;***

;;;### (autoloads (ispell-message ispell-minor-mode ispell ispell-complete-word-interior-frag ispell-complete-word ispell-continue ispell-buffer ispell-comments-and-strings ispell-region ispell-change-dictionary ispell-kill-ispell ispell-help ispell-pdict-save ispell-word ispell-personal-dictionary) "ispell" "ispell/ispell.el")

(put 'ispell-check-comments 'safe-local-variable (lambda (a) (memq a '(nil t exclusive))))

(defvar ispell-personal-dictionary nil "\
File name of your personal spelling dictionary, or nil.
If nil, the default personal dictionary, (\"~/.ispell_DICTNAME\" for ispell or
\"~/.aspell.LANG.pws\" for aspell) is used, where DICTNAME is the name of your
default dictionary and LANG the two letter language code.")

(put 'ispell-local-dictionary 'safe-local-variable 'string-or-null-p)

(defvar ispell-menu-map nil "\
Key map for ispell menu.")

(defvar ispell-menu-xemacs nil "\
Spelling menu for XEmacs.
If nil when package is loaded, a standard menu will be set,
and added as a submenu of the \"Edit\" menu.")

(defvar ispell-menu-map-needed (and (not ispell-menu-map) (not (featurep 'xemacs)) 'reload))

(if ispell-menu-map-needed (progn (setq ispell-menu-map (make-sparse-keymap "Spell")) (define-key ispell-menu-map [ispell-change-dictionary] (backquote (menu-item (\, (purecopy "Change Dictionary...")) ispell-change-dictionary :help (\, (purecopy "Supply explicit dictionary file name"))))) (define-key ispell-menu-map [ispell-kill-ispell] (backquote (menu-item (\, (purecopy "Kill Process")) (lambda nil (interactive) (ispell-kill-ispell nil 'clear)) :enable (and (boundp 'ispell-process) ispell-process (eq (ispell-process-status) 'run)) :help (\, (purecopy "Terminate Ispell subprocess"))))) (define-key ispell-menu-map [ispell-pdict-save] (backquote (menu-item (\, (purecopy "Save Dictionary")) (lambda nil (interactive) (ispell-pdict-save t t)) :help (\, (purecopy "Save personal dictionary"))))) (define-key ispell-menu-map [ispell-customize] (backquote (menu-item (\, (purecopy "Customize...")) (lambda nil (interactive) (customize-group 'ispell)) :help (\, (purecopy "Customize spell checking options"))))) (define-key ispell-menu-map [ispell-help] (backquote (menu-item (\, (purecopy "Help")) (lambda nil (interactive) (describe-function 'ispell-help)) :help (\, (purecopy "Show standard Ispell keybindings and commands"))))) (define-key ispell-menu-map [flyspell-mode] (backquote (menu-item (\, (purecopy "Automatic spell checking (Flyspell)")) flyspell-mode :help (\, (purecopy "Check spelling while you edit the text")) :button (:toggle bound-and-true-p flyspell-mode)))) (define-key ispell-menu-map [ispell-complete-word] (backquote (menu-item (\, (purecopy "Complete Word")) ispell-complete-word :help (\, (purecopy "Complete word at cursor using dictionary"))))) (define-key ispell-menu-map [ispell-complete-word-interior-frag] (backquote (menu-item (\, (purecopy "Complete Word Fragment")) ispell-complete-word-interior-frag :help (\, (purecopy "Complete word fragment at cursor")))))))

(if ispell-menu-map-needed (progn (define-key ispell-menu-map [ispell-continue] (backquote (menu-item (\, (purecopy "Continue Spell-Checking")) ispell-continue :enable (and (boundp 'ispell-region-end) (marker-position ispell-region-end) (equal (marker-buffer ispell-region-end) (current-buffer))) :help (\, (purecopy "Continue spell checking last region"))))) (define-key ispell-menu-map [ispell-word] (backquote (menu-item (\, (purecopy "Spell-Check Word")) ispell-word :help (\, (purecopy "Spell-check word at cursor"))))) (define-key ispell-menu-map [ispell-comments-and-strings] (backquote (menu-item (\, (purecopy "Spell-Check Comments")) ispell-comments-and-strings :help (\, (purecopy "Spell-check only comments and strings")))))))

(if ispell-menu-map-needed (progn (define-key ispell-menu-map [ispell-region] (backquote (menu-item (\, (purecopy "Spell-Check Region")) ispell-region :enable mark-active :help (\, (purecopy "Spell-check text in marked region"))))) (define-key ispell-menu-map [ispell-message] (backquote (menu-item (\, (purecopy "Spell-Check Message")) ispell-message :visible (eq major-mode 'mail-mode) :help (\, (purecopy "Skip headers and included message text"))))) (define-key ispell-menu-map [ispell-buffer] (backquote (menu-item (\, (purecopy "Spell-Check Buffer")) ispell-buffer :help (\, (purecopy "Check spelling of selected buffer"))))) (fset 'ispell-menu-map (symbol-value 'ispell-menu-map))))

(defvar ispell-skip-region-alist (backquote ((ispell-words-keyword forward-line) (ispell-dictionary-keyword forward-line) (ispell-pdict-keyword forward-line) (ispell-parsing-keyword forward-line) ((\, (purecopy "^---*BEGIN PGP [A-Z ]*--*")) \, (purecopy "^---*END PGP [A-Z ]*--*")) ((\, (purecopy "^begin [0-9][0-9][0-9] [^ 	]+$")) \, (purecopy "\nend\n")) ((\, (purecopy "^%!PS-Adobe-[123].0")) \, (purecopy "\n%%EOF\n")) ((\, (purecopy "^---* \\(Start of \\)?[Ff]orwarded [Mm]essage")) \, (purecopy "^---* End of [Ff]orwarded [Mm]essage")) ((\, (purecopy "\\(--+\\|_+\\|\\(/\\w\\|\\(\\(\\w\\|[-_]\\)+[.:@]\\)\\)\\(\\w\\|[-_]\\)*\\([.:/@]+\\(\\w\\|[-_~=?&]\\)+\\)+\\)"))))) "\
Alist expressing beginning and end of regions not to spell check.
The alist key must be a regular expression.
Valid forms include:
  (KEY) - just skip the key.
  (KEY . REGEXP) - skip to the end of REGEXP.  REGEXP may be string or symbol.
  (KEY REGEXP) - skip to end of REGEXP.  REGEXP must be a string.
  (KEY FUNCTION ARGS) - FUNCTION called with ARGS returns end of region.")

(defvar ispell-tex-skip-alists (purecopy '((("\\\\addcontentsline" ispell-tex-arg-end 2) ("\\\\add\\(tocontents\\|vspace\\)" ispell-tex-arg-end) ("\\\\\\([aA]lph\\|arabic\\)" ispell-tex-arg-end) ("\\\\bibliographystyle" ispell-tex-arg-end) ("\\\\makebox" ispell-tex-arg-end 0) ("\\\\e?psfig" ispell-tex-arg-end) ("\\\\document\\(class\\|style\\)" . "\\\\begin[ 	\n]*{[ 	\n]*document[ 	\n]*}")) (("\\(figure\\|table\\)\\*?" ispell-tex-arg-end 0) ("list" ispell-tex-arg-end 2) ("program" . "\\\\end[ 	\n]*{[ 	\n]*program[ 	\n]*}") ("verbatim\\*?" . "\\\\end[ 	\n]*{[ 	\n]*verbatim\\*?[ 	\n]*}")))) "\
Lists of regions to be skipped in TeX mode.
First list is used raw.
Second list has key placed inside \\begin{}.

Delete or add any regions you want to be automatically selected
for skipping in latex mode.")

(defconst ispell-html-skip-alists '(("<[cC][oO][dD][eE]\\>[^>]*>" "</[cC][oO][dD][eE]*>") ("<[sS][cC][rR][iI][pP][tT]\\>[^>]*>" "</[sS][cC][rR][iI][pP][tT]>") ("<[aA][pP][pP][lL][eE][tT]\\>[^>]*>" "</[aA][pP][pP][lL][eE][tT]>") ("<[vV][eE][rR][bB]\\>[^>]*>" "<[vV][eE][rR][bB]\\>[^>]*>") ("<[tT][tT]/" "/") ("<[^ 	\n>]" ">") ("&[^ 	\n;]" "[; 	\n]")) "\
Lists of start and end keys to skip in HTML buffers.
Same format as `ispell-skip-region-alist'.
Note - substrings of other matches must come last
 (e.g. \"<[tT][tT]/\" and \"<[^ \\t\\n>]\").")
(put 'ispell-local-pdict 'safe-local-variable 'stringp)
(define-key esc-map "$" 'ispell-word)

(autoload 'ispell-word "ispell" "\
Check spelling of word under or before the cursor.
If the word is not found in dictionary, display possible corrections
in a window allowing you to choose one.

If optional argument FOLLOWING is non-nil or if `ispell-following-word'
is non-nil when called interactively, then the following word
\(rather than preceding) is checked when the cursor is not over a word.
When the optional argument QUIETLY is non-nil or `ispell-quietly' is non-nil
when called interactively, non-corrective messages are suppressed.

With a prefix argument (or if CONTINUE is non-nil),
resume interrupted spell-checking of a buffer or region.

Interactively, in Transient Mark mode when the mark is active, call
`ispell-region' to check the active region for spelling errors.

Word syntax is controlled by the definition of the chosen dictionary,
which is in `ispell-local-dictionary-alist' or `ispell-dictionary-alist'.

This will check or reload the dictionary.  Use \\[ispell-change-dictionary]
or \\[ispell-region] to update the Ispell process.

Return values:
nil           word is correct or spelling is accepted.
0             word is inserted into buffer-local definitions.
\"word\"        word corrected from word list.
\(\"word\" arg)  word is hand entered.
quit          spell session exited." t nil)

(autoload 'ispell-pdict-save "ispell" "\
Check to see if the personal dictionary has been modified.
If so, ask if it needs to be saved." t nil)

(autoload 'ispell-help "ispell" "\
Display a list of the options available when a misspelling is encountered.

Selections are:

DIGIT: Replace the word with a digit offered in the *Choices* buffer.
SPC:   Accept word this time.
`i':   Accept word and insert into private dictionary.
`a':   Accept word for this session.
`A':   Accept word and place in `buffer-local dictionary'.
`r':   Replace word with typed-in value.  Rechecked.
`R':   Replace word with typed-in value.  Query-replaced in buffer.  Rechecked.
`?':   Show these commands.
`x':   Exit spelling buffer.  Move cursor to original point.
`X':   Exit spelling buffer.  Leaves cursor at the current point, and permits
        the aborted check to be completed later.
`q':   Quit spelling session (Kills ispell process).
`l':   Look up typed-in replacement in alternate dictionary.  Wildcards okay.
`u':   Like `i', but the word is lower-cased first.
`m':   Place typed-in value in personal dictionary, then recheck current word.
`C-l':  Redraw screen.
`C-r':  Recursive edit.
`C-z':  Suspend Emacs or iconify frame." nil nil)

(autoload 'ispell-kill-ispell "ispell" "\
Kill current Ispell process (so that you may start a fresh one).
With NO-ERROR, just return non-nil if there was no Ispell running.
With CLEAR, buffer session localwords are cleaned." t nil)

(autoload 'ispell-change-dictionary "ispell" "\
Change to dictionary DICT for Ispell.
With a prefix arg, set it \"globally\", for all buffers.
Without a prefix arg, set it \"locally\", just for this buffer.

By just answering RET you can find out what the current dictionary is." t nil)

(autoload 'ispell-region "ispell" "\
Interactively check a region for spelling errors.
Return nil if spell session was terminated, otherwise returns shift offset
amount for last line processed." t nil)

(autoload 'ispell-comments-and-strings "ispell" "\
Check comments and strings in the current buffer for spelling errors." t nil)

(autoload 'ispell-buffer "ispell" "\
Check the current buffer for spelling errors interactively." t nil)

(autoload 'ispell-continue "ispell" "\
Continue a halted spelling session beginning with the current word." t nil)

(autoload 'ispell-complete-word "ispell" "\
Try to complete the word before or under point.
If optional INTERIOR-FRAG is non-nil then the word may be a character
sequence inside of a word.

Standard ispell choices are then available." t nil)

(autoload 'ispell-complete-word-interior-frag "ispell" "\
Completes word matching character sequence inside a word." t nil)

(autoload 'ispell "ispell" "\
Interactively check a region or buffer for spelling errors.
If `transient-mark-mode' is on, and a region is active, spell-check
that region.  Otherwise spell-check the buffer.

Ispell dictionaries are not distributed with Emacs.  If you are
looking for a dictionary, please see the distribution of the GNU ispell
program, or do an Internet search; there are various dictionaries
available on the net." t nil)

(autoload 'ispell-minor-mode "\
ispell" "Toggle last-word spell checking (Ispell minor mode).
With a prefix argument ARG, enable Ispell minor mode if ARG is
positive, and disable it otherwise.  If called from Lisp, enable
the mode if ARG is omitted or nil.

Ispell minor mode is a buffer-local minor mode.  When enabled,
typing SPC or RET warns you if the previous word is incorrectly
spelled.

All the buffer-local variables and dictionaries are ignored.  To
read them into the running ispell process, type \\[ispell-word]
SPC.

For spell-checking \"on the fly\", not just after typing SPC or
RET, use `flyspell-mode'." t nil)

(autoload 'ispell-message "ispell" "\
Check the spelling of a mail message or news post.
Don't check spelling of message headers except the Subject field.
Don't check included messages.

To abort spell checking of a message region and send the message anyway,
use the `x' command.  (Any subsequent regions will be checked.)
The `X' command aborts sending the message so that you can edit the buffer.

To spell-check whenever a message is sent, include the appropriate lines
in your .emacs file:
   (add-hook 'message-send-hook 'ispell-message)  ;; GNUS 5
   (add-hook 'news-inews-hook 'ispell-message)    ;; GNUS 4
   (add-hook 'mail-send-hook  'ispell-message)
   (add-hook 'mh-before-send-letter-hook 'ispell-message)

You can bind this to the key C-c i in GNUS or mail by adding to
`news-reply-mode-hook' or `mail-mode-hook' the following lambda expression:
   (function (lambda () (local-set-key \"\\C-ci\" 'ispell-message)))" t nil)

;;;***

(provide 'ispell-autoloads)
