-- -*-Sql-*- mode (to keep my emacs happy)
--
-- API Package Body for Seqfeature_Qualifier_Assoc.
--
-- Scaffold auto-generated by gen-api.pl. gen-api.pl is
-- Copyright 2002-2003 Genomics Institute of the Novartis Research Foundation
-- Copyright 2002-2008 Hilmar Lapp
-- 
--  This file is part of BioSQL.
--
--  BioSQL is free software: you can redistribute it and/or modify it
--  under the terms of the GNU Lesser General Public License as
--  published by the Free Software Foundation, either version 3 of the
--  License, or (at your option) any later version.
--
--  BioSQL is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU Lesser General Public License for more details.
--
--  You should have received a copy of the GNU Lesser General Public License
--  along with BioSQL. If not, see <http://www.gnu.org/licenses/>.
--

CREATE OR REPLACE
PACKAGE BODY FeaTrmA IS

CURSOR FeaTrmA_c (
		FeaTrmA_FEA_OID	IN SG_SEQFEATURE_QUALIFIER_ASSOC.FEA_OID%TYPE,
		FeaTrmA_Trm_OID	IN SG_SEQFEATURE_QUALIFIER_ASSOC.TRM_OID%TYPE,
		FeaTrmA_RANK	IN SG_SEQFEATURE_QUALIFIER_ASSOC.RANK%TYPE)
RETURN SG_SEQFEATURE_QUALIFIER_ASSOC%ROWTYPE IS
	SELECT t.* FROM SG_SEQFEATURE_QUALIFIER_ASSOC t
	WHERE
		FEA_OID = FeaTrmA_FEA_OID
	AND	TRM_OID = FeaTrmA_TRM_OID
	AND	RANK    = FeaTrmA_RANK
	;

FUNCTION get_oid(
		FEA_OID	IN SG_SEQFEATURE_QUALIFIER_ASSOC.FEA_OID%TYPE DEFAULT NULL,
		TRM_OID	IN SG_SEQFEATURE_QUALIFIER_ASSOC.TRM_OID%TYPE DEFAULT NULL,
		FeaTrmA_RANK	IN SG_SEQFEATURE_QUALIFIER_ASSOC.RANK%TYPE DEFAULT NULL,
		FeaTrmA_VALUE	IN SG_SEQFEATURE_QUALIFIER_ASSOC.VALUE%TYPE DEFAULT NULL,
		Fea_ENT_OID	IN SG_SEQFEATURE.ENT_OID%TYPE DEFAULT NULL,
		Fea_TYPE_TRM_OID	IN SG_SEQFEATURE.TYPE_TRM_OID%TYPE DEFAULT NULL,
		Fea_SOURCE_TRM_OID	IN SG_SEQFEATURE.SOURCE_TRM_OID%TYPE DEFAULT NULL,
		Fea_RANK	IN SG_SEQFEATURE.RANK%TYPE DEFAULT NULL,
		Trm_NAME	IN SG_TERM.NAME%TYPE DEFAULT NULL,
		ONT_OID	IN SG_TERM.ONT_OID%TYPE DEFAULT NULL,
		ONT_NAME	IN SG_ONTOLOGY.NAME%TYPE DEFAULT NULL,
		Trm_IDENTIFIER	IN SG_TERM.IDENTIFIER%TYPE DEFAULT NULL,
		do_DML		IN NUMBER DEFAULT BSStd.DML_NO)
RETURN INTEGER
IS
	pk	INTEGER DEFAULT NULL;
	FeaTrmA_row FeaTrmA_c%ROWTYPE;
	FEA_OID_	SG_SEQFEATURE.OID%TYPE DEFAULT FEA_OID;
	TRM_OID_	SG_TERM.OID%TYPE DEFAULT TRM_OID;
BEGIN
	-- look up SG_SEQFEATURE
	IF (FEA_OID_ IS NULL) THEN
		FEA_OID_ := Fea.get_oid(
				ENT_OID => Fea_ENT_OID,
				TYPE_TRM_OID => Fea_TYPE_TRM_OID,
				SOURCE_TRM_OID => Fea_SOURCE_TRM_OID,
				Fea_RANK => Fea_RANK);
	END IF;
	-- look up SG_TERM
	IF (TRM_OID_ IS NULL) THEN
		TRM_OID_ := Trm.get_oid(
				Trm_NAME => Trm_NAME,
				ONT_OID => ONT_OID,
				ONT_NAME => ONT_NAME,
				Trm_IDENTIFIER => Trm_IDENTIFIER);
	END IF;
	-- look up
	FOR FeaTrmA_row IN FeaTrmA_c (FEA_OID_, TRM_OID_, FeaTrmA_RANK) LOOP
	        pk := 1;
	END LOOP;
	-- insert/update if requested
	IF (pk IS NULL) AND 
	   ((do_DML = BSStd.DML_I) OR (do_DML = BSStd.DML_UI)) THEN
	    	-- look up foreign keys if not provided:
		-- look up SG_SEQFEATURE successful?
		IF (FEA_OID_ IS NULL) THEN
			raise_application_error(-20101,
				'failed to look up Fea <' || Fea_ENT_OID || '|' || Fea_TYPE_TRM_OID || '|' || Fea_SOURCE_TRM_OID || '|' || Fea_RANK || '>');
		END IF;
		-- look up SG_TERM successful?
		IF (TRM_OID_ IS NULL) THEN
			raise_application_error(-20101,
				'failed to look up Trm <' || Trm_NAME || '|' || ONT_OID || '|' || ONT_NAME || '|' || Trm_IDENTIFIER || '>');
		END IF;
	    	-- insert the record and obtain the primary key
	    	pk := do_insert(
		        FEA_OID => FEA_OID_,
		        TRM_OID => TRM_OID_,
			RANK => FeaTrmA_RANK,
			VALUE => FeaTrmA_VALUE);
	ELSIF (do_DML = BSStd.DML_U) OR (do_DML = BSStd.DML_UI) THEN
	        -- update the record (note that not provided FKs will not
		-- be changed nor looked up)
		do_update(
			FeaTrmA_FEA_OID	=> FEA_OID_,
		        FeaTrmA_TRM_OID => TRM_OID_,
			FeaTrmA_RANK => FeaTrmA_RANK,
			FeaTrmA_VALUE => FeaTrmA_VALUE);
	END IF;
	-- return the primary key
	RETURN pk;
END;

FUNCTION do_insert(
		FEA_OID	IN SG_SEQFEATURE_QUALIFIER_ASSOC.FEA_OID%TYPE,
		TRM_OID	IN SG_SEQFEATURE_QUALIFIER_ASSOC.TRM_OID%TYPE,
		RANK	IN SG_SEQFEATURE_QUALIFIER_ASSOC.RANK%TYPE,
		VALUE	IN SG_SEQFEATURE_QUALIFIER_ASSOC.VALUE%TYPE)
RETURN INTEGER
IS
BEGIN
	-- insert the record
	INSERT INTO SG_SEQFEATURE_QUALIFIER_ASSOC (
		FEA_OID,
		TRM_OID,
		RANK,
		VALUE)
	VALUES (FEA_OID,
		TRM_OID,
		RANK,
		VALUE)
	;
	-- return TRUE
	RETURN 1;
END;

PROCEDURE do_update(
		FeaTrmA_FEA_OID	IN SG_SEQFEATURE_QUALIFIER_ASSOC.FEA_OID%TYPE,
		FeaTrmA_TRM_OID	IN SG_SEQFEATURE_QUALIFIER_ASSOC.TRM_OID%TYPE,
		FeaTrmA_RANK	IN SG_SEQFEATURE_QUALIFIER_ASSOC.RANK%TYPE,
		FeaTrmA_VALUE	IN SG_SEQFEATURE_QUALIFIER_ASSOC.VALUE%TYPE)
IS
BEGIN
	-- update the record (and leave attributes passed as NULL untouched)
	UPDATE SG_SEQFEATURE_QUALIFIER_ASSOC
	SET
		VALUE = NVL(FeaTrmA_VALUE, VALUE)
	WHERE FEA_OID = FeaTrmA_FEA_OID
	AND   TRM_OID = FeaTrmA_TRM_OID
	AND   RANK    = FeaTrmA_RANK
	;
END;

END FeaTrmA;
/

