<?php

declare(strict_types=1);

/**
 * SPDX-FileCopyrightText: 2025 Nextcloud GmbH and Nextcloud contributors
 * SPDX-License-Identifier: AGPL-3.0-or-later
 */

namespace OCP\Files\Config\Event;

use OCP\EventDispatcher\Event;
use OCP\Files\Config\ICachedMountInfo;
use OCP\Files\Mount\IMountPoint;

/**
 * Event emitted when a user mount was removed.
 *
 * @since 30.0.12
 */
class UserMountRemovedEvent extends Event {
	public function __construct(
		public readonly IMountPoint|ICachedMountInfo $mountPoint,
	) {
		parent::__construct();
	}
}
