/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.util;

import net.sf.saxon.Configuration;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.FingerprintedNode;
import net.sf.saxon.om.MutableNodeInfo;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.SingleNodeIterator;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;

public final class Orphan
implements MutableNodeInfo,
FingerprintedNode {
    private short kind;
    private int nameCode = -1;
    private CharSequence stringValue;
    private int typeAnnotation = -1;
    private Configuration config;
    private String systemId;
    private boolean isId;
    private boolean isIdref;

    public Orphan(Configuration config) {
        this.config = config;
    }

    public void setNodeKind(short kind) {
        this.kind = kind;
    }

    public void setNameCode(int nameCode) {
        this.nameCode = nameCode;
    }

    public void setStringValue(CharSequence stringValue) {
        this.stringValue = stringValue;
    }

    public void setTypeAnnotation(int typeAnnotation) {
        this.typeAnnotation = typeAnnotation;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public void setIsId(boolean id) {
        this.isId = id;
    }

    public void setIsIdref(boolean idref) {
        this.isIdref = idref;
    }

    public int getNodeKind() {
        return this.kind;
    }

    public SequenceIterator getTypedValue() throws XPathException {
        switch (this.getNodeKind()) {
            case 7: 
            case 8: {
                return SingletonIterator.makeIterator(new StringValue(this.stringValue));
            }
            case 3: 
            case 9: 
            case 13: {
                return SingletonIterator.makeIterator(new UntypedAtomicValue(this.stringValue));
            }
        }
        if (this.typeAnnotation == -1 || this.typeAnnotation == 630 || this.typeAnnotation == 631) {
            return SingletonIterator.makeIterator(new UntypedAtomicValue(this.stringValue));
        }
        SchemaType stype = this.config.getSchemaType(this.typeAnnotation);
        if (stype == null) {
            String typeName = this.config.getNamePool().getDisplayName(this.typeAnnotation);
            throw new IllegalStateException("Unknown type annotation " + Err.wrap(typeName) + " in standalone node");
        }
        return stype.getTypedValue(this);
    }

    public Value atomize() throws XPathException {
        switch (this.getNodeKind()) {
            case 7: 
            case 8: {
                return new StringValue(this.stringValue);
            }
            case 3: 
            case 9: 
            case 13: {
                return new UntypedAtomicValue(this.stringValue);
            }
        }
        if (this.typeAnnotation == -1 || this.typeAnnotation == 630 || this.typeAnnotation == 631) {
            return new UntypedAtomicValue(this.stringValue);
        }
        SchemaType stype = this.config.getSchemaType(this.typeAnnotation);
        if (stype == null) {
            String typeName = this.config.getNamePool().getDisplayName(this.typeAnnotation);
            throw new IllegalStateException("Unknown type annotation " + Err.wrap(typeName) + " in standalone node");
        }
        return stype.atomize(this);
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public NamePool getNamePool() {
        return this.config.getNamePool();
    }

    public int getTypeAnnotation() {
        if (this.typeAnnotation == -1) {
            if (this.kind == 1) {
                return 630;
            }
            if (this.kind == 2) {
                return 631;
            }
        }
        return this.typeAnnotation;
    }

    public boolean isSameNodeInfo(NodeInfo other) {
        return this == other;
    }

    public boolean equals(Object other) {
        return other instanceof NodeInfo && this.isSameNodeInfo((NodeInfo)other);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String getSystemId() {
        return this.systemId;
    }

    public String getBaseURI() {
        if (this.kind == 7) {
            return this.systemId;
        }
        return null;
    }

    public int getLineNumber() {
        return -1;
    }

    public int getColumnNumber() {
        return -1;
    }

    public int compareOrder(NodeInfo other) {
        if (this.isSameNodeInfo(other)) {
            return 0;
        }
        return this.hashCode() < ((Object)other).hashCode() ? -1 : 1;
    }

    public String getStringValue() {
        return ((Object)this.stringValue).toString();
    }

    public CharSequence getStringValueCS() {
        return this.stringValue;
    }

    public int getNameCode() {
        return this.nameCode;
    }

    public int getFingerprint() {
        if (this.nameCode == -1) {
            return -1;
        }
        return this.getNameCode() & 0xFFFFF;
    }

    public String getLocalPart() {
        if (this.nameCode == -1) {
            return "";
        }
        return this.config.getNamePool().getLocalName(this.nameCode);
    }

    public String getURI() {
        if (this.nameCode == -1) {
            return "";
        }
        return this.config.getNamePool().getURI(this.nameCode);
    }

    public String getPrefix() {
        if (this.nameCode == -1) {
            return "";
        }
        return this.config.getNamePool().getPrefix(this.nameCode);
    }

    public String getDisplayName() {
        if (this.nameCode == -1) {
            return "";
        }
        return this.config.getNamePool().getDisplayName(this.nameCode);
    }

    public NodeInfo getParent() {
        return null;
    }

    public AxisIterator iterateAxis(byte axisNumber) {
        switch (axisNumber) {
            case 1: 
            case 5: 
            case 12: {
                return SingleNodeIterator.makeIterator(this);
            }
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                return EmptyIterator.getInstance();
            }
        }
        throw new IllegalArgumentException("Unknown axis number " + axisNumber);
    }

    public AxisIterator iterateAxis(byte axisNumber, NodeTest nodeTest) {
        switch (axisNumber) {
            case 1: 
            case 5: 
            case 12: {
                return Navigator.filteredSingleton(this, nodeTest);
            }
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                return EmptyIterator.getInstance();
            }
        }
        throw new IllegalArgumentException("Unknown axis number " + axisNumber);
    }

    public String getAttributeValue(int fingerprint) {
        return null;
    }

    public NodeInfo getRoot() {
        return this;
    }

    public DocumentInfo getDocumentRoot() {
        return null;
    }

    public boolean hasChildNodes() {
        return false;
    }

    public void generateId(FastStringBuffer buffer) {
        buffer.append('Q');
        buffer.append(Integer.toString(this.hashCode()));
    }

    public long getDocumentNumber() {
        return this.hashCode() & 0xFFFFFF;
    }

    public void copy(Receiver out, int copyOptions, int locationId) throws XPathException {
        Navigator.copy(this, out, this.config.getNamePool(), copyOptions, locationId);
    }

    public int[] getDeclaredNamespaces(int[] buffer) {
        return null;
    }

    public boolean isId() {
        return this.isId || this.kind == 2 && (this.nameCode & 0xFFFFF) == 388;
    }

    public boolean isIdref() {
        return this.isIdref;
    }

    public boolean isNilled() {
        return false;
    }

    public void insertChildren(NodeInfo[] source, boolean atStart, boolean inherit) {
    }

    public void insertSiblings(NodeInfo[] source, boolean before, boolean inherit) {
    }

    public void removeAttribute(NodeInfo attribute) {
    }

    public void addAttribute(int nameCode, int typeCode, CharSequence value, int properties) {
    }

    public void delete() {
        this.kind = (short)-1;
    }

    public boolean isDeleted() {
        return this.kind == -1;
    }

    public void replace(NodeInfo[] replacement, boolean inherit) {
        throw new IllegalStateException("Cannot replace a parentless node");
    }

    public void replaceStringValue(CharSequence stringValue) {
        this.stringValue = stringValue;
    }

    public void rename(int newNameCode) {
        if (this.kind == 2 || this.kind == 7) {
            this.nameCode = newNameCode;
        }
    }

    public void addNamespace(int nscode, boolean inherit) {
    }

    public void removeTypeAnnotation() {
        this.typeAnnotation = 631;
    }

    public Builder newBuilder() {
        throw new UnsupportedOperationException("Cannot create children for an Orphan node");
    }
}

