/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.cache;

import java.io.Closeable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Cache<K, V>
implements Closeable {
    public static <K, V> Cache<K, V> synchronizedCache(Cache<K, V> cache) {
        return cache.getSynchronizedCache();
    }

    Cache<K, V> getSynchronizedCache() {
        return new SynchronizedCache(this);
    }

    public abstract void put(K var1, V var2);

    public abstract V get(Object var1);

    public abstract boolean containsKey(Object var1);

    @Override
    public abstract void close();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SynchronizedCache<K, V>
    extends Cache<K, V> {
        private Object mutex;
        private Cache<K, V> cache;

        SynchronizedCache(Cache<K, V> cache) {
            this.cache = cache;
            this.mutex = this;
        }

        SynchronizedCache(Cache<K, V> cache, Object mutex) {
            this.cache = cache;
            this.mutex = mutex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void put(K key, V value) {
            Object object = this.mutex;
            synchronized (object) {
                this.cache.put(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V get(Object key) {
            Object object = this.mutex;
            synchronized (object) {
                return this.cache.get(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsKey(Object key) {
            Object object = this.mutex;
            synchronized (object) {
                return this.cache.containsKey(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Object object = this.mutex;
            synchronized (object) {
                this.cache.close();
            }
        }

        @Override
        Cache<K, V> getSynchronizedCache() {
            return this;
        }
    }
}

