# Copyright 1999-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

inherit vdr-plugin-2 ssl-cert

VERSION="1971" # every bump, new version

DESCRIPTION="VDR Plugin: remote programming VDR using VDR-Manager running on Android devices"
HOMEPAGE="https://github.com/vdr-projects/vdr-plugin-vdrmanager/"
SRC_URI="https://github.com/vdr-projects/vdr-plugin-vdrmanager/archive/refs/tags/${PV}.tar.gz -> ${P}.tar.gz"
S="${WORKDIR}/vdr-plugin-vdrmanager-${PV}/vdr-vdrmanager"

LICENSE="GPL-2"
SLOT="0"
KEYWORDS="~amd64 ~x86"
IUSE="gzip +ssl stream zlib"

DEPEND="media-video/vdr:=
	ssl? ( dev-libs/openssl )"
RDEPEND="${DEPEND}
	stream? ( media-plugins/vdr-streamdev[server] )
	zlib? ( sys-libs/zlib )"

VDRMANAGER_SSL_KEY_DIR="/etc/vdr/plugins/vdrmanager"
VDRMANAGER_SSL_KEY_FILE="${VDRMANAGER_SSL_KEY_DIR}/vdrmanager"

make_vdrmanager_cert() {
	SSL_COUNTRY="${SSL_COUNTRY:-}"
	SSL_STATE="${SSL_STATE:-Unknown}"
	SSL_LOCALITY="${VDRMANAGER_SSL_LOCALITY:-Unkown}"
	SSL_ORGANIZATION="${VDRMNAGER_SSL_ORGANIZATION:-VDR-Manager Plugin}"
	SSL_UNIT="${VDRMANAGER_SSL_UNIT:-VDR Server}"
	SSL_COMMONNAME="${VDRMANAGER_SSL_COMMONNAME:-`hostname -f`}"
	SSL_EMAIL="${VDRMANAGER_SSL_EMAIL:-Unknown}"
	SSL_BITS="${VDRMANAGER_SSL_BITS:-1024}"
	SSL_DAYS="${VDRMANAGER_SSL_DAYS:-720}"

	rm -f "${ROOT}"${VDRMANAGER_SSL_KEY_FILE}.*

	install_cert ${VDRMANAGER_SSL_KEY_FILE}

	rm -f "${ROOT}"${VDRMANAGER_SSL_KEY_FILE}.{crt,csr,key}
	chown vdr:vdr "${ROOT}"${VDRMANAGER_SSL_KEY_FILE}.pem
	chmod 0400 "${ROOT}"${VDRMANAGER_SSL_KEY_FILE}.pem
}

src_prepare() {
	vdr-plugin-2_src_prepare

	BUILD_PARAMS+=" VDRMANAGER_USE_GZIP=$(usex gzip 1 0)"
	BUILD_PARAMS+=" VDRMANAGER_USE_SSL=$(usex ssl 1 0)"
	BUILD_PARAMS+=" VDRMANAGER_USE_ZLIB=$(usex zlib 1 0)"
}

pkg_postinst() {
	vdr-plugin-2_pkg_postinst

	einfo "Add a password to /etc/conf.d/vdr.vdrmanager"

	if use ssl ; then
		if [[ -f ${ROOT}${VDRMANAGER_SSL_KEY_FILE}.pem ]]; then
			einfo "found an existing SSL cert, to create a new SSL cert, run:\n"
			einfo "emerge --config ${PN}"
		else
			einfo "No SSL cert found, creating a default one now"
			make_vdrmanager_cert
		fi
	fi
}

pkg_config() {
	make_vdrmanager_cert
}
