# Copyright 1999-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

DISTUTILS_USE_PEP517=setuptools
PYPI_PN=${PN/-/.}
PYTHON_COMPAT=( python3_{12..14} )

inherit distutils-r1 pypi

DESCRIPTION="A locking API for expiring values while a single thread generates a new value"
HOMEPAGE="
	https://github.com/sqlalchemy/dogpile.cache/
	https://pypi.org/project/dogpile.cache/
"

LICENSE="Apache-2.0"
SLOT="0"
KEYWORDS="amd64 ~arm arm64 ~riscv x86"

RDEPEND="
	>=dev-python/decorator-4.0.0[${PYTHON_USEDEP}]
	>=dev-python/stevedore-3.0.0[${PYTHON_USEDEP}]
"
BDEPEND="
	test? (
		dev-python/mako[${PYTHON_USEDEP}]
	)
"

EPYTEST_PLUGINS=()
# not xdist safe
distutils_enable_tests pytest

python_test() {
	epytest -m "not time_intensive"
}
