# Joplin guiding principles

Our guiding principles are at the core of every decisions we make. They define how we work and what we strive for.

## Freedom of choice

We believe that software should empower you to choose technology that aligns with your needs and values. You should be able to explore various options, modify software, and collaborate with others. This freedom ensures transparency, privacy, and security, allowing you to shape your digital experience on your own terms.

At Joplin we achieve this by offering data syncing through multiple providers, via customizable applications with plugins and public APIs, and by using open technologies. Moreover we have a strong commitment to publish most of our software as open source, and to be involved in the open source community.

We also provide multiple import and export options. Ultimately we want you to stay with us because you love the app, and not because of vendor lock-in!

## Data privacy

We believe that data privacy is a crucial part of software development. It ensures that your personal information remains secure, away from unauthorized access. By protecting your privacy, you have control over how your data is collected, used, and shared. Privacy also safeguards your democratic rights, allowing you to exercise your freedoms without interference. In this interconnected world, data privacy is essential.

At Joplin we achieve this by providing technologies such as end-to-end encryption, to ensure that only yourself can access your data, even when it's uploaded to the cloud. We also disclose what web requests our apps are making, regularly review them and, when possible, provide a way to disable them.

## Great usability

At our core, we are dedicated to developing software that prioritizes user-friendliness and intuitive design. We firmly believe that technology should be accessible to all, regardless of their level of expertise.

However, our commitment to simplicity does not mean we neglect the needs of advanced users. In fact, we embrace the opportunity to cater to their requirements by incorporating a range of advanced features within our software. These features provide additional functionality and customization options, allowing experienced users to push the boundaries and unlock the full potential of our software.

Our goal is to strike a balance between simplicity and depth, ensuring that our software meets the diverse needs of users across the spectrum of expertise.

## Reliability

At Joplin, we understand the significance of personal notes and the valuable information they hold, which often need to be preserved over extended periods. That's why we prioritize the performance and reliability of our application.

We achieve this by conducting rigorous testing, with over 3500 automated tests, to ensure optimal functionality. We also continuously review and upgrade the technologies we utilize, adapting to evolving needs. Furthermore, we work closely with security researchers who help us identify and address potential vulnerabilities, enhancing the security of our software.

Moreover, we value open accessibility. The data stored in our application is stored in an open format, enabling you to access and retrieve their information even without using our application. This commitment to open formats ensures that your data remains accessible and provides you with the freedom to interact with your notes as you desire.

## Sustainability

Sustainability in software encompasses various practices aimed at reducing the environmental impact of software throughout its lifecycle. By prioritizing sustainability, we can play a significant role in mitigating our environmental footprint and fostering a more sustainable future.

At Joplin we achieve this through efficient coding, optimization, and resource management to help minimize energy consumption and carbon emissions. We have also partnered with the non-profit carbone.eco and invested in the reforestation of a four hectares of forest in France.