/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS.lookup;

import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.AAAARecord;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.CNAMERecord;
import org.xbill.DNS.Cache;
import org.xbill.DNS.DClass;
import org.xbill.DNS.DNAMERecord;
import org.xbill.DNS.EDNSOption;
import org.xbill.DNS.ExtendedErrorCodeOption;
import org.xbill.DNS.ExtendedResolver;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.NameTooLongException;
import org.xbill.DNS.RRset;
import org.xbill.DNS.Rcode;
import org.xbill.DNS.Record;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.ResolverConfig;
import org.xbill.DNS.SetResponse;
import org.xbill.DNS.SimpleResolver;
import org.xbill.DNS.Type;
import org.xbill.DNS.WireParseException;
import org.xbill.DNS.hosts.HostsFileParser;
import org.xbill.DNS.lookup.InvalidZoneDataException;
import org.xbill.DNS.lookup.IrrelevantRecordMode;
import org.xbill.DNS.lookup.LookupFailedException;
import org.xbill.DNS.lookup.LookupResult;
import org.xbill.DNS.lookup.NoSuchDomainException;
import org.xbill.DNS.lookup.NoSuchRRSetException;
import org.xbill.DNS.lookup.RedirectLoopException;
import org.xbill.DNS.lookup.RedirectOverflowException;
import org.xbill.DNS.lookup.ServerFailedException;

public class LookupSession {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LookupSession.class);
    public static final int DEFAULT_MAX_ITERATIONS = 16;
    public static final int DEFAULT_NDOTS = 1;
    private final Resolver resolver;
    private final int maxRedirects;
    private final int ndots;
    private final List<Name> searchPath;
    private final boolean cycleResults;
    private final Map<Integer, Cache> caches;
    private final HostsFileParser hostsFileParser;
    private final Executor executor;
    private final IrrelevantRecordMode irrelevantRecordMode;

    private LookupSession(@NonNull Resolver resolver, int maxRedirects, int ndots, List<Name> searchPath, boolean cycleResults, List<Cache> caches, HostsFileParser hostsFileParser, Executor executor, IrrelevantRecordMode irrelevantRecordMode) {
        if (resolver == null) {
            throw new NullPointerException("resolver is marked non-null but is null");
        }
        this.resolver = resolver;
        this.maxRedirects = maxRedirects;
        this.ndots = ndots;
        this.searchPath = searchPath;
        this.cycleResults = cycleResults;
        this.caches = caches == null ? Collections.emptyMap() : caches.stream().collect(Collectors.toMap(Cache::getDClass, e -> e));
        this.hostsFileParser = hostsFileParser;
        this.executor = executor == null ? ForkJoinPool.commonPool() : executor;
        this.irrelevantRecordMode = irrelevantRecordMode;
    }

    public static LookupSessionBuilder builder() {
        LookupSessionBuilder builder = new LookupSessionBuilder();
        builder.maxRedirects = 16;
        builder.ndots = 1;
        return builder;
    }

    public static LookupSessionBuilder defaultBuilder() {
        return LookupSession.builder().resolver(new ExtendedResolver(ResolverConfig.getCurrentConfig().servers().stream().map(SimpleResolver::new).collect(Collectors.toList()))).ndots(ResolverConfig.getCurrentConfig().ndots()).cache(new Cache(1)).defaultHostsFileParser();
    }

    Cache getCache(int dclass) {
        return this.caches.get(dclass);
    }

    public CompletionStage<LookupResult> lookupAsync(Record question) {
        return this.lookupAsync(question.getName(), question.getType(), question.getDClass());
    }

    public CompletionStage<LookupResult> lookupAsync(Name name, int type) {
        return this.lookupAsync(name, type, 1);
    }

    public CompletionStage<LookupResult> lookupAsync(Name name, int type, int dclass) {
        List<Name> searchNames = this.expandName(name);
        LookupResult localHostsLookupResult = this.lookupWithHosts(searchNames, type);
        if (localHostsLookupResult != null) {
            return CompletableFuture.completedFuture(localHostsLookupResult);
        }
        return this.lookupUntilSuccess(searchNames.iterator(), type, dclass);
    }

    List<Name> expandName(Name name) {
        if (name.isAbsolute()) {
            return Collections.singletonList(name);
        }
        List fromSearchPath = this.searchPath.stream().map(searchSuffix -> LookupSession.safeConcat(name, searchSuffix)).filter(Objects::nonNull).collect(Collectors.toCollection(ArrayList::new));
        if (name.labels() > this.ndots) {
            fromSearchPath.add(0, LookupSession.safeConcat(name, Name.root));
        } else {
            fromSearchPath.add(LookupSession.safeConcat(name, Name.root));
        }
        return fromSearchPath;
    }

    private static Name safeConcat(Name name, Name suffix) {
        try {
            return Name.concatenate(name, suffix);
        }
        catch (NameTooLongException e) {
            return null;
        }
    }

    private LookupResult lookupWithHosts(List<Name> names, int type) {
        if (this.hostsFileParser != null && (type == 1 || type == 28)) {
            try {
                for (Name name : names) {
                    Optional<InetAddress> result = this.hostsFileParser.getAddressForHost(name, type);
                    if (!result.isPresent()) continue;
                    Record r = type == 1 ? new ARecord(name, 1, 0L, result.get()) : new AAAARecord(name, 1, 0L, result.get());
                    return new LookupResult(Record.newRecord(name, type, 1), true, r);
                }
            }
            catch (IOException e) {
                log.debug("Local hosts database parsing failed, ignoring and using resolver", e);
            }
        }
        return null;
    }

    private CompletionStage<LookupResult> lookupUntilSuccess(Iterator<Name> names, int type, int dclass) {
        Record query = Record.newRecord(names.next(), type, dclass);
        return this.lookupWithCache(query, null).thenCompose(answer -> this.resolveRedirects((LookupResult)answer, query)).handle((result, ex) -> {
            Throwable cause;
            Throwable throwable = cause = ex == null ? null : ex.getCause();
            if (cause instanceof NoSuchDomainException || cause instanceof NoSuchRRSetException) {
                if (names.hasNext()) {
                    return this.lookupUntilSuccess(names, type, dclass);
                }
                return this.completeExceptionally(cause);
            }
            if (cause != null) {
                return this.completeExceptionally(cause);
            }
            return CompletableFuture.completedFuture(result);
        }).thenCompose(Function.identity());
    }

    private CompletionStage<LookupResult> lookupWithCache(Record queryRecord, List<Name> aliases) {
        return Optional.ofNullable(this.caches.get(queryRecord.getDClass())).map(c -> {
            log.debug("Looking for <{}/{}/{}> in cache", queryRecord.getName(), Type.string(queryRecord.getType()), DClass.string(queryRecord.getDClass()));
            return c.lookupRecords(queryRecord.getName(), queryRecord.getType(), 3);
        }).map(setResponse -> this.setResponseToMessageFuture((SetResponse)setResponse, queryRecord, aliases)).orElseGet(() -> this.lookupWithResolver(queryRecord, aliases));
    }

    private CompletionStage<LookupResult> lookupWithResolver(Record queryRecord, List<Name> aliases) {
        Message query = Message.newQuery(queryRecord);
        log.debug("Asking {} for <{}/{}/{}>", this.resolver, queryRecord.getName(), Type.string(queryRecord.getType()), DClass.string(queryRecord.getDClass()));
        return this.resolver.sendAsync(query, this.executor).thenCompose(m -> {
            try {
                Message normalized = m.normalize(query, this.irrelevantRecordMode == IrrelevantRecordMode.THROW);
                log.trace("Normalized response for <{}/{}/{}> from \n{}\ninto\n{}", queryRecord.getName(), Type.string(queryRecord.getType()), DClass.string(queryRecord.getDClass()), m, normalized);
                if (normalized == null) {
                    return this.completeExceptionally(new InvalidZoneDataException("Failed to normalize message"));
                }
                return CompletableFuture.completedFuture(normalized);
            }
            catch (WireParseException e) {
                return this.completeExceptionally(new LookupFailedException("Message normalization failed, refusing to return it", e));
            }
        }).thenApply(this::maybeAddToCache).thenApply(answer -> LookupSession.buildResult(answer, aliases, queryRecord));
    }

    private Message maybeAddToCache(Message message) {
        for (RRset set : message.getSectionRRsets(1)) {
            if (set.getType() != 5 && set.getType() != 39 || set.size() == 1) continue;
            throw new InvalidZoneDataException("Multiple CNAME RRs not allowed, see RFC 1034 3.6.2");
        }
        Optional.ofNullable(this.caches.get(message.getQuestion().getDClass())).ifPresent(cache -> cache.addMessage(message));
        return message;
    }

    private CompletionStage<LookupResult> setResponseToMessageFuture(SetResponse setResponse, Record queryRecord, List<Name> aliases) {
        if (setResponse.isNXDOMAIN()) {
            return this.completeExceptionally(new NoSuchDomainException(queryRecord.getName(), queryRecord.getType()));
        }
        if (setResponse.isNXRRSET()) {
            return this.completeExceptionally(new NoSuchRRSetException(queryRecord.getName(), queryRecord.getType()));
        }
        if (setResponse.isCNAME()) {
            return CompletableFuture.completedFuture(new LookupResult(Collections.singletonList(setResponse.getCNAME()), aliases));
        }
        if (setResponse.isDNAME()) {
            return CompletableFuture.completedFuture(new LookupResult(Collections.singletonList(setResponse.getDNAME()), aliases));
        }
        if (setResponse.isSuccessful()) {
            List<Record> records = setResponse.answers().stream().flatMap(rrset -> rrset.rrs(this.cycleResults).stream()).collect(Collectors.toList());
            return CompletableFuture.completedFuture(new LookupResult(records, aliases));
        }
        return null;
    }

    private <T extends Throwable, R> CompletionStage<R> completeExceptionally(T failure) {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(failure);
        return future;
    }

    private CompletionStage<LookupResult> resolveRedirects(LookupResult response, Record query) {
        return this.maybeFollowRedirect(response, query, 0);
    }

    private CompletionStage<LookupResult> maybeFollowRedirect(LookupResult response, Record query, int redirectCount) {
        if (redirectCount > this.maxRedirects) {
            throw new RedirectOverflowException(this.maxRedirects);
        }
        List<Record> records = response.getRecords();
        if (!(records.isEmpty() || query.getType() == records.get(0).getType() || records.get(0).getType() != 5 && records.get(0).getType() != 39)) {
            return this.maybeFollowRedirectsInAnswer(response, query, redirectCount);
        }
        return CompletableFuture.completedFuture(response);
    }

    private CompletionStage<LookupResult> maybeFollowRedirectsInAnswer(LookupResult response, Record query, int redirectCount) {
        ArrayList<Name> aliases = new ArrayList<Name>(response.getAliases());
        ArrayList<Record> results = new ArrayList<Record>();
        Name current = query.getName();
        for (Record r : response.getRecords()) {
            if (aliases.contains(current)) {
                return this.completeExceptionally(new RedirectLoopException(this.maxRedirects));
            }
            if (redirectCount >= this.maxRedirects) {
                throw new RedirectOverflowException(this.maxRedirects);
            }
            if (r.getDClass() != query.getDClass()) continue;
            if (r.getType() == 5 && current.equals(r.getName())) {
                aliases.add(current);
                ++redirectCount;
                current = ((CNAMERecord)r).getTarget();
                continue;
            }
            if (r.getType() == 39 && current.subdomain(r.getName())) {
                aliases.add(current);
                ++redirectCount;
                try {
                    current = current.fromDNAME((DNAMERecord)r);
                    continue;
                }
                catch (NameTooLongException e) {
                    throw new InvalidZoneDataException("Cannot derive DNAME from " + r + " for " + current, e);
                }
            }
            if (r.getType() != query.getType() || !current.equals(r.getName())) continue;
            results.add(r);
        }
        if (!results.isEmpty()) {
            return CompletableFuture.completedFuture(new LookupResult(results, aliases));
        }
        if (aliases.contains(current)) {
            return this.completeExceptionally(new RedirectLoopException(this.maxRedirects));
        }
        if (redirectCount >= this.maxRedirects) {
            throw new RedirectOverflowException(this.maxRedirects);
        }
        int finalRedirectCount = redirectCount;
        Record redirectQuery = Record.newRecord(current, query.getType(), query.getDClass());
        return this.lookupWithCache(redirectQuery, aliases).thenCompose(responseFromCache -> this.maybeFollowRedirect((LookupResult)responseFromCache, redirectQuery, finalRedirectCount));
    }

    private static LookupResult buildResult(Message answer, List<Name> aliases, Record query) {
        int rcode = answer.getRcode();
        List<Record> answerRecords = answer.getSection(1);
        if (answerRecords.isEmpty() && rcode != 0) {
            switch (rcode) {
                case 3: {
                    throw new NoSuchDomainException(query.getName(), query.getType());
                }
                case 8: {
                    throw new NoSuchRRSetException(query.getName(), query.getType());
                }
                case 2: {
                    List<EDNSOption> options;
                    if (answer.getOPT() != null && !(options = answer.getOPT().getOptions(15)).isEmpty()) {
                        throw new ServerFailedException(query.getName(), query.getType(), (ExtendedErrorCodeOption)options.get(0));
                    }
                    throw new ServerFailedException(query.getName(), query.getType());
                }
            }
            throw new LookupFailedException(String.format("Unknown non-success error code %s", Rcode.string(rcode)));
        }
        return new LookupResult(answerRecords, aliases);
    }

    public static class LookupSessionBuilder {
        private Resolver resolver;
        private int maxRedirects;
        private int ndots;
        private List<Name> searchPath;
        private boolean cycleResults;
        private List<Cache> caches;
        private HostsFileParser hostsFileParser;
        private Executor executor;
        private IrrelevantRecordMode irrelevantRecordMode = IrrelevantRecordMode.REMOVE;

        private LookupSessionBuilder() {
        }

        public LookupSessionBuilder resolver(@NonNull Resolver resolver) {
            if (resolver == null) {
                throw new NullPointerException("resolver is marked non-null but is null");
            }
            this.resolver = resolver;
            return this;
        }

        public LookupSessionBuilder maxRedirects(int maxRedirects) {
            this.maxRedirects = maxRedirects;
            return this;
        }

        public LookupSessionBuilder ndots(int ndots) {
            this.ndots = ndots;
            return this;
        }

        public LookupSessionBuilder searchPath(Name searchPath) {
            if (this.searchPath == null) {
                this.searchPath = new ArrayList<Name>();
            }
            this.searchPath.add(searchPath);
            return this;
        }

        public LookupSessionBuilder searchPath(Collection<? extends Name> searchPath) {
            if (this.searchPath == null) {
                this.searchPath = new ArrayList<Name>();
            }
            this.searchPath.addAll(searchPath);
            return this;
        }

        public LookupSessionBuilder clearSearchPath() {
            if (this.searchPath != null) {
                this.searchPath.clear();
            }
            return this;
        }

        public LookupSessionBuilder cycleResults(boolean cycleResults) {
            this.cycleResults = cycleResults;
            return this;
        }

        public LookupSessionBuilder hostsFileParser(HostsFileParser hostsFileParser) {
            this.hostsFileParser = hostsFileParser;
            return this;
        }

        public LookupSessionBuilder executor(Executor executor) {
            this.executor = executor;
            return this;
        }

        LookupSessionBuilder irrelevantRecordMode(IrrelevantRecordMode irrelevantRecordMode) {
            this.irrelevantRecordMode = irrelevantRecordMode;
            return this;
        }

        public LookupSessionBuilder defaultHostsFileParser() {
            this.hostsFileParser = new HostsFileParser();
            return this;
        }

        public LookupSessionBuilder cache(@NonNull Cache cache) {
            if (cache == null) {
                throw new NullPointerException("cache is marked non-null but is null");
            }
            if (this.caches == null) {
                this.caches = new ArrayList<Cache>(1);
            }
            for (Cache c : this.caches) {
                if (c.getDClass() != cache.getDClass()) continue;
                this.caches.remove(c);
                break;
            }
            this.caches.add(cache);
            return this;
        }

        public LookupSessionBuilder caches(@NonNull Collection<Cache> caches) {
            if (caches == null) {
                throw new NullPointerException("caches is marked non-null but is null");
            }
            caches.forEach(this::cache);
            return this;
        }

        public LookupSessionBuilder clearCaches() {
            if (this.caches != null) {
                this.caches.clear();
            }
            return this;
        }

        @Deprecated
        public LookupSessionBuilder cache(@NonNull Integer dclass, @NonNull Cache cache) {
            if (dclass == null) {
                throw new NullPointerException("dclass is marked non-null but is null");
            }
            if (cache == null) {
                throw new NullPointerException("cache is marked non-null but is null");
            }
            this.cache(cache);
            return this;
        }

        @Deprecated
        public LookupSessionBuilder caches(@NonNull Map<Integer, Cache> caches) {
            if (caches == null) {
                throw new NullPointerException("caches is marked non-null but is null");
            }
            return this.caches(caches.values());
        }

        public LookupSession build() {
            this.searchPath = this.searchPath != null ? (List<Object>)this.searchPath.stream().map(name -> {
                try {
                    return Name.concatenate(name, Name.root);
                }
                catch (NameTooLongException e) {
                    throw new IllegalArgumentException("Search path name too long");
                }
            }).collect(Collectors.toCollection(ArrayList::new)) : Collections.emptyList();
            return new LookupSession(this.resolver, this.maxRedirects, this.ndots, this.searchPath, this.cycleResults, this.caches, this.hostsFileParser, this.executor, this.irrelevantRecordMode);
        }

        @Generated
        public String toString() {
            return "LookupSession.LookupSessionBuilder(resolver=" + this.resolver + ", maxRedirects=" + this.maxRedirects + ", ndots=" + this.ndots + ", searchPath=" + this.searchPath + ", cycleResults=" + this.cycleResults + ", caches=" + this.caches + ", hostsFileParser=" + this.hostsFileParser + ", executor=" + this.executor + ", irrelevantRecordMode=" + (Object)((Object)this.irrelevantRecordMode) + ")";
        }
    }
}

