#
# Write a pkg-config pc file for given "name" with "decription"
# Arguments:
#   name: a library name (without "lib" prefix and "so" suffixes
#   desc: a desription string
#
macro (create_pkgconfig_file name desc)
    set(_pkgfname "${CMAKE_CURRENT_BINARY_DIR}/${name}.pc")
    message(STATUS "${name}: writing pkgconfig file ${_pkgfname}")

    file(WRITE "${_pkgfname}" "# file generated by vid.stab cmake build
prefix=${CMAKE_INSTALL_PREFIX}
libdir=\${prefix}/lib${LIB_SUFFIX}
includedir=\${prefix}/include

Name: ${name}
Description: ${desc}
Version: ${VIDSTAB_VERSION}
Libs: -L\${libdir} -l${name} ${PKG_EXTRA_LIBS}
Cflags: -I\${includedir}

")

    install(FILES ${_pkgfname} DESTINATION lib${LIB_SUFFIX}/pkgconfig)
endmacro()