/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.licensing.serialize;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.maltego.cloud.CloudAuth;
import com.paterva.maltego.licensing.LicenseErrorDisplayer;
import com.paterva.maltego.licensing.json.rest.SignatureService;
import com.paterva.maltego.licensing.json.serialize.JsonLicenseResponse;
import com.paterva.maltego.licensing.serialize.M;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.keycloak.representations.AccessToken;
import org.openide.util.Exceptions;

public final class N {
    private static final N E = new N();
    private static final Logger B = Logger.getLogger(N.class.getName());
    private static final ObjectMapper F = new ObjectMapper();
    private boolean A = false;
    private String C;
    private JsonLicenseResponse D;

    private N() {
    }

    public static N B() {
        if (!N.E.A) {
            E.E();
        }
        return E;
    }

    public void E() {
        if (M.B()) {
            try {
                B.log(Level.INFO, "Loading Maltego ID activation store from file");
                this.C = M.C();
                this.D = this.A(this.C);
            }
            catch (IOException | GeneralSecurityException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                this.C = null;
                this.D = null;
            }
        }
        this.A = true;
    }

    private JsonLicenseResponse A(String activationJson) throws IOException, GeneralSecurityException {
        if (activationJson == null) {
            return null;
        }
        SignatureService signatureService = SignatureService.getInstance();
        String jsonContent = M.A(signatureService, activationJson);
        return (JsonLicenseResponse)F.readValue(jsonContent, JsonLicenseResponse.class);
    }

    public void A() {
        B.log(Level.INFO, "Resetting activation");
        M.B("MaltegoID.activation");
        this.A = false;
        this.C = null;
        this.D = null;
    }

    public void C(String msg) {
        B.log(Level.INFO, "Clearing Maltego ID License. Message: {0}", msg);
        this.C = null;
        this.D = null;
        File file = M.A("MaltegoID.activation");
        if (file != null && file.exists()) {
            file.delete();
            if (msg != null) {
                SwingUtilities.invokeLater(() -> LicenseErrorDisplayer.getDefault().show(msg));
            }
        }
    }

    public String C() {
        return this.C;
    }

    public void F(String activationJson, CloudAuth cloudAuth) throws IOException, GeneralSecurityException {
        B.log(Level.INFO, "Setting new activation info");
        this.C = activationJson;
        this.D = this.A(activationJson);
        B.log(Level.INFO, this.F(this.D, cloudAuth));
        M.D(activationJson);
    }

    public Optional<JsonLicenseResponse> D() {
        return Optional.ofNullable(this.D);
    }

    private String F(JsonLicenseResponse activation, CloudAuth cloudAuth) {
        HashMap map;
        Map otherClaims;
        AccessToken accessToken;
        if (activation == null) {
            return null;
        }
        String orgID = null;
        if ((activation.getOrganization() == null || activation.getOrganization().getId() == null) && cloudAuth != null && (accessToken = cloudAuth.getAccessToken()) != null && (otherClaims = accessToken.getOtherClaims()) instanceof HashMap && (map = (HashMap)otherClaims.get("organization")) instanceof HashMap) {
            orgID = map.get("id") == null ? null : map.get("id").toString();
        }
        try {
            return "Activation Id: " + activation.getActivationId() + "; Org: " + orgID + "; System UNIX time: " + System.currentTimeMillis() + "; Valid From: " + activation.getValidFrom() + "; Valid To: " + activation.getValidTo() + "; Product Plan: " + activation.getProductPlan().getTextId() + ", " + activation.getProductPlan().getPricingPlan() + "; Beta: " + activation.isInBeta() + "; Desktop Attributes: " + F.writeValueAsString((Object)activation.getProductPlan().getAttributes());
        }
        catch (JsonProcessingException ex) {
            return "JsonProcessingException";
        }
    }
}

