/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.core;

import com.paterva.maltego.core.DisplayInformationCollection;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.Guid;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.typing.Converter;
import com.paterva.maltego.typing.DataSource;
import com.paterva.maltego.typing.DataSources;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.PropertyDescriptorCollection;
import com.paterva.maltego.typing.PropertyDescriptorSet;
import com.paterva.maltego.typing.TypeRegistry;
import com.paterva.maltego.util.FastURL;
import com.paterva.maltego.util.StringUtilities;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.openide.util.Utilities;

public abstract class GenericPart<ID extends Guid>
implements MaltegoPart<ID> {
    private static final Logger LOG = Logger.getLogger(GenericPart.class.getName());
    private GraphID _graphID;
    private String _typeName;
    private String _valuePropertyName;
    private String _displayValueExpression;
    private PropertyDescriptorSet _properties;
    private DataSource _data;
    private PropertyChangeSupport _changeSupport;
    private PropertyChangeSupport _notesChangeSupport;
    private PropertyChangeSupport _bookmarkChangeSupport;
    private ID _id;
    private DisplayInformationCollection _displayInformation;
    private String _notes;
    private Boolean _showNotes;
    private Integer _bookmark;
    private int _propertiesUpdating = 0;
    private PropertyDescriptorSet _updatedProperties;
    private String _cachedValueStr;
    private String _cachedDisplayStr;
    private Boolean _cachedHasAttachments;
    private boolean _labelReadonly = true;

    public GenericPart(ID id) {
        this._id = id;
        this._data = new DataSources.Map();
    }

    public GenericPart(ID id, String type) {
        this(id);
        this._typeName = type;
        this._showNotes = Boolean.FALSE;
        this._bookmark = null;
        this._notes = "";
        this._valuePropertyName = "";
        this._displayValueExpression = null;
    }

    public GenericPart(ID id, String type, PropertyDescriptorCollection collection) {
        this(id, type);
        this.getProperties().addAll(collection);
    }

    protected GenericPart(MaltegoPart<ID> original) {
        this._typeName = original.getTypeName();
        this._valuePropertyName = original.getValuePropertyName();
        this._displayValueExpression = original.getDisplayValueExpression().orElse(null);
        this._id = original.getID();
        PropertyDescriptorCollection properties = original.getProperties();
        this.getProperties().addAll(properties);
        DataSources.Map data = new DataSources.Map();
        DataSource originalData = original.getData();
        for (PropertyDescriptor property : properties) {
            Object value = originalData.getValue(property);
            if (value == null) continue;
            data.put((Object)property, value);
        }
        this._data = data;
        if (original.getDisplayInformation() != null) {
            this.getOrCreateDisplayInformation().addAll(original.getDisplayInformation());
        }
        this._notes = original.getNotes();
        this._showNotes = original.isShowNotesValue();
        this._bookmark = original.getBookmarkValue();
        if (original instanceof GenericPart) {
            GenericPart genericPart = (GenericPart)original;
            this._cachedValueStr = genericPart._cachedValueStr;
            this._cachedDisplayStr = genericPart._cachedDisplayStr;
            this._cachedHasAttachments = genericPart._cachedHasAttachments;
            this._labelReadonly = genericPart._labelReadonly;
        }
    }

    @Override
    public void setGraphID(GraphID graphID) {
        this._graphID = graphID;
    }

    @Override
    public DataSource getData() {
        return this._data;
    }

    @Override
    public void setData(DataSource dataSource) {
        this._data = dataSource;
    }

    protected void setId(ID id) {
        this._id = id;
    }

    @Override
    public boolean isCopy(MaltegoPart<ID> part) {
        if (part instanceof GenericPart) {
            GenericPart genericPart = (GenericPart)part;
            if (!(Utilities.compareObjects((Object)this._typeName, (Object)genericPart._typeName) && Utilities.compareObjects((Object)this._valuePropertyName, (Object)genericPart._valuePropertyName) && Utilities.compareObjects((Object)this._displayValueExpression, (Object)genericPart._displayValueExpression) && this.isCopy(this._notes, genericPart._notes) && Utilities.compareObjects((Object)this._showNotes, (Object)genericPart._showNotes) && Utilities.compareObjects((Object)this._bookmark, (Object)genericPart._bookmark))) {
                return false;
            }
            if (!this.isCopy(this._displayInformation, genericPart._displayInformation)) {
                return false;
            }
            if (!(this._properties == genericPart._properties || this._properties != null && this._properties.isCopy(genericPart._properties))) {
                return false;
            }
            if (this._properties != null) {
                for (PropertyDescriptor pd : this._properties) {
                    if (Utilities.compareObjects((Object)this.getData().getValue(pd), (Object)genericPart.getData().getValue(pd))) continue;
                    return false;
                }
            }
        } else {
            return false;
        }
        return true;
    }

    public boolean isCopy(String str1, String str2) {
        if (StringUtilities.isNullOrEmpty((String)str1)) {
            return StringUtilities.isNullOrEmpty((String)str2);
        }
        if (StringUtilities.isNullOrEmpty((String)str2)) {
            return StringUtilities.isNullOrEmpty((String)str1);
        }
        return str1.equals(str2);
    }

    public boolean isCopy(DisplayInformationCollection dic1, DisplayInformationCollection dic2) {
        return dic1 == dic2 || dic1 != null && dic1.isCopy(dic2) || dic2 != null && dic2.isCopy(dic1);
    }

    private boolean isUpdating() {
        return this._propertiesUpdating > 0;
    }

    protected Object getSpecialPropertyValue(String name) {
        PropertyDescriptor pd = this.getSpecialProperty(name);
        if (pd == null) {
            return null;
        }
        return this.getValue(pd);
    }

    protected void setSpecialPropertyValue(String name, Object value) {
        PropertyDescriptor pd = this.getSpecialProperty(name);
        if (pd == null) {
            if (value != null) {
                PropertyDescriptor descriptor = new PropertyDescriptor(value.getClass(), name);
                this.addProperty(descriptor);
                this.setValue(descriptor, value);
            }
        } else {
            this.setValue(pd, value);
        }
    }

    protected PropertyDescriptor getSpecialProperty(String name) {
        if (StringUtilities.isNullOrEmpty((String)name)) {
            return null;
        }
        return this.getProperties().get(name);
    }

    @Override
    public String getTypeName() {
        return this._typeName;
    }

    @Override
    public void setTypeName(String value) {
        this._typeName = value;
        this.firePropertyChange("type");
    }

    @Override
    public String getValuePropertyName() {
        return this._valuePropertyName;
    }

    @Override
    public PropertyDescriptor getValueProperty() {
        return this.getSpecialProperty(this._valuePropertyName);
    }

    @Override
    public void setValueProperty(PropertyDescriptor property) {
        boolean mustFire;
        if (property == null) {
            mustFire = !StringUtilities.isNullOrEmpty((String)this._valuePropertyName);
            this._valuePropertyName = "";
        } else {
            mustFire = !property.getName().equals(this._valuePropertyName);
            this._valuePropertyName = property.getName();
        }
        if (mustFire) {
            this.firePropertyChange("value");
        }
    }

    @Override
    public Optional<String> getDisplayValueExpression() {
        return Optional.ofNullable(this._displayValueExpression);
    }

    @Override
    public void setDisplayValueExpression(String displayExpr) {
        if (StringUtils.isBlank((CharSequence)displayExpr)) {
            displayExpr = null;
        }
        if (!Objects.equals(displayExpr, this._displayValueExpression)) {
            this._displayValueExpression = displayExpr;
            this.firePropertyChange("displayValue");
        }
    }

    @Override
    public Object getValue() {
        return this.getSpecialPropertyValue(this._valuePropertyName);
    }

    @Override
    public void setValue(Object value) {
        if (StringUtilities.isNullOrEmpty((String)this._valuePropertyName)) {
            this._valuePropertyName = "value";
        }
        this.setSpecialPropertyValue(this._valuePropertyName, value);
    }

    @Override
    public Object getDisplayValue() {
        Object value = this.getSpecialPropertyValue(this._displayValueExpression);
        if (!this.isNullOrEmpty(value)) {
            return value;
        }
        return this.getValue();
    }

    @Override
    public void setDisplayValue(Object value) {
        if (StringUtilities.isNullOrEmpty((String)this._displayValueExpression)) {
            this._displayValueExpression = "display-value";
        }
        this.setSpecialPropertyValue(this._displayValueExpression, value);
    }

    @Override
    public void addProperty(PropertyDescriptor desc) {
        if (this.getProperties().add(desc) && !this.isUpdating()) {
            this.firePropertiesChanged();
        }
    }

    @Override
    public void removeProperty(String name) {
        PropertyDescriptor pd = this.getProperties().get(name);
        if (pd != null) {
            this.setValue(pd, null);
            if (this.getProperties().remove(pd)) {
                this.firePropertiesChanged();
            }
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.getChangeSupport().addPropertyChangeListener(pcl);
    }

    public void clear() {
        this._data.clear();
        this.getProperties().clear();
    }

    private PropertyChangeSupport getChangeSupport() {
        if (this._changeSupport == null) {
            this._changeSupport = new PropertyChangeSupport(this);
        }
        return this._changeSupport;
    }

    protected void firePropertiesChanged() {
        this.firePropertyChange("properties", null, this.getProperties());
    }

    protected void firePropertyChange(String property) {
        this.firePropertyChange(property, null, null);
    }

    protected void firePropertyChange(String name, Object newValue, Object oldValue) {
        if (!this.isUpdating()) {
            this.getChangeSupport().firePropertyChange(name, newValue, oldValue);
        }
    }

    protected void checkSpecialPropertyUpdate(PropertyDescriptor descriptor) {
        if (descriptor.getName().equals(this._valuePropertyName)) {
            this.firePropertyChange("value");
        } else if (descriptor.getName().equals(this._displayValueExpression)) {
            this.firePropertyChange("displayValue");
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.getChangeSupport().removePropertyChangeListener(pcl);
    }

    public PropertyDescriptorSet getProperties() {
        if (this._properties == null) {
            this._properties = new PropertyDescriptorSet();
        }
        return this._properties;
    }

    public Object getValue(PropertyDescriptor descriptor) {
        return this.getData().getValue(descriptor);
    }

    public void setValue(PropertyDescriptor descriptor, Object value) {
        this.setValue(descriptor, value, true, false);
    }

    @Override
    public void setValue(PropertyDescriptor descriptor, Object value, boolean refreshProperties, boolean resetIfSamplePart) {
        Object oldValue;
        PropertyDescriptor currentDescriptor = this.getProperties().get(descriptor.getName());
        if (currentDescriptor != null) {
            descriptor = currentDescriptor;
        }
        if (value != null) {
            Object backupValue = value;
            Class type = descriptor.getType();
            boolean compatible = Converter.isAssignableFrom((Class)type, value.getClass());
            if (!compatible) {
                Class valueClass = Converter.getReferenceType(value.getClass());
                Class descriptorClass = Converter.getReferenceType((Class)type);
                if (type.equals(String.class)) {
                    value = Converter.convert((Object)value, String.class);
                    compatible = true;
                } else if (descriptorClass != null && descriptorClass.equals(Float.class) && valueClass != null && valueClass.equals(Double.class)) {
                    compatible = true;
                } else if (descriptorClass != null && descriptorClass.equals(Double.class) && valueClass != null && valueClass.equals(Float.class)) {
                    compatible = true;
                } else {
                    boolean bl = compatible = (value = Converter.convertFrom((String)((String)value), (Class)type)) != null || this.isNullAcceptableReturnType(type);
                }
            }
            if (!compatible) {
                StringBuilder sb = new StringBuilder();
                sb.append("The property \"");
                sb.append(descriptor.getName());
                sb.append("\" of type \"");
                sb.append(type.getSimpleName());
                sb.append("\" is not compatible with value \"");
                sb.append(backupValue);
                sb.append("\" of type \"");
                sb.append(backupValue.getClass().getSimpleName());
                sb.append("\"");
                throw new IllegalArgumentException(sb.toString());
            }
        }
        if (!Objects.equals(value, oldValue = this.getData().getValue(descriptor))) {
            if (resetIfSamplePart) {
                this.resetIfSamplePart();
            }
            if (currentDescriptor == null) {
                this.getProperties().add(descriptor);
            }
            this.getData().setValue(descriptor, value);
            PropertyDescriptorSet updated = new PropertyDescriptorSet();
            updated.add(descriptor);
            if (refreshProperties) {
                this.refreshProperties(descriptor, updated, oldValue);
            }
            if (!this.isUpdating()) {
                this.firePropertiesUpdated(updated);
            } else {
                this._updatedProperties.addAll((PropertyDescriptorCollection)updated);
            }
        }
    }

    @Override
    public void resetIfSamplePart() {
        if (this.isSamplePart()) {
            for (PropertyDescriptor property : this.getProperties()) {
                this.clearProperty(property);
            }
        }
    }

    private boolean isSamplePart() {
        for (PropertyDescriptor property : this.getProperties()) {
            if (!property.getLinkedProperties().isEmpty() || this.isSampleValue(property)) continue;
            return false;
        }
        return true;
    }

    private boolean isNullAcceptableReturnType(Class c) {
        return c == FastURL.class;
    }

    protected void refreshProperties(PropertyDescriptor changed, PropertyDescriptorSet updated, Object oldValue) {
        List linkedProps = changed.getLinkedProperties();
        for (PropertyDescriptor pd : this.getProperties()) {
            if (changed == pd) continue;
            List inverseLinkedProps = null;
            boolean clear = linkedProps.contains(pd);
            if (clear) {
                this.clearProperty(pd);
                updated.add(pd);
                continue;
            }
            if (inverseLinkedProps == null) {
                inverseLinkedProps = pd.getLinkedProperties();
            }
            if (!inverseLinkedProps.contains(changed)) continue;
            pd.refreshValues(this.getData());
            updated.add(pd);
        }
    }

    private boolean isSampleValue(PropertyDescriptor pd, Object value) {
        if (pd instanceof DisplayDescriptor) {
            DisplayDescriptor dd = (DisplayDescriptor)pd;
            return Utilities.compareObjects((Object)dd.getSampleValue(), (Object)value);
        }
        return false;
    }

    private boolean isSampleValue(PropertyDescriptor pd) {
        return this.isSampleValue(pd, this.getData().getValue(pd));
    }

    private void clearProperty(PropertyDescriptor pd) {
        this.getData().setValue(pd, TypeRegistry.getDefault().getType(pd.getType()).getDefaultValue());
    }

    @Override
    public DisplayInformationCollection getDisplayInformation() {
        return this._displayInformation;
    }

    @Override
    public DisplayInformationCollection getOrCreateDisplayInformation() {
        if (this._displayInformation == null) {
            this._displayInformation = new DisplayInformationCollection();
        }
        return this._displayInformation;
    }

    @Override
    public void setDisplayInformation(DisplayInformationCollection displayInfo) {
        this._displayInformation = displayInfo;
        this.firePropertyChange("displayInformationChanged");
    }

    @Override
    public ID getID() {
        return this._id;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenericPart)) {
            return false;
        }
        GenericPart other = (GenericPart)obj;
        return this._id == other._id || this._id != null && ((Guid)this._id).equals(other._id);
    }

    public int hashCode() {
        return ((Guid)this._id).hashCode();
    }

    private boolean isNullOrEmpty(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof String) {
            return ((String)value).isEmpty();
        }
        return false;
    }

    @Override
    public String getNotes() {
        return this._notes;
    }

    @Override
    public void setNotes(String notes) {
        if (!Objects.equals(notes, this._notes)) {
            String oldNotes = this._notes;
            this._notes = notes;
            this.fireNotesChange("notesChanged", oldNotes, this._notes);
        }
    }

    @Override
    public Boolean isShowNotesValue() {
        return this._showNotes;
    }

    @Override
    public boolean isShowNotes() {
        return this._showNotes != null ? this._showNotes : false;
    }

    @Override
    public void setShowNotes(Boolean show) {
        if (!Utilities.compareObjects((Object)this._showNotes, (Object)show)) {
            Boolean old = this._showNotes;
            this._showNotes = show;
            this.fireNotesChange("showNotesChanged", old, this._showNotes);
        }
    }

    protected void fireNotesChange(String name, Object newValue, Object oldValue) {
        if (!this.isUpdating()) {
            this.getNotesChangeSupport().firePropertyChange(name, newValue, oldValue);
        }
    }

    @Override
    public void addNotesListener(PropertyChangeListener pcl) {
        this.getNotesChangeSupport().addPropertyChangeListener(pcl);
    }

    private PropertyChangeSupport getNotesChangeSupport() {
        if (this._notesChangeSupport == null) {
            this._notesChangeSupport = new PropertyChangeSupport(this);
        }
        return this._notesChangeSupport;
    }

    @Override
    public void removeNotesListener(PropertyChangeListener pcl) {
        this.getNotesChangeSupport().removePropertyChangeListener(pcl);
    }

    @Override
    public Integer getBookmarkValue() {
        return this._bookmark;
    }

    @Override
    public int getBookmark() {
        return this._bookmark != null ? this._bookmark : -1;
    }

    @Override
    public void setBookmark(Integer bookmark) {
        if (!Objects.equals(bookmark, this._bookmark)) {
            Integer oldBookmark = this._bookmark;
            this._bookmark = bookmark;
            this.fireBookmarkChange("bookmarkChanged", oldBookmark, this._bookmark);
        }
    }

    protected void fireBookmarkChange(String name, Object newValue, Object oldValue) {
        if (!this.isUpdating()) {
            this.getBookmarkChangeSupport().firePropertyChange(name, newValue, oldValue);
        }
    }

    @Override
    public void addBookmarkListener(PropertyChangeListener pcl) {
        this.getBookmarkChangeSupport().addPropertyChangeListener(pcl);
    }

    @Override
    public void removeBookmarkListener(PropertyChangeListener pcl) {
        this.getBookmarkChangeSupport().removePropertyChangeListener(pcl);
    }

    private PropertyChangeSupport getBookmarkChangeSupport() {
        if (this._bookmarkChangeSupport == null) {
            this._bookmarkChangeSupport = new PropertyChangeSupport(this);
        }
        return this._bookmarkChangeSupport;
    }

    @Override
    public void beginPropertyUpdating() {
        ++this._propertiesUpdating;
        if (this._updatedProperties == null) {
            this._updatedProperties = new PropertyDescriptorSet();
        }
    }

    @Override
    public void endPropertyUpdating(boolean fireChanges) {
        --this._propertiesUpdating;
        if (!this.isUpdating()) {
            if (fireChanges) {
                this.firePropertiesUpdated(this._updatedProperties);
            }
            this._updatedProperties = null;
        }
    }

    private void firePropertiesUpdated(PropertyDescriptorSet updatedProperties) {
        for (PropertyDescriptor pd : updatedProperties) {
            this.firePropertyChange(pd.getName());
        }
        this.firePropertyChange("value");
        this.firePropertyChange("displayValue");
    }

    @Override
    public void setValueString(String valueStr) {
        this._cachedValueStr = valueStr;
    }

    @Override
    public String getValueString() {
        return this._cachedValueStr;
    }

    @Override
    public void setDisplayString(String displayStr) {
        this._cachedDisplayStr = displayStr;
    }

    @Override
    public String getDisplayString() {
        return this._cachedDisplayStr;
    }

    @Override
    public void setHasAttachments(Boolean hasAttachments) {
        this._cachedHasAttachments = hasAttachments;
    }

    @Override
    public boolean hasAttachments() {
        return this._cachedHasAttachments;
    }

    @Override
    public void setLabelReadonly(boolean labelReadonly) {
        this._labelReadonly = labelReadonly;
    }

    @Override
    public boolean isLabelReadonly() {
        return this._labelReadonly;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String id = Integer.toString(System.identityHashCode(this), 36).toUpperCase();
        sb.append(this.getTypeName()).append("@").append(this.getID()).append(":").append(id);
        boolean multiline = true;
        sb.append("\n");
        String spacing = "   ";
        for (PropertyDescriptor propertyDescriptor : this.getProperties()) {
            String name = propertyDescriptor.getName();
            Object value = this.getValue(propertyDescriptor);
            sb.append("   ").append(name).append("=").append(value).append("\n");
        }
        if (this.getNotes() != null) {
            sb.append("   ").append("notes=").append(this.getNotes()).append("\n");
        }
        if (this.isShowNotesValue() != null) {
            sb.append("   ").append("showNotes=").append(this.isShowNotesValue()).append("\n");
        }
        if (this.getBookmarkValue() != null) {
            sb.append("   ").append("bookmark=").append(this.getBookmarkValue()).append("\n");
        }
        if (this.getValuePropertyName() != null) {
            sb.append("   ").append("valuePropertyName=").append(this.getValuePropertyName()).append("\n");
        }
        if (this.getDisplayValueExpression() != null) {
            sb.append("   ").append("displayValueExpression=").append((String)this.getDisplayValueExpression().orElse(null)).append("\n");
        }
        if (this instanceof MaltegoEntity) {
            MaltegoEntity entity = (MaltegoEntity)((Object)this);
            sb.append("   ").append("imageExpression=").append((String)entity.getImageExpression().orElse(null)).append("\n");
        }
        String str = sb.toString();
        return str;
    }
}

