/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins.wasm;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.js.builtins.wasm.WebAssemblyGlobalPrototypeBuiltins;
import com.oracle.truffle.js.nodes.control.TryCatchNode;
import com.oracle.truffle.js.nodes.wasm.ToJSValueNode;
import com.oracle.truffle.js.nodes.wasm.ToWebAssemblyValueNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSFrameUtil;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JavaScriptRootNode;
import com.oracle.truffle.js.runtime.builtins.JSConstructor;
import com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.builtins.JSNonProxy;
import com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssembly;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyGlobalObject;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.Undefined;

public class JSWebAssemblyGlobal
extends JSNonProxy
implements JSConstructorFactory.Default,
PrototypeSupplier {
    public static final String CLASS_NAME = "Global";
    public static final String PROTOTYPE_NAME = "Global.prototype";
    public static final String VALUE = "value";
    public static final JSWebAssemblyGlobal INSTANCE = new JSWebAssemblyGlobal();

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public String getClassName(DynamicObject object) {
        return this.getClassName();
    }

    public static boolean isJSWebAssemblyGlobal(Object object) {
        return object instanceof JSWebAssemblyGlobalObject;
    }

    @Override
    public DynamicObject createPrototype(JSRealm realm, DynamicObject constructor) {
        JSContext ctx = realm.getContext();
        DynamicObject prototype = JSObjectUtil.createOrdinaryPrototypeObject(realm);
        JSObjectUtil.putConstructorProperty(ctx, prototype, constructor);
        JSObjectUtil.putFunctionsFromContainer(realm, prototype, WebAssemblyGlobalPrototypeBuiltins.BUILTINS);
        JSObjectUtil.putAccessorProperty(ctx, prototype, VALUE, JSWebAssemblyGlobal.createValueGetterFunction(realm), JSWebAssemblyGlobal.createValueSetterFunction(realm), JSAttributes.configurableEnumerableWritable());
        JSObjectUtil.putToStringTag(prototype, "WebAssembly.Global");
        return prototype;
    }

    @Override
    public DynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getWebAssemblyGlobalPrototype();
    }

    @Override
    public Shape makeInitialShape(JSContext ctx, DynamicObject prototype) {
        return JSObjectUtil.getProtoChildShape(prototype, INSTANCE, ctx);
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return INSTANCE.createConstructorAndPrototype(realm);
    }

    public static JSWebAssemblyGlobalObject create(JSContext context, JSRealm realm, Object wasmGlobal, String valueType) {
        Object embedderData = JSWebAssembly.getEmbedderData(realm, wasmGlobal);
        if (embedderData instanceof JSWebAssemblyGlobalObject) {
            return (JSWebAssemblyGlobalObject)((Object)embedderData);
        }
        JSObjectFactory factory = context.getWebAssemblyGlobalFactory();
        JSWebAssemblyGlobalObject object = new JSWebAssemblyGlobalObject(factory.getShape(realm), wasmGlobal, valueType);
        factory.initProto(object, realm);
        JSWebAssembly.setEmbedderData(realm, wasmGlobal, (Object)object);
        return context.trackAllocation(object);
    }

    private static DynamicObject createValueGetterFunction(final JSRealm realm) {
        JSFunctionData getterData = realm.getContext().getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.WebAssemblyGlobalGetValue, c -> {
            RootCallTarget callTarget = Truffle.getRuntime().createCallTarget((RootNode)new JavaScriptRootNode(c.getLanguage(), null, null){
                @Node.Child
                ToJSValueNode toJSValueNode;
                @Node.Child
                InteropLibrary globalReadLib;
                private final BranchProfile errorBranch;
                {
                    super(lang, sourceSection, frameDescriptor);
                    this.toJSValueNode = ToJSValueNode.create();
                    this.globalReadLib = (InteropLibrary)InteropLibrary.getFactory().createDispatched(5);
                    this.errorBranch = BranchProfile.create();
                }

                public Object execute(VirtualFrame frame) {
                    Object thiz = JSFrameUtil.getThisObj((Frame)frame);
                    if (JSWebAssemblyGlobal.isJSWebAssemblyGlobal(thiz)) {
                        JSWebAssemblyGlobalObject object = (JSWebAssemblyGlobalObject)((Object)thiz);
                        Object wasmGlobal = object.getWASMGlobal();
                        Object globalRead = realm.getWASMGlobalRead();
                        try {
                            return this.toJSValueNode.execute(this.globalReadLib.execute(globalRead, new Object[]{wasmGlobal}));
                        }
                        catch (InteropException ex) {
                            throw Errors.shouldNotReachHere(ex);
                        }
                    }
                    this.errorBranch.enter();
                    throw Errors.createTypeError("get WebAssembly.Global.value: Receiver is not a WebAssembly.Global", (Node)this);
                }
            });
            return JSFunctionData.createCallOnly(c, (CallTarget)callTarget, 0, "get value");
        });
        return JSFunction.create(realm, getterData);
    }

    private static DynamicObject createValueSetterFunction(final JSRealm realm) {
        JSFunctionData setterData = realm.getContext().getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.WebAssemblyGlobalSetValue, c -> {
            RootCallTarget callTarget = Truffle.getRuntime().createCallTarget((RootNode)new JavaScriptRootNode(c.getLanguage(), null, null){
                @Node.Child
                ToWebAssemblyValueNode toWebAssemblyValueNode;
                @Node.Child
                InteropLibrary globalWriteLib;
                private final BranchProfile errorBranch;
                {
                    super(lang, sourceSection, frameDescriptor);
                    this.toWebAssemblyValueNode = ToWebAssemblyValueNode.create();
                    this.globalWriteLib = (InteropLibrary)InteropLibrary.getFactory().createDispatched(5);
                    this.errorBranch = BranchProfile.create();
                }

                public Object execute(VirtualFrame frame) {
                    Object[] args = frame.getArguments();
                    Object thiz = JSArguments.getThisObject(args);
                    if (JSWebAssemblyGlobal.isJSWebAssemblyGlobal(thiz)) {
                        JSWebAssemblyGlobalObject global = (JSWebAssemblyGlobalObject)((Object)thiz);
                        Object wasmGlobal = global.getWASMGlobal();
                        try {
                            if (JSArguments.getUserArgumentCount(args) == 0) {
                                this.errorBranch.enter();
                                throw Errors.createTypeError("set WebAssembly.Global.value: Argument 0 is required");
                            }
                            Object value = JSArguments.getUserArgument(args, 0);
                            Object webAssemblyValue = this.toWebAssemblyValueNode.execute(value, global.getValueType());
                            Object globalWrite = realm.getWASMGlobalWrite();
                            this.globalWriteLib.execute(globalWrite, new Object[]{wasmGlobal, webAssemblyValue});
                            return Undefined.instance;
                        }
                        catch (InteropException ex) {
                            throw Errors.shouldNotReachHere(ex);
                        }
                        catch (Throwable throwable) {
                            this.errorBranch.enter();
                            if (TryCatchNode.shouldCatch(throwable)) {
                                throw Errors.createTypeError(throwable, (Node)this);
                            }
                            throw throwable;
                        }
                    }
                    this.errorBranch.enter();
                    throw Errors.createTypeError("set WebAssembly.Global.value: Receiver is not a WebAssembly.Global", (Node)this);
                }
            });
            return JSFunctionData.createCallOnly(c, (CallTarget)callTarget, 1, "set value");
        });
        return JSFunction.create(realm, setterData);
    }
}

