/*
 * Decompiled with CFR 0.152.
 */
package com.pinkmatter.pandora.lucene.serialize;

import com.pinkmatter.pandora.PandoraException;
import com.pinkmatter.pandora.PandoraFilter;
import com.pinkmatter.pandora.lucene.PandoraConstants;
import com.pinkmatter.pandora.lucene.serialize.AbstractTypeConverter;
import com.pinkmatter.pandora.lucene.serialize.FilterHelper;
import com.pinkmatter.pandora.lucene.serialize.SortHelper;
import java.lang.reflect.Array;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.BytesRef;

class StringConverter
extends AbstractTypeConverter<String> {
    protected static final String ANALYZED_COLUMN = "*analyzed";
    private FieldType _analyzedType;

    public StringConverter() {
        super("string", String.class);
    }

    @Override
    protected void writeImpl(String value, String property, Document to) {
        String fieldName = this.getIndexField(property);
        String keyword = StringConverter.limit(value).toLowerCase();
        StringField indexField = new StringField(fieldName, keyword, Field.Store.NO);
        to.add((IndexableField)indexField);
        to.add(SortHelper.createStringDocValueField(fieldName, keyword));
        StoredField storeField = new StoredField(fieldName, value);
        to.add((IndexableField)storeField);
        Field analyzedField = new Field(this.getAnalyzedField(property), value, this.getAnalyzedFieldType());
        to.add((IndexableField)analyzedField);
    }

    @Override
    protected String readImpl(IndexableField field) throws PandoraException {
        return field.stringValue();
    }

    private String getAnalyzedField(String field) {
        StringBuilder builder = new StringBuilder(this.getIndexField(field));
        builder.append("|");
        builder.append(ANALYZED_COLUMN);
        return builder.toString();
    }

    private FieldType getAnalyzedFieldType() {
        if (this._analyzedType == null) {
            this._analyzedType = new FieldType();
            this._analyzedType.setStored(false);
            this._analyzedType.setIndexOptions(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS);
            this._analyzedType.setTokenized(true);
            this._analyzedType.setStoreTermVectors(true);
            this._analyzedType.setStoreTermVectorPositions(true);
            this._analyzedType.setStoreTermVectorOffsets(true);
            this._analyzedType.freeze();
        }
        return this._analyzedType;
    }

    @Override
    public SortField[] getSortFieldsImpl(String property, boolean reverse, boolean emptyFirst) {
        return new SortField[]{SortHelper.createStringSortField(this.getIndexField(property), reverse, emptyFirst)};
    }

    @Override
    protected Query createFilterImpl(PandoraFilter.Simple parameters) throws PandoraException {
        if (parameters instanceof PandoraFilter.Like) {
            String field = this.getAnalyzedField(parameters.getProperty());
            PandoraFilter.Like params = (PandoraFilter.Like)parameters;
            return FilterHelper.createLikeQuery(field, (String)params.getValue());
        }
        String field = this.getIndexField(parameters.getProperty());
        StringConverter.checkLimit(parameters, "Strings");
        return FilterHelper.createSimpleQuery(field, this.getClassType(), parameters);
    }

    @Override
    protected boolean isFilterTermsSupported() {
        return true;
    }

    @Override
    protected BytesRef createFilterTerm(String value) {
        return new BytesRef((CharSequence)value.toLowerCase());
    }

    static void checkLimit(PandoraFilter.Simple parameters, String type) throws PandoraException {
        boolean valid = true;
        Object value = parameters.getValueAsObject();
        if (value != null) {
            if (value.getClass().isArray()) {
                for (int i = 0; i < Array.getLength(value); ++i) {
                    Object o = Array.get(value, i);
                    if (StringConverter.meetsLimit(o)) continue;
                    valid = false;
                    break;
                }
            } else {
                valid = StringConverter.meetsLimit(value);
            }
        }
        if (!valid) {
            throw new PandoraException(String.format("Exact match queries on " + type + " are limited to %s characters. Shorten your parameters or use a LIKE query instead.", PandoraConstants.getExactMatchStringLimit()));
        }
    }

    static boolean meetsLimit(Object obj) {
        return obj.toString().length() <= PandoraConstants.getExactMatchStringLimit();
    }

    static String limit(String value) {
        if (value.length() > PandoraConstants.getExactMatchStringLimit()) {
            value = value.substring(0, PandoraConstants.getExactMatchStringLimit());
        }
        return value;
    }
}

