/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.impl;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.ui.graph.GraphEditorRegistry;
import com.paterva.maltego.ui.graph.GraphSelectionContext;
import com.paterva.maltego.ui.graph.SelectionProvider;
import com.paterva.maltego.util.ui.slide.SlideWindowManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.util.ChangeSupport;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class SelectiveGlobalActionContext
implements PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger(SelectiveGlobalActionContext.class.getName());
    private static SelectiveGlobalActionContext _instance;
    private TopComponent.Registry _topComponentRegistry;
    private SlideWindowManager _slideWindowManager;
    private SelectionProvider _activeSelectionProvider;
    private final ChangeSupport _changeSupport = new ChangeSupport((Object)this);
    private final ChangeListener _listener = new ProviderListener();

    public static synchronized SelectiveGlobalActionContext instance() {
        if (_instance == null) {
            _instance = new SelectiveGlobalActionContext();
        }
        return _instance;
    }

    public SelectiveGlobalActionContext() {
        this(TopComponent.getRegistry(), SlideWindowManager.getDefault());
    }

    public SelectiveGlobalActionContext(TopComponent.Registry registry, SlideWindowManager slideWindowManager) {
        this._topComponentRegistry = registry;
        this._slideWindowManager = slideWindowManager;
        this.init();
    }

    public void init() {
        this._topComponentRegistry.addPropertyChangeListener((PropertyChangeListener)this);
        this._slideWindowManager.addPropertyChangeListener((PropertyChangeListener)this);
        this.update();
    }

    public GraphID getTopGraphID() {
        return GraphSelectionContext.instance().getTopGraphID();
    }

    public boolean isSelectionEmpty() {
        return this.getSelectedModelEntities().isEmpty() && this.getSelectedModelLinks().isEmpty();
    }

    public Set<EntityID> getSelectedModelEntities() {
        Set<EntityID> entities = this._activeSelectionProvider == null ? Collections.emptySet() : this._activeSelectionProvider.getSelectedModelEntities();
        LOG.log(Level.FINE, "Entities: {0}", entities);
        return entities;
    }

    public Set<LinkID> getSelectedModelLinks() {
        Set<LinkID> links = this._activeSelectionProvider == null ? Collections.emptySet() : this._activeSelectionProvider.getSelectedModelLinks();
        LOG.log(Level.FINE, "Links: {0}", links);
        return links;
    }

    private synchronized void update() {
        LOG.fine("update");
        TopComponent tc = null;
        JComponent active = this._slideWindowManager.getActiveContent();
        if (active instanceof TopComponent) {
            tc = (TopComponent)active;
        }
        if (tc == null) {
            tc = this._topComponentRegistry.getActivated();
        }
        if (tc == null) {
            this.setActiveSelectionProvider(null);
        } else if (tc instanceof SelectionProvider) {
            this.setActiveSelectionProvider((SelectionProvider)tc);
        } else if (GraphEditorRegistry.getDefault().getTopmost() != null) {
            this.setActiveSelectionProvider(GraphSelectionContext.instance());
        } else if (WindowManager.getDefault().isEditorTopComponent(tc)) {
            this.setActiveSelectionProvider(null);
        }
    }

    private void setActiveSelectionProvider(SelectionProvider provider) {
        if (!Utilities.compareObjects((Object)provider, (Object)this._activeSelectionProvider)) {
            if (this._activeSelectionProvider != null) {
                this._activeSelectionProvider.removeSelectionChangeListener(this._listener);
            }
            LOG.log(Level.FINE, "Provider: {0}", provider);
            this._activeSelectionProvider = provider;
            if (this._activeSelectionProvider != null) {
                this._activeSelectionProvider.addSelectionChangeListener(this._listener);
            }
            this.fireChange();
        }
    }

    private void fireChange() {
        LOG.fine("Fire change");
        this._changeSupport.fireChange();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("activated".equals(evt.getPropertyName()) || "activeSlideWindowChanged".equals(evt.getPropertyName())) {
            this.update();
        }
    }

    public void addChangeListener(ChangeListener listener) {
        LOG.log(Level.FINE, "Add listener: {0}", listener);
        this._changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        LOG.log(Level.FINE, "Remove listener: {0}", listener);
        this._changeSupport.removeChangeListener(listener);
    }

    private class ProviderListener
    implements ChangeListener {
        private ProviderListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e2) {
            SelectiveGlobalActionContext.this.fireChange();
        }
    }
}

