/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.wrapper;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphEntity;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.GraphLink;
import com.paterva.maltego.core.Guid;
import com.paterva.maltego.core.LinkEntityIDs;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.graph.GraphLifeCycleManager;
import com.paterva.maltego.graph.UserDataHolder;
import com.paterva.maltego.graph.selection.GraphSelection;
import com.paterva.maltego.graph.selection.SelectionState;
import com.paterva.maltego.graph.store.data.GraphDataStore;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.layout.GraphLayoutMods;
import com.paterva.maltego.graph.store.layout.GraphLayoutReader;
import com.paterva.maltego.graph.store.layout.GraphLayoutStore;
import com.paterva.maltego.graph.store.structure.GraphStructureMods;
import com.paterva.maltego.graph.store.structure.GraphStructureReader;
import com.paterva.maltego.graph.store.structure.GraphStructureStore;
import com.paterva.maltego.graph.store.view.GraphStoreView;
import com.paterva.maltego.graph.wrapper.GraphStructureWrapper;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Exceptions;
import yguard.A.A.D;
import yguard.A.A.H;
import yguard.A.A.I;
import yguard.A.A.J;
import yguard.A.A.K;
import yguard.A.A.Y;
import yguard.A.I.M;
import yguard.A.I.R;
import yguard.A.J.BA;
import yguard.A.J.HA;
import yguard.A.J.SA;
import yguard.A.J.q;

public class GraphWrapper
extends GraphStructureWrapper {
    private static final Logger LOG = Logger.getLogger(GraphWrapper.class.getName());
    private final GraphID _graphID;
    private final List<EventListener> _propertyChangeListeners = Collections.synchronizedList(new LinkedList());
    private final GraphStoreView _graphStoreView;
    private GraphLayoutListener _layoutListener;
    private GraphStructureListener _structureListener;
    private boolean _isSyncing = false;

    protected GraphWrapper(GraphID graphID, D graph, GraphStoreView view) {
        super(graph);
        this._graphID = graphID;
        this._graphStoreView = view;
        this._structureListener = new GraphStructureListener();
        this._layoutListener = new GraphLayoutListener();
        this._graphStoreView.getGraphStructureStore().addPropertyChangeListener((PropertyChangeListener)this._structureListener);
        this._graphStoreView.getGraphLayoutStore().addPropertyChangeListener((PropertyChangeListener)this._layoutListener);
        GraphLifeCycleManager.getDefault().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("graphClosing".equals(evt.getPropertyName()) && evt.getNewValue().equals(GraphWrapper.this._graphID)) {
                    GraphLifeCycleManager.getDefault().removePropertyChangeListener((PropertyChangeListener)this);
                    GraphWrapper.this._graphStoreView.getGraphStructureStore().removePropertyChangeListener((PropertyChangeListener)GraphWrapper.this._structureListener);
                    GraphWrapper.this._graphStoreView.getGraphLayoutStore().removePropertyChangeListener((PropertyChangeListener)GraphWrapper.this._layoutListener);
                    GraphWrapper.this._structureListener = null;
                    GraphWrapper.this._layoutListener = null;
                }
            }
        });
    }

    public void beginUpdate() {
        this.graph().\u00cc();
        this.getGraphStoreView().beginUpdate();
    }

    public void endUpdate() {
        this.getGraphStoreView().endUpdate(null);
        this.graph().\u00a3();
    }

    private HA getRealizer(Y node) {
        SA g2d;
        BA nr;
        D graph = this.getGraph();
        if (graph instanceof SA && (nr = (g2d = (SA)graph).f(node)) instanceof HA) {
            return (HA)nr;
        }
        return null;
    }

    private q getRealizer(H edge) {
        D graph = this.getGraph();
        if (graph instanceof SA) {
            SA g2d = (SA)graph;
            return g2d.X(edge);
        }
        return null;
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this._propertyChangeListeners.add(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this._propertyChangeListeners.remove(pcl);
    }

    public boolean isCollectionNode(EntityID entityID) {
        try {
            return this.getGraphStoreView().getModelViewMappings().isOnlyViewEntity(entityID);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return false;
        }
    }

    public boolean isCollectionNodeLink(LinkID linkID) {
        try {
            return this.getGraphStoreView().getModelViewMappings().isOnlyViewLink(linkID);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return false;
        }
    }

    protected void firePropertyChange(String propertyName, Object old, Object nue) {
        PropertyChangeListener[] pcls = this._propertyChangeListeners.toArray(new PropertyChangeListener[0]);
        for (int i = 0; i < pcls.length; ++i) {
            pcls[i].propertyChange(new PropertyChangeEvent(this, propertyName, old, nue));
        }
    }

    private void yFilesMemLeakWorkaround(D graph, Y node) {
        I nodeMap;
        Object modelNode;
        K view2Model = graph.B((Object)"y.view.ModelViewManager.VIEW_2_MODEL_NODES");
        if (view2Model instanceof I && (modelNode = (nodeMap = (I)view2Model).get((Object)node)) != null) {
            nodeMap.set((Object)node, null);
            K model2View = graph.B((Object)"y.view.ModelViewManager.MODEL_2_VIEW_NODES");
            if (model2View instanceof I) {
                nodeMap = (I)model2View;
                nodeMap.set(modelNode, null);
            }
        }
    }

    private void yFilesMemLeakWorkaround(D graph, H edge) {
        J edgeMap;
        Object modelEdge;
        K view2Model = graph.B((Object)"y.view.ModelViewManager.VIEW_2_MODEL_EDGES");
        if (view2Model instanceof J && (modelEdge = (edgeMap = (J)view2Model).get((Object)edge)) != null) {
            edgeMap.set((Object)edge, null);
            K model2View = graph.B((Object)"y.view.ModelViewManager.MODEL_2_VIEW_EDGES");
            if (model2View instanceof J) {
                edgeMap = (J)model2View;
                edgeMap.set(modelEdge, null);
            }
        }
    }

    private void cleanupRemovedNode(Y node) {
        SA g2d;
        BA realizer;
        D graph = this.getGraph();
        if (graph instanceof SA && (realizer = (g2d = (SA)graph).f(node)) instanceof HA) {
            ((HA)realizer).setUserData(null);
        }
        this.yFilesMemLeakWorkaround(graph, node);
    }

    private void cleanupEdgeRemoved(H edge) {
        SA g2d;
        q realizer;
        D graph = this.getGraph();
        if (graph instanceof SA && (realizer = (g2d = (SA)graph).X(edge)) instanceof UserDataHolder) {
            ((UserDataHolder)realizer).setUserData(null);
        }
        this.yFilesMemLeakWorkaround(graph, edge);
    }

    public GraphDataStore getGraphDataStore() {
        return this.getGraphStoreView().getGraphDataStore();
    }

    public GraphStructureStore getGraphStructureStore() {
        return this.getGraphStoreView().getGraphStructureStore();
    }

    public GraphLayoutStore getGraphLayoutStore() {
        return this.getGraphStoreView().getGraphLayoutStore();
    }

    public GraphStoreView getGraphStoreView() {
        return this._graphStoreView;
    }

    private GraphID getGraphID() {
        return this._graphID;
    }

    private R listToYPointPath(List<Point> path) {
        ArrayList<M> pointList = new ArrayList<M>(path.size());
        for (Point point2D : path) {
            pointList.add(new M((double)point2D.x, (double)point2D.y));
        }
        return new R(pointList);
    }

    public boolean isSyncing() {
        return this._isSyncing;
    }

    public void setIsSyncing(boolean isSyncing) {
        this._isSyncing = isSyncing;
    }

    private class GraphLayoutListener
    implements PropertyChangeListener {
        private GraphLayoutListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            SA graph = (SA)GraphWrapper.this.graph();
            graph.\u00cc();
            try {
                GraphLayoutMods mods = (GraphLayoutMods)evt.getNewValue();
                for (Map.Entry entry : mods.getCenters().entrySet()) {
                    EntityID entityID = (EntityID)entry.getKey();
                    Point center = (Point)entry.getValue();
                    if (center == null) continue;
                    Y node = GraphWrapper.this.node(entityID);
                    if (node != null) {
                        graph.D(node, (double)center.x, (double)center.y);
                        continue;
                    }
                    LOG.log(Level.WARNING, "Node not found for entity {0}", entityID);
                }
                for (Map.Entry entrySet : mods.getPaths().entrySet()) {
                    LinkID linkID = (LinkID)entrySet.getKey();
                    List path = (List)entrySet.getValue();
                    if (path == null) continue;
                    H edge = GraphWrapper.this.edge(linkID);
                    if (edge != null) {
                        R pointPath = GraphWrapper.this.listToYPointPath(path);
                        graph.A(edge, pointPath);
                        graph.A(edge, pointPath.L());
                        graph.C(edge, pointPath.I());
                        continue;
                    }
                    LOG.log(Level.WARNING, "Edge not found for link {0}", linkID);
                }
            }
            finally {
                graph.\u00a3();
                graph.\u0107();
            }
        }
    }

    private class GraphStructureListener
    implements PropertyChangeListener {
        private GraphStructureListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            GraphWrapper.this.graph().\u00cc();
            boolean updateViews = false;
            try {
                GraphID graphID = GraphWrapper.this.getGraphID();
                GraphStructureMods mods = (GraphStructureMods)evt.getNewValue();
                for (LinkID linkID : mods.getLinksRemoved().keySet()) {
                    this.onLinkRemoved(linkID);
                    updateViews = true;
                }
                for (EntityID entityID : mods.getEntitiesRemoved()) {
                    this.onEntityRemoved(entityID);
                    updateViews = true;
                }
                if (!mods.getEntitiesAdded().isEmpty()) {
                    this.onEntitiesAdded(mods.getEntitiesAdded(), graphID);
                    updateViews = true;
                }
                if (!mods.getLinksAdded().isEmpty()) {
                    this.onLinksAdded(mods.getLinksAdded(), graphID);
                    updateViews = true;
                }
            }
            finally {
                GraphWrapper.this.graph().\u00a3();
                if (updateViews) {
                    SA g2d = (SA)GraphWrapper.this.graph();
                    g2d.\u0107();
                }
            }
        }

        private void onLinksAdded(Set<LinkID> linkIDs, GraphID graphID) {
            try {
                GraphStructureReader reader = GraphWrapper.this.getGraphStructureStore().getStructureReader();
                Map linkEntities = reader.getEntities(linkIDs);
                GraphStoreView graphStoreView = GraphWrapper.this.getGraphStoreView();
                GraphLayoutReader viewLayoutReader = graphStoreView.getGraphLayoutStore().getLayoutReader();
                Map paths = viewLayoutReader.getPaths(linkIDs);
                for (LinkID linkID : linkIDs) {
                    List path;
                    GraphSelection selection;
                    LinkEntityIDs entities = (LinkEntityIDs)linkEntities.get(linkID);
                    SA graph = (SA)GraphWrapper.this.graph();
                    H edge = graph.A(GraphWrapper.this.node(entities.getSourceID()), GraphWrapper.this.node(entities.getTargetID()));
                    GraphWrapper.this.edgeMap().set((Object)edge, (Object)linkID);
                    GraphWrapper.this.linkMap().put((Guid)linkID, (Object)edge);
                    q realizer = GraphWrapper.this.getRealizer(edge);
                    if (realizer instanceof UserDataHolder) {
                        ((UserDataHolder)realizer).setUserData((Object)new GraphLink(graphID, linkID));
                    }
                    if ((selection = GraphSelection.forGraph((GraphID)graphID)).isSelectedInView(linkID) && !GraphWrapper.this.isSyncing()) {
                        graph.B(edge, true);
                    }
                    if ((path = (List)paths.get(linkID)) == null) continue;
                    R pointPath = GraphWrapper.this.listToYPointPath(path);
                    graph.A(edge, pointPath);
                    graph.A(edge, pointPath.L());
                    graph.C(edge, pointPath.I());
                }
            }
            catch (GraphStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        private void onEntitiesAdded(Set<EntityID> entityIDs, GraphID graphID) {
            SA graph = (SA)GraphWrapper.this.graph();
            GraphStoreView graphStoreView = GraphWrapper.this.getGraphStoreView();
            GraphLayoutReader layoutReader = graphStoreView.getGraphLayoutStore().getLayoutReader();
            Map centers = Collections.EMPTY_MAP;
            HashSet<EntityID> selectedEntities = new HashSet<EntityID>();
            try {
                centers = layoutReader.getCenters(entityIDs);
            }
            catch (GraphStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            GraphSelection selection = GraphSelection.forGraph((GraphID)graphID);
            for (EntityID entityID : entityIDs) {
                Point center = (Point)centers.get(entityID);
                Y node = center == null ? graph.w() : graph.C((double)center.x, (double)center.y);
                GraphWrapper.this.nodeMap().set((Object)node, (Object)entityID);
                GraphWrapper.this.entityMap().put((Guid)entityID, (Object)node);
                HA realizer = GraphWrapper.this.getRealizer(node);
                if (realizer instanceof HA) {
                    realizer.setUserData((Object)new GraphEntity(graphID, entityID));
                }
                if (selection.getViewSelectionState(entityID) == SelectionState.NO || GraphWrapper.this.isSyncing()) continue;
                selectedEntities.add(entityID);
            }
            if (!selectedEntities.isEmpty()) {
                selection.clearSelection();
                selection.setSelectedViewEntities(selectedEntities);
            }
        }

        private void onEntityRemoved(EntityID entityID) {
            Y node = GraphWrapper.this.node(entityID);
            if (node != null) {
                GraphWrapper.this.graph().B(node);
                GraphWrapper.this.nodeMap().set((Object)node, null);
                GraphWrapper.this.cleanupRemovedNode(node);
            }
            GraphWrapper.this.entityMap().remove((Guid)entityID);
        }

        private void onLinkRemoved(LinkID linkID) {
            H edge = GraphWrapper.this.edge(linkID);
            if (edge != null) {
                GraphWrapper.this.graph().H(edge);
                GraphWrapper.this.edgeMap().set((Object)edge, null);
                GraphWrapper.this.cleanupEdgeRemoved(edge);
            }
            GraphWrapper.this.linkMap().remove((Guid)linkID);
        }
    }
}

