/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.descriptor;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.TypedPropertyBag;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphDataStoreReader;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.transform.descriptor.Constraint;
import com.paterva.maltego.transform.descriptor.ConstraintTargetTypeEnum;
import com.paterva.maltego.transform.descriptor.ConstraintTypeEnum;
import com.paterva.maltego.transform.descriptor.InheritedTypesProvider;
import com.paterva.maltego.transform.descriptor.InputConstraint;
import com.paterva.maltego.transform.descriptor.LogicalOperation;
import com.paterva.maltego.transform.descriptor.TransformInputType;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.types.DateRange;
import com.paterva.maltego.typing.types.DateTime;
import com.paterva.maltego.typing.types.TimeSpan;
import com.paterva.maltego.util.FastURL;
import java.awt.Color;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Exceptions;

public class ExecutionInputConstraint
implements Constraint {
    private static final Logger LOG = Logger.getLogger(ExecutionInputConstraint.class.getName());
    private final TransformInputType inputType;
    private InputConstraint inputConstraint;

    public ExecutionInputConstraint(TransformInputType inputType) {
        this.inputType = inputType;
    }

    public ExecutionInputConstraint(TransformInputType inputType, InputConstraint inputConstraint) {
        this.inputType = inputType;
        this.inputConstraint = inputConstraint;
    }

    @Override
    public boolean isSatisfiedByAny(Iterable<? extends TypedPropertyBag> entities, InheritedTypesProvider typeProvider) {
        return false;
    }

    @Override
    public boolean isSatisfiedByAny(GraphID graphID, Set<EntityID> entities, InheritedTypesProvider typeProvider) {
        try {
            Set<String> types = typeProvider.getAllInheritedTypes();
            if ((types == null || this.isSatisfiedByInheritedTypes(types)) && GraphStoreRegistry.getDefault().isExistingAndOpen(graphID)) {
                GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
                GraphDataStoreReader dataReader = graphStore.getGraphDataStore().getDataStoreReader();
                Map<EntityID, MaltegoEntity> entityMap = new HashMap<EntityID, MaltegoEntity>();
                for (EntityID entityID : entities) {
                    MaltegoEntity entity = dataReader.getEntity(entityID);
                    entityMap.put(entityID, entity);
                }
                Long startTimeTotal = System.nanoTime();
                entityMap = this.getSatisfiedBy(graphID, entityMap, typeProvider, true);
                startTimeTotal = (System.nanoTime() - startTimeTotal) / 1000000L;
                LOG.log(Level.FINE, "isSatisfiedByAny for entity count {0}. Number of satisfied entities {1} took {2} milsec", new Object[]{entities.size(), entityMap.size(), startTimeTotal});
                return !entityMap.isEmpty();
            }
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return false;
    }

    @Override
    public boolean isSatisfiedByInheritedTypes(Collection<String> types) {
        return true;
    }

    @Override
    public Set<EntityID> getSatisfiedBy(GraphID graphID, Set<EntityID> entities, InheritedTypesProvider typeProvider) {
        String constrInfo = this.getDisplay();
        Integer entitiesCount = entities.size();
        Long startTimeTotal = System.nanoTime();
        HashSet<EntityID> satisfied = new HashSet<EntityID>();
        try {
            if (GraphStoreRegistry.getDefault().isExistingAndOpen(graphID)) {
                GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
                GraphDataStoreReader dataReader = graphStore.getGraphDataStore().getDataStoreReader();
                Map<EntityID, MaltegoEntity> entityMap = new HashMap<EntityID, MaltegoEntity>();
                for (EntityID entityID : entities) {
                    MaltegoEntity entity = dataReader.getEntity(entityID);
                    entityMap.put(entityID, entity);
                }
                entityMap = this.getSatisfiedBy(graphID, entityMap, typeProvider);
                satisfied.addAll(entityMap.keySet());
            }
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        startTimeTotal = (System.nanoTime() - startTimeTotal) / 1000000L;
        LOG.log(Level.FINE, "(Set) Constraint {0} for entities count {1} took {2} milsec. Number of satisfied entities {3}", new Object[]{constrInfo, entitiesCount, startTimeTotal, satisfied.size()});
        return satisfied;
    }

    @Override
    public Map<EntityID, MaltegoEntity> getSatisfiedBy(GraphID graphID, Map<EntityID, MaltegoEntity> entities, InheritedTypesProvider typeProvider) {
        return this.getSatisfiedBy(graphID, entities, typeProvider, false);
    }

    private Map<EntityID, MaltegoEntity> getSatisfiedBy(GraphID graphID, Map<EntityID, MaltegoEntity> entities, InheritedTypesProvider typeProvider, Boolean isSatisfiedByAny) {
        String constrInfo = this.getDisplay();
        Integer entitiesCount = entities.size();
        Long startTimeTotal = System.nanoTime();
        HashMap<EntityID, MaltegoEntity> satisfied = new HashMap<EntityID, MaltegoEntity>();
        Set<EntityID> satisfiedEntityIds = this.getSatisfiedByConstraint(graphID, entities, typeProvider, this.inputConstraint, isSatisfiedByAny);
        for (EntityID entryId : satisfiedEntityIds) {
            satisfied.put(entryId, entities.get(entryId));
        }
        startTimeTotal = (System.nanoTime() - startTimeTotal) / 1000000L;
        LOG.log(Level.FINE, "(Map) Constraint {0} , isSatisfiedByAny = {1} for entities count {2} took {3} milsec. Number of satisfied entities {4}", new Object[]{constrInfo, isSatisfiedByAny, entitiesCount, startTimeTotal, satisfied.size()});
        return satisfied;
    }

    private Set<EntityID> getSatisfiedByConstraint(GraphID graphID, Map<EntityID, MaltegoEntity> entities, InheritedTypesProvider typeProvider, InputConstraint inputConstraint, Boolean isSatisfiedByAny) {
        if (inputConstraint.getConstraintType() == ConstraintTypeEnum.GROUP_CONSTRAINT) {
            return this.evaluateGroupConstraint(graphID, entities, typeProvider, inputConstraint, isSatisfiedByAny);
        }
        return this.evaluateLeafConstraint(entities, typeProvider, inputConstraint, isSatisfiedByAny);
    }

    @Override
    public String getDisplay() {
        return String.format("Constraint %s for %s satisfies %s", new Object[]{this.inputConstraint.constraintType, this.inputConstraint.constraintType == ConstraintTypeEnum.GROUP_CONSTRAINT ? this.inputConstraint.getCompositeConstraintType() : this.inputConstraint.constraintTargetType, this.inputConstraint.getConstraintOperation()});
    }

    public TransformInputType getInputType() {
        return this.inputType;
    }

    public InputConstraint getInputConstraint() {
        return this.inputConstraint;
    }

    public int hashCode() {
        int hash = 5;
        hash = 29 * hash + Objects.hashCode((Object)this.inputType);
        hash = 29 * hash + Objects.hashCode(this.inputConstraint);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExecutionInputConstraint other = (ExecutionInputConstraint)obj;
        if (this.inputType != other.inputType) {
            return false;
        }
        return Objects.equals(this.inputConstraint, other.inputConstraint);
    }

    @Override
    public List<String> getInputTypeNames() {
        return new ArrayList<String>();
    }

    private Set<EntityID> evaluateGroupConstraint(GraphID graphID, Map<EntityID, MaltegoEntity> entities, InheritedTypesProvider typeProvider, InputConstraint groupConstraint, Boolean isSatisfiedByAny) {
        LogicalOperation operation = groupConstraint.getConstraintOperation() != null ? groupConstraint.getConstraintOperation() : LogicalOperation.ALL;
        HashSet<EntityID> result = null;
        block5: for (InputConstraint inner : groupConstraint.getInnerConstraints()) {
            Set<EntityID> evaluated = this.getSatisfiedByConstraint(graphID, entities, typeProvider, inner, isSatisfiedByAny);
            if (result == null) {
                result = new HashSet();
                if (operation == LogicalOperation.NONE) {
                    result.addAll(entities.keySet());
                    result.removeAll(evaluated);
                    continue;
                }
                result.addAll(evaluated);
                continue;
            }
            switch (operation) {
                case ALL: {
                    if (evaluated.isEmpty()) {
                        return new HashSet<EntityID>();
                    }
                    result.retainAll(evaluated);
                    continue block5;
                }
                case ANY: {
                    result.addAll(evaluated);
                    if (!isSatisfiedByAny.booleanValue() || evaluated.isEmpty()) continue block5;
                    return result;
                }
                case NONE: {
                    result.removeAll(evaluated);
                    if (!result.isEmpty()) continue block5;
                    return result;
                }
            }
            throw new RuntimeException("Unknown logical operation: " + (Object)((Object)operation));
        }
        return result != null ? result : new HashSet<EntityID>();
    }

    private Set<EntityID> evaluateLeafConstraint(Map<EntityID, MaltegoEntity> entities, InheritedTypesProvider typeProvider, InputConstraint constraint, Boolean isSatisfiedByAny) {
        HashSet<EntityID> satisfied = new HashSet<EntityID>();
        for (Map.Entry<EntityID, MaltegoEntity> entry : entities.entrySet()) {
            EntityID entityID = entry.getKey();
            MaltegoEntity entity = entry.getValue();
            boolean match = this.isPropertyConstraint(constraint) ? this.evaluatePropertyConstraint(constraint, entity) : this.evaluateEntityConstraint(constraint, entity, typeProvider);
            if (!match) continue;
            satisfied.add(entityID);
            if (!isSatisfiedByAny.booleanValue()) continue;
            return satisfied;
        }
        return satisfied;
    }

    private boolean evaluatePropertyConstraint(InputConstraint constraint, MaltegoEntity entity) {
        for (PropertyDescriptor prop : entity.getProperties()) {
            List<String> inputs = this.extractInputsFromProperty(prop, entity, constraint.getConstraintTargetType());
            if (!constraint.evaluate(inputs)) continue;
            return true;
        }
        return false;
    }

    private boolean evaluateEntityConstraint(InputConstraint constraint, MaltegoEntity entity, InheritedTypesProvider typeProvider) {
        ArrayList<String> inputs = new ArrayList<String>();
        if (typeProvider != null) {
            inputs.addAll(typeProvider.getAllInheritedTypes(entity.getTypeName()));
        } else {
            inputs.add(entity.getTypeName());
        }
        return constraint.evaluate(inputs);
    }

    private List<String> extractInputsFromProperty(PropertyDescriptor prop, MaltegoEntity entity, ConstraintTargetTypeEnum targetType) {
        ArrayList<String> inputs = new ArrayList<String>();
        switch (targetType) {
            case PROPERTY_NAME: {
                inputs.add(prop.getName());
                break;
            }
            case PROPERTY_DISPLAY_NAME: {
                inputs.add(prop.getDisplayName());
                break;
            }
            case PROPERTY_TYPE: {
                if (!(prop instanceof DisplayDescriptor)) break;
                DisplayDescriptor displayDescriptor = (DisplayDescriptor)prop;
                String typeName = this.getV3PropertyTypeFromClass(displayDescriptor.getTypeDescriptor().getType());
                LOG.log(Level.FINE, "DisplayDescriptor for property {0} with typeName from getV3PropertyTypeFromClass = {1}", new Object[]{displayDescriptor.getName(), typeName});
                inputs.add(typeName);
                break;
            }
            case PROPERTY_VALUE: {
                Object value = entity.getData().getValue(prop);
                if (value == null) break;
                if (prop.getType().isArray()) {
                    int length = Array.getLength(value);
                    for (int i = 0; i < length; ++i) {
                        Object item = Array.get(value, i);
                        inputs.add(item.toString());
                    }
                    break;
                }
                inputs.add(value.toString());
            }
        }
        return inputs;
    }

    private boolean isPropertyConstraint(InputConstraint constraint) {
        ConstraintTargetTypeEnum target = constraint.getConstraintTargetType();
        return target == ConstraintTargetTypeEnum.PROPERTY_NAME || target == ConstraintTargetTypeEnum.PROPERTY_DISPLAY_NAME || target == ConstraintTargetTypeEnum.PROPERTY_TYPE || target == ConstraintTargetTypeEnum.PROPERTY_VALUE;
    }

    private String getV3PropertyTypeFromClass(Class type) {
        if (type.isArray()) {
            type = type.getComponentType();
        }
        if (String.class.isAssignableFrom(type)) {
            return "STRING";
        }
        if (Double.class.isAssignableFrom(type) || Double.TYPE.isAssignableFrom(type)) {
            return "DOUBLE";
        }
        if (Float.class.isAssignableFrom(type) || Float.TYPE.isAssignableFrom(type)) {
            return "DOUBLE";
        }
        if (Boolean.class.isAssignableFrom(type) || Boolean.TYPE.isAssignableFrom(type)) {
            return "BOOLEAN";
        }
        if (Integer.class.isAssignableFrom(type) || Integer.TYPE.isAssignableFrom(type) || Long.class.isAssignableFrom(type) || Long.TYPE.isAssignableFrom(type) || BigInteger.class.isAssignableFrom(type)) {
            return "INT";
        }
        if (Date.class.isAssignableFrom(type)) {
            return "DATE";
        }
        if (DateRange.class.isAssignableFrom(type)) {
            return "DATE_RANGE";
        }
        if (DateTime.class.isAssignableFrom(type)) {
            return "DATE_TIME";
        }
        if (FastURL.class.isAssignableFrom(type)) {
            return "URL";
        }
        if (Color.class.isAssignableFrom(type)) {
            return "COLOR";
        }
        if (TimeSpan.class.isAssignableFrom(type)) {
            return "TIME_SPAN";
        }
        return "STRING";
    }
}

