/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.tabular.transforms.run.v2;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.entity.api.EntityFactory;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.transform.descriptor.TransformDescriptor;
import com.paterva.maltego.transform.protocol.v2api.TransformRunnerV2;
import com.paterva.maltego.transforms.tabular.data.TabularTransformSource;
import com.paterva.maltego.util.Args;
import java.io.File;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public abstract class AbstractTabularTransformRunnerV2
extends TransformRunnerV2 {
    private static final RequestProcessor processor = new RequestProcessor("Tabular Transform Runner", 10, true);
    private final TransformDescriptor transform;

    public AbstractTabularTransformRunnerV2(GraphID graphID, EntityFactory factory, EntityRegistry registry, TransformDescriptor transform) {
        super(graphID, factory, registry);
        Args.notNull((Object)graphID, (String)"graphID");
        Args.notNull((Object)factory, (String)"factory");
        Args.notNull((Object)registry, (String)"registry");
        Args.notNull((Object)transform, (String)"transform");
        this.transform = transform;
    }

    protected abstract Set<MaltegoEntity> runTransform(MaltegoEntity var1, ProgressHandle var2) throws Exception;

    public TransformDescriptor getTransform() {
        return this.transform;
    }

    protected RequestProcessor processor() {
        return processor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TransformRunnerV2.RunResultV2 doRunTransform(MaltegoEntity inputEntity) throws Exception {
        Args.notNull((Object)inputEntity, (String)"inputEntity");
        TransformRunnerV2.RunResultV2 runResult = new TransformRunnerV2.RunResultV2(inputEntity);
        ProgressHandle handle = null;
        try {
            handle = ProgressHandleFactory.createHandle((String)"Please wait...");
            handle.start();
            Set<MaltegoEntity> entities = this.runTransform(inputEntity, handle);
            runResult.getEntities().addAll(entities);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            if (handle != null) {
                handle.finish();
            }
        }
        return runResult;
    }

    protected List<File> getFiles(TabularTransformSource transformSource) {
        Args.notNull((Object)transformSource, (String)"transformSource");
        return transformSource.getSourceFiles().stream().map(File::new).collect(Collectors.toList());
    }
}

