/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.propertyview;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.EntityUpdate;
import com.paterva.maltego.core.GraphEntity;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.GraphLink;
import com.paterva.maltego.core.GraphPart;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.core.LinkUpdate;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.graph.GraphLifeCycleManager;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.structure.GraphStructureReader;
import com.paterva.maltego.graph.store.view.GraphStoreView;
import com.paterva.maltego.graph.store.view.GraphStoreViewRegistry;
import com.paterva.maltego.propertyview.AddDynamicPropertyAction;
import com.paterva.maltego.propertyview.EditPropertyMappingsAction;
import com.paterva.maltego.propertyview.FilteredPropertySet;
import com.paterva.maltego.propertyview.ManyNodesPrompt;
import com.paterva.maltego.propertyview.PropertyFilterNode;
import com.paterva.maltego.typing.editing.propertygrid.DisplayDescriptorProperty;
import com.paterva.maltego.ui.graph.GraphCookie;
import com.paterva.maltego.ui.graph.GraphEditorRegistry;
import com.paterva.maltego.ui.graph.GraphUser;
import com.paterva.maltego.ui.graph.HoverContext;
import com.paterva.maltego.ui.graph.ModifiedHelper;
import com.paterva.maltego.ui.graph.actions.EditNodeAction;
import com.paterva.maltego.ui.graph.data.GraphDataObject;
import com.paterva.maltego.ui.graph.impl.SelectiveGlobalActionContext;
import com.paterva.maltego.ui.graph.nodes.BulkQueryEntityCache;
import com.paterva.maltego.ui.graph.nodes.BulkQueryLinkCache;
import com.paterva.maltego.ui.graph.nodes.EntityNode;
import com.paterva.maltego.ui.graph.nodes.LinkNode;
import com.paterva.maltego.ui.graph.nodes.PartProperties;
import com.paterva.maltego.ui.graph.nodes.ProxyProperty;
import com.paterva.maltego.ui.graph.transacting.GraphTransactorRegistry;
import com.paterva.maltego.ui.graph.transactions.GraphTransaction;
import com.paterva.maltego.ui.graph.transactions.GraphTransactionBatch;
import com.paterva.maltego.ui.graph.transactions.GraphTransactionHelper;
import com.paterva.maltego.ui.graph.transactions.GraphTransactions;
import com.paterva.maltego.util.SimilarStrings;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.beans.FeatureDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.explorer.propertysheet.PropertySheet;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class PropertyViewTopComponent
extends TopComponent
implements PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger(PropertyViewTopComponent.class.getName());
    private static PropertyViewTopComponent instance;
    private static final String PREFERRED_ID = "maltego.PropertyViewTopComponent";
    private final PropertySheet _sheet = new PropertySheet();
    private final ManyNodesPrompt _prompt = new ManyNodesPrompt(this);
    private final RemovePropertyAction _removeAction = new RemovePropertyAction();
    private Node[] _selectedNodes;
    private final JToolBar _toolbar;
    private static final String PROMPT_PANEL = "PromptPanel";
    private static final String SHEET_PANEL = "SheetPanel";
    private static final int PROMPT_LIMIT_SOFT = 1000;
    private static final int PROMPT_LIMIT_HARD = 10000;
    private static final String PROP_SHOW_TOOLBAR = "propertyViewShowToolbar";
    private final HoverContext _hoverContext = HoverContext.forContextID((String)"global");
    private final PropertyChangeListener _hoverListener;
    private final ChangeListener _selectionListener;
    private final PropertyChangeListener _dataListener = new DataListener();
    private GraphID _graphID;
    private GraphStore _graphStore;

    public PropertyViewTopComponent() {
        this.initComponents();
        Logger.getLogger(PropertySheet.class.getName()).setLevel(Level.OFF);
        this.setName(NbBundle.getMessage(PropertyViewTopComponent.class, (String)"CTL_PropertyViewTopComponent"));
        this.setToolTipText(NbBundle.getMessage(PropertyViewTopComponent.class, (String)"HINT_PropertyViewTopComponent"));
        JPanel sheetPanel = new JPanel();
        sheetPanel.setLayout(new BorderLayout());
        this._sheet.setDescriptionAreaVisible(false);
        sheetPanel.add((Component)this._sheet, "Center");
        this._toolbar = new JToolBar();
        this._toolbar.setRollover(true);
        this._toolbar.add((Action)SystemAction.get(AddDynamicPropertyAction.class));
        this._toolbar.add(this._removeAction);
        this._toolbar.add((Action)SystemAction.get(EditPropertyMappingsAction.class));
        this._toolbar.add(Box.createHorizontalGlue());
        this._toolbar.add((Action)SystemAction.get(EditNodeAction.class));
        sheetPanel.add((Component)this._toolbar, "Last");
        this.add(sheetPanel, SHEET_PANEL);
        this.add(this._prompt, PROMPT_PANEL);
        this._toolbar.setVisible(NbPreferences.forModule(PropertyViewTopComponent.class).getBoolean(PROP_SHOW_TOOLBAR, false));
        this._selectionListener = new SelectionListener();
        this._hoverListener = new HoverListener();
        GraphLifeCycleManager.getDefault().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                GraphID graphID;
                if ("graphClosing".equals(evt.getPropertyName()) && (graphID = (GraphID)evt.getNewValue()).equals((Object)PropertyViewTopComponent.this._graphID)) {
                    PropertyViewTopComponent.this.setSelectedNodes(new Node[0]);
                    PropertyViewTopComponent.this.refresh();
                }
            }
        });
    }

    public Action[] getActions() {
        ArrayList<Action> actionsList = new ArrayList<Action>(Arrays.asList(super.getActions()));
        actionsList.add(new AbstractAction("Show/Hide Toolbar"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropertyViewTopComponent.this._toolbar.setVisible(!PropertyViewTopComponent.this._toolbar.isVisible());
                NbPreferences.forModule(PropertyViewTopComponent.class).putBoolean(PropertyViewTopComponent.PROP_SHOW_TOOLBAR, PropertyViewTopComponent.this._toolbar.isVisible());
            }
        });
        return actionsList.toArray(new Action[actionsList.size()]);
    }

    private void initComponents() {
        this.setLayout(new CardLayout());
    }

    public static synchronized PropertyViewTopComponent getDefault() {
        if (instance == null) {
            instance = new PropertyViewTopComponent();
        }
        return instance;
    }

    public static synchronized PropertyViewTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            Logger.getLogger(PropertyViewTopComponent.class.getName()).warning("Cannot find maltego.PropertyViewTopComponent component. It will not be located properly in the window system.");
            return PropertyViewTopComponent.getDefault();
        }
        if (win instanceof PropertyViewTopComponent) {
            return (PropertyViewTopComponent)win;
        }
        Logger.getLogger(PropertyViewTopComponent.class.getName()).warning("There seem to be multiple components with the 'maltego.PropertyViewTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return PropertyViewTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    public void componentOpened() {
        this._hoverContext.addPropertyChangeListener(this._hoverListener);
        this._sheet.addPropertyChangeListener("selectedFeatureDescriptor", (PropertyChangeListener)this);
        SelectiveGlobalActionContext.instance().addChangeListener(this._selectionListener);
        this.checkRemoveEnabled();
        this.onResultChanged();
    }

    public void componentClosed() {
        SelectiveGlobalActionContext.instance().removeChangeListener(this._selectionListener);
        this._sheet.removePropertyChangeListener("selectedFeatureDescriptor", (PropertyChangeListener)this);
        this._hoverContext.removePropertyChangeListener(this._hoverListener);
    }

    public void removeNotify() {
        this.setSelectedNodes(new Node[0]);
        this.refresh();
        super.removeNotify();
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    Object readProperties(Properties p) {
        PropertyViewTopComponent singleton = PropertyViewTopComponent.getDefault();
        singleton.readPropertiesImpl(p);
        return singleton;
    }

    private void readPropertiesImpl(Properties p) {
        String version = p.getProperty("version");
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    private void onResultChanged() {
        try {
            this.updateSelectedNodes(true);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public void updateSelectedNodes(boolean checkLimit) throws GraphStoreException {
        GraphID graphID;
        Node[] nodes = null;
        GraphPart hoverPart = this._hoverContext.getHoverPart();
        boolean tooMany = false;
        if (hoverPart != null) {
            graphID = hoverPart.getGraphID();
            if (GraphStoreRegistry.getDefault().isExistingAndOpen(graphID)) {
                nodes = this.createNodes(hoverPart, checkLimit);
                tooMany = nodes == null;
            }
        } else {
            SelectiveGlobalActionContext selection = SelectiveGlobalActionContext.instance();
            graphID = selection.getTopGraphID();
            if (graphID != null && GraphStoreRegistry.getDefault().isExistingAndOpen(graphID)) {
                Set selectedModelEntities = selection.getSelectedModelEntities();
                if (!selectedModelEntities.isEmpty()) {
                    nodes = this.createEntityNodes(graphID, selectedModelEntities, checkLimit);
                    tooMany = nodes == null;
                } else {
                    Set selectedModelLinks = selection.getSelectedModelLinks();
                    if (!selectedModelLinks.isEmpty()) {
                        nodes = this.createLinkNodes(graphID, selectedModelLinks, checkLimit);
                        boolean bl = tooMany = nodes == null;
                    }
                }
            }
        }
        if (nodes == null) {
            nodes = new Node[]{};
            graphID = null;
        }
        if (!Utilities.compareObjects((Object)this._graphID, (Object)graphID)) {
            if (this._graphStore != null) {
                this.removeDataListener(this._graphStore);
                this._graphStore = null;
            }
            this._graphID = graphID;
            if (this._graphID != null) {
                try {
                    this._graphStore = GraphStoreRegistry.getDefault().forGraphID(this._graphID);
                }
                catch (GraphStoreException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                this.addDataListener(this._graphStore);
            }
        }
        this.setSelectedNodes(nodes);
        ((AddDynamicPropertyAction)SystemAction.get(AddDynamicPropertyAction.class)).isEnabled();
        ((EditPropertyMappingsAction)SystemAction.get(EditPropertyMappingsAction.class)).isEnabled();
        ((EditNodeAction)SystemAction.get(EditNodeAction.class)).isEnabled();
        if (!tooMany) {
            this.showNodeProperties();
        } else {
            this.showPrompt();
        }
    }

    private Node[] createEntityNodes(GraphID graphID, Set<EntityID> entityIDs, boolean checkLimit) {
        Node[] nodes = null;
        if (this.checkLimitForWarning(checkLimit, entityIDs)) {
            this._prompt.setNodeCountWarning(entityIDs.size());
        } else if (this.checkLimitForError(checkLimit, entityIDs)) {
            this._prompt.setNodeCountError(entityIDs.size());
        } else {
            nodes = this.createNbEntityNodes(graphID, entityIDs);
        }
        return nodes;
    }

    private Node[] createLinkNodes(GraphID graphID, Set<LinkID> linkIDs, boolean checkLimit) {
        Node[] nodes = null;
        if (this.checkLimitForWarning(checkLimit, linkIDs)) {
            this._prompt.setNodeCountWarning(linkIDs.size());
        } else if (this.checkLimitForError(checkLimit, linkIDs)) {
            this._prompt.setNodeCountError(linkIDs.size());
        } else {
            nodes = this.createNbLinkNodes(graphID, linkIDs);
        }
        return nodes;
    }

    private boolean checkLimitForWarning(boolean checkLimit, Set<?> items) {
        int count = items.size();
        return checkLimit && count >= 1000 && count < 10000;
    }

    private boolean checkLimitForError(boolean checkLimit, Set<?> items) {
        int count = items.size();
        return checkLimit && count >= 10000;
    }

    private void setSelectedNodes(Node[] nodes) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Nodes: {0}", Arrays.toString(nodes));
        }
        this._selectedNodes = nodes;
    }

    private void refresh() {
        if (this._selectedNodes != null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Setting nodes on sheet: {0}", Arrays.toString(this._selectedNodes));
            }
            this._sheet.setNodes(this._selectedNodes);
        }
        this.checkRemoveEnabled();
    }

    private Node[] createNodes(GraphPart graphPart, boolean checkLimit) {
        Node[] nodes = null;
        try {
            if (graphPart instanceof GraphEntity) {
                GraphEntity graphEntity = (GraphEntity)graphPart;
                GraphID graphID = graphEntity.getGraphID();
                GraphStoreView view = GraphStoreViewRegistry.getDefault().getDefaultView(graphID);
                Set modelEntities = view.getModelViewMappings().getModelEntities((EntityID)graphEntity.getID());
                nodes = this.createEntityNodes(graphID, modelEntities, checkLimit);
            } else if (graphPart instanceof GraphLink) {
                GraphLink graphLink = (GraphLink)graphPart;
                GraphID graphID = graphLink.getGraphID();
                GraphStoreView view = GraphStoreViewRegistry.getDefault().getDefaultView(graphID);
                Set modelLinks = view.getModelViewMappings().getModelLinks((LinkID)graphLink.getID());
                nodes = this.createLinkNodes(graphID, modelLinks, checkLimit);
            }
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return nodes;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!"activated".equals(evt.getPropertyName())) {
            if ("value".equals(evt.getPropertyName()) || "displayValue".equals(evt.getPropertyName())) {
                GraphCookie cookie;
                TopComponent topmost = GraphEditorRegistry.getDefault().getTopmost();
                if (topmost != null && (cookie = (GraphCookie)topmost.getLookup().lookup(GraphCookie.class)) instanceof GraphDataObject) {
                    ((DataObject)cookie).setModified(true);
                }
                this._sheet.repaint();
            } else {
                this.checkRemoveEnabled();
            }
        }
    }

    private void showNodeProperties() {
        CardLayout layout = (CardLayout)this.getLayout();
        layout.show((Container)((Object)this), SHEET_PANEL);
        this.refresh();
    }

    private void showPrompt() {
        CardLayout layout = (CardLayout)this.getLayout();
        layout.show((Container)((Object)this), PROMPT_PANEL);
        this.refresh();
    }

    private void checkRemoveEnabled() {
        boolean enabled = false;
        if (this._selectedNodes != null && this._selectedNodes.length > 0) {
            FeatureDescriptor feature = this._sheet.getSelectedProperty();
            if (feature instanceof ProxyProperty) {
                feature = ((ProxyProperty)feature).getDelegate();
            }
            if (feature instanceof DisplayDescriptorProperty) {
                enabled = PartProperties.isDynamicProperty((DisplayDescriptorProperty)((DisplayDescriptorProperty)feature));
            }
        }
        this._removeAction.setEnabled(enabled);
    }

    private Node[] createNbEntityNodes(GraphID graphID, Set<EntityID> entityIDs) {
        try {
            GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
            GraphStructureReader structureReader = graphStore.getGraphStructureStore().getStructureReader();
            entityIDs = structureReader.getExistingEntities(entityIDs);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        boolean alreadyHasAttachmentProperty = false;
        Node[] nbNodes = new Node[entityIDs.size()];
        int index = 0;
        BulkQueryEntityCache cache = new BulkQueryEntityCache(graphID, entityIDs);
        for (EntityID entityID : entityIDs) {
            LOG.log(Level.FINE, "Creating node for: {0}", entityID);
            PropertyFilterNode entityNode = new PropertyFilterNode((Node)new EntityNode(graphID, entityID, cache, !alreadyHasAttachmentProperty));
            nbNodes[index] = entityNode;
            ++index;
            if (alreadyHasAttachmentProperty || !this.hasAttachmentProperty((Node)entityNode)) continue;
            alreadyHasAttachmentProperty = true;
        }
        return nbNodes;
    }

    private boolean hasAttachmentProperty(Node node) {
        for (Node.PropertySet ps : node.getPropertySets()) {
            if (!(ps instanceof FilteredPropertySet) || !((FilteredPropertySet)ps).hasAttachmentProperty()) continue;
            return true;
        }
        return false;
    }

    private Node[] createNbLinkNodes(GraphID graphID, Set<LinkID> linkIDs) {
        try {
            GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
            GraphStructureReader structureReader = graphStore.getGraphStructureStore().getStructureReader();
            linkIDs = structureReader.getExistingLinks(linkIDs);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        Node[] nbNodes = new Node[linkIDs.size()];
        int index = 0;
        BulkQueryLinkCache cache = new BulkQueryLinkCache(graphID, linkIDs);
        for (LinkID linkID : linkIDs) {
            PropertyFilterNode linkNode = new PropertyFilterNode((Node)new LinkNode(graphID, linkID, cache));
            nbNodes[index] = linkNode;
            ++index;
        }
        return nbNodes;
    }

    private void addDataListener(GraphStore graphStore) {
        graphStore.getGraphDataStore().addPropertyChangeListener(this._dataListener);
    }

    private void removeDataListener(GraphStore graphStore) {
        graphStore.getGraphDataStore().removePropertyChangeListener(this._dataListener);
    }

    private class DataListener
    implements PropertyChangeListener {
        private DataListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            LOG.fine("Data changed");
            PropertyViewTopComponent.this.onResultChanged();
        }
    }

    private class HoverListener
    implements PropertyChangeListener {
        private HoverListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            LOG.fine("Hover changed");
            if ("hoverChanged".equals(evt.getPropertyName())) {
                PropertyViewTopComponent.this.onResultChanged();
            }
        }
    }

    private class SelectionListener
    implements ChangeListener {
        private SelectionListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            LOG.fine("Selection changed");
            PropertyViewTopComponent.this.onResultChanged();
        }
    }

    private class RemovePropertyAction
    extends AbstractAction {
        public RemovePropertyAction() {
            super("Remove");
            this.putValue("SmallIcon", new ImageIcon(ImageUtilities.loadImage((String)"com/paterva/maltego/propertyview/Delete.png")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (PropertyViewTopComponent.this._selectedNodes != null && PropertyViewTopComponent.this._selectedNodes.length > 0) {
                GraphID graphID = this.getGraphID(PropertyViewTopComponent.this._selectedNodes[0]);
                String user = GraphUser.getUser((GraphID)graphID);
                FeatureDescriptor feature = PropertyViewTopComponent.this._sheet.getSelectedProperty();
                List<MaltegoEntity> entities = this.toEntities(PropertyViewTopComponent.this._selectedNodes);
                ArrayList<EntityUpdate> entityDeletePropertyUpdates = new ArrayList<EntityUpdate>();
                ArrayList<EntityUpdate> entityDateModifiedUpdates = new ArrayList<EntityUpdate>();
                for (MaltegoEntity entity : entities) {
                    EntityUpdate entityUpdate = new EntityUpdate(entity);
                    entityUpdate.addProperty(entity.getProperties().get(feature.getName()));
                    entityDeletePropertyUpdates.add(entityUpdate);
                    EntityUpdate update = ModifiedHelper.createUpdate((String)user, (MaltegoEntity)entity);
                    if (update == null) continue;
                    entityDateModifiedUpdates.add(update);
                }
                List<MaltegoLink> links = this.toLinks(PropertyViewTopComponent.this._selectedNodes);
                ArrayList<LinkUpdate> linkDeletePropertyUpdates = new ArrayList<LinkUpdate>();
                ArrayList<LinkUpdate> linkDateModifiedUpdates = new ArrayList<LinkUpdate>();
                for (MaltegoLink link : links) {
                    LinkUpdate linkUpdate = new LinkUpdate(link);
                    linkUpdate.addProperty(link.getProperties().get(feature.getName()));
                    linkDeletePropertyUpdates.add(linkUpdate);
                    LinkUpdate update = ModifiedHelper.createUpdate((String)user, (MaltegoLink)link);
                    if (update == null) continue;
                    linkDateModifiedUpdates.add(update);
                }
                String description = "%s dynamic property \"" + SimilarStrings.escape((String)feature.getDisplayName()) + "\" %s ";
                description = entities.size() > 0 ? description + GraphTransactionHelper.getDescriptionForEntities((GraphID)graphID, entities, (boolean)true) : description + GraphTransactionHelper.getDescriptionForLinks((GraphID)graphID, links, (boolean)true);
                SimilarStrings descriptions = new SimilarStrings(description, new Object[]{"Remove", "from"}, new Object[]{"Add", "to"});
                GraphTransactionBatch batch = new GraphTransactionBatch(descriptions, true, new GraphTransaction[0]);
                batch.add(GraphTransactions.deleteProperties(entityDeletePropertyUpdates, linkDeletePropertyUpdates));
                if (!entityDateModifiedUpdates.isEmpty() || !linkDateModifiedUpdates.isEmpty()) {
                    batch.add(GraphTransactions.updateEntitiesAndLinks(entityDateModifiedUpdates, linkDateModifiedUpdates));
                }
                GraphTransactorRegistry.getDefault().get(graphID).doTransactions(batch);
                PropertyViewTopComponent.this.refresh();
            }
        }

        private GraphID getGraphID(Node node) {
            GraphEntity graphEntity = (GraphEntity)node.getLookup().lookup(GraphEntity.class);
            if (graphEntity != null) {
                return graphEntity.getGraphID();
            }
            GraphLink graphLink = (GraphLink)node.getLookup().lookup(GraphLink.class);
            if (graphLink != null) {
                return graphLink.getGraphID();
            }
            return null;
        }

        private List<MaltegoEntity> toEntities(Node[] selectedNodes) {
            ArrayList<MaltegoEntity> entities = new ArrayList<MaltegoEntity>();
            for (Node node : selectedNodes) {
                MaltegoEntity entity = (MaltegoEntity)node.getLookup().lookup(MaltegoEntity.class);
                if (entity == null) continue;
                entities.add(entity);
            }
            return entities;
        }

        private List<MaltegoLink> toLinks(Node[] selectedNodes) {
            ArrayList<MaltegoLink> links = new ArrayList<MaltegoLink>();
            for (Node node : selectedNodes) {
                MaltegoLink link = (MaltegoLink)node.getLookup().lookup(MaltegoLink.class);
                if (link == null) continue;
                links.add(link);
            }
            return links;
        }
    }
}

